<?php

/**
*  Clase Apartado que contiene los datos de una sección con datos SEO y esas cosas
*  @version 1.0
 **/

class Apartado extends Objeto{
    public $nombre_seo = '';
    public $title_seo = '';
    public $keywords_seo = '';
    public $descripcion_seo = '';
    public $url = '';
    public $lista_articulos = array();
    public $total_articulos = 0;
    public $sentencia_select;
    public $orden_select;
    public $paginacion_select;
    public $filtrado = '';

	function __construct(){
		parent::__construct();
	}
	
	
    public function adaptarFiltrado($filtrado_previo, $filtradoBusqueda = false) {
        include('comunes/globals.php');
        //Separador de partes: '*'
        //Separador de indice => valor: ':'
        //Separador de frases: '-'
        //Lo primero es separar el filtrado previo en un array con las partes necesarias
        if ($filtrado_previo != '') {
            $filtrado_previo = explode('*', $filtrado_previo);
            //Ahora recorremos el array para ir preparando la cadena de condiciones IF de mysql
            foreach ($filtrado_previo as $clave => $valor) {
                //En cada '$valor' que tengo, hay un par de valores: campo:valores. hay que separarlos
                $par_valores = explode(':', $valor);
                $cadena_filtrado = '';
                if (count($par_valores) > 1) {
                    if ($par_valores[0] == 'pvp') {
                        //El caso del precio es un tanto especial se gestiona a parte
                        //Tenemos el PVP en una cadena del tipo: desde-hasta. 
                        $lista_valores = explode('-', str_replace('_', ' ', $par_valores[1]));
                        if (count($lista_valores) > 1) {
                            if ((floatval($lista_valores[0]) <= floatval($lista_valores[1])) && ( floatval($lista_valores[0] > 0) || floatval($lista_valores[1] > 0))) {
                                $cadena_filtrado .= ' pvp >= ' . $lista_valores[0] . ' AND pvp <= ' . $lista_valores[1] . " ";
                            }
                        }
                    } else if ($par_valores[0] == 'stock_disponible') {
                        $cadena_filtrado .= ' stock_disponible > 0';
                    } else if ($par_valores[0] == 'escaparate') {// filtrado sólo disponibles en un "filtradoBusqueda"
                        //No hacemos este filtrado cuando es un filtrado de búsqueda:
                        if ($filtradoBusqueda) {
                            //Creamos un escaparate con el valor recibido
                            $tmpEscaparate = new Escaparate($par_valores[1], 1);
                            $tmpEscaparate->cargar_productos_escaparate(0, NULL, 0);
                            $cadena_filtrado .= ' articulo.codigo IN ( SELECT codigo_articulo FROM (' . $tmpEscaparate->sentencia_select . ') subconsulta ) ';
                        }
                    } else if ($par_valores[0] == 'tipo_articulo') {
                        $lista_valores = explode('-', str_replace('_', ' ', $par_valores[1]));
                        foreach ($lista_valores as $clave_valores => $valor_valores) {
                            $cadena_filtrado .= ($cadena_filtrado != '') ? ' OR ' : '';
                            if ($valor_valores == 'libros') {
                                $cadena_filtrado .= " articulo.tipo = 'L' ";
                            }if ($valor_valores == 'papeleria') {
                                $cadena_filtrado .= " articulo.tipo = 'P' ";
                            }
                        }
                    } else if (strpos($par_valores[0], 'primeraLetra') !== false) {
                        $temp = explode('_', $par_valores[0]);
                        $cadena_filtrado .= 'LEFT(' . $temp[1] . ' ,' . strlen($par_valores[1]) . ")='" . $par_valores[1] . "'";
                    } else if (strpos($par_valores[0], 'edad') !== false) {
                        if ($par_valores[1] != '-1') {
                            //La edad tiene un guión
                            $temp = explode('-', $par_valores[1]);
                            //$cadena_filtrado .= " ( (articulo.desde_edad <= " . $temp[0] . ") AND (articulo.hasta_edad >= " . $temp[1] . ") ) ";
                            $cadena_filtrado .= "( " . $temp[0] . " < IF(articulo.hasta_edad = 0, 99, IF(articulo.hasta_edad > 99, (articulo.hasta_edad - 100) / 12.0 , articulo.hasta_edad) ) 
							AND 
							" . $temp[1] . " > IF(articulo.desde_edad > 99, (articulo.desde_edad - 100) / 12.0 , articulo.desde_edad) )";
                            //echo($cadena_filtrado);
                        }
                    } else {
                        //Vamos a separar los posibles  valores en cadenas, aprovechamos para cambiar los "_" por " "
                        $lista_valores = explode('-', str_replace('_', ' ', $par_valores[1]));
                        foreach ($lista_valores as $clave_valores => $valor_valores) {
                            //En $valor_valores tengo todas las palabras a filtrar según el campo $lista_valores[0]. Hay que componer una cadena
                            $cadena_filtrado .= ($cadena_filtrado != '') ? ' OR ' : '';
                            $cadena_filtrado .= $par_valores[0] . " = '" . $valor_valores . "' ";
                        }
                    }
                    if ($cadena_filtrado != '') {
                        $cadena_filtrado = ($cadena_filtrado != '') ? '( ' . $cadena_filtrado . ') ' : '';
                        //Llegados a este punto, en "cadena_filtrado" tengo el valor a añadir
                        $this->filtrado .= ($this->filtrado != '') ? ' AND ' : '';
                        $this->filtrado .= $cadena_filtrado;
                    }
                }
            }
        }
        $this->filtrado = ( ($this->filtrado != '') ? ' AND ' : '' ) . $this->filtrado;

        //Desde este punto se colocan los filtrados según la configuración
        //Ahora vamos a tener en cuenta que haya que tener en cuenta el stock
        //Cargamos Filtrados
        if (Shop::$configuracion->ocultar_stock_0) {
            $this->filtrado .= ' AND articulo.stock > 0 ';
        }
        //Añadimos un filtrado general que se añadira siempre
        if (Shop::$configuracion->filtroGlobal != '') {
            $this->filtrado .= ( ($this->filtrado != '') ? ' AND ' : '' ) . Shop::$configuracion->filtroGlobal;
        }

        //echo("El filtrado es: " . $this->filtrado . "<br />\n");
        //filtrado por artículo padre
        //Filtrado por configuración
        //var_dump(Shop::$configuracion->segundaMano);
        if (Shop::$configuracion->segundaMano) {
            $this->filtrado .= ' AND articulo.articulo_padre = 0 ';
            //echo $this->filtrado;
        }
    }

    public function extraerCodigo($enArray = false, $codigo_inicial = NULL) {
        $lista_codigos = '';
        if (($codigo_inicial != NULL) && ($codigo_inicial != '')) {
            $lista_codigos = $codigo_inicial;
        }
        foreach ($this->lista_articulos as $clave => $valor) {
            $lista_codigos .= ", '" . $valor->codigo . "'";
        }

        if ($enArray) {
            $lista_codigos = explode(',', $lista_codigos);
        }
        return($lista_codigos);
    }

    public function crea_orden($cadena_inicial) {
        $this->orden_select = " $cadena_inicial ";
        //Miramos si hay orden en la sesión. Si lo hubiese, hay que asignarlo
        $orden_lista_productos = Sesion::get('orden_lista_productos');
        if ($orden_lista_productos !== NULL) {
            if (strtoupper($orden_lista_productos) != 'DEFAULT') {
                $this->orden_select = " $orden_lista_productos ";
            }
        }
    }
}
?>