<?php

/**
 * Description of BaseDatos
 *
 * @author pedroTHDC
 * @version 0.7
 * 0.7 => Añadida función estática para enlazar campos con alias
 *
 */
class BaseDatos {

    private static $conexion = NULL;
    private $resultado;

    function __construct($db_name = '', $user = '', $password = '', $host = '127.0.0.1') {
		//Si tenemos conexión, no nos conectamos:
		if (self::$conexion == NULL){
			/* Conectar a una base de datos de MySQL invocando al controlador */
			$dsn = 'mysql:dbname=' . $db_name . ';host=' . $host;
			$usuario = $user;
			$pass = $password;
			try {
				self::$conexion = new PDO($dsn, $usuario, $pass);
			} catch (PDOException $e) {
				self::$conexion = null;
				echo 'Falló la conexión: ' . $e->getMessage();
			}
		}
    }

    public function isConectado() {
        if (self::$conexion != NULL) {
            return true;
        } else {
            return false;
        }
    }

//

    public function closeConexion() {
        self::$conexion = null;
    }

//
    public function getAutonumerico() {
        if ($id = self::$conexion->lastInsertId()) {
            return $id;
        } else {
            return false;
        }
    }

    public function getFila() {
        if ($this->resultado != null) {
            return $this->resultado->fetch();
        } else {
            return false;
        }
    }

    public function getNumeroFilas() {
        if ($this->resultado != null) {
            return $this->resultado->rowCount();
        }
        return -1;
        //según la documentación no devuelve siempre el número de filas después de un select (depende del SGBD)
    }

    public function setBaseDatos($bd) {
        return self::$conexion->query("use $baseDatos") !== false;
    }

    public function closeConsulta() {
        $this->resultado->closeCursor();
    }

    /**
     * Realiza un query de la consulta utilizando  consultas preparadas y haciendo un bind de los valores por nombre
     * @param type $sql
     * @param type $param
     */
    public function setConsulta($sql, $param = array()) {
        $this->resultado = self::$conexion->prepare($sql);
        foreach ($param as $indice => $valor) {
            $this->resultado->bindValue($indice, $valor);
        }
        return $this->resultado->execute();
    }

    /**
     * Realiza el query con consulta preparada con id.
     * @param type $sql
     * @param type $param
     */
    public function setConsultaPreparada($sql, $param = array()) {
        $this->resultado = self::$conexion->prepare($consulta);
        $pos = 1;
        foreach ($parametros as $valor) {
            $this->resultado->bindValue($pos, $valor);
            $pos++;
        }

        return $this->resultado->execute();
    }

    /**
     * 
     * @param type $sql
     * @return boolean
     */
    public function setConsultaSQL($sql) {
        $this->resultado = self::$conexion->query($sql);
        if ($this->resultado === false) {
            $this->resultado = null;
            return false;
        } else {
            return true;
        }
    }

    public function setTransaccion() {
        self::$conexion->beginTransacion();
    }

    public function setValidarTransaccion() {
        self::$conexion->commit();
    }

    public function setAnularTrasaccion() {
        self::$conexion->rollBack();
    }

    public function getError() {
        return $this->resultado->errorInfo();
    }

    public function getErorres() {
        mysql_errno(self::$conexion) . ": " . mysql_error(self::$conexion) . "\n";
    }

	public static function dameCamposAlias($campos = array(), $alias = ''){
		$retorno = '';
		$alias_tabla = '';
		if ($alias != ''){
			$alias_tabla = '`' . $alias . '`.';
		}
		foreach($campos as $clave => $campo){
			$retorno .= (($retorno != '') ? ', ' : '') . $alias_tabla . '`' . $campo . '` `' . $alias . '_' . $campo . '` ';
		}
		return($retorno);
	}	
}
