<?php

/**
 * Description of BaseDatos
 *
 * @author pedroTHDC
 * @version 0.6
 */
class BaseDatos {

    private $conexion;
    private $resultado;

    function __construct($db_name = 'arminet_web', $user = 'arminet_web', $password = 'sinlib05', $servidor = '127.0.0.1') {
        /* Conectar a una base de datos de MySQL invocando al controlador */
        /*$dsn = 'mysql:dbname=' . $db_name . ';host=127.0.0.1';
        $usuario = $user;
        $contraseña = $password;
        try {
            $this->conexion = new PDO($dsn, $usuario, $contraseña);
        } catch (PDOException $e) {
            $this->conexion = null;
            echo 'Falló la conexión: ' . $e->getMessage();
        }*/
		// mysqli, object oriented way
		$this->conexion = new mysqli($servidor, $user, $password, $bd_name);
    }

    function isConectado() {
        if ($this->conexion != NULL) {
            return true;
        } else {
            return false;
        }
    }

//

    function closeConexion() {
		unset($this->conexion);
        $this->conexion = null;
    }

//
    function getAutonumerico() {
        if ($id = $this->conexion->insert_id) {
            return $id;
        } else {
            return false;
        }
    }

    function getFila() {
        if ($this->resultado != null) {
            return $this->resultado->fetch_array();
        } else {
            return false;
        }
    }

    function getNumeroFilas() {
        if ($this->resultado != null) {
            return $this->resultado->num_rows();
        }
        return -1;
        //según la documentación no devuelve siempre el número de filas después de un select (depende del SGBD)
    }

    function setBaseDatos($bd) {
        return $this->conexion->query("use $baseDatos") !== false;
    }
/*
    function closeConsulta() {
        $this->resultado->closeCursor();
    }
*/
    /**
     * Realiza un query de la consulta utilizando  consultas preparadas y haciendo un bind de los valores por nombre
     * @param type $sql
     * @param type $param
     */
    function setConsulta($sql) { //TODO
        $this->resultado = $this->conexion->prepare($sql);
        foreach ($param as $indice => $valor) {
            $this->resultado->bindValue($indice, $valor);
        }
        return $this->resultado->execute();
    }

    /**
     * Realiza el query con consulta preparada con id.
     * @param type $sql
     * @param type $param
     */
    function setConsultaPreparada($sql, $param = array()) { //TODO
        $this->resultado = $this->conexion->prepare($consulta);
        $pos = 1;
        foreach ($parametros as $valor) {
            $this->resultado->bindValue($pos, $valor);
            $pos++;
        }

        return $this->resultado->execute();
    }

    /**
     * 
     * @param type $sql
     * @return boolean
     */
    function setConsultaSQL($sql) {
        $this->resultado = $this->conexion->query($sql);
        if ($this->resultado === false) {
            $this->resultado = null;
            return false;
        } else {
            return true;
        }
    }

    /*function setTransaccion() {
        $this->conexion->beginTransacion();
    }

    function setValidarTransaccion() {
        $this->conexion->commit();
    }

    function setAnularTrasaccion() {
        $this->conexion->rollBack();
    }
*/
    function getError() {
        return $this->conexion->error();
    }

/*    function getErorres() {
        mysql_errno($this->conexion) . ": " . mysql_error($this->conexion) . "\n";
    }
*/
	public static function dameCamposAlias($campos = array(), $alias = ''){
		$retorno = '';
		$alias_tabla = '';
		if ($alias != ''){
			$alias_tabla = '`' . $alias . '`.';
		}
		foreach($campos as $clave => $campo){
			$retorno .= (($retorno != '') ? ', ' : '') . $alias_tabla . '`' . $campo . '` ' . $alias . '_' . $campo . ' ';
		}
		return($retorno);
	}	
}
