<?php

/*
  Class SuperAlbaran
 */

class SuperAlbaran {

    public $codigo = 0;
    public $num_doc = 0;
    public $cliente = 0;
    public $tipo_doc = '';
    public $nombre_tipo_doc = '';
    public $factura = 0;
    public $fecha = 0;
    public $fecha_date_format = 0;
    public $hora = 0;
    public $iva1 = 0;
    public $iva2 = 0;
    public $iva3 = 0;
    public $iva4 = 0;
    public $recargo = 0;
    public $recargo1 = 0;
    public $recargo2 = 0;
    public $recargo3 = 0;
    public $recargo4 = 0;
    public $bruto1 = 0;
    public $bruto2 = 0;
    public $bruto3 = 0;
    public $bruto4 = 0;
    public $base1 = 0;
    public $base2 = 0;
    public $base3 = 0;
    public $base4 = 0;
    public $imp_iva1 = 0;
    public $imp_iva2 = 0;
    public $imp_iva3 = 0;
    public $imp_iva4 = 0;
    public $imp_recargo1 = 0;
    public $imp_recargo2 = 0;
    public $imp_recargo3 = 0;
    public $imp_recargo4 = 0;
    public $total_albaran = 0;
    public $cantidad = 0;
    public $lineas_albaran = array();

    function __construct($codigo = 0, $crear_objetos_linea = false, $crear_objetos_articulo = false, $crear_objeto_cliente = false) {
        include('comunes/globals.php');
        //Cargamos todos los datos del albaran
        $sentencia_sql = "SELECT cab_albaran.codigo, num_doc, cliente.codigo cliente, tipo_doc, nombre_tipo_doc, factura, fecha, hora, 
							iva1, iva2, iva3, iva4, 
							recargo, recargo1, recargo2, recargo3, recargo4, 
							bruto1, bruto2, bruto3, bruto4, 
							base1, base2, base3, base4, 
							imp_iva1, imp_iva2, imp_iva3, imp_iva4, 
							imp_recargo1, imp_recargo2, imp_recargo3, imp_recargo4, 
							total_albaran
						FROM cliente, cab_albaran 
						WHERE cab_albaran.codigo = $codigo 
						AND cab_albaran.cliente = cliente.codigo_sinlib";
        //echo("$sentencia_sql<br />\n");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->num_doc = $fila['num_doc'];
                    $this->cliente = ($crear_objeto_cliente) ? new Usuario($fila['cliente']) : NULL;
                    $this->tipo_doc = $fila['tipo_doc'];
                    $this->nombre_tipo_doc = $fila['nombre_tipo_doc'];
                    $this->factura = $fila['factura'];
                    $this->fecha = $fila['fecha'];
                    $this->fecha_date_format = date_create($this->fecha);
                    $this->hora = $fila['hora'];
                    $this->iva1 = $fila['iva1'];
                    $this->iva2 = $fila['iva2'];
                    $this->iva3 = $fila['iva3'];
                    $this->iva4 = $fila['iva4'];
                    $this->recargo = $fila['recargo'];
                    $this->recargo1 = $fila['recargo1'];
                    $this->recargo2 = $fila['recargo2'];
                    $this->recargo3 = $fila['recargo3'];
                    $this->recargo4 = $fila['recargo4'];
                    $this->bruto1 = $fila['bruto1'];
                    $this->bruto2 = $fila['bruto2'];
                    $this->bruto3 = $fila['bruto3'];
                    $this->bruto4 = $fila['bruto4'];
                    $this->base1 = $fila['base1'];
                    $this->base2 = $fila['base2'];
                    $this->base3 = $fila['base3'];
                    $this->base4 = $fila['base4'];
                    $this->imp_iva1 = $fila['imp_iva1'];
                    $this->imp_iva2 = $fila['imp_iva2'];
                    $this->imp_iva3 = $fila['imp_iva3'];
                    $this->imp_iva4 = $fila['imp_iva4'];
                    $this->imp_recargo1 = $fila['imp_recargo1'];
                    $this->imp_recargo2 = $fila['imp_recargo2'];
                    $this->imp_recargo3 = $fila['imp_recargo3'];
                    $this->imp_recargo4 = $fila['imp_recargo4'];
                    $this->total_albaran = $fila['total_albaran'];
                }
            }
            //Ahora vamos con las líneas
            if ($crear_objetos_linea) {
                $this->cargar_lineas($crear_objetos_articulo);
            }
        }
        $this->cantidad = $this->get_cant_total();
    }

    function cargar_lineas($crear_objetos_articulo = false) {
        include('comunes/globals.php');
        $sentencia_sql = "SELECT codigo FROM lin_albaran WHERE cab_albaran = " . $this->codigo;
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                $this->lineas_albaran[count($this->lineas_albaran)] = new LineaAlbaran($fila['codigo'], $this->codigo, $crear_objetos_articulo);
            }
        }
    }

    function cargar_objeto_articulo_linea() {
        foreach ($lineas_albaran as $clave => $valor) {
            $valor->cargar_objeto_articulo();
        }
    }

    function get_cant_total() {
        include('comunes/globals.php');
        $cantidad = 0;
        if ($this->codigo > 0) {
            $sentencia_sql = "SELECT SUM( cantidad ) total FROM lin_albaran WHERE cab_albaran = " . $this->codigo;
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $cantidad = $fila['total'];
                }
            }
        }
        return($cantidad);
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->num_doc);
        unset($this->cliente);
        unset($this->tipo_doc);
        unset($this->nombre_tipo_doc);
        unset($this->factura);
        unset($this->fecha);
        unset($this->hora);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>