<?php

/**
  Clase Articulo
  @version 1.1
  Versión 1.1 ==> 15/Noviemb/2016 =>	Añadida función estática para buscar un producto por ean o código indistíntamente
  La clase artículo utilizará esta misma función para localizar el producto en el parámetro $ean
  Versión 2.0 ==> Vamos a optimizar las cargas de producto y las select que se utilizan aquí.
	Se cargará siempre el producto sin sus datos adicionales (escaparates asociados, temas, adjuntos, etc. Según el caso el diseñoador decidirá qué cargar.
	se hará una única carga por EAN y código y se cogerá el primero de los dos elementos_relacionados
 */
class SuperArticulo extends Apartado {

    public $codigo = 0;
    public $tipo = 0;
    public $nombre = 0;
    public $subtitulo = 0;
    public $stock = 0;
    public $pvp = 0;
    public $iva = 0;
    public $base = 0;
    public $ean = 0;
    public $referencia = 0;
    public $isbn = 0;
    public $autor = 0;
    public $fecha_alta = 0;
    public $num_paginas = 0;
    public $peso = 0;
    public $alto = 0;
    public $ancho = 0;
    public $ilustrador = 0;
    public $observaciones = 0;
    public $fecha_ult_modif = 0;
    public $editorial = '';
    public $cod_editorial = 0;
    public $cod_distribuidor = 0;
    public $coleccion = 0;
    public $no_web = 0;
    public $familia = 0;
    public $familia_nombre = '';
    public $foto = 0;
    public $tema = 0;
    public $pvpoferta = 0;
    public $base_pvpoferta = 0;
    public $dto_maximo = 0;
    public $texto = 0;
    public $pvp_tar1 = 0;
    public $pvp_tar2 = 0;
    public $pvp_tar3 = 0;
    public $pvp_tar4 = 0;
	public $pvp_tar = Array();
    public $dto_tar1 = 0;
    public $dto_tar2 = 0;
    public $dto_tar3 = 0;
    public $dto_tar4 = 0;
	public $dto_tar = Array();
    public $fecha_envio = 0;
    public $pendiente_envio = 0;
    public $fecha_creacion_web = 0;
    public $encuadernacion = 0;
    public $edicion = 0;
    public $ano_edicion = 0;
    public $suma_votos = 0;
    public $total_votos = 0;
    public $estado = 0;
    public $stock_disponible = 0;
    public $desde_edad = 0;
    public $hasta_edad = 0;
    public $promociones = 0;
    public $nivel_lectura = 0;
    public $curso = 0;
    public $ubicacion1 = 0;
    public $ubicacion2 = 0;
    public $unidades_caja = 1;
    public $tipo_precio = 'F';
    public $nombreColeccion = '';
    public $numeroColeccion = 0;
    public $talla = '';
    public $color = 'gris';
    public $articulo_padre = 0;
    public $fecha_ultima_compra = '0000-00-00';
    public $pendiente_envio_suscripcion = 0;
    public $fecha_envio_suscripcion = 0;
    public $temas = array();
    public $lista_escaparates = array();
    //Le añado el descuento para el usuario y el precio para el usuario
    public $descuento_cliente = 0;
    public $pvp_final = 0;
    public $base_final = 0;
	public $adjuntos = array();
	
	//Vamos a sobreescribir en esta clase los alias y campos porque necesitamos más:
	
	public static function getCampos(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			include('comunes/diccionario/diccionario.php');
			self::$campos_tabla = ${self::$nombreTabla . 'Campos'};
			self::$camposSelect = 
				BaseDatos::dameCamposAlias(${self::$nombreTabla . 'Campos'}, self::getAlias()) . ', ' . 
				BaseDatos::dameCamposAlias(${TraduccionArticulo::getNombreTabla() . 'Campos'}, TraduccionArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(${SeoArticulo::getNombreTabla() . 'Campos'}, SeoArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(${Familia::getNombreTabla() . 'Campos'}, Familia::getAlias());
		}
		return(self::$camposSelect);
	}
	
	public static function getNombreTabla(){
		//Incluimos los globals para coger el valor del idioma:
		include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		self::$nombreTabla = self::$nombreTabla . ' `' .  self::getAlias() . '`  
							LEFT JOIN ' . TraduccionArticulo::getNombreTabla() . ' `' . TraduccionArticulo::getAlias() . '` on (`' .  self::getAlias() . '`.`codigo` = `' .  TraduccionArticulo::getAlias() . '`.`articulo` AND `' .  TraduccionArticulo::getAlias() . '`.`idioma` = "' . $idioma . '")
							LEFT JOIN ' . SeoArticulo::getNombreTabla() . ' `' . SeoArticulo::getAlias() . '` on(`' . SeoArticulo::getAlias() . '`.`articulo` = `' . self::getAlias() . '`.`codigo` AND `' . SeoArticulo::getAlias() . '`.`idioma` = "' . $idioma . '" ) 
							LEFT JOIN ' . Familia::getNombreTabla() . ' `' . Familia::getAlias() . '` on (`' . self::getAlias() . '`.`familia` = `' . Familia::getAlias() . '`.`codigo` ) ';
		return(self::$nombreTabla);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$ean_articulo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$no_web = isset($argumentos[1]) ? $argumentos[1] : 0;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		include('comunes/globals.php');
		self::$whereSelect = '';
		if ($ean_articulo != NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = "' . $ean_articulo . '" OR `' .  self::getAlias() . '`.`ean` = "' . $ean_articulo . '"';
		}
		if ($no_web) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' .  self::getAlias() . '`.`no_web` = 0';
		}
		if (Shop::$configuracion->ocultar_stock_0) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' .  self::getAlias() . '`.`stock` > 0';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 0,1 ';
		}
		return(self::$whereSelect);
	}
	
    function __construct($ean_articulo = NULL, $cliente = NULL, $cantidad = 1, $lote = 0, $no_web = true, $solo_datos = true) {
        include('comunes/globals.php');
        //Si el cliente que nos han pasado es nulo, cogemos el de la sesión
        if ($cliente == NULL) {
            $cliente = Sesion::get('cod_cliente_web');
        }
        $idioma = Sesion::get('idioma');
        $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
        $cod_articulo = NULL;
		$filaArticulo = NULL;
		//Vamos a convertir este constructor en un V2:
		if (is_a($ean_articulo, 'OpcionesWidget')) {
			$opciones = $ean_articulo;
			$ean_articulo = ($opciones->configuracion->ean_articulo != NULL) ? $opciones->configuracion->ean_articulo : $ean_articulo;
			$cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : $cliente;
			$cantidad = ($opciones->configuracion->cantidad != NULL) ? $opciones->configuracion->cantidad : $cantidad;
			$lote = ($opciones->configuracion->lote != NULL) ? $opciones->configuracion->lote : $lote;
			$no_web = ($opciones->configuracion->no_web != NULL) ? $opciones->configuracion->no_web : $no_web;
			$solo_datos = ($opciones->configuracion->solo_datos != NULL) ? $opciones->configuracion->solo_datos : $solo_datos;
			$filaArticulo = ($opciones->configuracion->filaArticulo != NULL) ? $opciones->configuracion->filaArticulo : $filaArticulo;
		}
		
        //Si el ean recibido es un array, entonces hemos recibido ean y c??o
        if (is_array($ean_articulo)) {
            if (count($ean_articulo) > 1) {
                $ean_articulo = $ean_articulo[1];
            }
            $ean_articulo = $ean_articulo[0];
        }
		//$cod_articulo = $this->buscaArticulo($ean_articulo);
		//Ojo a la posibilidad de haber recibido una "fila" de artículo:
		$fila = NULL;
		if ($filaArticulo == NULL){
			if (intval($ean_articulo) > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . Articulo::getCampos() . ' 
									FROM ' . Articulo::getNombreTabla() . '
									WHERE ' .Articulo::getWhereTabla($ean_articulo, $no_web) ;
				
				//echo("$sentencia_sql <br />\n");

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaArticulo;
		}
		if ($fila != NULL){
			$this->codigo = (int) $fila[self::getAlias() . '_' . 'codigo'];
			$this->tipo = $fila[self::getAlias() . '_' . 'tipo'];
			$this->nombre = $fila[self::getAlias() . '_' . 'nombre'];
			$this->subtitulo = $fila[self::getAlias() . '_' . 'subtitulo'];
			$this->stock = (int) $fila[self::getAlias() . '_' . 'stock'];
			$this->pvp = (float) $fila[self::getAlias() . '_' . 'pvp'];
			$this->iva = (int) $fila[self::getAlias() . '_' . 'iva'];
			$this->base = $this->pvp / ( 1 + ( $this->iva / 100 ) );
			$this->ean = trim($fila[self::getAlias() . '_' . 'ean']);
			$this->referencia = trim($fila[self::getAlias() . '_' . 'referencia']);
			$this->isbn = trim($fila[self::getAlias() . '_' . 'isbn']);
			$this->autor = $fila[self::getAlias() . '_' . 'autor'];
			$this->fecha_alta = $fila[self::getAlias() . '_' . 'fecha_alta'];
			$this->num_paginas = (int) $fila[self::getAlias() . '_' . 'num_paginas'];
			$this->peso = (int) $fila[self::getAlias() . '_' . 'peso'];
			$this->alto = (int) $fila[self::getAlias() . '_' . 'alto'];
			$this->ancho = (int) $fila[self::getAlias() . '_' . 'ancho'];
			$this->ilustrador = $fila[self::getAlias() . '_' . 'ilustrador'];
			$this->observaciones = $fila[self::getAlias() . '_' . 'observaciones'];
			$this->fecha_ult_modif = $fila[self::getAlias() . '_' . 'fecha_ult_modif'];
			$this->editorial = $fila[self::getAlias() . '_' . 'editorial'];
			$this->cod_editorial = $fila[self::getAlias() . '_' . 'cod_editorial'];
			$this->cod_distribuidor = $fila[self::getAlias() . '_' . 'cod_distribuidor'];
			$this->coleccion = $fila[self::getAlias() . '_' . 'coleccion'];
			$this->no_web = (int) $fila[self::getAlias() . '_' . 'no_web'];
			$this->familia = $fila[self::getAlias() . '_' . 'familia'];
			//$this->asigna_familia(); ==> TODO
			$this->familia_nombre = $fila[Familia::getAlias() . '_' . 'nombre'];
			$this->foto = (int) $fila[self::getAlias() . '_' . 'foto'];
			$this->tema = $fila[self::getAlias() . '_' . 'tema'];
			$this->pvpoferta = (float) $fila[self::getAlias() . '_' . 'pvpoferta'];
			if ($this->pvpoferta == 0) {
				$this->pvpoferta = $this->pvp;
			}
			$this->dto_maximo = (int) $fila[self::getAlias() . '_' . 'dto_maximo'];
			$this->texto = (int) $fila[self::getAlias() . '_' . 'texto'];
			$this->pvp_tar1 = (float) $fila[self::getAlias() . '_' . 'pvp_tar1'];
			$this->pvp_tar2 = (float) $fila[self::getAlias() . '_' . 'pvp_tar2'];
			$this->pvp_tar3 = (float) $fila[self::getAlias() . '_' . 'pvp_tar3'];
			$this->pvp_tar4 = (float) $fila[self::getAlias() . '_' . 'pvp_tar4'];
			$this->pvp_tar = [$this->pvp_tar1, $this->pvp_tar2, $this->pvp_tar3, $this->pvp_tar4];
			$this->dto_tar1 = (int) $fila[self::getAlias() . '_' . 'dto_tar1'];
			$this->dto_tar2 = (int) $fila[self::getAlias() . '_' . 'dto_tar2'];
			$this->dto_tar3 = (int) $fila[self::getAlias() . '_' . 'dto_tar3'];
			$this->dto_tar4 = (int) $fila[self::getAlias() . '_' . 'dto_tar4'];
			$this->dto_tar = [$this->dto_tar1, $this->dto_tar2, $this->dto_tar3, $this->dto_tar4];
			$this->fecha_envio = $fila[self::getAlias() . '_' . 'fecha_envio'];
			$this->pendiente_envio = $fila[self::getAlias() . '_' . 'pendiente_envio'];
			$this->fecha_creacion_web = $fila[self::getAlias() . '_' . 'fecha_creacion_web'];
			$this->encuadernacion = $fila[self::getAlias() . '_' . 'encuadernacion'];
			$this->edicion = (int) $fila[self::getAlias() . '_' . 'edicion'];
			$this->ano_edicion = (int) $fila[self::getAlias() . '_' . 'ano_edicion'];
			$this->suma_votos = (int) $fila[self::getAlias() . '_' . 'suma_votos'];
			$this->total_votos = (int) $fila[self::getAlias() . '_' . 'total_votos'];
			$this->estado = (int) $fila[self::getAlias() . '_' . 'estado'];
			$this->stock_disponible = (int) $fila[self::getAlias() . '_' . 'stock_disponible'];
			$this->desde_edad = (int) $fila[self::getAlias() . '_' . 'desde_edad'];
			$this->hasta_edad = (int) ($fila[self::getAlias() . '_' . 'hasta_edad'] == 0) ? 99 : $fila[self::getAlias() . '_' . 'hasta_edad'];
			$this->promociones = (int) $fila[self::getAlias() . '_' . 'promociones'];
			$this->nivel_lectura = (int) $fila[self::getAlias() . '_' . 'nivel_lectura'];
			$this->curso = $fila[self::getAlias() . '_' . 'curso'];
			$this->ubicacion1 = $fila[self::getAlias() . '_' . 'ubicacion1'];
			$this->ubicacion2 = $fila[self::getAlias() . '_' . 'ubicacion2'];
			$this->unidades_caja = $fila[self::getAlias() . '_' . 'unidades_caja'];
			//Pequeña correción, puede que unidades caja sea 0
			$this->unidades_caja = ($this->unidades_caja == 0) ? 1 : $this->unidades_caja;
			//OJO, siempre que sean libros, las unidades x caja será 1 (se hace así desde que descubrimos que galo usa este campo para otra cosa en libros
			$this->unidades_caja = ($this->tipo == 'L') ? 1 : $this->unidades_caja;
			$this->tipo_precio = ($fila[self::getAlias() . '_' . 'tipo_precio'] == '') ? $this->tipo_precio : $fila[self::getAlias() . '_' . 'tipo_precio'];
			$this->nombreColeccion = $fila[self::getAlias() . '_' . 'nombre_coleccion'];
			$this->numeroColeccion = $fila[self::getAlias() . '_' . 'numero_coleccion'];
			$this->talla = $fila[self::getAlias() . '_' . 'talla'];
			$this->color = $fila[self::getAlias() . '_' . 'color'];
			$this->articulo_padre = $fila[self::getAlias() . '_' . 'articulo_padre'];
			$this->fecha_ultima_compra = $fila[self::getAlias() . '_' . 'fecha_ultima_compra'];
			$this->pendiente_envio_suscripcion = (int) $fila[self::getAlias() . '_' . 'pendiente_envio_suscripcion'];
			$this->fecha_envio_suscripcion = $fila[self::getAlias() . '_' . 'fecha_envio_suscripcion'];
			//Traducciones
			$this->observaciones = $fila[TraduccionArticulo::getAlias() . '_' . 'traduccion'];
			//datos SEO:
			$this->nombre_seo = ($fila[SeoArticulo::getAlias() . '_' . 'nombre'] != '') ? $fila[SeoArticulo::getAlias() . '_' . 'nombre'] : $this->nombre;
			$this->title_seo = ($fila[SeoArticulo::getAlias() . '_' . 'title'] != '') ? $fila[SeoArticulo::getAlias() . '_' . 'title'] : $this->nombre;
			$this->descripcion_seo = ($fila[SeoArticulo::getAlias() . '_' . 'descripcion'] != '') ? $fila[SeoArticulo::getAlias() . '_' . 'descripcion'] : $this->observaciones;
			$this->keywords_seo = ($fila[SeoArticulo::getAlias() . '_' . 'keywords'] != '') ? $fila[SeoArticulo::getAlias() . '_' . 'keywords'] : $this->nombre;
			
			//Si el artículo no pertenece a ningún escaparate, vamos a crear el 'otros-productos'
			$this->url = Shop::$configuracion->url . traducir('otros-productos');
			
			//Sólo cargamos el resto de datos si así se nos ha especificado
			if (!$solo_datos) {
				$this->asigna_temas();
				$this->rellena_escaparates();
				//Como tenemos todos los escaparates del producto, vamos a coger el primero para la URL (si es q hay alguno)
				if (count($this->lista_escaparates) > 0) {
					//Si pertenece a algúne scaparate, cogemos SIEMPRE el primero
					$this->url = $this->lista_escaparates[0]->url;
				}
			}else{
				//Vamos a cargar aquí mismo el último escaparate:
				$sentencia_sql = 'SELECT IFNULL(`b`.`nombre`, `c`.`nombre`) nombre_escaparate
								FROM `categorias-productos` a, (`traducesca` b LEFT JOIN `cesca_seo` c ON `b`.`escaparate` = `c`.`cescaparate` AND `b`.`idioma` = "' . $idioma . '" AND `c`.`idioma` = "' . $idioma . '") 
								WHERE `a`.`articulo` = ' . $this->codigo . '  
								AND `a`.`categoria` = `b`.`escaparate`
								ORDER BY `orden` DESC LIMIT 0,1';
				//echo("$sentencia_sql\n<br />");
				$bdUrl = new BaseDatos();
				if ($fila = $bdUrl->getFila()){
					$this->url = corregir_url(Shop::$configuracion->url . (str_replace('/', '_', $fila['nombre_escaparate'])));
				}
			}
			//Por último, dejamos la URL con un formato bonito
			
			$this->url .= corregir_url('/' . (str_replace('/', '_', $this->nombre_seo)) . '-p' . $this->ean);
			//Si el producto NO está en un lote, entonces cargamos su precio de forma natural
			$this->pvp_final = 0;
			//Necesitamos asegurarnos de que el lote que nos han pasado contiene el artículo
			if ($lote > 0) {
				$sentencia_sql = "SELECT trabaja_cantidades, pvp FROM ml_lotes, mc_lotes WHERE ml_lotes.mc_lote = $lote AND ml_lotes.articulo = " . $this->codigo . ' AND mc_lotes.codigo = $lote ';
				//echo("$sentencia_sql<br />\n");
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					if ($fila = mysqli_fetch_array($resultado)) {
						if ($fila['trabaja_cantidades'] > 0) {
							$this->pvpoferta = $fila['pvp'];
							$this->pvp_final = $fila['pvp'];
						}
					}
				}
			}
			//Si no tenemos PVP, vamos a ver el precio del artículo y su tarifa, etc...
			if ($this->pvp_final == 0) {
				//Vamos a calcular precio y descuento
				$pvp_dto_arti = $this->calcula_precio_articulo($cliente, $cantidad);
				$this->descuento_cliente = $pvp_dto_arti[0];
				if ($pvp_dto_arti[1] == 0) {
					$pvp_dto_arti[1] = $this->pvp;
				}
				$this->pvp_final = Price::setDiscount($pvp_dto_arti[1], $pvp_dto_arti[0]);
			} else {
				
			}
			//Si hemos recibido alg??ote, es el momento de ver si tenemos ese lote en los descuentos para ver cual es su descuento
			if ($lote > 0) {
				$indice_dto_lote = Lote::buscar_dto_lote($lote);
				$cod_dto_lote_actual = '';
				$porcen_dto_actual = 0;
				if ($indice_dto_lote > -1) {
					$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
					$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
					$porcen_dto_actual = $cod_dto_lote_actual[1];
					$this->pvp_final = Price::setDiscount($this->pvp_final, $porcen_dto_actual);
				}
			}
		}
		//Lo ultimo es calcular la base del pvp final:
		$this->base_final = $this->pvp_final / ( 1 + ( $this->iva / 100 ) );
		$this->base_pvpoferta = $this->pvpoferta / ( 1 + ( $this->iva / 100 ) );
		$this->adjuntos = Ebook::cargarAdjuntos($this->ean);

	}

	function venderAdjuntos($cod_usuario){
		include('comunes/globals.php');
		$retorno = false;
		//Controlamos si hemos recibido un código o un objeto
		$usuario = NULL;
		if (is_a($cod_usuario, 'Usuario')){
			$usuario = $cod_usuario;
			$cod_usuario = $usuario->codigo;
		}else{
			$usuario = new Usuario($cod_usuario);
			$cod_usuario = $usuario->codigo;
		}
		//si tenemos un usuario bien creado vamos a utilizarlo:
		if ($cod_usuario > 0){
			$bd = new BaseDatos();

			//Vamos a limpiar las descargas que ya  existan para ese cliente y ean:
			$sentenciaBorrado = 'DELETE FROM `descargas_ebook` WHERE `ean` = ' . $this->ean . ' AND `usuario` = \'' . $cod_usuario . '\';';
			$bd->setConsultaSQL($sentenciaBorrado);
			
			//Necesitamos los adjuntos:
			$adjuntos = Ebook::getRutasAdjuntos($this->ean);
			$sentencia_sql = '';
			foreach($adjuntos as $clave => $valor){
				$sentencia_sql .= ( ($sentencia_sql != '')?',':'' ) . ' ( \'' . $this->ean . '\', \'' . $valor . '\', \'' . $cod_usuario . '\' ) ';
			}
			//echo("$sentencia_sql<br />\n");
			
			//Una vez q tenemos la select, vamos a hacer el insert
			if ($sentencia_sql != ''){
				$sentencia_sql = 'INSERT INTO descargas_ebook (`ean`, `ruta`, `usuario`) VALUES ' . $sentencia_sql;
			}
			//Para hacer pruebas, no actualizo el pedido
			$bd->setConsultaSQL($sentencia_sql);
			if ($bd->getNumeroFilas() > 0){
				$retorno = true;
			}
		}
		return($retorno);
	}
	
    function __destruct() {
        //Limpiamos los hijos que tenga asociados al artículo
        for ($i = 0; $i < count($this->temas); $i++) {
            unset($this->temas[$i]);
        }
        for ($i = 0; $i < count($this->lista_escaparates); $i++) {
            unset($this->lista_escaparates[$i]);
        }
    }
	
    public function asigna_temas() {
        include('comunes/globals.php');
        $sentencia_sql = "SELECT tema FROM temasarti WHERE articulo = " . $this->codigo;
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		while ($fila = $bd->getFila()){
			$this->temas[count($this->temas)] = new Temas($fila['tema']);
		}
    }

    public function rellena_escaparates() {
        include('comunes/globals.php');
        $idioma = Sesion::get('idioma');
        $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
        $sentencia_sql = 'SELECT `categoria` FROM `categorias-productos` WHERE `articulo` = ' . $this->codigo . ' ORDER BY `orden` DESC';
        //echo("$sentencia_sql\n<br />");
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		while ($fila = $bd->getFila()){
                    //comento esta linea porque antes la select era por codigo y ahora en la tabla nueva que hemos creado es categoria
			//$escaparateTMP = new Escaparate($fila['codigo'], 1);
			$escaparateTMP = new Escaparate($fila['categoria'], 1);
			if ($escaparateTMP->objeto_vacio == 0) {
				$this->lista_escaparates[count($this->lista_escaparates)] = $escaparateTMP;
			}
		}
    }

    public function dame_indice_escaparate_codigo($codigo_a_buscar) {
        $retorno = NULL;
        //Buscamos el índice en el array de códigos de escaparate
        $encontrado = false;
        for ($i = 0; ( ($i < count($this->lista_escaparates)) && (!($encontrado))); $i++) {
            if ($this->lista_escaparates[$i]->codigo == $codigo_a_buscar) {
                $retorno = $i;
                $encontrado = true;
            }
        }
        return($retorno);
    }

    public function productos_relacionados($cantidad = 0, $seleccion_x_escaparate = false) {
        include('comunes/globals.php');
        $retorno = 0;
        if ($cantidad == 0) {
            $cantidad = Shop::$configuracion->elementos_relacionados;
        }
        $codigos_a_quitar = "'" . $this->codigo . "'";
        if ($seleccion_x_escaparate) {
            //Cuando hay selección por escaparate, cargamos primero los asociados por escaparate y después por otros datos:
            $this->lista_articulos = $this->relacionados_x_escaparate($cantidad, $this->lista_articulos, $codigos_a_quitar);
            $codigos_a_quitar = $this->extraerCodigo(false, $this->codigo);
            $this->lista_articulos = $this->relacionados_x_datosArti($cantidad, $this->lista_articulos, $codigos_a_quitar);
        } else {
            $this->lista_articulos = $this->relacionados_x_datosArti($cantidad, $this->lista_articulos, $codigos_a_quitar);
            $codigos_a_quitar = $this->extraerCodigo(false, $this->codigo);
            $this->lista_articulos = $this->relacionados_x_escaparate($cantidad, $this->lista_articulos, $codigos_a_quitar);
        }
        $retorno = count($this->lista_articulos);
        return($retorno);
    }

    private function relacionados_x_datosArti($cantidad, $lista_actual = array(), $codigos_a_quitar = "") {
        include('comunes/globals.php');
		//Sentencia por optimizar
        if (count($lista_actual) < $cantidad) {
            $cantidad = $cantidad - count($lista_actual);
            //Vamos a cargar los productos asociados por autor y editorial, ordenados por la fecha de alta
            $this->sentencia_select = "SELECT codigo FROM articulo 
								WHERE ( autor LIKE '%" . $this->autor . "%' OR editorial LIKE '%" . $this->editorial . "%' )
									AND codigo NOT IN (" . $codigos_a_quitar . ") AND no_web = 0 ";
            $this->orden_select = "	ORDER BY RAND() LIMIT 0, $cantidad ";
            $this->paginacion_select = '';
            $sentencia_sql = $this->sentencia_select . $this->orden_select . $this->paginacion_select;
            //echo("$sentencia_sql<br />\n");
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($lista_actual, new Articulo($fila['codigo']));
			}
        }
        return($lista_actual);
    }

    private function relacionados_x_escaparate($cantidad, $lista_actual = array(), $codigos_a_quitar = '') {
        //En esta función vamos a cargar 10 veces más productos de los que indica "cantidad", después cortaremos la lista para sacar 3 de forma aleatoria
        include('comunes/globals.php');
        if (count($lista_actual) < $cantidad) {
            $cantidad = $cantidad - count($lista_actual);
            if ($cantidad > 0) {
                //Si no tenemos suficientes, vamos a cargar los asociados por los mismos escaparates
                //cargamos los "cantidad" productos asociados a este por los escaparates que tiene
                if (count($this->lista_escaparates) > 0) {
                    $num_elementos = count($this->lista_escaparates);
                    $cad_escaparates = '';
                    for ($i = 0; $i < $num_elementos; $i++) {
                        if ($this->lista_escaparates[$i]->codigo > 0) {
                            $cad_escaparates .= ( ($cad_escaparates != '' ) ? ', ' : '') . $this->lista_escaparates[$i]->codigo;
                        }
                    }
                    if ($cad_escaparates != '') {
                        $cad_escaparates = '(' . $cad_escaparates . ')';
                        //Si tenemos escaparates cargamos los productos de dichos escaparates
                        $escaparate = new Escaparate(0, 0); //Creamos un escaparate vacío
                        //print_r($escaparate);
                        //Utilizamos el método de los escaparates para cargar los hijos
                        if ($num_elementos > 0) {
                            $escaparate->cargar_productos_escaparate(0, $cad_escaparates, ($cantidad * 5), '(' . $codigos_a_quitar . ')');
                            //Tengo en cuenta que haya un elemento, porque la función "array_rand" devuelve un elemento simple cuando el array sólo contiene un elmeento
                            $cantidad_a_extraer = min(count($escaparate->lista_articulos), $cantidad);
                            if ($cantidad_a_extraer > 1) {
                                foreach (array_rand($escaparate->lista_articulos, $cantidad_a_extraer) as $clave => $valor) {
                                    array_push($lista_actual, $escaparate->lista_articulos[$valor]);
                                }
                            } else if ($cantidad_a_extraer == 1) {
                                array_push($lista_actual, $escaparate->lista_articulos[0]);
                            }
                        }
                        $escaparate->lista_articulos = $lista_actual;
                        unset($escaparate);
                    }
                }
            }
        }
        return($lista_actual);
    }

    public function temas_con_traduccion() {
        return(array_filter($this->temas, 'Articulo::filtrar_temas_con_tracuccion'));
    }

    public static function filtrar_temas_con_tracuccion($objeto_tema) {
        if ($objeto_tema->traduccion != '') {
            return(true);
        } else {
            return(false);
        }
    }

    public static function dame_valor_campo($campo, $codigoArticulo) {
        include 'comunes/globals.php';
        $valor = null;
        $sentencia_sql = "SELECT $campo FROM articulo  WHERE codigo = $codigoArticulo";
        //echo("$sentencia_sql<br />\n");
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $valor = $fila[$campo];
            }
        }
        return $valor;
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (gettype($value) == 'string') {
                $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
            } else {
                $resp .= '"' . $key . '":' . json_encode($value) . ',';
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

    /**
     *
     */
    public function hasHijos() {
        //modificada por Tomás: vamos a aligerar este proceso 
        include 'comunes/globals.php';

        //$sentencia_sql = "SELECT count(*) as count FROM articulo  WHERE articulo_padre =".$this->codigo;
        $sentencia_sql = "SELECT codigo as count FROM articulo  WHERE articulo_padre =" . $this->codigo;
        $result = mysqli_query($conexionBD, $sentencia_sql);
        return mysqli_num_rows($result);
        /* mysqli_row_count;
          //echo("$sentencia_sql<br />\n");
          if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
          if ($fila = mysqli_fetch_array($resultado)) {
          $valor = $fila["count"];
          }
          }

          return $valor; */
    }

    public static function buscaArticulo($codigo) {
        include('comunes/globals.php');
        $retorno = 0;
        if ($conexionBD) {
			 //Si tenemos código no seguimos
			$sentencia_sql = "SELECT codigo FROM articulo WHERE ean = '$codigo'";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				if ($fila = mysqli_fetch_array($resultado)) {
					$retorno = $fila['codigo'];
				}
			}
			if ($retorno == 0) {
				$sentencia_sql = "SELECT codigo FROM articulo WHERE codigo = $codigo";
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					if ($fila = mysqli_fetch_array($resultado)) {
						$retorno = $fila['codigo'];
					}
				}
			}
        }
        return($retorno);
    }

    public static function dameCampo($codigo, $nombreCampo) {
        include('comunes/globals.php');
        $retorno = 0;
        $codigo = $this::buscaArticulo($codigo);
        if ($conexionBD) {
            $sentencia_sql = "SELECT $nombreCampo FROM articulo WHERE codigo = $codigo";
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $retorno = $fila[$nombreCampo];
                }
            }
        }
        return($retorno);
    }


	//Funciones de precios:
	private function calcula_precio_articulo($cliente = 0, $cantidad = 1) {
		include('comunes/globals.php');
		if ($cliente == NULL) {
			$cliente = 0;
		}
		$pvp_final = 0;
		$dto = 0;
		$pvp_arti = 0;
		$retorno = array(0, 0);

		$pvp_final = $this->pvpoferta;
		$pvp = $this->pvp;
		if (Shop::$configuracion->trabaja_descuentos){
			//Si no tenemos pvp_final, vamos a ver el descuento del cliente por código promocional
			if ($pvp_final == 0) {
				//Si es sindis, o sinlib, hay que hacer una cosa u otra
				switch (Shop::$configuracion->programa_arminet) {
					case 1:
						//Sindis
						$dto = dame_descuento_sindis($this->codigo, $cliente);
						//$dto = calcula_dto_cliente($cliente);
						break;
					case 2:
						//Herbolib
						break;
					default:
						//Por defecto sinlib
						$dto = calcula_dto_cliente($cliente);
						break;
				}
			}
			//Si no tenemos descuento ni precio, vamos a calcular el precio del artículo
			if (($dto == 0) && ($pvp_final == 0)) {
				switch (Shop::$configuracion->programa_arminet) {
					case 1:
						//Sindis
						$pvp_final = $this->dame_precio_articulo_sindis($this->codigo, $cantidad, $cliente);
						break;
					case 2:
						//Herbolib
						break;
					default:
						//Por defecto sinlib
						$pvp_final = dame_precio_articulo($this->codigo, $cantidad, $cliente);
						break;
				}
			}
			//Si ni por esas tenemos precio, entonces vamos a ver si hubiese algún descuento especial para ese cliente
			if (($dto == 0) && ($pvp_final == $pvp )) {
				$dto = dame_descuento($this->codigo, $cliente);
			}
		}
		$retorno[0] = $dto;
		$retorno[1] = $pvp_final;
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Devolvemos el precio de un artículo para un cliente
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	private function dame_precio_articulo($cantidad = 1, $cliente = 0, $prensa = 0) {
		include('comunes/globals.php');
		$hoy = date('Y-m-d');
		//El cliente que recibimos es el de la web. Necesitamos el de sinlib
		$cliente = dame_cod_programa($cliente);
		$pvp = 0;
		$precios_escalados = 0;
		$tarifas_multiples = 0;
		$resta_iva = 0;
		$tarifa = 0;
		//Si el artículo está de oferta, entonces no hay que cargar más datos
		if ($this->pvpoferta > 0) {
			$pvp = $this->pvpoferta;
		}
		if ($pvp == 0) {
			//Cargamos los datos que necesitamos de los clientes que afectan al precio del artículo
			$sentencia_sql = "SELECT tarifa, precios_escalados, resta_iva, tarifas_multiples FROM cliente WHERE codigo_sinlib = $cliente";
			//echo("Tarifas, precios escalados, resta iva, tarifas multiples:<br />$sentencia_sql<br />\n");
			//echo("Consulta: $sentencia_sql<br />\n");
			if ($resultado_cli = mysqli_query($conexionBD, $sentencia_sql)) {
				if ($fila_cli = mysqli_fetch_array($resultado_cli)) {
					$tarifa = $fila_cli['tarifa'];
					$precios_escalados = $fila_cli['precios_escalados'];
					$resta_iva = $fila_cli['resta_iva'];
					$tarifas_multiples = $fila_cli['tarifas_multiples'];
				}
			}
		}
		//Ahora con los datos que tenemos vamos a ir viendo que precio tiene el producto
		//__________________________________________________________________________________________________________________________________________
		//_____________________________________________________ ARTIOFERTAS ________________________________________________________________________
		//__________________________________________________________________________________________________________________________________________
		if ($pvp == 0) {
			$pvp = calcula_precio_oferta_arti($articulo);
		}
		//__________________________________________________________________________________________________________________________________________
		//_____________________________________________________ DTOS_CLI_ART _______________________________________________________________________
		//__________________________________________________________________________________________________________________________________________
		if ($pvp == 0) {
			$pvp = calcula_precio_cliente($articulo, $cliente);
		}
		//__________________________________________________________________________________________________________________________________________
		//_____________________________________________________ PRECIOS ESCALADOS __________________________________________________________________
		//__________________________________________________________________________________________________________________________________________
		if (($pvp == 0) && ( $precios_escalados == 1 )) {
			$pvp = dame_precio_escalado($articulo, $cantidad);
		}
		//__________________________________________________________________________________________________________________________________________
		//_______________________________________________________________ TARIFAS X FAMILIA ________________________________________________________
		//__________________________________________________________________________________________________________________________________________
		if (($pvp == 0) && ($this->tipo == "P")) {
			//Si no usa tarifas múltiples, cogemos la tarifa del artículo
			if (($tarifas_multiples == 0) || ($tarifas_multiples == 255)) {
				$pvp = $this->pvp_tari[$tarifa];
			} else {
				//Como usa tarifas múltiples, vamos a consultarlas
				$sentencia_sql = 'SELECT tariarti.pvp precio_tarifa FROM dtosclifam, tariarti
							WHERE dtosclifam.cliente = $cliente AND dtosclifam.familia = "' . $familia . '" AND dtosclifam.tarifa != 255
							AND dtosclifam.tarifa = tariarti.codigo AND tariarti.descuento = 0 AND tariarti.articulo = ' . $this->codigo;
				//echo("Tarifa x familia:<br />$sentencia_sql<br />\n");
				if ($resultado_arti = mysqli_query($conexionBD, $sentencia_sql)) {
					if ($fila_arti = mysqli_fetch_array($resultado_arti)) {
						$pvp = $fila_arti['precio_tarifa'];
					}
				}
			}
		}
		//__________________________________________________________________________________________________________________________________________
		//_______________________________________________________________ TARIFAS MULTIPLES ________________________________________________________
		//__________________________________________________________________________________________________________________________________________
		if (($pvp == 0) && ($tipo == 'P')) {
			$sentencia_sql = "SELECT pvp FROM tariarti WHERE articulo = $articulo AND tarifa = $tarifas_multiples AND $tarifas_multiples != 255 AND descuento = 0";
			//echo("Datos articulo:<br />$sentencia_sql<br />\n");
			if ($resultado_arti = mysqli_query($conexionBD, $sentencia_sql)) {
				if ($fila_arti = mysqli_fetch_array($resultado_arti)) {
					$pvp = $fila_arti['pvp'];
				}
			}
		}
		//si no hay precio, cogemos el del artículo
		if ($pvp == 0) {
			$pvp = $this->pvp;
		}
		//Ahora vamos a ver si hay que restar el iva
		if ($resta_iva) {
			$pvp = calcula_base($pvp, $iva);
		}
		return($pvp);
	}
	
}

?>
