<?php
/*
	Clase SuperBanner
	// Editado por Tomás añadido el campo target.
	//Editado por Pedro para añadir la clase BaseDatos
*/
class SuperBanner{
	public $codigo = 0;
	public $posicion = 0;
	public $orden = 0;
	public $url = '';
	public $titulo = '';
	public $imagen = '';
	public $activo = 0;
	public $condicion = '';
	private $rutaBase = 'almacen_img/';
	public $target = '_blank';
	
	function __construct($codigo = 0){
		include('comunes/globals.php');
		//Cargamos los datos que necesitamos del banner
		$sentencia_sql = 'SELECT codigo, posicion, orden, url, titulo, imagen, activo, condicion, target FROM banner WHERE codigo = ' . $codigo;
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			if ($fila = $bd->getFila()){
				$imagen = $fila['imagen'];
				$this->codigo = $fila['codigo'];
				$this->posicion = $fila['posicion'];
				$this->orden = $fila['orden'];
				$this->url = $fila['url'];
				$this->titulo = $fila['titulo'];				
				if(!preg_match('/almacen_img/',$imagen)){
					//echo 'entra';
					$imagen = $this->rutaBase.$fila['imagen'];
				}
				$this->imagen = Shop::$configuracion->url.$imagen;
				$this->activo = $fila['activo'];
				$this->condicion = $fila['condicion'];
				$this->target = $fila['target'];
			}
		}
	}
	
	function __destruct() {
        unset($this->codigo);
        unset($this->posicion);
        unset($this->orden);
        unset($this->url);
        unset($this->titulo);
        unset($this->imagen);
        unset($this->activo);
        unset($this->condicion);
        unset($this->target);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}
?>