<?php
/*
	Clase SuperBusqueda
	@version 1.0
*/
class SuperBusqueda extends Apartado{
	//Esta clase se usa para hacer búsquedas y podre mostrar los resultados
	private $sentencia_sql = '';
	public $busqueda_simple = '';
	public $titulo = '';
	public $nombre = ''; //El nombre lo usamos en la búsqueda avanzada, lo cambiamos por el título
	public $editorial = '';
	public $autor = '';
	public $isbn = '';
	public $ean = '';
	public $nombreColeccion = '';
	public $categoria = '';
	public $tbusqueda = 'simple';/*0 = Normal 1 = Avanzada*/
	
	function __construct(){
		include('comunes/globals.php');
		$filtrado_previo = ''; //Indicamos que, por ahora, no hay filtrado previo
		//Esta función recibe un número indeterminado de parámetros
		$lista_argumentos = func_get_args();
		//Sólo funciona si el número de argumentos es par
		$numero_argumentos = func_num_args();
		if ($numero_argumentos % 2 == 1){
			//El último argumento es el filtrado
			$filtrado_previo = $lista_argumentos[$numero_argumentos-1];
			//Vamos a quitar el último argumento de la lista
			array_splice($lista_argumentos, -1, 1);
			$numero_argumentos--;
		}
		if ($numero_argumentos % 2 == 0){
			//Hemos recibido un número par de argumentos, hay que recorrerlos de 2 en 2
			for ($j = 0; $j < $numero_argumentos; $j+=2){
				$nombre_campo = $lista_argumentos[$j];
				$valor = $lista_argumentos[$j + 1];
				//Si el objeto tiene esta propiedad, entonces la asignamos
				if (property_exists('Busqueda', $nombre_campo)){
					$this->$nombre_campo = $valor;
					//echo("CAMPO: $nombre_campo <br />\n");
				}
			}
		}else{
			echo('ha ocurrido un error al crear la select, número de parámetros incorrectos<br />\n');
		}
		//Antes de seguir, componemos la cadena de filtrado, siempre y cuando lo haya
		//if ($filtrado_previo != ''){
		$this->adaptarFiltrado($filtrado_previo, true);
		/*
		//Filtrado por configuración
		//var_dump(Shop::$configuracion->segundaMano);
		if (Shop::$configuracion->segundaMano){
			$this->filtrado .= ' AND articulo.articulo_padre = 0 ';
			//echo $this->filtrado;
		}
		*/
		//}
		//Ahora, según los valores recibidos, vamos a hacer una cosa u otra
		if ($this->busqueda_simple != ''){
			//$this->tbusqueda ="simple";
			//Búsqueda sencilla
			$this->busqueda_simple = trim(str_replace('-', ' ', $this->busqueda_simple));
			//Vamos a dividir el texto de búsqueda en sus palabras
			$array_busqueda = explode(' ', $this->busqueda_simple);
			$this->sentencia_select = 'SELECT codigo, fecha_alta, codigo codigo_articulo FROM articulo WHERE (no_web = 0) AND (ean != "") ';
			$campos = str_replace("," , ",' '," ,Shop::$configuracion->campos_busqueda);
			$cadena_campos = " CONCAT($campos) ";
			foreach($array_busqueda as $clave => $valor){
				$this->sentencia_select .= " AND ( ";
				//Según la longitud de la palabra a buscar tenemos que hacer un like o un regexp
				/*
				if (strlen($valor) <=3){
					$this->sentencia_select .= $cadena_campos . " LIKE '%" . $valor . "%' ";
				}else{
					$this->sentencia_select .= $cadena_campos . " REGEXP '[[:<:]]" . $valor . "[[:>:]]' ";
				}
				*/
				//Cambiamos la búsqueda porque limitan demasiado las expresiones regulares.
				$this->sentencia_select .= $cadena_campos . " LIKE '%" . $valor . "%' ";
				//Nombre
				$this->sentencia_select .= " ) ";
			}
			//echo($this->sentencia_select . "\n");
			//$this->sentencia_select .= $this->descomponCadena($cadena_campos);
			//Vamos a componer los datos seo
			$this->title_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			$this->descripcion_seo = traducir('Estos son los productos encontrados en nuestra web con los términos de búsqueda ') . ' ' . $this->busqueda_simple;
			$this->keywords_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			//Creamos la url de esta búsqueda
			$this->url = Shop::$configuracion->url . 'buscar/' . str_replace(' ', '-', $this->busqueda_simple);
		}else{
			
			//Aquí va la búsqueda compleja
			$this->sentencia_select = 'SELECT codigo, fecha_alta, codigo FROM articulo WHERE (no_web = 0) AND (ean != "") ';
			//Vamos a crear la condición según el resto de parámetros
			if ($this->autor != ''){
				//$this->sentencia_select .= " AND (autor " . ( (strlen($this->autor) <= 3)? " REGEXP  '[[:<:]]" : " LIKE '%") . $this->autor . ( (strlen($this->autor) <= 3)? "[[:>:]]'" : "%'") . ")";
				$this->sentencia_select .= $this->descomponCadena('autor');
			}
			if ($this->editorial != ''){
				//$this->sentencia_select .= " AND (editorial " . ( (strlen($this->editorial) <= 3)? " REGEXP  '[[:<:]]" : " LIKE '%") . $this->editorial . ( (strlen($this->editorial) <= 3)? "[[:>:]]'" : "%'") . ")";
				$this->sentencia_select .= $this->descomponCadena('editorial');
			}
			if ($this->titulo != ''){
				$this->nombre = $this->titulo;
				//$this->sentencia_select .= " AND (nombre " . ( (strlen($this->titulo) <= 3)? " REGEXP  '[[:<:]]" : " LIKE '%") . $this->titulo . ( (strlen($this->titulo) <= 3)? "[[:>:]]'" : "%'") . ")";
				$this->sentencia_select .= $this->descomponCadena('nombre');
			}
			if ($this->isbn != ''){
				$this->sentencia_select .= " AND (isbn = '" . $this->isbn . "') ";
			}
			if ($this->ean != ""){
				$this->sentencia_select .= " AND (ean = '" . $this->ean . "') ";
			}
			if ($this->nombreColeccion != ""){
				//echo("El nombre de la coleccion es: " . $this->nombreColeccion . "<br>\n");
				$this->sentencia_select .= " AND (nombre_coleccion LIKE '%" . $this->nombreColeccion . "%') ";
			}
			
			//Ahora hay que crear la URL y los keywords
			$this->title_seo = '';
			$this->descripcion_seo = '';
			$this->keywords_seo = '';
			$this->url = Shop::$configuracion->url;
			$frase = '';
			$url = 'busqueda_avanzada';
			if ( ($this->titulo . $this->editorial . $this->autor . $this->isbn . $this->categoria .$this->nombreColeccion) != ''){
				$this->tbusqueda ='avanzada';
				//Hay datos como para generar el seo
				if ($this->autor != ''){
					if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('Autor/a') . ' ' . $this->autor;
					$url .= '/autor_' . trim(str_replace(' ', '-', $this->autor));
				}
				if ($this->editorial != ''){
					if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('Editorial') . ' ' . $this->editorial;
					$url .= '/editorial_' . trim(str_replace(' ', '-', $this->editorial));
				}
				if ($this->titulo != ''){
					if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('Título') . ' ' . $this->titulo;
					$url .= '/titulo_' . trim(str_replace(' ', '-', $this->titulo));
				}
				if ($this->categoria != ''){
					if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('Categoría') . ' ' . $this->categoria;
					$url .= '/categoria_' . trim(str_replace(' ', '-', $this->categoria));
				}
				if ($this->isbn != ''){
					if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('ISBN') . ' ' . $this->isbn;
					$url .= '/isbn_' . trim(str_replace(' ', '-', $this->isbn));
				}
				if ($this->nombreColeccion != ''){
						if ($frase != ''){
						$frase .= '. ';
					}
					$frase .= traducir('Colección') . ' ' . $this->nombreColeccion;
					$url .= '/nombreColeccion_' . trim(str_replace(' ', '-', $this->nombreColeccion));
				}
				$frase = traducir('Resultado de la búsqueda de:') . ' ' . $frase;
			}
			$this->title_seo = $this->descripcion_seo = $this->keywords_seo = $frase;
			$this->url .= $url;
		}
		//Aquí vamos a tener en cuenta las búsquedas de papelería
		if (Shop::$configuracion->busquedas_papeleria == 0){
			$this->sentencia_select .= " AND (tipo != 'P') ";
		}

		$this->sentencia_sql = $this->sentencia_select . $this->filtrado;
		//echo('<!-' . $this->sentencia_sql . '-->');
	}

	function carga_articulos($pagina_actual = 0){
		include('comunes/globals.php');
		//Ejecutamos la select para contar cuantos elementos hay
		if ($this->sentencia_sql != ''){
			//echo("<!--" . $this->sentencia_sql . "-->\n");
			//$query=mysqli_query($conexionBD, $this->sentencia_sql);
			//echo '<pre> CASA AZUL '.var_dump($query).'</pre>';
			$this->total_articulos = mysqli_num_rows(mysqli_query($conexionBD, $this->sentencia_sql));
			//Vamos con la paginación
			$elemento_inicial = Shop::$configuracion->elementos_por_pagina * $pagina_actual;
			//Ahora es el momento de añadir el orden a la búsqueda
			//$consulta = $this->sentencia_sql . " ORDER BY fecha_alta DESC " . ' LIMIT ' . $elemento_inicial . ', ' . Shop::$configuracion->elementos_por_pagina;
			$this->crea_orden(" ORDER BY fecha_alta DESC ");
			//$this->orden_select = " ORDER BY fecha_alta DESC ";
			$this->paginacion_select = ' LIMIT ' . $elemento_inicial . ', ' . Shop::$configuracion->elementos_por_pagina;
			$consulta = $this->sentencia_sql . $this->orden_select . $this->paginacion_select;
			//echo("$consulta<br />\n");
			//Ahora vamos a cargar los artículos en el escaparate
			//$tiempo_ini = microtime(true);
			
			//echo $consulta;
			
			if ($resultado = mysqli_query($conexionBD, $consulta)){
				while ($fila = mysqli_fetch_array($resultado)){
					$this->lista_articulos[count($this->lista_articulos)] = new Articulo($fila['codigo']);
				}
			}
			//$tiempo_ini = microtime(true) - $tiempo_ini;
			//echo("<br />la consulta tardó $tiempo_ini milisegundos. Hay " . $this->total_articulos . " resultados<br />");
		}
		if ($pagina_actual > 0){
			$this->title_seo .= ", " . traducir('página') . ' ' . ($pagina_actual + 1);
		}
	}

	function descomponCadena($nombre_campo){
		$retorno = '';
		if (property_exists ('Busqueda', $nombre_campo)){
			$array_valores = explode(' ', $this->$nombre_campo);
			foreach($array_valores as $clave => $valor){
				$retorno .= ' AND ( ';
				//Segun la longitud de la palabra, vamos utilizar expresión regular o like
				if (strlen($valor) <= 3){
					$retorno .= $nombre_campo . " LIKE '%" . $valor . "%' ";
				}else{
					//$retorno .= $nombre_campo . " REGEXP '[[:<:]]" . $valor . "[[:>:]]' ";
					$retorno .= $nombre_campo .  " LIKE '%" . $valor . "%' ";
				}
				$retorno .= " ) ";
			}
		}
		return($retorno);
	}

	function __destruct(){
		
	}
}
?>