<?php
/*
	Clase SuperCatálogo
	@version 1.0
*/
class SuperCatalogo{
	public $codigo = '';
	public $nombre = '';
	public $ruta = '';
	public $ruta_previsualizacion = '';
	public $nombre_original = '';
	public $descripcion = '';
	public $condicion = '';
	public $activo = 0;
	//Constructor y destructor
	function __construct($codigo = 0, $nombre = '', $ruta = '', $nombre_original = '', $descripcion = '', $condicion = '', $activo = NULL) {
		//echo('Codigo: $codigo, ruta: $ruta, nombre_original: $nombre_original, descripcion: $descripcion, condicion: $condicion, activo: $activo<br />\n');
		include('comunes/globals.php');
		//Si todos los campos tienen valor, entonces lo asignamos a manubrio:
		if ($codigo != 0 && $nombre != '' && $ruta != '' && $nombre_original != '' && $descripcion != '' && $condicion != '' && $activo != NULL){
			$this->codigo = $codigo;
			$this->nombre = $nombre;
			$this->ruta = $ruta;
			$this->nombre_original = $nombre_original;
			$this->descripcion = $descripcion;
			$this->condicion = $condicion;
			$this->activo = $activo;
		}else{
			$sentencia_sql = Catalogo::select_campos_tabla() . '
								FROM catalogo ';
			//Si hay codigo y/o condición, los añadimos a la select:
			if ($codigo != 0){
				$sentencia_sql .= " WHERE codigo = $codigo ";
			}
			if ($ruta != ""){
				$sentencia_sql .= ( ($codigo != 0) ? ' AND ' : ' WHERE ' ) . " ruta = '$ruta' ";
			}
			//echo("$sentencia_sql<br />\n");
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$this->codigo = $fila['codigo'];
						$this->nombre = $fila['nombre'];
						$this->ruta = $fila['ruta'];
						$this->nombre_original = $fila['nombre_original'];
						$this->descripcion = $fila['descripcion'];
						$this->condicion = $fila['condicion'];
						$this->activo = $fila['activo'];
					}
				}
			}
		}
		$this->extraer_portada();
	}

	public static function select_campos_tabla(){
		return('SELECT codigo, nombre, ruta, nombre_original, descripcion, condicion, activo');
	}

	public static function cargar_lista($condicion = '', $activo = NULL){
		include('comunes/globals.php');
		$sentencia_sql = Catalogo::select_campos_tabla() . '
						FROM catalogo ';
		if ($condicion != ''){
				$sentencia_sql .= " WHERE condicion = '$condicion' ";
			}
		if ($activo != NULL){
			$sentencia_sql .=  ( ($condicion != "") ? ' AND ' : ' WHERE ' ) ." AND activo = $activo";
		}
		//echo($sentencia_sql);
		$lista_catalogo = array();
		if ( ($conexionBD) && ($idioma != NULL) ){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				while ($fila = mysqli_fetch_array($resultado)){
					$lista_catalogo[] = new Catalogo($fila['codigo'], $fila['nombre'], $fila['ruta'], $fila['nombre_original'], $fila['descripcion'], $fila['condicion'], $fila['activo']);
				}
			}
		}
		return($lista_catalogo);
	}

	public static function crear($nombre = '', $ruta = '', $nombre_original = '', $descripcion = '', $condicion = '', $activo = 0){
		include('comunes/globals.php');
		$sentencia_sql ="INSERT INTO catalogo 
						(nombre, ruta, nombre_original, descripcion, condicion, activo) VALUES 
						('$nombre', '$ruta', '$nombre_original', '$descripcion', '$condicion', '$activo')";
		mysqli_query($conexionBD, $sentencia_sql);
		return(mysqli_insert_id($conexionBD));
		//Aquí cogemos el código de la tupla creada y lo devolvemos
	}

	public static function actualizar($codigo = 0, $nombre = '', $ruta = '', $nombre_original = '', $descripcion = '', $condicion = '', $activo = 0){
		include('comunes/globals.php');
		if ($codigo > 0){
			$sentencia_sql ="UPDATE catalogo SET
							nombre = '$nombre', ruta = '$ruta', nombre_original = '$nombre_original', descripcion = '$descripcion', condicion = '$condicion', activo = '$activo'
							WHERE codigo = $codigo ";
			mysqli_query($conexionBD, $sentencia_sql);
		}
	}

	function __destruct() {

	}
	
	public function extraer_portada(){
	//echo("esta entrando en extraer portada");
		ini_set('include_path', '../..' . PATH_SEPARATOR . get_include_path());
		include('comunes/globals.php');
		$tipos_permitidos = array('pdf', 'jpg', 'bmp', 'gif', 'png');
		//Sólo lo hacemos si es PDF
		if (in_array(strtolower(substr($this->nombre_original, -3)), $tipos_permitidos)){
			$ruta_absoluta = getcwd();
			$in = "$ruta_absoluta/adjuntos/ficheros/" . $this->ruta . "[0]";
			//echo($in);
			$out = "$ruta_absoluta/adjuntos/ficheros/temp/" . $this->ruta . '.jpg';
			//echo($out);
			//$comando = "/usr/bin/convert -thumbnail x300 -background white -alpha remove   $in   $out";
			//$comando = "/usr/bin/convert   $in   $out";
			$comando = "/usr/bin/convert $in  $out";
			//echo($comando . "<br />\n");
			exec($comando, $out, $rcode);
			//echo "Version return code is $rcode.<br>";
			//Print the output of "convert -version"    
			//echo alist($out);
			//echo $rcode ;
			if ($rcode == "0"){
				$this->ruta_previsualizacion =  $this->ruta . '.jpg';
				//echo($this->ruta_previsualizacion);
			}
			
		}
/*

//Try to get ImageMagick "convert" program version number.
exec("convert -version", $out, $rcode);
//Print the return code: 0 if OK, nonzero if error. 
echo "Version return code is $rcode <br>"; 
//Print the output of "convert -version"    
echo alist($out);
*/
	}
}

//This function prints a text array as an html list.
function alist ($array) {  
  $alist = '<ul>';
  for ($i = 0; $i < sizeof($array); $i++) {
    $alist .= "<li>$array[$i]";
  }
  $alist .= '</ul>';
  return $alist;
}

?>