<?php

/*
  Clase SuperConfiguracion
  @version 1.0
 */

class SuperConfiguracion {

    public $idioma = ''; //X
    public $importe_minimo = 0; //X
    public $elementos_por_pagina = 10; //V
    public $decimales = 2; //V
    public $num_novedades = 4;  //X
    public $paginas_a_mostrar = 8; //V
    public $descripcion = '';
    public $meta = '';
    public $busquedas_papeleria = 1; //V
    public $url_sin_idioma = ''; //V
    public $color_de_fondo = '#ffffff'; //V
    public $opacidad_fondo = 100; //V
    public $password_encriptado = 1; //V
    public $datos_obligatorios = ''; //X
    public $elementos_relacionados = 3; //V
    public $pedidos_sin_login = 0; //X
    public $tipo_envio = 0; //X
    public $dto_dia_libro = 0; //X
    public $franquicia_feran = 0; //X
    public $dto_texto = 0; //X
	public $dto_texto_libre = 0; //X
    public $mes_inicio_texto = 0; //X
    public $mes_fin_texto = 0; //X
    public $captchaSiteKey = '';
    public $captchaClaveSecreta = '';
    public $cesta_siempre_paso1 = false;
    public $programa_arminet = 0;
    public $cesta_login_inicio = 0;
    public $dias_borrado_pedidos_libros = 0;
    public $dias_borrado_pedidos_papeleria = 0;
    public $permitir_anular_pedidos_pendientes = false;
    public $elementos_hco_pedidos = 0;
    public $elementos_reservas = 0;
    public $elementos_pedidos_pendientes = 0;
    public $elementos_facturas = 0;
    public $elementos_albaranes = 0;
    public $elementos_depositos = 0;
    public $segundos_sesion = 0;
    public $cookies_rules = false;
    public $multi_idioma = false;
    public $registro_supervisado = false;
    public $registro_con_confirmacion = true;
    public $campos_busqueda = '';
    public $controlar_stock = 0;
    public $ocultar_stock_0 = 0;
    public $cliente_contado = 0;
    public $guardar_pedidos_bd = 0;
    public $segundaMano = 0;
    public $filtroGlobal = '';
    private $tam_portadas = array(); //V
	//Pedro 05/Febrero/2018 ==> Añadimos la posibilidad de descargar ebooks
	public $url_ebooks = '';
	public $limite_descargas_ebook = 0;
	public $servidor_portadas = 'https://www.sinlib.es/portadasSinlib/';
        public $no_foto = '';
	
	
    private function cargar_configuracionBD() {
        $resultado = false;
        include('comunes/globals.php');
        if ($conexionBD) {
            $sentencia_sql = 'SELECT * FROM configuracion WHERE 1 LIMIT 0 , 1';
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->idioma = $fila['idioma'];
                    $this->importe_minimo = $fila['importe_minimo'];
                    $this->elementos_por_pagina = $fila['elementos_por_pagina'];
                    $this->decimales = $fila['decimales_importe'];
                    $this->num_novedades = $fila['novedades_en_pagina'];
                    $this->paginas_a_mostrar = $fila['paginas_escaparate'];
                    $this->descripcion = $fila['descripcion'];
                    $this->meta = $fila['meta'];
                    $this->busquedas_papeleria = $fila['busquedas_papeleria'];
                    $this->color_de_fondo = $fila['color_de_fondo'];
                    $this->opacidad_fondo = $fila['opacidad_fondo'];
                    $this->url_sin_idioma = $fila['url'];
                    $this->password_encriptado = $fila['password_encriptado'];
                    $this->datos_obligatorios = $fila['datos_obligatorios'];
                    $this->elementos_relacionados = $fila['elementos_relacionados'];
                    $this->pedidos_sin_login = $fila['pedidos_sin_login'];
                    $this->tipo_envio = $fila['tipo_envio'];
                    $this->dto_dia_libro = $fila['dto_dia_libro'];
                    $this->franquicia_feran = $fila['franquicia_feran'];
                    $this->dto_texto = $fila['dto_texto'];
					$this->dto_texto_libre = $fila['dto_texto_libre'];
                    $this->mes_inicio_texto = $fila['mes_inicio_texto'];
                    $this->mes_fin_texto = $fila['mes_fin_texto'];
                    $this->captchaSiteKey = $fila['captchaSiteKey'];
                    $this->captchaClaveSecreta = $fila['captchaClaveSecreta'];
                    $this->cesta_siempre_paso1 = $fila['cesta_siempre_paso1'];
                    $this->programa_arminet = $fila['programa_arminet'];
                    $this->cesta_login_inicio = $fila['cesta_login_inicio'];
                    $this->dias_borrado_pedidos_libros = $fila['dias_borrado_pedidos_libros'];
                    $this->dias_borrado_pedidos_papeleria = $fila['dias_borrado_pedidos_papeleria'];
                    $this->permitir_anular_pedidos_pendientes = ($fila['permitir_anular_pedidos_pendientes'] == 0) ? false : true;
                    $this->elementos_hco_pedidos = $fila['elementos_hco_pedidos'];
                    $this->elementos_reservas = $fila['elementos_reservas'];
                    $this->elementos_pedidos_pendientes = $fila['elementos_pedidos_pendientes'];
                    $this->elementos_facturas = $fila['elementos_facturas'];
                    $this->elementos_albaranes = $fila['elementos_albaranes'];
                    $this->elementos_depositos = $fila['elementos_depositos'];
                    $this->segundos_sesion = $fila['segundos_sesion'];
                    $this->cookies_rules = ($fila['cookies_rules'] == 0) ? false : true;
                    $this->multi_idioma = ($fila['multi_idioma'] == 0) ? false : true;
                    $this->registro_supervisado = ($fila['registro_supervisado'] == 0) ? false : true;
                    $this->registro_con_confirmacion = ($fila['registro_con_confirmacion'] == 0) ? false : true;
                    $this->campos_busqueda = $fila['campos_busqueda'];
                    $this->controlar_stock = ($fila['controlar_stock'] == 0) ? false : true;
                    $this->ocultar_stock_0 = ($fila['ocultar_stock_0'] == 0) ? false : true;
                    $this->cliente_contado = $fila['cliente_contado'];
                    $this->guardar_pedidos_bd = ($fila['guardar_pedidos_bd'] == 0) ? false : true;
                    $this->segundaMano = ($fila['segundaMano'] == 0) ? false : true;
                    $this->filtroGlobal = $fila['filtroGlobal'];
					$this->url_ebooks = $fila['url_ebooks'];
					$this->limite_descargas_ebook = $fila['limite_descargas_ebook'];
					$this->servidor_portadas = $fila['servidor_portadas'];
					$this->no_foto = $fila['no_foto'];
                                        
                    $resultado = true;
                }
            }
            //Vamos a cargar los tamaños de las portadas
            $sentencia_sql = 'SELECT funcion, alto, ancho FROM tam_portadas WHERE 1';
            //echo('$sentencia_sql<br />\n');
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                for ($i = 0; $fila = mysqli_fetch_array($resultado); $i++) {
                    $this->tam_portadas[$i] = array();
                    $this->tam_portadas[$i]['funcion'] = $fila['funcion'];
                    $this->tam_portadas[$i]['alto'] = $fila['alto'];
                    $this->tam_portadas[$i]['ancho'] = $fila['ancho'];
					$this->tam_portadas[$i]['calidad'] = $fila['calidad'];
                }
            }
            //print_r($this->tam_portadas);
        } else {
            echo('Error cargando configuraci&oacute;n, no existe conexi&oacute;n a la base de datos<br />\n');
        }
        return($resultado);
    }

    //Constructor y destructor
    function __construct() {
        global $ruta_configXML;
        //Si existe un fichero xml no cargamos la configuracion de la base de datos
        if ($ruta_configXML != NULL) {
            $resultado = $this->cargar_configuracionXML($ruta_configXML);
        } else {
            $resultado = $this->cargar_configuracionBD();
        }
        if (!$resultado) {
            echo('Ha ocurrido un error al cargar la configuraci&oacute;n de la web<br />\n');
        } else {
            //Ahora vamos a inicializar ciertos campos necesarios
            if ($this->campos_busqueda == '') {
                $this->campos_busqueda = 'nombre,autor,editorial';
            }
        }
    }

    function __destruct() {
        
    }

    public function __get($name) {
        $retorno = NULL;
        //Si alguien quiere la url de la web tenemos que ver si hay multi idioma y si este está definido
        include('comunes/globals.php');
        if ($name == 'url') {
            if ($this->multi_idioma) {
                $idioma = Sesion::get('idioma');
                if (isset($idioma)) {
                    $retorno = $this->url_sin_idioma . $idioma . '/';
                } else {
                    $retorno = $this->url_sin_idioma;
                }
            } else {
                $retorno = $this->url_sin_idioma;
            }
        }
        //Si no hay retorno aún, vamos a ver si está definida la propiedad
        if (($retorno == NULL) && (isset($this->$name))) {
            $retorno = $this->$name;
        }
        return($retorno);
    }

    public function tam_portada($nombre_funcion) {
        $encontrado = 0;
        $retorno = array(100, 100);
        for ($i = 0; ($i < count($this->tam_portadas)) && ($encontrado == 0); $i++) {
            if ($this->tam_portadas[$i]['funcion'] == $nombre_funcion) {
                $retorno[0] = $this->tam_portadas[$i]['ancho'];
                $retorno[1] = $this->tam_portadas[$i]['alto'];
				$retorno[2] = $this->tam_portadas[$i]['calidad'];
            }
        }
        return($retorno);
    }

    private function cargar_configuracionXML($ruta_fichero) {
        $retorno = false;
        if (file_exists($ruta_fichero)) {
            $datos = simplexml_load_file($ruta_fichero);
            /* echo('<pre>');
              print_r($datos);
              echo('</pre>'); */
            $this->idioma = (string) $datos->idioma;
            $this->importe_minimo = (float) $datos->importe_minimo;
            $this->elementos_por_pagina = (int) $datos->elementos_por_pagina;
            $this->decimales = (int) $datos->decimales_importe;
            $this->num_novedades = (int) $datos->novedades_en_pagina;
            $this->paginas_a_mostrar = (int) $datos->paginas_escaparate;
            $this->descripcion = (string) $datos->descripcion;
            $this->meta = (string) $datos->meta;
            $this->busquedas_papeleria = (int) $datos->busquedas_papeleria;
            $this->color_de_fondo = (string) $datos->color_de_fondo;
            $this->opacidad_fondo = (int) $datos->opacidad_fondo;
            $this->url_sin_idioma = (string) $datos->url;
            $this->password_encriptado = (int) $datos->password_encriptado;
            $this->datos_obligatorios = (string) $datos->datos_obligatorios;
            $this->elementos_relacionados = (int) $datos->elementos_relacionados;
            $this->pedidos_sin_login = (int) $datos->pedidos_sin_login;
            $this->tipo_envio = (int) $datos->tipo_envio;
            $this->dto_dia_libro = (int) $datos->dto_dia_libro;
            $this->franquicia_feran = (int) $datos->franquicia_feran;
            $this->dto_texto = (int) $datos->dto_texto;
			$this->dto_texto_libre = (int) $datos->dto_texto_libre;
            $this->mes_inicio_texto = (int) $datos->mes_inicio_texto;
            $this->mes_fin_texto = (int) $datos->mes_fin_texto;
            $this->captchaSiteKey = (string) $datos->captchaSiteKey;
            $this->captchaClaveSecreta = (string) $datos->captchaClaveSecreta;
            $this->cesta_siempre_paso1 = (int) $datos->cesta_siempre_paso1;
            $this->programa_arminet = (int) $datos->programa_arminet;
            $this->cesta_login_inicio = (int) $datos->cesta_login_inicio;
            $this->dias_borrado_pedidos_libros = (int) $datos->dias_borrado_pedidos_libros;
            $this->dias_borrado_pedidos_papeleria = (int) $datos->dias_borrado_pedidos_papeleria;
            $this->permitir_anular_pedidos_pendientes = ((int) $datos->permitir_anular_pedidos_pendientes == 0) ? false : true;
            $this->elementos_hco_pedidos = (int) $datos->elementos_hco_pedidos;
            $this->elementos_reservas = (int) $datos->elementos_reservas;
            $this->elementos_pedidos_pendientes = (int) $datos->elementos_pedidos_pendientes;
            $this->elementos_facturas = (int) $datos->elementos_facturas;
            $this->elementos_albaranes = (int) $datos->elementos_albaranes;
            $this->elementos_depositos = (int) $datos->elementos_depositos;
            $this->segundos_sesion = (int) $datos->segundos_sesion;
            $this->cookies_rules = ((int) $datos->cookies_rules == 0) ? false : true;
            $this->multi_idioma = ((int) $datos->multi_idioma == 0) ? false : true;
            $this->registro_supervisado = ((int) $datos->registro_supervisado == 0) ? false : true;
            $this->registro_con_confirmacion = ((int) $datos->registro_con_confirmacion == 0) ? false : true;
            $this->campos_busqueda = (String) $datos->campos_busqueda;
            $this->controlar_stock = ((int) $datos->controlar_stock == 0) ? false : true;
            $this->ocultar_stock_0 = ((int) $datos->ocultar_stock_0 == 0) ? false : true;
            $this->cliente_contado = (int) $datos->cliente_contado;
            $this->guardar_pedidos_bd = ((int) $datos->guardar_pedidos_bd == 0) ? false : true;
            $this->segundaMano = ((int) $datos->segundaMano == 0) ? false : true;
            $this->filtroGlobal = (string) $datos->filtroGlobal;
			$this->url_ebooks = (string) $datos->url_ebooks;
			$this->limite_descargas_ebook = (int) $datos->limite_descargas_ebook;
			$this->servidor_portadas = $datos->servidor_portadas;
			$resultado = true;

            /* echo('<pre>');
              echo('$this->dias_borrado_pedidos_libros\n$this->dias_borrado_pedidos_papeleria\n');
              echo('</pre>'); */
            //Vamos con los tamaños de las portadas
            $i = 0;
            foreach ($datos->tam_portadas->portada as $clave => $valor) {
                $this->tam_portadas[$i] = array();
                $this->tam_portadas[$i]['funcion'] = (string) $valor->funcion;
                $this->tam_portadas[$i]['alto'] = (int) $valor->alto;
                $this->tam_portadas[$i]['ancho'] = (int) $valor->ancho;
				$this->tam_portadas[$i]['calidad'] = (int) $valor->calidad;
                $i++;
            }

            $retorno = true;
        }
        return($retorno);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (gettype($value) == 'string') {
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (is_object($value)) {
                    if (method_exists('"' . get_class($value) . '"', 'getJson')) {
                        $ejecutarJson = false;
                    }
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
            $resp = substr($resp, 0, -1) . "}";
            return $resp;
        }
    }

}

?>