<?php

class SuperLineaAlbaran {

    public $codigo = 0;
    public $cab_albaran = 0;
    public $articulo = 0;
    public $prensa = 0;
    public $cantidad = 0;
    public $descripcion = '';
    public $precio = 0;
    public $descuento = 0;
    public $importe = 0;
    public $iva = 0;
    public $objeto_articulo = NULL;
    public $ean = '';
    public $codigo_articulo = 0;

    function __construct($codigo_linea_albaran = 0, $codigo_albaran = 0, $crear_objetos_articulo = false) {
        //Cargamos las lineas del albaran
        include('comunes/globals.php');
        $sentencia_sql = "SELECT lin_albaran.codigo codigo, cab_albaran, articulo, prensa, cantidad, descripcion, precio, descuento, importe, lin_albaran.iva, articulo.ean ean, articulo.codigo codigo_articulo
						FROM lin_albaran, articulo 
						WHERE lin_albaran.codigo = $codigo_linea_albaran 
						AND lin_albaran.cab_albaran = $codigo_albaran 
						AND articulo.codigo = lin_albaran.articulo";
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->cab_albaran = $fila['cab_albaran'];
                    $this->articulo = $fila['articulo'];
                    $this->prensa = $fila['prensa'];
                    $this->cantidad = $fila['cantidad'];
                    $this->descripcion = $fila['descripcion'];
                    $this->precio = $fila['precio'];
                    $this->descuento = $fila['descuento'];
                    $this->importe = $fila['importe'];
                    $this->iva = $fila['iva'];
                    $this->ean = $fila['ean'];
                    $this->codigo_articulo = $fila['codigo_articulo'];
                }
            }
        }
        if ($crear_objetos_articulo) {
            $this->cargar_objeto_articulo();
        }
    }

    function cargar_objeto_articulo() {
        $this->objeto_articulo = new Articulo($this->codigo_articulo, NULL, 1, 0, true, true);
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->cab_albaran);
        unset($this->articulo);
        unset($this->prensa);
        unset($this->cantidad);
        unset($this->descripcion);
        unset($this->precio);
        unset($this->descuento);
        unset($this->importe);
        unset($this->iva);
        unset($this->objeto_articulo);
        unset($this->ean);
        unset($this->codigo_articulo);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>