<?php
class SuperLineaLote{
	public $mc_lote = 0;
	public $codigo = 0;
	public $articulo = 0;
	public $cantidad = 0;
	public $pvp = 0;
	public $total = 0;
	public $optativa = 0;
	public $nueva_inclusion = 0;
	public $observaciones = '';
	
	function __construct($codigo_lote = 0, $codigo_linea_lote = 0, $trabaja_cantidades = false){
		//Cargamos las lineas del lote
		include('comunes/globals.php');
		$sentencia_sql = "SELECT mc_lote, ml_lotes.codigo codigo, articulo.codigo articulo, cantidad, ml_lotes.pvp pvp, total, optativa, nueva_inclusion, ml_lotes.observaciones observaciones 
						FROM ml_lotes, articulo 
						WHERE ml_lotes.mc_lote = $codigo_lote 
						AND ml_lotes.codigo = $codigo_linea_lote 
						AND articulo.codigo = ml_lotes.articulo";
		if ($conexionBD){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				if ($fila = mysqli_fetch_array($resultado)){
					$this->mc_lote = $fila['mc_lote'];
					$this->codigo = $fila['codigo'];
					$this->cantidad = ($trabaja_cantidades) ? $fila['cantidad'] : 1;
					$this->articulo = new Articulo($fila['articulo'], NULL, $this->cantidad, $this->mc_lote);
					$this->pvp = ($trabaja_cantidades) ? $fila['pvp'] : $this->articulo->pvp_final;
					$this->total = ($trabaja_cantidades) ? $fila['total'] : $this->articulo->pvp_final * $this->cantidad;
					$this->optativa = $fila['optativa'];
					$this->nueva_inclusion = $fila['nueva_inclusion'];
					$this->observaciones = $fila['observaciones'];
				}
			}
		}
	}
	
	function __destruct(){
		unset($this->mc_lote);
		unset($this->codigo);
		unset($this->articulo);
		unset($this->cantidad);
		unset($this->pvp);
		unset($this->total);
		unset($this->optativa);
		unset($this->nueva_inclusion);
		unset($this->observaciones);
	}
}

?>