<?php

/*
  Clase SuperLineaPedidoCliente
 */

class SuperLineaPedidoCliente {

    public $mc_pedcli = 0;
    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $articulo = NULL;
    public $codigo_articulo = 0;
    public $ean = '';
    public $cantidad = 0;
    public $recibida = 0;
    public $retirada = 0;
    public $pendiente = 0;
    public $pvp = 0;
    public $descuento = 0;
    public $importe = 0;
    public $importe_pendiente = 0;
    public $importe_reservado = 0;
    public $importe_retirado = 0;
    public $pvp_con_dto = 0;
    public $importe_con_dto = 0;
    public $importe_con_dto_pendiente = 0;
    public $importe_con_dto_reservado = 0;
    public $importe_con_dto_retirado = 0;
    public $cod_lote = 0;
    public $lote = NULL;
    public $dto_lote = 0;
    public $tipo = '';
    public $objeto_pedido = NULL;
    public $pedido_eliminado = 0;


	
    function __construct($codigo_pedido_cliente, $codigo_linea, $extraer_datos_cabecera = false, $extraer_datos_articulo = false) {
        include('comunes/globals.php');
        //Cargamos los datos que necesitamos de los artículo
        $sentencia_sql = "SELECT a.mc_pedcli mc_pedcli, a.codigo_sinlib codigo_sinlib, a.codigo codigo, a.cantidad cantidad, a.pvp pvp, a.descuento descuento, a.importe importe, 
							 a.pvp_con_dto pvp_con_dto, a.importe_con_dto importe_con_dto, a.lote lote, a.dto_lote dto_lote, a.recibida recibida, a.retirada retirada,
							 b.ean ean, b.tipo tipo, a.pedido_eliminado pedido_eliminado, b.codigo codigo_articulo
							FROM  ( ml_pedcli a LEFT JOIN articulo b on a.articulo = b.codigo)
							WHERE a.mc_pedcli = $codigo_pedido_cliente AND a.codigo = $codigo_linea";
        //echo($sentencia_sql);
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->mc_pedcli = $fila['mc_pedcli'];
                    $this->codigo = $fila['codigo'];
                    $this->codigo_sinlib = $fila['codigo_sinlib'];
                    $this->ean = $fila['ean'];
                    $this->codigo_articulo = $fila['codigo_articulo'];
                    if (($fila['codigo_articulo'] != '') && ($extraer_datos_articulo)) {
                        $this->articulo = new Articulo($this->codigo_articulo, NULL, $fila['cantidad'], $fila['lote'], true, true);
                    }
                    $this->cantidad = $fila['cantidad'];
                    $this->recibida = $fila['recibida'];
                    $this->retirada = $fila['retirada'];
                    $this->pendiente = $this->cantidad - $this->recibida - $this->retirada;
                    $this->pvp = $fila['pvp'];
                    $this->importe = $fila['importe'];
                    $this->importe_pendiente = $this->pvp * $this->pendiente;
                    $this->importe_reservado = $this->pvp * $this->recibida;
                    $this->importe_retirado = $this->pvp * $this->retirada;
                    $this->descuento = $fila['descuento'];
                    $this->pvp_con_dto = $fila['pvp_con_dto'];
                    $this->importe_con_dto = $fila['importe_con_dto'];
                    $this->importe_con_dto_pendiente = $this->pvp_con_dto * $this->pendiente;
                    $this->importe_con_dto_reservado = $this->pvp_con_dto * $this->recibida;
                    $this->importe_con_dto_retirado = $this->pvp_con_dto * $this->retirada;
                    $this->cod_lote = $fila['lote'];
                    $this->lote = new Lote($fila['lote']);
                    $this->dto_lote = $fila['dto_lote'];
                    $this->tipo = $fila['tipo'];
                    $this->pedido_eliminado = $fila['pedido_eliminado'];
                }
            }
            //Si hay que extraer los datos de la cabecera, vamos a hacerlo aquí
            if ($extraer_datos_cabecera) {
                $this->objeto_pedido = new PedidoCliente($this->mc_pedcli, NULL, false);
            }
        }
    }

    function __destruct() {
        unset($this->articulo);
    }

	function cargarArticulo(){
		$this->articulo = new Articulo($this->codigo_articulo, NULL, $this->cantidad, $this->cod_lote, true, true);
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>