<?php
class SuperListSysMsg{
	private $lista = array();
	
	function __construct(){
	}
	
	function __destruct(){
		foreach ($this->lista as $clave => $valor){
			unset($this->lista[$clave]);
		}
		unset($this->lista);
	}
	
	function addElement($origen = '', $cuerpo = '', $clase = '', $funcion = '', $contador = 0){
		$posicion = count($this->lista);
		$this->lista[$posicion] = new SysMsg($origen, $cuerpo, $clase, $funcion);
		//Si nos han pasado un contador, lo inicializamos a ese valor
		if ($contador > 0){
			$this->lista[$posicion]->setContador($contador);
		}
	}
	
	function findElement($array_busqueda_recibido){
		$retorno = NULL;
		$parametros_permitidos = array('origen', 'cuerpo', 'clase', 'funcion');
		$array_busqueda = array();
		//Vamos a componer un array de búsqueda sólo con los parámetros permitidos
		if (is_array($array_busqueda_recibido)){
			//Si el elemento que buscamos está en el array, lo añadimos
			foreach($array_busqueda_recibido as $clave => $valor){
				if (in_array($clave, $parametros_permitidos)){
					$array_busqueda[$clave] = $valor;
				}
			}
			//Después de esto tenemos un array de búsqueda filtrado sólo con los parámetros permitidos. Si no está vacío continuamos
			if (count($array_busqueda) > 0){
				//Ahora vamos a recorrer el array de mensajes buscando según los parámetros recibidos
				$cantidad_elementos = count($this->lista);
				for ($i = 0; ($i < $cantidad_elementos); $i++){
					//En coincidencias almacen el número de coincidencias encontradas con respecto a lo que estoy buscando
					$coincidencias = 0;
					//Sólo podemos buscar en aquellos mensajes que vienen de una pantalla anterior
					if ($this->lista[$i]->getContador() == 1){
						//Recorremos el array de búsqueda para obtener cada clave y su correspondiente valor
						foreach($array_busqueda as $clave => $valor){
							//Si la clave del elemento de la lista contiene el valor asignado, entonces hay una coincidencia
							if (preg_match($valor, $this->lista[$i]->getParam($clave))){
								$coincidencias++;
							}
						}
						}
					//Si hay tantas coincidencias omo elementos en el array, entonces tenemos un resultado.
					if ($coincidencias == count($array_busqueda)){
						if ($retorno == NULL){
							$retorno = array();
						}
						$retorno[count($retorno)] = $this->lista[$i];
					}
				}
			}
		}
		return($retorno);
	}

	function limpiar(){
		include('comunes/globals.php');
		//OJO, no se limpian mensajes cuando la web está en modo 'recarga'
		if (!$web_en_recarga){
			$cantidad_elementos = count($this->lista);
			for ($i = 0; $i < $cantidad_elementos; $i++){
				$contador_actual = $this->lista[$i]->getContador();
				if ($contador_actual >= 2){
					//Hay que borrar
					unset($this->lista[$i]);
				}
			}
		}
		//Reestructuramos el array
		$this->lista = array_values($this->lista);
	}

	function incrementaContador($contador = 1){
		$cantidad_elementos = count($this->lista);
		for ($i = 0; $i < $cantidad_elementos; $i++){
			$this->lista[$i]->incrementaContador($contador);
		}
	}
	function __wakeup(){
		//Esat función se utiliza cuando se des-serializa la variable	
	}
}
?>