<?php
class SuperLote{
	public $codigo = 0;
	public $nombre = '';
	public $trabaja_cantidades = 0;
	public $observaciones = '';
	public $total = 0;
	public $cantidad = 0;
	public $codigo_anterior = '';
	public $ano_lote = 0;
	public $precio_lote = 0;
	public $visible_web = 0;
	public $lineas_lote = array();
	
	function __construct($codigo = 0){
		include('comunes/globals.php');
		//Cargamos todos los datos de los lotes dependiendo lo que pasemos
		$sentencia_sql = 'SELECT codigo, nombre, trabaja_cantidades, observaciones, total, cantidad, codigo_anterior, ano_lote, precio_lote, visible_web 
						FROM mc_lotes ';
		if(!is_numeric($codigo)){
			$sentencia_sql .= "	WHERE nombre LIKE '%$codigo%'";
		}else{
			$sentencia_sql .= " WHERE codigo = $codigo";
		}
		//echo("$sentencia_sql<br />\n");
		if ($conexionBD){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				if ($fila = mysqli_fetch_array($resultado)){
					$this->codigo = $fila['codigo'];
					$this->nombre = $fila['nombre'];
					$this->trabaja_cantidades = $fila['trabaja_cantidades'];
					$this->observaciones = $fila['observaciones'];
					$this->total = $fila['total'];
					$this->cantidad = $fila['cantidad'];
					$this->codigo_anterior = $fila['codigo_anterior'];
					$this->ano_lote = $fila['ano_lote'];
					$this->precio_lote = $fila['precio_lote'];
					$this->visible_web = $fila['visible_web'];
				}
			}
			//Ahora vamos con las líneas del lote
			$sentencia_sql = "SELECT mc_lote, codigo, articulo, cantidad, pvp, total, optativa, nueva_inclusion, observaciones 
							FROM ml_lotes 
							WHERE mc_lote = $this->codigo";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				while ($fila = mysqli_fetch_array($resultado)){
					$this->lineas_lote[count($this->lineas_lote)] = new LineaLote($this->codigo, $fila['codigo'], (($this->trabaja_cantidades == 1)? true : false));
				}
			}
		}
	}
	
	function __destruct(){
		unset($this->codigo);
		unset($this->nombre);
		unset($this->trabaja_cantidades);
		unset($this->observaciones);
		unset($this->total);
		unset($this->cantidad);
		unset($this->codigo_anterior);
		unset($this->ano_lote);
		unset($this->precio_lote);
		unset($this->visible_web);
	}
	
	public static function lote_nombre_colegio($nombre_colegio = ''){
		include('comunes/globals.php');
		$retorno = '';
		if ($nombre_colegio != ''){
			$sentencia_sql = "SELECT SUBSTRING_INDEX( nombre,  '/', 1 ) nombre_lote FROM mc_lotes
							WHERE visible_web =1 AND SUBSTRING_INDEX( nombre,  '/', 1 ) LIKE  '%$nombre_colegio%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila['nombre_lote'];
					}
				}
			}
		}
		return($retorno);	
	}
	
	public static function lote_nombre($nombre = ''){
		include('comunes/globals.php');
		$retorno = '';
		if ($nombre != ''){
			$sentencia_sql = "SELECT nombre FROM mc_lotes
							WHERE visible_web =1 AND nombre LIKE  '%$nombre%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila["nombre"];
					}
				}
			}
		}
		return($retorno);	
	}

	public static function codigo_de_nombre($nombre = ""){
		include('comunes/globals.php');
		$retorno = "";
		if ($nombre != ""){
			$sentencia_sql = "SELECT codigo FROM mc_lotes
							WHERE visible_web =1 AND nombre LIKE  '%$nombre%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila['codigo'];
					}
				}
			}
		}
		return($retorno);	
	}
	
	public static function borrar_dto_lote($lote = 0){
		include('comunes/globals.php');
		$retorno = false;
		if ($lote > 0){
			//Buscamos el índice del descuento
			$indice_a_borrar = lote::buscar_dto_lote($lote);
			//Si hay índice vamos a borrar
			if ($indice_a_borrar > -1){
				//Cogemos el array de la sesión
				$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
				//Eliminamos el elmento del array
				array_splice($array_descuentos_lotes, indice_a_borrar, 1);
				//Guardamos el array en la sesión
				Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
				$retorno = true;
			}
		}
		return($retorno);
	}
	
	public static function insertar_dto_lote($lote = 0, $dto = 0, $cod_dto = ''){
		if ($lote != 0){
			//Borramos el descuento que ya tenga el lote
			lote::borrar_dto_lote($lote);
			//Componemos la cadena
			$cad_lote = $lote . '|' . $dto . '|' . $cod_dto . '|';
			$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
			$array_descuentos_lotes[] = $cad_lote;
			Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
		}
	}
	
	public static function buscar_dto_lote($lote = 0){
		$indice_lote = -1;
		if ($lote > 0){
			$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
			for ($i = 0; ($i < count($array_descuentos_lotes) && ($indice_lote < 0)); $i++){
				$valor_lote = explode('|', $array_descuentos_lotes[$i]);
				if ($valor_lote[0] == $lote){
					$indice_lote = $i;
				}
			}
		}
		return($indice_lote);
	}

	public static function purgar_dto_lotes(){
		//Vamos a coger los códigos de lote que tenemos activos
		$array_lotes_cesta = Sesion::get('array_lotes_cesta');
		//Ahora cogemos los códigos de descuento asociados
		$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
		//Vamos a recorrer los descuentos de los lotes para ir borrando los que no existan en los lotes de la cesta
		foreach($array_descuentos_lotes as $clave => $valor){
			$valor_lote = explode('|', $valor);
			if (!(in_array($valor_lote[0], $array_lotes_cesta))){
				unset($array_descuentos_lotes[$clave]);
			}
		}
		//Ahora toca reordenar el array
		$array_descuentos_lotes = array_values($array_descuentos_lotes);
		//Grabamos el array
		Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
	}
}
?>