<?php

class SuperPedidoCliente extends Objeto{

    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $cliente = 0;
    public $nombre_legal = '';
    public $email = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $telefono = '';
    public $telefono2 = '';
    public $cif = '';
    public $pendiente_sinlib = 0;
    public $fecha = 0;
    public $fecha_date_format = 0;
    public $cadena_fecha = '';
    public $fecha_pago = 0;
    public $fecha_envio = 0;
    public $pagado = 0;
    public $referencia = '';
    public $enviado = 0;
    public $observaciones = '';
    public $tipo_envio = NULL;
    public $no_revisado = 1;
    public $pedido_preparado = 0;
    public $pais = 0;
    public $datos_facturacion = '';
    public $factura = 0;
    public $descuento = 0;
    public $envolver_regalo = 0;
    public $comercial = 0;
    public $g_envio = 0;
    public $forma_pago = 0;
    public $pendiente_paypal = 0;
    public $oculto = 0;
    public $forma_pago_nombre = '';
    public $tipo_envio_nombre = '';
    public $reembolso = 0;
    public $transferencia = 0;
    public $sin_pago = 0;
    public $cuenta_bancaria = '';
    public $cantidad_total = 0;
    public $cantidad_pendiente = 0;
    public $cantidad_reservada = 0;
    public $total_pvp = 0;
    public $total_pvp_pendiente = 0;
    public $total_pvp_reservado = 0;
    public $total_pvp_con_dto = 0;
    public $total_pvp_con_dto_pendiente;
    public $total_pvp_con_dto_reservado = 0;
    public $importe_total = 0;
    public $importe_total_pendiente = 0;
    public $importe_total_reservado = 0;
    public $lineas = array();
    public $tipo_pasarela = 0;
	public $emailEnviado = false;
	
    private $flag_utf8 = false;

	public static function getCampos(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			include('comunes/diccionario/diccionario.php');
			self::$camposSelect = 
				BaseDatos::dameCamposAlias(${self::$nombreTabla . 'Campos'}, self::getAlias()) . ', ' . 
				BaseDatos::dameCamposAlias(${TipoEnvioCliente::getNombreTabla() . 'Campos'}, TipoEnvioCliente::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(${FormasPago::getNombreTabla() . 'Campos'}, FormasPago::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(${Usuario::getNombreTabla() . 'Campos'}, Usuario::getAlias());
		}
		return(self::$camposSelect);
	}
	
	public static function getNombreTabla(){
		//Incluimos los globals para coger el valor del idioma:
		include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		self::$nombreTabla = ' `' . self::$nombreTabla . '` `' .  self::getAlias() . '` 
		LEFT JOIN `' . Usuario::getNombreTabla() . '` `' . Usuario::getAlias() . '` ON ( `' . Usuario::getAlias() . '`.`codigo` = `' . self::getAlias() . '`.`cliente` ),
		`' . TipoEnvioCliente::getNombreTabla() . '` `' . TipoEnvioCliente::getAlias() . '`, 
		`' . FormasPago::getNombreTabla() . '` `' . FormasPago::getAlias() . '` 
		
		';
		return(self::$nombreTabla);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_pedido_cliente = isset($argumentos[0]) ? $argumentos[0] : 0;
		$pagado = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$usuario = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$pendienteSinlib = isset($argumentos[3]) ? $argumentos[3] : NULL;
		include('comunes/globals.php');
		self::$whereSelect = '';
		
		if ($codigo_pedido_cliente > 0) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`codigo` = ' . $codigo_pedido_cliente . ' ';
		}
		if ($pagado !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`pagado` = ' . $pagado . ' ';
		}
		if ($pendienteSinlib !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`pendiente_sinlib` > 0 ';
		}
		if ($usuario !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`cliente` = ' . $usuario . ' ';
		}		
		self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
		self::$whereSelect .= ' `' . TipoEnvioCliente::getAlias() . '`.`codigo` = `' . self::getAlias() . '`.`tipo_envio` 
							AND `' . FormasPago::getAlias() . '`.`codigo` = `' . self::getAlias() . '`.`forma_pago` 
							';
							
		return(self::$whereSelect);
	}
	
	
	
    function __construct($codigo_pedido_cliente = 0, $pagado = NULL, $con_detalle = true, $finalizado = NULL) {
		include('comunes/globals.php');
        $filaPedido = NULL;
		$opciones = NULL;
		if (is_a($codigo_pedido_cliente, 'OpcionesWidget')) {
			$opciones = $codigo_pedido_cliente;
			$codigo_pedido_cliente = ($opciones->configuracion->codigo_pedido_cliente != NULL) ? $opciones->configuracion->codigo_pedido_cliente : 0;
			$pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
			$con_detalle = ($opciones->configuracion->con_detalle != NULL) ? $opciones->configuracion->con_detalle : $con_detalle;
			$finalizado = ($opciones->configuracion->finalizado != NULL) ? $opciones->configuracion->finalizado : $finalizado;
			$filaPedido = ($opciones->configuracion->filaPedido != NULL) ? $opciones->configuracion->filaPedido : $filaPedido;
		}
		$fila = NULL;
		if ($filaPedido == NULL){
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
								FROM ' . self::getNombreTabla() . ' 
								WHERE ' . self::getWhereTabla($codigo_pedido_cliente, $pagado, NULL, $finalizado);
			//echo($sentencia_sql);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaPedido;
		}
		if ($fila != NULL){
			$this->codigo = $fila[PedidoCliente::getAlias() . '_' . 'codigo'];
			$this->codigo_sinlib = $fila[PedidoCliente::getAlias() . '_' . 'cod_sinlib'];
			//$this->cliente = new Usuario($fila[PedidoCliente::getAlias() . '_' . 'cliente']);
			$this->cliente = new Usuario(new OpcionesWidget(Array('filaUsuario' => $fila)));
			$this->nombre_legal = $fila[PedidoCliente::getAlias() . '_' . 'nombre_legal'];
			$this->email = $fila[PedidoCliente::getAlias() . '_' . 'email'];
			$this->direccion = $fila[PedidoCliente::getAlias() . '_' . 'direccion'];
			$this->cod_postal = $fila[PedidoCliente::getAlias() . '_' . 'cod_postal'];
			$this->localidad = $fila[PedidoCliente::getAlias() . '_' . 'localidad'];
			$this->provincia = $fila[PedidoCliente::getAlias() . '_' . 'provincia'];
			$this->telefono = $fila[PedidoCliente::getAlias() . '_' . 'telefono'];
			$this->telefono2 = $fila[PedidoCliente::getAlias() . '_' . 'telefono2'];
			$this->cif = $fila[PedidoCliente::getAlias() . '_' . 'cif'];
			$this->pendiente_sinlib = $fila[PedidoCliente::getAlias() . '_' . 'pendiente_sinlib'];
			$this->fecha = $fila[PedidoCliente::getAlias() . '_' . 'fecha'];
			$this->fecha_date_format = date_create($this->fecha);
			$aux_fecha = new DateTime($this->fecha);
			$this->cadena_fecha = dame_dia_de_la_semana($aux_fecha->format('w')) . ' <strong>' . $aux_fecha->format('d') . '</strong> de <strong>' . dame_mes($aux_fecha->format('n')) . '</strong> a las ' . $aux_fecha->format('H:i') . 'h';
			$this->fecha_pago = $fila[PedidoCliente::getAlias() . '_' . 'fecha_pago'];
			$this->fecha_envio = $fila[PedidoCliente::getAlias() . '_' . 'fecha_envio'];
			$this->pagado = $fila[PedidoCliente::getAlias() . '_' . 'pagado'];
			$this->referencia = $fila[PedidoCliente::getAlias() . '_' . 'referencia'];
			$this->enviado = $fila[PedidoCliente::getAlias() . '_' . 'enviado'];
			$this->observaciones = $fila[PedidoCliente::getAlias() . '_' . 'observaciones'];
			$this->no_revisado = $fila[PedidoCliente::getAlias() . '_' . 'no_revisado'];
			$this->pedido_preparado = $fila[PedidoCliente::getAlias() . '_' . 'pedido_preparado'];
			$this->pais = $fila[PedidoCliente::getAlias() . '_' . 'pais'];
			$this->datos_facturacion = $fila[PedidoCliente::getAlias() . '_' . 'datos_facturacion'];
			$this->factura = $fila[PedidoCliente::getAlias() . '_' . 'factura'];
			$this->descuento = $fila[PedidoCliente::getAlias() . '_' . 'descuento'];
			$this->envolver_regalo = $fila[PedidoCliente::getAlias() . '_' . 'envolver_regalo'];
			$this->comercial = $fila[PedidoCliente::getAlias() . '_' . 'comercial'];
			$this->g_envio = $fila[PedidoCliente::getAlias() . '_' . 'g_envio'];
			$this->pendiente_paypal = $fila[PedidoCliente::getAlias() . '_' . 'pendiente_paypal'];
			$this->oculto = $fila[PedidoCliente::getAlias() . '_' . 'oculto'];
			$this->emailEnviado = ($fila[PedidoCliente::getAlias() . '_emailEnviado'] == 1); // Lo hacemos así para asignar un valor booleano
			
			//Tipo de envío
			//$this->tipo_envio = $fila[PedidoCliente::getAlias() . '_' . 'tipo_envio'];
			$this->tipo_envio = new TipoEnvioCliente(new OpcionesWidget(Array('filaTipoEnvio' => $fila)));
			$this->tipo_envio_nombre = $fila[TipoEnvioCliente::getAlias() . '_nombre'];
			$this->cuenta_bancaria = $fila[TipoEnvioCliente::getAlias() . '_cuenta_bancaria'];
			$this->reembolso = $fila[TipoEnvioCliente::getAlias() . '_reembolso'];
			$this->transferencia = $fila[TipoEnvioCliente::getAlias() . '_transferencia'];
			$this->sin_pago = $fila[TipoEnvioCliente::getAlias() . '_sin_pago'];
			//formas de pago
			//$this->forma_pago = $fila[PedidoCliente::getAlias() . '_' . 'forma_pago'];
			$this->forma_pago = new FormasPago(new OpcionesWidget(Array('filaFormaPago' => $fila)));
			$this->forma_pago_nombre = $fila[FormasPago::getAlias() . '_nombre'];
			if ($fila[FormasPago::getAlias() . '_cuenta_bancaria'] != '') {
				$this->cuenta_bancaria = $fila[FormasPago::getAlias() . '_cuenta_bancaria'];
			}
			if ($fila[FormasPago::getAlias() . '_transferencia'] != '') {
				$this->transferencia = $fila[FormasPago::getAlias() . '_transferencia'];
			}
			$this->tipo_pasarela = $fila[FormasPago::getAlias() . '_tipo_pasarela'];
		}
		//var_dump($this);
		
		//Ahora vamos con las líneas si lo queremos con detalle, claro
		if ($con_detalle) {
			$this->cargarDetalle();
		} else {
			//Cargamos las líneas pero no creamos los objetos
			$sentencia_sql = "SELECT pvp, cantidad, recibida, reservada, pvp_con_dto, importe_con_dto FROM  ml_pedcli WHERE mc_pedcli = $codigo_pedido_cliente";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					$pendiente = $fila["cantidad"] - $fila['recibida'] - $fila['reservada'];
					$reservado = $fila['recibida'];
					$this->total_pvp += $fila['pvp'] * $fila['cantidad'];
					$this->total_pvp_pendiente += $fila['pvp'] * $pendiente;
					$this->total_pvp_reservado += $fila['pvp'] * $reservado;
					$this->total_pvp_con_dto += $fila['importe_con_dto'];
					$this->total_pvp_con_dto_pendiente += $fila['pvp_con_dto'] * $pendiente;
					$this->total_pvp_con_dto_reservado += $fila['pvp_con_dto'] * $reservado;
					$this->cantidad_total += $fila['cantidad'];
					$this->cantidad_pendiente += $pendiente;
					$this->cantidad_reservada += $reservado;
				}
			}
		}

		$this->importe_total = Price::setDiscount($this->total_pvp_con_dto, $this->descuento);
		$this->importe_total_pendiente = Price::setDiscount($this->total_pvp_con_dto_pendiente, $this->descuento);
		$this->importe_total_reservado = Price::setDiscount($this->total_pvp_con_dto_reservado, $this->descuento);

    }

	public function cargarDetalle(){
		include('comunes/globals.php');
		$sentencia_sql = 'SELECT codigo FROM ml_pedcli WHERE mc_pedcli = ' . $this->codigo . ';';
		//echo($sentencia_sql);
		if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
			while ($fila = mysqli_fetch_array($resultado)) {
				$this->lineas[count($this->lineas)] = new LineaPedidoCliente($this->codigo, $fila['codigo']);
			}
		}
		//Ahora toca recorrer las líneas para calcular los totales
		foreach ($this->lineas as $clave => $valor) {
			$this->total_pvp += $valor->pvp * $valor->cantidad;
			$this->total_pvp_pendiente += $valor->pvp * $valor->pendiente;
			$this->total_pvp_reservado += $valor->pvp * $valor->recibida;
			$this->total_pvp_con_dto += $valor->importe_con_dto;
			$this->total_pvp_con_dto_pendiente += $valor->pvp_con_dto * $valor->pendiente;
			$this->total_pvp_con_dto_reservado += $valor->pvp_con_dto * $valor->recibida;
			$this->cantidad_total += $valor->cantidad;
			$this->cantidad_pendiente += $valor->pendiente;
			$this->cantidad_reservada += $valor->recibida;
		}
	}
	
    public function calcularTotales() {
        include('comunes/globals.php');
        //Vamos a cargar los datos que necesito de este pedido
        if ($this->codigo > 0) {
            $sentencia_sql = 'SELECT SUM(`cantidad`) cantidad, SUM(`cantidad` - `recibida` - `retirada`) `pendiente`, SUM(`recibida`) `recibida`, 
									 SUM(`pvp` * cantidad)`pvp`, SUM(`pvp` * (`cantidad` - `recibida` - `retirada`)) `total_pvp_pendiente`, SUM(`pvp` * recibida) `total_pvp_reservado`,
									 SUM(`pvp_con_dto`* cantidad) `pvp_con_dto`, SUM(`pvp_con_dto` * (`cantidad` - `recibida` - `retirada`)) `total_pvp_pendiente`, SUM(`pvp_con_dto` * `recibida`) `total_pvp_reservado` 
			FROM `ml_pedcli` 
			WHERE `mc_pedcli` = ' . $this->codigo . ' GROUP BY mc_pedcli ';
            //echo("$sentencia_sql<br />\n");
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->cantidad_total = $fila['cantidad'];
                    $this->cantidad_pendiente = $fila['pendiente'];
                    $this->cantidad_reservada = $fila['recibida'];

                    $this->total_pvp = $fila['pvp'];
                    $this->total_pvp_pendiente = $fila['total_pvp_pendiente'];
                    $this->total_pvp_reservado = $fila['total_pvp_reservado'];

                    $this->importe_total = $fila['pvp_con_dto'];
                    $this->importe_total_pendiente = $fila['total_pvp_pendiente'];
                    $this->importe_total_reservado = $fila['total_pvp_reservado'];
                }
            }
        }
    }

	//------------------------------------------
	//	Damos un pedido por finalizado
	//------------------------------------------
	public function finalizado(){
		return(self::darPorFinalizado($this));
	}
	public static function darPorFinalizado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pendiente_sinlib` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		//Para hacer pruebas, no actualizo el pedido
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}

		if($retorno){
			//Necesitamos un objeto pedido cliente:
			if ($mc_pedcli == NULL){
				$mc_pedcli = new PedidoCliente($codPedido);
			}
			//si todo ha ido bien, vamos a hacer más recálculos
			//Si los productos comprados itenen ficheros adjuntos
			$listaFicheros = array();
			foreach($mc_pedcli->lineas as $clave => $valor){
				if ($valor->articulo == NULL){
					$valor->cargarArticulo();
				}
				$valor->articulo->venderAdjuntos($mc_pedcli->cliente->codigo);
			}
			//var_dump($listaFicheros);
		}

		return($retorno);
	}
	
	//------------------------------------------
	//	Damos un pedido por pagado
	//------------------------------------------
	public function pagado(){
		return(self::darPorPagado($this));
	}
	public static function darPorPagado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pagado` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}

	//------------------------------------------
	//	Damos un pedido por pagado y finalizado
	//------------------------------------------
	public function pagadoFinalizado(){
		return(self::darPorpagadoFinalizado($this));
	}
	public static function darPorpagadoFinalizado($codPedido){
		$retorno = self::darPorPagado($codPedido) | self::darPorFinalizado($codPedido);
		return($retorno);
	}
	
	//------------------------------------------
	//	Indicamos que el email de aviso de un pedido ya se ha enviado
	//------------------------------------------
	public function pedidoEmailEnviado(){
		return(self::darPedidoEmailEnviado($this));
	}
	public static function darPedidoEmailEnviado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `emailEnviado` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}
	
	//------------------------------------------
	//	Actualizamos el stock de los productos de un pedido:
	//------------------------------------------
	public static function actualizarStockPedido(){
		include('coumes/globals.php');
		$sentencia_sql = '';
		foreach($this->lineas as $clave => $valor){
			$sentencia_sql .= ' UPDATE articulo SET stock = stock - ' . $valor->cantidad . ' WHERE codigo = ' . $valor->articulo . '; ';
		}
		if ($sentencia_sql != ''){
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
	
	//------------------------------------------
	//	Extraemos una lista de pedidos de un cliente
	//------------------------------------------
	public static function getPedidosCliente($cliente = NULL, $pagado = NULL, $pendienteSinlib = NULL){
		include('comunes/globals.php');
		$listaPedidos = array();
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
									FROM ' . self::getNombreTabla() . ' 
									WHERE ' . self::getWhereTabla(NULL, $pagado, $cliente->codigo, $pendienteSinlib);
				//echo($sentencia_sql);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					while($fila = $bd->getFila()){
						array_push($listaPedidos, new PedidoCliente(new OpcionesWidget(array('filaPedido' => $fila))));
					}
				}
			}				
		}
		return($listaPedidos);
	}
	
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>