<?php
/*
	Clase secciones para las secciones de la web
	@version 1.0
*/
class Sesion{
	private static $valores = array();
	private static $modificada = array();
	private static $alta = array();
	private static $borrada = array();
	private static $hashSesion = '';
	
	//Esta funcin no necesita constructor ni destructor, los dejamos as por ahora
	function __construct(){
		
	}
	function __destruct() {

	}
	
	public static function getHashSesion(){
		//Si no est seteado lo cogemos de las cookies
		if (self::$hashSesion == NULL){
			self::$hashSesion = Sesion::getCookieValue('hashSesion');
		}
		//Si en este punto seguimos sin hash es porque no est seteado y no se ha cogido de las cookies
		//Vamos a generar uno nuevo
		if (self::$hashSesion == NULL){
			//El hash de la sesin es nulo, hay que crearlo:
			self::$hashSesion = self::newHashSesion();
		}else{
			//Si el hash de la sesin no empieza por "webStore" entonces algo falla:
			if (substr(self::$hashSesion, 0, strlen(PALABRA)) != PALABRA){
				self::$hashSesion = self::newHashSesion();
			}
		}
		return(self::$hashSesion);
	}
	
	private static function newHashSesion(){
		self::$hashSesion = PALABRA . bin2hex(openssl_random_pseudo_bytes(24));
		setcookie('hashSesion', self::$hashSesion, 0, '/');
		return(self::$hashSesion);
	}
	
	//Vamos a definir el get y el set_error_handler
	public static function get($nombreVariable, $defaultValue = NULL){
		$retorno = $defaultValue;
		if (isset(self::$valores[$nombreVariable])){
			if (self::$borrada[$nombreVariable] == 0){
				$retorno = self::$valores[$nombreVariable];
			}
		}
		return($retorno);
	}
	public static function set($nombreVariable, $valor){
		if (!isset(self::$valores[$nombreVariable])){
			self::$alta[$nombreVariable] = 1;
			self::$modificada[$nombreVariable] = 0;
			self::$borrada[$nombreVariable] = 0;
		}else{
			self::$modificada[$nombreVariable] = 1;
			self::$alta[$nombreVariable] = 0;
			self::$borrada[$nombreVariable] = 0;
		}
		self::$valores[$nombreVariable] = $valor;
	}
	
	public static function remove($nombreVariable){
		if (isset(self::$valores[$nombreVariable])){
			self::$borrada[$nombreVariable] = 1;
		}
	}
	
	public static function commit(){
		include('comunes/globals.php');
		$hashSesion = self::getHashSesion();
		//Si hay conexin con la base de datos y hemos recibido un hash, entonces actualizamos
		if ( ($conexionBD != NULL) && ($hashSesion != '') ){
			//Aqu vamos a hacer una macro update y/o insert y a ejecutarla
			
			/*INSERT INTO sesion (hash, nombre, valor, ultimo_acceso) VALUES
			(1, '1', '10', CURRENT_TIMESTAMP()),
			(2, '2', '30', CURRENT_TIMESTAMP()),
			(3, '9', '33', CURRENT_TIMESTAMP()),
			(4, '10', '001', CURRENT_TIMESTAMP())
			ON DUPLICATE KEY UPDATE valor=VALUES(valor), ultimo_acceso=VALUES(ultimo_acceso);*/
			$coma = '';
			$lista_elementos = '';
			$coma_borrado = '';
			$lista_borrar = '';
			foreach(self::$valores as $clave => $valor){
				if ((self::$modificada[$clave]) || (self::$alta[$clave])){
					//Serializamos el valor para guardarlo
					$valor = addslashes(serialize($valor));
					$lista_elementos .= $coma . '("' . $hashSesion . '", "' . $clave . '", "' . $valor . '", CURRENT_TIMESTAMP())';
					$coma = ',';
				}
				//Si slo es borrado, la aadimos a la lista de borrado
				if (self::$borrada[$clave]){
					$lista_borrar .= $coma_borrado . '("' . $hashSesion . '", "' . $clave . '")';
					$coma_borrado = ',';
				}
			}
			//Primero borramos:
			if ($lista_borrar != ''){
				$sentenciaSQL = 'DELETE FROM sesion WHERE (hash, nombre) IN (' . $lista_borrar . ');';
				mysqli_query($conexionBD, $sentenciaSQL);
			}
			//Ahora creamos/modificamos
			if ($lista_elementos != ''){
				$sentenciaSQL = 'INSERT INTO sesion (hash, nombre, valor, ultimo_acceso) VALUES ' . $lista_elementos . 
				' ON DUPLICATE KEY UPDATE valor = VALUES(valor), ultimo_acceso = VALUES(ultimo_acceso);';
				mysqli_query($conexionBD, $sentenciaSQL);
			}
		}
	}
	
	public static function purge(){
		include('comunes/globals.php');
		$hashSesion = self::getHashSesion();
		if ($conexionBD != NULL){
			$sentenciaSQL = 'DELETE FROM sesion WHERE (ultimo_acceso < DATE_ADD(ultimo_acceso, INTERVAL ' . TIEMPO_VIDA_SESION . ');';
			mysqli_query($conexionBD, $sentenciaSQL);
		}
	}
	
	public static function init(){
		include('comunes/globals.php');
		$hashSesion = self::getHashSesion();
		$objetos_a_serializar = array();
		if ($hashSesion != ''){
			$sentenciaSQL = 'SELECT nombre, valor FROM sesion WHERE hash = "' . $hashSesion . '";';
			if ($conexionBD) {
				if ($resultado = mysqli_query($conexionBD, $sentenciaSQL)) {
					while ($fila = mysqli_fetch_array($resultado)) {
						$nombreVariable = $fila['nombre'];
						$valor = $fila['valor'];
						self::init_value($nombreVariable, unserialize($valor));
					}
				}
			}
		}
	}
	private static function init_value($clave, $valor){
		self::$valores[$clave] = $valor;
		self::$alta[$clave] = 0;
		self::$modificada[$clave] = 0;
		self::$borrada[$clave] = 0;
	}
	public static function clean(){
		include('comunes/globals.php');
		$hashSesion = self::getHashSesion();
		if ($conexionBD != NULL){
			$sentenciaSQL = 'DELETE FROM sesion WHERE hash = "' . $hashSesion . '";';
			mysqli_query($conexionBD, $sentenciaSQL);
		}
		$valores = array();
		$modificada = array();
		$alta = array();
		$borrada = array();
		//Regeneramos el hash
		self::$hashSesion = self::newHashSesion();
		
	}
}

?>