<?php

class SuperTipoEnvioCliente extends Objeto{

    public $codigo = 0;
    public $nombre = '';
    public $importe_fijo = 0;
    public $importe_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_rec_reembolso = 0;
    public $privado = 0;
    public $pais = 0;
    public $transferencia = 0;
    public $pasarela = 0;
    public $tipo_pasarela = 0;
    public $cuenta_bancaria = '';
    public $sin_pago = 0;
    public $sin_envio = 0;
    public $rangosEnvios = array();
    public $tarifasPorLocalidad = array();
    public $flag_utf8 = false;
    public $descripcion = "";
    public $importe = 0;
    public $requiere_pago = true;
    private $importe_pedido = 0;
    private $cantidad_articulos = 0;
    private $localidad = 0;
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : 0;
		include('comunes/globals.php');
		self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = ' . $codigo . '
							';
		return(self::$whereSelect);
	}

    function __construct($codigo = 0, $flag_RangosEnvio = true, $flag_TarifasPorLocalidad = true) {
        include('comunes/globals.php');
        //$objCliente = $datos_usuario;
        $objCliente = Usuario::logueado();
		$filaTipoEnvio = NULL; // ==> Aquí podemos pasar el resultado de una select ya hecha, lo que nos dará los campos directamente para insertarlos
		if (is_a($codigo, 'OpcionesWidget')){
			//Recogemos las opciones del 'OpcionesWidget'
			$opciones = $codigo;
			$codigo = 0;
			$codigo = ($opciones->configuracion->codigo !== NULL) ? $opciones->configuracion->codigo : $codigo;
			$filaTipoEnvio = ($opciones->configuracion->filaTipoEnvio !== NULL) ? $opciones->configuracion->filaTipoEnvio : $filaTipoEnvio;
			$flag_RangosEnvio = ($opciones->configuracion->flag_RangosEnvio !== NULL) ? $opciones->configuracion->flag_RangosEnvio : $flag_RangosEnvio;
			$flag_TarifasPorLocalidad = ($opciones->configuracion->flag_TarifasPorLocalidad !== NULL) ? $opciones->configuracion->flag_TarifasPorLocalidad : $flag_TarifasPorLocalidad;
		}
		$fila = NULL;
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaTipoEnvio == NULL){
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
							FROM `' . self::getNombreTabla() . '` `' . self::getAlias() . '`
							WHERE ' . self::getWhereTabla($codigo);
			/*
			$sentencia_sql = 'SELECT codigo, nombre, importe_fijo, importe_unidad, reembolso, recargo_reembolso, porc_rec_reembolso, privado, pais, transferencia, pasarela, tipo_pasarela, cuenta_bancaria, sin_pago, sin_envio '
					. 'FROM tipo_envio_cli '
					. 'WHERE codigo = ' . $codigo;
			*/
			//echo("$sentencia_sql<br />\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaTipoEnvio;
		}
		
        if ($fila != NULL) {
			//echo("El código es: " . self::getAlias() . '_codigo');
			$this->codigo = $fila[self::getAlias() . '_codigo'];
			$this->nombre = $fila[self::getAlias() . '_nombre'];
			$this->importe_fijo = $fila[self::getAlias() . '_importe_fijo'];
			$this->importe_unidad = $fila[self::getAlias() . '_importe_unidad'];
			$this->reembolso = $fila[self::getAlias() . '_reembolso'];
			$this->recargo_reembolso = $fila[self::getAlias() . '_recargo_reembolso'];
			$this->porc_rec_reembolso = $fila[self::getAlias() . '_porc_rec_reembolso'];
			$this->privado = $fila[self::getAlias() . '_privado'];
			$this->pais = $fila[self::getAlias() . '_pais'];
			$this->transferencia = $fila[self::getAlias() . '_transferencia'];
			$this->pasarela = $fila[self::getAlias() . '_pasarela'];
			$this->tipo_pasarela = $fila[self::getAlias() . '_tipo_pasarela'];
			$this->cuenta_bancaria = $fila[self::getAlias() . '_cuenta_bancaria'];
			$this->sin_pago = $fila[self::getAlias() . '_sin_pago'];
			$this->sin_envio = $fila[self::getAlias() . '_sin_envio'];
			$this->descripcion = descripcion_tipo_envio($this->codigo);
			if ($this->sin_pago || $this->reembolso) {
				$this->requiere_pago = false;
			}
        }
        //Hay que coger los datos de la cesta de las variables globales
        $this->importe_pedido = $importe_cesta;
        $this->cantidad_articulos = $cantidad_cesta;
        /* if (isset($objCliente) && sizeof($objCliente->direcciones) > 0) {
          $this->localidad = $objCliente->direcciones[0]->cod_postal;
          } */

        if ($objCliente != NULL) {
            $this->localidad = $objCliente->direcciones[0]->cod_postal;
        }
        if ($descuento_cesta > 0) {
            $this->importe_pedido = $importe_cesta_con_dto;
        }
        if ($flag_RangosEnvio) {
            $this->cogerRangosEnvio();
        }

        if ($flag_TarifasPorLocalidad) {
            $this->cogerTarifasPorLocalidad();
        }

        $this->importe = $this->getGastosEnvio();
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->importe_fijo);
        unset($this->importe_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_rec_reembolso);
        unset($this->privado);
        unset($this->pais);
        unset($this->transferencia);
        unset($this->pasarela);
        unset($this->tipo_pasarela);
        unset($this->cuenta_bancaria);
        unset($this->sin_pago);
        unset($this->sin_envio);
        unset($this->importe_pedido);
        unset($this->cantidad_articulos);
    }

    function cogerRangosEnvio() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM rango_envio '
                . 'WHERE tipo_envio_cliente = ' . $this->codigo;
        //echo("$sentencia_sql\n");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    $this->rangosEnvios[] = new RangoEnvio($fila['codigo']);
                }
            }
        }
    }

    function cogerTarifasPorLocalidad() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM tarifasporlo '
                . 'WHERE tipo_envio = ' . $this->codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    while ($fila = mysqli_fetch_array($resultado)) {
                        $this->tarifasPorLocalidad[] = new TarifasPorLocalidad($fila['codigo']);
                    }
                }
            }
        }
    }

	public static function tipoEnvioTodos(){
		$retorno = array();
		$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
						FROM `' . self::getNombreTabla() . '` `' . self::getAlias() . '` ';
		//echo("$sentencia_sql<br />\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($retorno, new TipoEnvioCliente(new OpcionesWidget(array('filaTipoEnvio' => $fila))));
			}
		}
		return($retorno);
	}
	
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

    /**
     * Nos devuelve los gastos de envío
     * */
    function getGastosEnvio() {
        include('comunes/globals.php');
        $finded = false;
        $localImporteTotal = 0;
        $localImporte_fijo = $this->importe_fijo;
        $localImporte_unidad = $this->importe_unidad;
        $localReembolso = $this->reembolso;
        $localRecargo_reembolso = $this->recargo_reembolso;
        $localPorc_rec_reembolso = $this->porc_rec_reembolso;


        if ($this->localidad > 0) {
            $objeto = array_filter($this->tarifasPorLocalidad, function($k, $v) {
                return $v['localidad'] == $this->localidad;
            }, ARRAY_FILTER_USE_BOTH);
            if (count($objeto) > 0) {
                $objeto = $objeto[0];
                $finded = true;
                $localImporte_fijo = $objeto->importe_fijo;
                $localImporte_unidad = $objeto->importe_x_unidad;
                $localReembolso = $objeto->reembolso;
                $localRecargo_reembolso = $objeto->recargo_reembolso;
                $localPorc_rec_reembolso = $objeto->porc_recargo_reembolso;
            }
        }

        //Si hemos encontrado los gastos, los calculamos
        if (!$finded) {
            if ($this->importe_pedido > 0) {
                $objeto = array_filter($this->rangosEnvios, function($k, $v) {
                    return ( ($v['rango_inferior'] <= $this->importe_pedido) && ($v['rango_superior'] > $this->importe_pedido));
                }, ARRAY_FILTER_USE_BOTH);
                if (count($objeto) > 0) {
                    $objeto = $objeto[0];
                    $finded = true;
                    $localImporteTotal = $objeto->importe;
                }
            }
        }
        //Llegados a este momento, vamos a ver si ya tenemos el importe toal
        if ($localImporteTotal == 0) {
            //Si no existe rango de envio le aplicamos el importe fijo
            $localImporteTotal = $localImporte_fijo;

            if ($localImporte_unidad > 0) {
                $localImporteTotal += $this->cantidad_articulos * $localImporte_unidad;
            }
            if ($localReembolso) {
                //Si hay porcentaje de recargo de reembolso lo sumamos
                if ($localPorc_rec_reembolso > 0) {
                    //$retorno = ($retorno * $gastos["porc_recargo_reembolso"]) / 100;
                    $localImporteTotal += ( ($this->importe_pedido + $localImporteTotal) * $localPorc_rec_reembolso) / 100;
                }
                //Es un reembolso, así que hay que calcular los gastos x reembolso
                $localImporteTotal += $localRecargo_reembolso;
            }
        }
        return($localImporteTotal);
    }	
}

?>