<?php

class SuperTipoEnvioCliente {

    public $codigo = 0;
    public $nombre = '';
    public $importe_fijo = 0;
    public $importe_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_rec_reembolso = 0;
    public $privado = 0;
    public $pais = 0;
    public $transferencia = 0;
    public $pasarela = 0;
    public $tipo_pasarela = 0;
    public $cuenta_bancaria = '';
    public $sin_pago = 0;
    public $sin_envio = 0;
    public $cod_RangosEnvios = array();
    public $cod_TarifasPorLocalidad = array();
    public $flag_utf8 = false;

    function __construct($codigo = 0, $flag_RangosEnvio = true, $flag_TarifasPorLocalidad = true) {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo, nombre, importe_fijo, importe_unidad, reembolso, recargo_reembolso, porc_rec_reembolso, privado, pais, transferencia, pasarela, tipo_pasarela, cuenta_bancaria, sin_pago, sin_envio '
                . 'FROM tipo_envio_cli '
                . 'WHERE codigo = ' . $codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->nombre = $fila['nombre'];
                    $this->importe_fijo = $fila['importe_fijo'];
                    $this->importe_unidad = $fila['importe_unidad'];
                    $this->reembolso = $fila['reembolso'];
                    $this->recargo_reembolso = $fila['recargo_reembolso'];
                    $this->porc_rec_reembolso = $fila['porc_rec_reembolso'];
                    $this->privado = $fila['privado'];
                    $this->pais = $fila['pais'];
                    $this->transferencia = $fila['transferencia'];
                    $this->pasarela = $fila['pasarela'];
                    $this->tipo_pasarela = $fila['tipo_pasarela'];
                    $this->cuenta_bancaria = $fila['cuenta_bancaria'];
                    $this->sin_pago = $fila['sin_pago'];
                    $this->sin_envio = $fila['sin_envio'];
                }
            }
        }

        if ($flag_RangosEnvio) {
            $this->cogerRangosEnvio();
        }

        if ($flag_TarifasPorLocalidad) {
            $this->cogerTarifasPorLocalida();
        }

        if ($codigo == 0) {
            $this->dame_gastos_x_cliente_pedido();
        }
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->importe_fijo);
        unset($this->importe_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_rec_reembolso);
        unset($this->privado);
        unset($this->pais);
        unset($this->transferencia);
        unset($this->pasarela);
        unset($this->tipo_pasarela);
        unset($this->cuenta_bancaria);
        unset($this->sin_pago);
        unset($this->sin_envio);
    }

    function cogerRangosEnvio() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM rango_envio '
                . 'WHERE tipo_envio_cliente = ' . $this->codigo;
        //echo("$sentencia_sql\n");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    $cod_RangosEnvios[] = new RangoEnvio($fila['codigo']);
                }
            }
        }
    }

    function cogerTarifasPorLocalida() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM tarifasporlo '
                . 'WHERE tipo_envio = ' . $this->codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    while ($fila = mysqli_fetch_array($resultado)) {
                        $cod_TarifasPorLocalidad[] = new TarifasPorLocalidad($fila['codigo']);
                    }
                }
            }
        }
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

    function dame_gastos_x_cliente_pedido($pedido = 0) {
        include('comunes/globals.php');
        $retorno = 0;
        $finded = false;
        $gastos = false;
        $localidad = '';
        $cantidad_articulos = 0;
        $importe_pedido = 0;
        $descuento = 0;

        if (Usuario::logueado()) {
            $objCliente = Usuario::logueado();
        }

        $tipo_rango_envio = 0;
        $tipo_envio = 0;
        $cantidad_articulos = 0;



        //si hay pedido, cogemos el tipo de envío de ahí
        if ($pedido > 0) {
            $sentencia_sql = 'SELECT tipo_envio, descuento FROM mc_pedcli WHERE codigo = ' . $pedido;
            if ($conexionBD) {
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    if ($fila = mysqli_fetch_array($resultado)) {
                        $tipo_envio = $fila["tipo_envio"];
                        $descuento = $fila["descuento"];
                    }
                }
            }
            //Vamos con las lineas
            $sentencia_sql = 'SELECT cantidad, importe_con_dto '
                    . 'FROM ml_pedcli '
                    . 'WHERE mc_pedcli = ' . $pedido;
            if ($conexionBD) {
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    while ($fila = mysqli_fetch_array($resultado)) {
                        $cantidad_articulos += $fila["cantidad"];
                        $importe_pedido += $fila["importe_con_dto"];
                    }
                }
            }
            //OJO que al importe hay que aplicarle el dto
            $importe_pedido = Price::setDiscount($importe_pedido, $descuento);
        } else {
            //Hay que coger los datos de la cesta de las variables globales
            $importe_pedido = $importe_cesta;
            $cantidad_articulos = $cantidad_cesta;
            if ($descuento_cesta > 0) {
                $importe_pedido = $importe_cesta_con_dto;
            }
        }

        //Ahora cogemos la localidad del cliente
        if ($objCliente > 0) {
            $localidad = $objCliente->direcciones[0]->cod_postal;
        }
        //Empezamos por los gastos más restrictivos, tarifasporlo
        $select_g_envio = "SELECT `importe_fijo`,`importe_x_unidad` importe_unidad,`reembolso`,`recargo_reembolso`,`porc_recargo_reembolso` 
							FROM `tarifasporlo` 
							WHERE `tipo_envio` = $tipo_envio AND `localidad` = $localidad";
        if ($conexionBD) {
            if ($resultado_g_envio = mysqli_query($conexionBD, $select_g_envio)) {
                if ($fila_g_envio = mysqli_fetch_array($resultado_g_envio)) {
                    $gastos = $fila_g_envio;
                    $finded = true;
                }
            }
        }

        //Vamos a hacerlo por rango de envío
        if (!$finded) {
            //OJO a los decimales
            $importe_select = number_format($importe_pedido, 2, ".", "");
            $select_g_envio = "SELECT `importe`, `tipo_envio_cliente` FROM `rango_envio` 
							WHERE ($importe_select >= `rango_inferior` AND $importe_select <= `rango_superior`) AND tipo_envio_cliente = $tipo_envio";
            //echo("<!-- $select_g_envio -->");
            if ($conexionBD) {
                if ($resultado_g_envio = mysqli_query($conexionBD, $select_g_envio)) {
                    if ($fila_g_envio = mysqli_fetch_array($resultado_g_envio)) {
                        $tipo_rango_envio = $fila_g_envio["tipo_envio_cliente"];
                        $retorno = $fila_g_envio["importe"];
                        $finded = false;
                    }
                }
            }
        }

        //Miramos directamente en la tabla de envío
        if (!$finded) {
            $select_g_envio = "SELECT `importe_fijo`,`importe_unidad`,`reembolso`,`recargo_reembolso`,`porc_rec_reembolso` porc_recargo_reembolso FROM `tipo_envio_cli` WHERE `codigo` = $tipo_envio";
            //echo("<!-- $select_g_envio -->");
            if ($conexionBD) {
                if ($resultado_g_envio = mysqli_query($conexionBD, $select_g_envio)) {
                    if ($fila_g_envio = mysqli_fetch_array($resultado_g_envio)) {
                        $gastos = $fila_g_envio;
                        $finded = true;
                    }
                }
            }
        }

        //Si hemos encontrado los gastos, los calculamos
        if ($finded) {
            /* echo("<!--");
              print_r($gastos);
              echo("-->"); */
            //print_r($gastos);
            //Si no existe rango de envio le aplicamos el importe fijo
            if ($tipo_rango_envio != $tipo_envio) {
                $retorno = $gastos['importe_fijo'];
            }
            if ($gastos['importe_unidad'] > 0) {
                $retorno += $cantidad_articulos * $gastos['importe_unidad'];
            }
            if ($gastos['reembolso']) {
                //Si hay porcentaje de recargo de reembolso lo sumamos
                if ($gastos['porc_recargo_reembolso'] > 0) {
                    //$retorno = ($retorno * $gastos["porc_recargo_reembolso"]) / 100;
                    $retorno += ( ($importe_pedido + $retorno) * $gastos['porc_recargo_reembolso']) / 100;
                }
                //Es un reembolso, así que hay que calcular los gastos x reembolso
                $retorno += $gastos['recargo_reembolso'];
            }
        }
        return($retorno);
    }

}

?>