<?php

/**
  Clase SuperUsuario
 */
class SuperUsuario extends Objeto{

    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $nombre_comercial = '';
    public $nombre_legal = '';
    public $email = '';
    public $direcciones = array();
    public $direccion_principal = 0; //Este es el índice del array de direcciones que apunta a la predeterminada
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $pais = '';
    public $telefono = '';
    public $telefono2 = '';
    public $cif = '';
    public $tarifa = 0;
    public $no_precio_especial = 0;
    public $precios_escalados = 0;
    public $resta_iva = 0;
    public $tarifa_dto_pap = 0;
    public $descuento_papeleria = 0;
    public $descuento_libros = 0;
    public $descuento_texto = 0;
    public $limpiar_cesta = 0;
    public $cod_descuento = 0;
    public $direc_predeterminada = 0; //Este es el código de la dirección predeterminada
    public $escalados_tafifas = 0;
    public $vender_costo = 0;
    public $fecha_nacimiento = '';
    public $version_sinli = 0;
    public $administrador = false;
    public $factura_sin_detalle = false;
    public $favoritos = array();
    public $tipo_cliente = 0;
    public $tipo_envio = 0;
    private $flag_utf8 = false;

	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : 0;
		include('comunes/globals.php');
		self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = ' . $codigo . '
							';
		return(self::$whereSelect);
	}
	
    function __construct($codigo) {
        include('comunes/globals.php');
		//Vamos a controlar que no se nos haya pasado un opciones widget
		$filaUsuario = NULL; // ==> Aquí podemos pasar el resultado de una select ya hecha, lo que nos dará los campos directamente para insertarlos
		if (is_a($codigo, 'OpcionesWidget')){
			//Recogemos las opciones del 'OpcionesWidget'
			$opciones = $codigo;
			$codigo = 0;
			$codigo = ($opciones->configuracion->codigo !== NULL) ? $opciones->configuracion->codigo : $codigo;
			$filaUsuario = ($opciones->configuracion->filaUsuario !== NULL) ? $opciones->configuracion->filaUsuario : $filaUsuario;
		}
		$fila = NULL;
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaUsuario == NULL){
			/*
			$sentencia_sql = 'SELECT `codigo`, `codigo_sinlib`, `nombre_comercial`, `nombre_legal`, `email`, `direccion`, `cod_postal`, `localidad`, `provincia`, `telefono`, `telefono2`, `cif`, `pais`, `no_precio_especial`, `tarifa`, `precios_escalados`, `resta_iva`, `tarifa_dto_pap`, `descuento_papeleria`, `descuento_libros`, `descuento_texto`, `limpiar_cesta`, `cod_descuento`, `tarifas_multiples`, `direc_predeterminada`, `escalados-tarifa`, `vender-costo`, `fecha_nacimiento`, `version_sinli`, `factura_sin_detalle`,`tipo_cliente`, `tipo_envio` 
			 FROM cliente WHERE codigo = ' . $codigo;
			 */
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
								FROM ' . self::getNombreTabla() . ' ' . self::getAlias() . ' 
								WHERE ' . self::getWhereTabla($codigo);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaUsuario;
		}
		if ($fila != NULL) {
			$this->codigo = $fila[self::getAlias() . '_codigo'];
			$this->codigo_sinlib = $fila[self::getAlias() . '_codigo_sinlib'];
			$this->nombre_comercial = $fila[self::getAlias() . '_nombre_comercial'];
			$this->nombre_legal = $fila[self::getAlias() . '_nombre_legal'];
			$this->email = $fila[self::getAlias() . '_email'];
			//Vamos a crear un objeto direcciones para añadir la dirección del cliente
			$this->direccion = $fila[self::getAlias() . '_direccion'];
			$this->cod_postal = $fila[self::getAlias() . '_cod_postal'];
			$this->localidad = $fila[self::getAlias() . '_localidad'];
			$this->provincia = $fila[self::getAlias() . '_provincia'];
			$this->telefono = $fila[self::getAlias() . '_telefono'];
			$this->pais = $fila[self::getAlias() . '_pais'];
			$this->direcciones[0] = new Direcciones($this->codigo, 0, $this->direccion, $this->cod_postal, $this->localidad, $this->provincia, $this->telefono, $this->nombre_legal, $this->pais);
			$this->telefono2 = $fila[self::getAlias() . '_telefono2'];
			$this->cif = $fila[self::getAlias() . '_cif'];
			$this->tarifa = $fila[self::getAlias() . '_tarifa'];
			$this->no_precio_especial = $fila[self::getAlias() . '_no_precio_especial'];
			$this->precios_escalados = $fila[self::getAlias() . '_precios_escalados'];
			$this->resta_iva = $fila[self::getAlias() . '_resta_iva'];
			$this->tarifa_dto_pap = $fila[self::getAlias() . '_tarifa_dto_pap'];
			$this->descuento_papeleria = $fila[self::getAlias() . '_descuento_papeleria'];
			$this->descuento_libros = $fila[self::getAlias() . '_descuento_libros'];
			$this->descuento_texto = $fila[self::getAlias() . '_descuento_texto'];
			$this->limpiar_cesta = $fila[self::getAlias() . '_limpiar_cesta'];
			$this->cod_descuento = $fila[self::getAlias() . '_cod_descuento'];
			$this->direc_predeterminada = $fila[self::getAlias() . '_direc_predeterminada'];
			$this->escalados_tafifas = $fila[self::getAlias() . '_escalados-tarifa'];
			$this->vender_costo = $fila[self::getAlias() . '_vender-costo'];
			$this->fecha_nacimiento = $fila[self::getAlias() . '_fecha_nacimiento'];
			$this->version_sinli = $fila[self::getAlias() . '_version_sinli'];
			$this->factura_sin_detalle = ( $fila[self::getAlias() . '_factura_sin_detalle'] == 0) ? false : true;
			$this->tipo_cliente = $fila[self::getAlias() . '_tipo_cliente'];
			$this->tipo_envio = $fila[self::getAlias() . '_tipo_envio'];

			//Vamos a comprobar rápidamente si el usuario es administrador
			$sentencia_sql = "SELECT codigo FROM administrador WHERE email = '$this->email'";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				if ($fila = mysqli_fetch_array($resultado)) {
					if ($fila["codigo"] > 0) {
						$this->administrador = true;
					}
				}
			}
			//Vamos a cargar las direcciones asociadas a este usuario
			$sentencia_sql = "SELECT `codigo`, `direccion`, `cod_postal`, `localidad`, `provincia`, `nombre`, `telefono`, `pais` FROM `direccion_envio` WHERE `cliente` = " . $this->codigo;
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					$actual = count($this->direcciones);
					$this->direcciones[$actual] = new Direcciones($this->codigo, $fila['codigo'], $fila["direccion"], $fila["cod_postal"], $fila["localidad"], $fila["provincia"], $fila["telefono"], $fila["nombre"], $fila["pais"]);
					if ($fila["codigo"] == $this->direc_predeterminada) {
						$this->direccion_principal = $fila["codigo"];
					}
				}
			}
			//Ahora hay que ordenar las direcciones de envío
			if ($this->direc_predeterminada != 0) {
				$encontrado = 0;
				for ($i = 1; $i < count($this->direcciones) && ($encontrado == 0); $i++) {
					if ($this->direcciones[$i]->codigo == $this->direc_predeterminada) {
						$encontrado = $i;
					}
				}
				$copia_dir = $this->direcciones[0];
				$this->direcciones[0] = $this->direcciones[$encontrado];
				$this->direcciones[$encontrado] = $copia_dir;
			}
			//Cargamos los favoritos. No se inicializan los objetos artículos por optimizar la velocidad
			$sentencia_sql = 'SELECT articulo.codigo FROM articulo, favoritos WHERE favoritos.articulo = articulo.codigo AND favoritos.cliente = ' . $this->codigo . ' ORDER BY favoritos.fecha_alta ASC';
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					$this->favoritos[] = $fila["codigo"];
				}
			}
		}
	}

    function __destruct() {
        //Limpiamos los hijos que tenga asociados el escaparate
        for ($i = 0; $i < count($this->direcciones); $i++) {
            unset($this->direcciones[$i]);
        }
    }

	function limpiarCesta(){
		return(self::setLimpiarCesta($this->codigo));
	}
	
	static function setLimpiarCesta($cod_usuario){
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `cliente` SET `limpiar_cesta` = 1 WHERE `codigo` = ' . $cod_usuario . '; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>