<?php

ini_set('include_path', '../..' . PATH_SEPARATOR . get_include_path());

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FUNCIONES UTILIZADAS EN LA CARGA DE LA BASE DE DATOS
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function cerrar_conexion_bd() {
    if (isset($GLOBALS['conexionBD'])) {
        if ($GLOBALS['conexion_sql_activa'] == true) {
            mysqli_close($GLOBALS['conexionBD']);
            $GLOBALS['conexion_sql_activa'] == false;
            $GLOBALS['conexionBD'] == false;
        }
    }
}

function crea_cliente($array_datos, $pendiente_sinlib = false, $envia_confirmacion = false, $modificar_si_existe = false, $confirmacion_necesaria) {
    include('comunes/globals.php');
    $retorno = 0;
    //Vamos a transformar el array de datos en los campos del select
    $campos = '';
    $valores = '';
    $sentencia_update = '';
    $codigo_cliente = 0;
	$codigo_confirmacion = 0;
	if ($confirmacion_necesaria){
	    $codigo_confirmacion = 1000 + rand(1, 89999);
	}
    $cadena_email_empresa = '<p>Un cliente acaba de registrarse en su web. Falta por confirmar su registro. Estos son sus datos:</p>';
    //$cadena_email_empresa .='<PRE>'.print_r($array_datos).'<pre>';
    $email_cliente = '';
	/*Hacemos una comprobacion al estilo compadre para que los datos se pongan en su sitio....*/
	if(empty($array_datos['nombre_legal']) && !empty($array_datos['nombre_comercial'])){
		
		$array_datos['nombre_legal'] = $array_datos['nombre_comercial'];
		
	}else if (!empty($array_datos['nombre_legal']) && empty($array_datos['nombre_comercial'])){
		
		$array_datos['nombre_comercial'] = $array_datos['nombre_legal'];
		
	}
    foreach ($array_datos as $clave => $valor) {
        //Ojo con el password:
        if (( $clave == 'password') && (Shop::$configuracion->password_encriptado)) {
            //Si el password va encriptado tenemos que encriptarlo
            $valor = sha1(str_pad($valor, 10));
        }
        if ($clave != 'password') {
            $cadena_email_empresa .= "<p>$clave: $valor</p>";
        }
        $campos .= (($campos != '' ) ? ',' : '') . $clave;
        $valores .= (($valores != '' ) ? ',' : '') . "'" . $valor . "'";
        $sentencia_update = (($sentencia_update != '' ) ? ',' : '') . $clave . " = '" . $valor . "'";
        //Si estamos en el campo email, lo guardamos
        if ($clave == 'email') {
            $email_cliente = $valor;
        }
    }
    if (($campos != '') && ($valores != '')) {
        //Antes de hacer el insert, vamos a ver si existe el cliente, necesitamos comprobarlo por el email

        $sentencia_sql = "SELECT codigo FROM cliente WHERE email = '$email_cliente'";
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $codigo_cliente = $retorno = $fila['codigo'];
            }
        }
        //Si el cliente en cuestión ya existe, lo modificamos si procede
        if ($codigo_cliente > 0) {
            if ($modificar_si_existe) {
                $sentencia_sql = "UPDATE cliente SET $sentencia_update WHERE codigo = $codigo_cliente";
                mysqli_query($conexionBD, $sentencia_sql);
            }
        } else {
            //Si el cliente está pendiente de sinlib tenemos que añadir esos campos
            if ($pendiente_sinlib) {
                $campos .= (($campos != '' ) ? ',' : '') . ' pendiente_sinlib, codigo_confirmacion';
                $valores .= (($valores != '' ) ? ',' : '') . " 1, $codigo_confirmacion";
            }
            $campos = '(' . $campos . ')';
            $valores = '(' . $valores . ')';
            $sentencia_sql = "INSERT INTO cliente $campos
									VALUES $valores";
            //$cadena_email_empresa .= ("$sentencia_sql<br />\n");
			//var_dump($sentencia_sql);
            $consulta = mysqli_query($conexionBD, $sentencia_sql);
            $codigo_cliente = $retorno = mysqli_insert_id($conexionBD);
        }
    }
    //si tenemos que enviar el email de confirmación lo hacemos aquí
    if ( ($envia_confirmacion) && ($confirmacion_necesaria) ) {
        $url_confirmacion = Shop::$configuracion->url . 'confirmacion_registro/' . $codigo_confirmacion . '/' . $codigo_cliente;
        //echo $url_confirmacion;
        $texto_email = traducir('Bienvenido a') . ' ' . Shop::$empresa->nombre . '. ' . traducir('Para completar el registro pinche') . ' <a href="' . $url_confirmacion . '"><b>' . traducir("aquí") . "</b></a>.
			<br /><br />" . traducir("Si el enlace no funciona, copie la siguiente dirección y péguela en su navegador") . ":<br />
			" . $url_confirmacion . "<br /><br />
			" . traducir('Atentamente') . ': ' . Shop::$empresa->nombre;
        //echo("este es el texto : <br />\n$texto_email <br />\n");
        $asunto = traducir('Confirme su registro en ') . Shop::$empresa->nombre;
        $contenido_email = dame_email($asunto, $texto_email);
        //echo("este es el texto : <br />\n$contenido_email <br />\n");        
        $destinatario = $array_datos['email'] . ',' . ( ($array_datos['nombre_legal'] != '') ? $array_datos['nombre_legal'] : $array_datos['nombre_comercial'] );
        //echo "Destinatario:".$destinatario;
        $retorno = envia_email($destinatario, $asunto, $contenido_email);
        //Vamos a enviar un email a la empresa
        $asunto = "Un nuevo cliente se ha registrado en Shop::$empresa->nombre_legal";
        $contenido_email = dame_email($asunto, $cadena_email_empresa);
        $retorno = envia_email(Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
        //envia_email("tatiana@arminet.es," . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
    }
	
	if (!$confirmacion_necesaria){
		enviarEmailRegistroSinConfirmar($codigo_cliente);
		$asunto = 'Un nuevo cliente se ha registrado en Shop::$empresa->nombre_legal';
        $contenido_email = dame_email($asunto, $cadena_email_empresa);
        $retorno = envia_email(Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
	}
    return($retorno);
}

function creaClienteSupervisado($array_datos) {
    $array_datos_textos = array('email' => 'Email',
        'password' => 'Password',
        'direccion' => 'Dirección',
        'cod_postal' => 'Código postal',
        'telefono' => 'Teléfono',
        'provincia' => 'Provincia',
        'localidad' => 'Localidad',
        'fecha_nacimiento' => 'Fecha de Nacimiento',
        'nombre_legal' => 'Nombre'
    );

    $texto_email = 'Un nuevo usuario desea registrarse en al web, estos son sus datos:';
    ob_start();
    ?>
    <table>
        <?php
        foreach ($array_datos as $clave => $valor) {
            ?>
            <tr><td><?= $array_datos_textos[$clave]; ?>:</td><td><?= $valor; ?></td></tr>
            <?php
        }
        ?>
    </table>
    <?php
    $texto_email.= ob_get_clean();
    $asunto = traducir('Un nuevo usuario desea registrarse en ') . Shop::$empresa->nombre;
    $contenido_email = dame_email($asunto, $texto_email);
    envia_email(Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
    //envia_email("tomas@arminet.es,Tomas Hernández", $asunto, $contenido_email);
    /* Enviamos confirmación de su registro al client, pero es meramente informativo */
    $texto_email = traducir('Bienvenido a') . ' ' . Shop::$empresa->nombre . 'En breve nos pondremos en contacto con usted para darle de alta en el sistema.';
    $asunto = traducir('Datos recibidos en') . Shop::$empresa->nombre;
    $contenido_email = dame_email($asunto, $texto_email);
    $destinatario = $array_datos['email'] . ',' . ( ($array_datos['nombre_legal'] != '') ? $array_datos['nombre_legal'] : $array_datos['nombre_comercial'] );
    envia_email($destinatario, $asunto, $contenido_email);
}

function modifica_cliente($codigo_cliente, $array_datos) {
    /*
      echo("<pre>");
      print_r($array_datos);
      echo("</pre>");
     */
    include('comunes/globals.php');
    $retorno = 0;
    if ($codigo_cliente > 0) {
        //Vamos a transformar el array de datos en los campos del select
        $campos = '';
        foreach ($array_datos as $clave => $valor) {
            $campos .= (($campos != '' ) ? ',' : '') . $clave . "='" . $valor . "' ";
        }
        if ($campos != "") {
            if (!isset($array_datos['email'])) {
                $codigo_tmp = $codigo_cliente;
            }
            //Antes de nada, necesitamos comprobar que el email que nos ha proporcionado el cliente no esté en otro cliente
            if (isset($array_datos['email'])) {
                $codigo_tmp = $codigo_cliente;
                //Vamos a cargar el código del cliente que tenga ese mismo email. En caso de ser el mismo que el del cliente actual, todo va guay
                $sentencia_sql = "SELECT codigo FROM cliente WHERE email ='" . $array_datos["email"] . "'";
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    if ($fila = mysqli_fetch_array($resultado)) {
                        $codigo_tmp = $fila['codigo'];
                    }
                }
            }
            if ($codigo_tmp == $codigo_cliente) {
                //Si el cliente está pendiente de sinlib tenemos que añadir esos campos
                $campos .= (($campos != '' ) ? ',' : '') . ' modificado = 1 ';
                $sentencia_sql = "UPDATE cliente SET  $campos
										WHERE codigo = " . $codigo_cliente;
                //echo("$sentencia_sql<br />\n");
                $consulta = mysqli_query($conexionBD, $sentencia_sql);
                $retorno = $codigo_cliente;
            } else {
                $retorno = -1;
            }
        }
    }
    return($retorno);
}

function confirmar_cliente($codigo_confirmacion, $codigo_cliente) {
    $retorno = false;
    include('comunes/globals.php');
    if (($codigo_confirmacion > 0) && ($codigo_cliente > 0)) {
        $sentencia_sql = "UPDATE cliente SET codigo_confirmacion = '0', pendiente_sinlib = 1 WHERE codigo = $codigo_cliente AND codigo_confirmacion = $codigo_confirmacion";
        $consulta = mysqli_query($conexionBD, $sentencia_sql);
        $afectados = mysqli_affected_rows($conexionBD);
        if ($afectados > 0) {
            //Vamos a obtener el email y la contraseña
            $sentencia_sql = "SELECT email, nombre_legal FROM cliente WHERE codigo = $codigo_cliente";
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {

                    $retorno = true;
                    //Vamos a enviar un mail con los datos del cliente
                    $texto_email = '<p>' . traducir('Hemos confirmado su dirección de correo electrónico. Ya puede acceder a nuestra web utilizando sus datos de usuario') . ':</p>';
                    $texto_email .= '<p>' . traducir('Dirección de email: ') . $fila['email'] . '</p>';
                    $texto_email .= '<p>' . traducir('Contraseña: ') . '**********' . '</p>';
                    $texto_email .= '<p>' . traducir('Su contraseña ha sido ocultada por seguridad') . '.</p>';
                    //echo("este es el texto : <br />\n$texto_email <br />\n");
                    $asunto = traducir('Email confirmado correctamente en ') . Shop::$empresa->nombre;
                    $contenido_email = dame_email($asunto, $texto_email);
                    $destinatario = $fila['email'] . ',' . $fila['nombre_legal'];
                    envia_email($destinatario, $asunto, $contenido_email);
                    //Vamos a enviar el email a la empresa
                    $asunto = "Confirmación de registro realizada en Shop::$empresa->nombre_legal";
                    $contenido_email = dame_email($asunto, "<p>Un cliente con dirección email: $destinatario acaba de confirmar su registro en la web.</p>");
                    envia_email(Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
                }
            }
        }
    } else if (($codigo_confirmacion == '') && ($codigo_cliente > 0)) {
        //Si no nos pasan código de confirmación entonces confirmamos al cliente sin más, usando su código de cliente
        $sentencia_sql = "UPDATE cliente SET codigo_confirmacion = '0', pendiente_sinlib = 1 WHERE codigo = $codigo_cliente";
        $consulta = mysqli_query($conexionBD, $sentencia_sql);
        $afectados = mysqli_affected_rows($conexionBD);
        if ($afectados > 0) {
            //Vamos a obtener el email y la contraseña
            $sentencia_sql = "SELECT email, nombre_legal FROM cliente WHERE codigo = $codigo_cliente";
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $retorno = true;
                    //Vamos a enviar un mail con los datos del cliente
                    $texto_email = '<p>' . traducir('Hemos confirmado su dirección de correo electrónico. Ya puede acceder a nuestra web utilizando sus datos de usuario') . ':</p>';
                    $texto_email .= '<p>' . traducir('Dirección de email: ') . $fila['email'] . '</p>';
                    $texto_email .= '<p>' . traducir('Contraseña: ') . '**********' . '</p>';
                    $texto_email .= '<p>' . traducir('Su contraseña ha sido ocultada por seguridad') . '.</p>';
                    //echo("este es el texto : <br />\n$texto_email <br />\n");
                    $asunto = traducir('Email confirmado correctamente en ') . Shop::$empresa->nombre;
                    $contenido_email = dame_email($asunto, $texto_email);
                    $destinatario = $fila['email'] . ',' . $fila['nombre_legal'];
                    envia_email($destinatario, $asunto, $contenido_email);
                    //Vamos a enviar el email a la empresa
                    $asunto = 'Confirmación de registro realizada en Shop::$empresa->nombre_legal';
                    $contenido_email = dame_email($asunto, '<p>Un cliente con dirección email: $destinatario acaba de confirmar su registro en la web.</p>');
                    envia_email(Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal, $asunto, $contenido_email);
                }
            }
        }
    }
    return($retorno);
}

function crea_cliente_tmp($array_datos = NULL) {
    include('comunes/globals.php');
    $retorno = NULL;
    //Vamos a transformar el array de datos en los campos del select
    $array_campos = array();
    $valor_clave = 'campo_registro_';
    if (($array_datos != NULL) && (is_array($array_datos))) {
        foreach ($array_datos as $clave => $valor) {
            $posicion = strpos($clave, $valor_clave);
            if ($posicion !== false) {
                $array_campos[substr($clave, strlen($valor_clave))] = $valor;
            }
        }
        if (count($array_campos) > 0) {
            $retorno = new UsuarioSinRegistro($array_campos);
        }
    }
    return($retorno);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Generamos un código de seguridad para él formulario actual
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function genera_cod_seguridad($session_id = '') {
    include('comunes/globals.php');
	$recargar_web = Sesion::getReloadPage();
    $hash = '';
    if ($session_id == '') {
        $session_id = Sesion::getCookieValue('session_id');
        //Para que las cookies y la sesión, por seguridad, coincidan, vamos a coger el session ID de la propia sesión en vez e las cookes
        //Si el id de sesión está vacío, lo cogemos de la sesión
        if ($session_id == NULL) {
			//OJO, si no hay sesión, esto no furula:
			if (session_status() == PHP_SESSION_NONE) {
				session_start();
			}
            $session_id = session_id();
        }
    }
    $navegador = $_SERVER['HTTP_USER_AGENT'];
    if ($session_id != '') {
        //Lo primero es mirar si tenemos un código para la IP actual y en menos de 6 horas
        $sentencia_sql = "SELECT codigo, hash, cliente FROM seguridad WHERE session_id = '$session_id' AND navegador = '$navegador' ";
        if (Shop::$configuracion->segundos_sesion > 0) {
            $sentencia_sql .= ' AND ( (HOUR(TIMEDIFF(NOW(), fecha)) *3600) + (MINUTE(TIMEDIFF(NOW(), fecha)) * 60) + (SECOND(TIMEDIFF(NOW(), fecha))) ) <= ' . Shop::$configuracion->segundos_sesion;
        }
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $hash = $fila['hash'];
                    //Si no hay cliente pero estamos logueados, hay que insertar el cliente
                    if (($fila['cliente'] == 0) && (Usuario::logueado() != NULL)) {
                        //Hay que insertar el cliente
                        $sentencia_sql = "UPDATE seguridad SET cliente = " . $datos_usuario->codigo . " WHERE codigo = " . $fila["codigo"];
                        ;
                        mysqli_query($conexionBD, $sentencia_sql);
                    }
                }
            }
        }
    }
    //Si no hay código, generamos un nuevo hash, eliminando previamente todos los que haya asociados al session_id
    if (($hash == "") && (!$recargar_web)) {
        /*
          $sentencia_sql = "DELETE FROM seguridad WHERE session_id = '$session_id'";
          mysqli_query($conexionBD, $sentencia_sql);
         */
        deleteHash($session_id);
        $hash = sha1(microtime());
        $cod_cliente = Sesion::get('cod_cliente_web');
        if ($cod_cliente == NULL) {
            $cod_cliente = '';
        }
        $sentencia_sql = "INSERT INTO seguridad (session_id, hash, navegador, fecha, cliente) VALUES ('$session_id', '$hash', '$navegador', NOW(), $cod_cliente)";
        mysqli_query($conexionBD, $sentencia_sql);
    }
    return($hash);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FIN Generamos un código de seguridad para él formulario actual
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Eliminamos un hash creado
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function deleteHash($session_id) {
    include('comunes/globals.php');
    $sentencia_sql = "DELETE FROM seguridad WHERE session_id = '$session_id'";
    mysqli_query($conexionBD, $sentencia_sql);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Eliminamos un hash creado
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


function purgeHash() {
    include('comunes/globals.php');
    //Borramos sesiones caducadas
    $sentencia_sql = "DELETE FROM seguridad WHERE 
			( ( (HOUR(TIMEDIFF(NOW(), fecha)) *3600) + (MINUTE(TIMEDIFF(NOW(), fecha)) * 60) + (SECOND(TIMEDIFF(NOW(), fecha))) ) > " . Shop::$configuracion->segundos_sesion . " )
			OR 
			( ( (HOUR(TIMEDIFF(NOW(), fecha)) *3600) + (MINUTE(TIMEDIFF(NOW(), fecha)) * 60) + (SECOND(TIMEDIFF(NOW(), fecha))) ) > 86400 AND cliente = 0 )
			";
    mysqli_query($conexionBD, $sentencia_sql);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Cargamos el cliente utilizando el sesion_id
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function cargar_cliente_desde_sesion($session_id = "") {
    include('comunes/globals.php');
    $navegador = $_SERVER['HTTP_USER_AGENT'];
    $cliente = 0;
    if ($session_id == '') {
        $session_id = Sesion::getCookieValue('session_id');
        //Para que las cookies y la sesión, por seguridad, coincidan, vamos a coger el session ID de la propia sesión en vez e las cookes
        //Si el id de sesión está vacío, lo cogemos de la sesión
        if ($session_id == NULL) {
            $session_id = session_id();
        }
    }
    $sentencia_sql = "SELECT cliente FROM seguridad WHERE session_id = '$session_id' AND navegador = '$navegador'";
    if (Shop::$configuracion->segundos_sesion > 0) {
        $sentencia_sql .= " AND ( (HOUR(TIMEDIFF(NOW(), fecha)) *3600) + (MINUTE(TIMEDIFF(NOW(), fecha)) * 60) + (SECOND(TIMEDIFF(NOW(), fecha))) ) <= " . Shop::$configuracion->segundos_sesion;
    }
    //echo($sentencia_sql);
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $cliente = $fila["cliente"];
            }
        }
    }
    return($cliente);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Comprobamos si el hash recibido es el de la sesión
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function comprueba_hash_sesion($hash) {
    include('comunes/globals.php');
    $sesion = session_id();
    $navegador = $_SERVER['HTTP_USER_AGENT'];
    $retorno = false;
    $sentencia_sql = "SELECT hash FROM seguridad WHERE hash = '$hash' AND session_id = '$sesion' AND navegador = '$navegador'";
    if (Shop::$configuracion->segundos_sesion > 0) {
        $sentencia_sql .= " AND ( (HOUR(TIMEDIFF(NOW(), fecha)) *3600) + (MINUTE(TIMEDIFF(NOW(), fecha)) * 60) + (SECOND(TIMEDIFF(NOW(), fecha))) ) <= " . Shop::$configuracion->segundos_sesion;
    }
    //echo("$sentencia_sql<br />\n");
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if (mysqli_num_rows($resultado) > 0) {
                $retorno = true;
            }
        }
    }
    return($retorno);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FIN Comprobamos si el hash recibido es el de la sesión
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Devolvemos los nombres del tipo del tipo de envio y deforma de envío y sus descripciones
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function nombre_tipo_envio($tipo_envio) {
    $retorno = "";
    include('comunes/globals.php');
    $sentencia_sql = "SELECT nombre FROM tipo_envio_cli WHERE codigo = $tipo_envio";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $retorno = $fila['nombre'];
            }
        }
    }
    return($retorno);
}

function descripcion_tipo_envio($tipo_envio) {
    $retorno = '';
    include('comunes/globals.php');
    $idioma = Sesion::get('idioma');
    $sentencia_sql = "SELECT descripcion FROM traduc_tipo_envio WHERE idioma = '$idioma' AND tipo_envio = $tipo_envio";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $retorno = $fila['descripcion'];
            }
        }
    }
    return($retorno);
}

function nombre_forma_pago($forma_pago) {
    $retorno = '';
    include('comunes/globals.php');
    $sentencia_sql = "SELECT nombre FROM formas_de_pago WHERE codigo = $forma_pago";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $retorno = $fila['nombre'];
            }
        }
    }
    return($retorno);
}

function descripcion_forma_pago($forma_pago) {
    $retorno = '';
    include('comunes/globals.php');
    $sentencia_sql = "SELECT descripcion FROM formas_de_pago WHERE codigo = $forma_pago";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $retorno = $fila['descripcion'];
            }
        }
    }
    return($retorno);
}
function envioSinEnvio($codigo){
	  $retorno = '';
    include('comunes/globals.php');
    $sentencia_sql = "SELECT sin_envio FROM tipo_envio_cli WHERE codigo = $codigo";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $retorno = $fila['sin_envio'];
            }
        }
    }
    return($retorno);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FIN Devolvemos los nombres del tipo del tipo de envio y deforma de envío
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Función que nos dice si hay un usuario logueado o no y nos devuelve el objeto usuario
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*function usuario_logueado() {
    include('comunes/globals.php');
    $retorno = NULL;
    if ($datos_usuario != NULL) {
        if ($datos_usuario->codigo > 0) {
            $retorno = $datos_usuario;
        }
    }

    return($retorno);
}
*/
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FIN Función que nos dice si hay un usuario logueado o no y nos devuelve el objeto usuario
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Función para agregar usuario al boletin de novedades
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function agregar_cliente_boletin($email) {
    include('comunes/globals.php');
    $retorno = NULL;
    if (isset($email)) {
        //Vamos a comprobar que el email no existe en la tabla de la base de datos.
        $sentencia_sql = "SELECT codigo FROM newsletter WHERE email ='" . $email . "'";
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            $num = mysqli_num_rows($resultado);
            if ($num > 0) {
                $retorno = false;
            } else {
                $sentencia_sql = "INSERT INTO newsletter (email) VALUES ('" . $email . "')";
                $resultado = mysqli_query($conexionBD, $sentencia_sql);
                $retorno = mysqli_insert_id($conexionBD);
            }
        }
    }
    return($retorno);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// FIN Función para agregar usuario al boletin de novedades
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Obtenemos el código del programa de gestión del cliente, en función de su código web
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function dame_cod_programa($cliente = 0) {
    include("comunes/globals.php");
    $retorno = 0;
    $sentencia_cliente = "SELECT codigo_sinlib FROM cliente WHERE codigo = $cliente";
    if ($cliente > 0) {
        if ($conexionBD) {
            if ($resultado_cliente = mysqli_query($conexionBD, $sentencia_cliente)) {
                if ($fila_cliente = mysqli_fetch_array($resultado_cliente)) {
                    $retorno = $fila_cliente['codigo_sinlib'];
                }
            }
        }
    }
    return($retorno);
}
function getNombrePais($pais){
	include('comunes/globals.php');
    $retorno = 'No Result';
    $sentencia_cliente = 'SELECT `nombre` FROM `pais` WHERE `codigo` = '.$pais;
    if ($pais > 0) {
        if ($conexionBD) {
            if ($resultado_cliente = mysqli_query($conexionBD, $sentencia_cliente)) {
                if ($fila_cliente = mysqli_fetch_array($resultado_cliente)) {
                    $retorno = $fila_cliente['nombre'];
                }
            }
        }
    }
    return($retorno);
	
	
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                  COMPROBAMOS SI EXISTE UN CONTADOR. SI NO EXISTE SE CREA, SI EXISTE SE INCREMENTA EN UNO Y DEVOLVEMOS EL VALOR
//----------------------------------------------------------------------------------------------------------------------------------------------------
function incrementa_contador_en_tabla($nombre, $incremento = 1){
	$retorno = false;
	global $conexionBD;
	if ($conexionBD){
		$retorno = 0;
		$sentencia_sql = "SELECT contador FROM contador WHERE nombre = '$nombre'";
		if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
			if($fila = mysqli_fetch_array($resultado)){
				$retorno = $fila["contador"] + 1;
				//Insertamos este contador en la tabla
				$sentencia_sql = "UPDATE contador SET contador = $retorno WHERE nombre = '$nombre'";
				mysqli_query($conexionBD, $sentencia_sql);
			}else{
				$retorno = 1;
				//No existe contador, hay que insertarlo
				$sentencia_sql = "INSERT INTO contador (nombre, contador) VALUES ('$nombre', $retorno)";
				mysqli_query($conexionBD, $sentencia_sql);
			}
		}
	}
	return($retorno);
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                  Esta función desofusca una cadena ofuscada para almacenar una clave de un TPV virtual (ANABEL)
//----------------------------------------------------------------------------------------------------------------------------------------------------
function desofuscar_cadena($clave_xor){
	//Necesito sacar el id_tpv y la clave_ofuscada de la configuración de la empresa
	$consulta_conf = 'SELECT id_tpv, clave_ofuscada FROM configuracion';
	$correcto = false;
	$pal_sec = '';
	$conexionBD = dame_valor_variable_global('conexionBD', false);
	if ($conexionBD){
		//echo("Hay conexionBD<br />\n");
		if ($result_conf = mysqli_query( $conexionBD, $consulta_conf)){
			//echo("Ejecutada consulta select<br />\n");
			if ( $fila_conf = mysqli_fetch_array($result_conf) ){
				//echo("Obtenemos los datos<br />\n");
				$pal_sec_ofuscada  = $fila_conf['clave_ofuscada'];
				$clave_xor = $fila_conf['id_tpv'] . $clave_xor;
				$correcto = true;
			}
		}
	}
	//echo("$consulta_conf<br />\n");
	//echo("$pal_sec_ofuscada <br />\n$clave_xor<br />\n");
	//$pal_sec_ofuscada = "5D;7F;0A;27;09;0D;25;5D;04;01;0B;00;06;01;00;70;06;1C;19;19";
	if ($correcto){
		$trozos = explode (';', $pal_sec_ofuscada);
		$tope = count($trozos);
		//echo("tenemos $tope trozos<br />\n");
		for ($i=0; $i<$tope ; $i++){
			$res = "";
			//Rellenamos el elmento con 0 a la izquierda para que sean 8 dígitos (un byte)
			$pal_sec_ofus_bytes[$i] = str_pad(decbin(hexdec($trozos[$i])), 8, '0', STR_PAD_LEFT);
			$pal_sec_xor_bytes[$i] = str_pad(decbin(ord($clave_xor[$i])), 8, '0', STR_PAD_LEFT);
			for ($j=0; $j<8; $j++){
				(string)$res .= (int)$pal_sec_ofus_bytes[$i][$j] ^ (int)$pal_sec_xor_bytes[$i][$j];
			}
			//echo("Respuesta $i = $res <br />\n");
			$xor[$i] = $res;
			$pal_sec .= chr(bindec($xor[$i]));
		}
	}
	return($pal_sec);
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                  07/Febrero/2017 => Devolvemos el nombre del vendedor
//----------------------------------------------------------------------------------------------------------------------------------------------------
function vendedorDameNombre($codigoVendedor = 0){
	include('comunes/globals.php');
	$retorno = '';
	$sentenciaSql = 'SELECT nombre FROM vendedor WHERE codigo = ' . $codigoVendedor;
	//echo('<!--' . $sentenciaSql . '-->');
	if ($resultado = mysqli_query($conexionBD, $sentenciaSql)){
		if($fila = mysqli_fetch_array($resultado)){
			$retorno = $fila["nombre"];
		}
	}
	return($retorno);
}

?>
