<?php
	//---------------------------------------------------------------------------------------------------------
	// 10/Noviembre/2014
	// Versión 1.0 Widget utilizado para que el usuario modifique sus direcciones de envío
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function widget_direcciones_envio(){
		//Aquí definimos una serie de parámetros que necesitamos
		$funcion_por_defecto = 'direcciones_envio';
		$parametros_por_defecto = array();
		$parametros_recibidos = func_get_args();
		if (count($parametros_recibidos) == 0){
			$parametros_recibidos[0] = $funcion_por_defecto;
		}else{
			if ( ($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL) ){
				$parametros_recibidos[0] = $funcion_por_defecto;
			}
		}
		$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
		$retorno = false;
		//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
		if (count($parametros_recibidos) > 0){
			//Recogemos el nombre de la función de entre el resto de parámetros
			$nombre_funcion = $parametros_recibidos[0];
			//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
			$parametros_recibidos = array_slice($parametros_recibidos, 1);
			//Si la función existe la ejecutamos
			if(function_exists($nombre_funcion)){
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
		return($retorno);
	}

	function direcciones_envio($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
				include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
	<h2><?=traducir('Mis direcciones');?></h2>
	<a href="javascript:void(0);" title="<?=traducir('Nueva dirección de envío');?>" onclick="form_nueva_direccion();"><?=traducir('Nueva dirección de envío');?></a>
<?php
		//Primero creamos el widget con el formulario
        new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'), $campos_direccion, $campos_obligatorios);
        new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio'), $campos_direccion);
?>
</div>
<?php
	}


	function direcciones_envio_inverso($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
		//El enlace de nueva dirección va abajo
				include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
	<h2><?=traducir('Mis direcciones');?></h2>

<?php
        new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio'), $campos_direccion);
?>
	<a href="javascript:void(0);" title="<?=traducir('Nueva dirección de envío');?>" onclick="form_nueva_direccion();"><?=traducir('Nueva dirección de envío');?></a>
<?php
        new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'), $campos_direccion, $campos_obligatorios);
?>
</div>
<?php
	}

	function form_nueva_direccion($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
		include('comunes/globals.php');
		//Vamos a calcular la dirección de envío. En este caso consiste en obtener el último elemento del camino seguido
?>
		<div class="<?=(__FUNCTION__);?>">
			<p class="aviso_nueva_direccion"></p>
			<div class="form_nueva_direccion_formulario">
				<p class="texto_aclaracion_nueva_direccion"></p>
				<form action="javascript:void(0);" method="post" class="nueva_direccion">
					<fieldset>
<?php
		//Recorremos el array de campos
		foreach($campos_direccion as $clave => $valor){
			//Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
			$tipo_campo = 'text';
			$texto_requerido = '';
			$asterisco = '';
			$nombre_campo_formulario = 'campo_direccion_' . $valor;
			if (in_array($valor, $campos_obligatorios)){
				$texto_requerido = 'required';
				$asterisco = ' <span class="asterisco">*</span>';
			}
?>
					<label><?=traduce_campo_registro($valor);?><?=$asterisco;?></label>
					<input type="<?=$tipo_campo;?>" name="<?=$nombre_campo_formulario;?>" value="" class="campo_<?=$valor;?>" <?=$texto_requerido;?> />
<?php
		}
?>
					<input type="submit" name="enviar" value="<?=traducir('Guardar');?>"/>
					</fieldset>
					<a href="javascript:void(0);" onclick="limpiar_form_mod_direccion();limpiar_aviso_direccion();" title="<?=traducir('Cancelar');?>"><?=traducir('Cancelar');?></a>
				</form>
<?php
	crear_script_control_direcciones();
?>
			</div>
		</div>
<?php
		return(true);
	}

	function lista_direcciones_envio($lista_campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		include('comunes/globals.php');
		//Vamos a calcular la dirección de envío. En este caso consiste en obtener el último elemento del camino seguido
?>
		<div class="<?=(__FUNCTION__);?>">
<?php
			//Recorremos las direcciones de envío, teniendo en cuenta que la 0 es la de la ficha
			for ($i = 0; $i < count($datos_usuario->direcciones); $i++){
				genera_direccion_envio($datos_usuario->codigo, $datos_usuario->direcciones[$i], $datos_usuario->direc_predeterminada, false, $lista_campos);
			}
?>
		</div>
<script type="text/javascript">
	function form_nueva_direccion(){
		if ($('.form_nueva_direccion_formulario').is(":hidden")){
			$('.form_nueva_direccion_formulario').show('fast');
			//Ocultamos el aviso
			limpiar_aviso_direccion();
		}
		//lo primero es eliminar los campos ocultos que se utilizan en el formulario
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		//Ahora además los insertamos de nuevo con sus valores correspondientes
		$("form.nueva_direccion").append('<input type="hidden" name="codigo" value="0" />');
		$("form.nueva_direccion").append('<input type="hidden" name="accion" value="nueva" />');
		$("form.nueva_direccion").append('<input type="hidden" name="cliente" value="<?=$datos_usuario->codigo;?>" />');
		var texto = "<?=traducir('Introduzca los datos de la nueva dirección de envío y pulse sobre el botón "Guardar". La dirección de envío introducida se sumará a las direcciones existentes.');?>";
		$("p.texto_aclaracion_nueva_direccion").html(texto);
	}
	function limpiar_form_mod_direccion(){
		$('.form_nueva_direccion_formulario').hide('fast');
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		$("form.nueva_direccion fieldset input[name='campo_direccion_nombre']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_direccion']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_cod_postal']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_localidad']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_provincia']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_pais']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_telefono']").prop("value", "");
	}
	function limpiar_aviso_direccion(){
		//Ocultamos el aviso
		$("p.aviso_nueva_direccion").hide('fast');
		$("p.aviso_nueva_direccion").html("");
	}

	function inicio_modificar_direccion(cod_direccion, cod_cliente){
		/*if ($('.form_nueva_direccion').is(":hidden")){
			$('.form_nueva_direccion').show('fast');
		}*/
		form_nueva_direccion();
		var texto = "<?=traducir("Modifique los datos de la dirección de envío seleccionada y pulse el botón 'Guardar'.");?>";
		$("p.texto_aclaracion_nueva_direccion").html(texto);


		//Tenemos que comprobar si es necesario hacer un scroll
		var posicion = $('.form_nueva_direccion').offset();
		if (posicion.top < $(document).scrollTop()){
			$(document).scrollTop(posicion.top - 50);
		}

		//lo primero es eliminar los campos ocultos que se utilizan en el formulario
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		//Ahora además los insertamos de nuevo con sus valores correspondientes
		$("form.nueva_direccion").append('<input type="hidden" name="codigo" value="' + cod_direccion + '" />');
		$("form.nueva_direccion").append('<input type="hidden" name="accion" value="modificar" />');
		$("form.nueva_direccion").append('<input type="hidden" name="cliente" value="' + cod_cliente + '" />');
		//Obtenemos los datos de la direccion
		var nombre = $(".direccion_envio .datos_" + cod_direccion + " span.nombre").html();
		var direccion = $(".direccion_envio .datos_" + cod_direccion + " span.direccion").html();
		var cod_postal = $(".direccion_envio .datos_" + cod_direccion + " span.cod_postal").html();
		var localidad = $(".direccion_envio .datos_" + cod_direccion + " span.localidad").html();
		var provincia = $(".direccion_envio .datos_" + cod_direccion + " span.provincia").html();
		var pais = $(".direccion_envio .datos_" + cod_direccion + " span.pais").html();
		var telefono = $(".direccion_envio .datos_" + cod_direccion + " span.telefono").html();
		//Ahora modificamos el resto de datos
		$("form.nueva_direccion fieldset input[name='campo_direccion_nombre']").prop("value", nombre);
		$("form.nueva_direccion fieldset input[name='campo_direccion_direccion']").prop("value", direccion);
		$("form.nueva_direccion fieldset input[name='campo_direccion_cod_postal']").prop("value", cod_postal);
		$("form.nueva_direccion fieldset input[name='campo_direccion_localidad']").prop("value", localidad);
		$("form.nueva_direccion fieldset input[name='campo_direccion_provincia']").prop("value", provincia);
		$("form.nueva_direccion fieldset input[name='campo_direccion_pais']").prop("value", pais);
		$("form.nueva_direccion fieldset input[name='campo_direccion_telefono']").prop("value", telefono);

	}

	function eliminar_direccion_envio(codigo, cliente){
		//quitamos la dirección de la lista
		if (confirm("<?=html_entity_decode(traducir("¿Está seguro de que desea eliminar esta dirección?"));?>")){
			var parametros = "codigo=" + codigo + "&cliente=" + cliente + "&accion=borrar&hash=<?=genera_cod_seguridad();?>";
			var url = "<?=Shop::$configuracion->url;?>comunes/consultas/crea_mod_direccion_envio.php";
			realizar_solicitud(url, parametros, function(respuesta){
				//console.log(respuesta);
				if (respuesta == "BORRADA"){
					//Si se ha borrado la dirección de envío eliminamos la lína
					$(".direccion_envio .datos_" + codigo + " span.nombre").parents(".direccion_envio").remove();
				}
			});
		}
	}

	function predeterminar_direccion(codigo, cliente){
		var parametros = "codigo=" + codigo + "&cliente=" + cliente + "&hash=<?=genera_cod_seguridad();?>";
		var url = "<?=Shop::$configuracion->url;?>comunes/consultas/predeterminar_direccion_envio.php";
		realizar_solicitud(url, parametros, function(respuesta){
			//console.log(respuesta);
			if (respuesta == "CORRECTO"){
				$("#direc_predeterminada").removeAttr("id");
				//Ahora predeterminamos la que nos han pasado en código
				$(".datos_" + codigo ).parent().attr("id", "direc_predeterminada");
			}
		});
	}
</script>
<?php
	}


	function muestra_datos_dir_predeterminada($usuario = NULL, $campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		include('comunes/globals.php');
		if ($usuario != NULL){
			$usuario_a_mostrar = new Usuario($usuario);
		}else{
			$usuario_a_mostrar = $datos_usuario;
		}
		if ($usuario_a_mostrar != NULL){
			//La dirección predeterminada siempre es la 0.
			if (count($usuario_a_mostrar->direcciones) > 0){
				genera_direccion_envio($usuario_a_mostrar->codigo, $usuario_a_mostrar->direcciones[0], $usuario_a_mostrar->direc_predeterminada, true, $campos);
			}
		}
	}

//--------------------------------------------------------------------------------
//Funciones extras que mecesita este widget
//--------------------------------------------------------------------------------
	//function genera_direccion_envio($cliente, $codigo, $nombre, $direccion, $cod_postal, $localidad, $provincia, $pais, $telefono, $direc_predeterminada = NULL, $oculta_botones = false){
	function genera_direccion_envio($cliente, $obj_direccion, $direc_predeterminada = NULL, $oculta_botones = false, $campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		$datos_permitidos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono');
		if (is_a($obj_direccion, 'Direcciones')){
?>
		<div class="direccion_envio" <?=( ($direc_predeterminada == $obj_direccion->codigo) && ($direc_predeterminada != NULL) ) ? 'id="direc_predeterminada"' : "";?>>
			<span></span>
			<div class="datos_<?=$obj_direccion->codigo;?>">
<?php
			foreach($campos as $clave => $valor){
				//Comprobamos que la clave exista en los elementos permitidos
				if (in_array($valor, $datos_permitidos)){
?>
				<p><span class="nombre_campo"><?=traducir($valor);?> </span><span class="<?=$valor;?>"><?=$obj_direccion->$valor;?></span> </p>
<?php
				}
			}
			/*
?>
				<p><span class="nombre_campo"><?=traducir("Nombre");?> </span><span class="nombre"><?=$nombre;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Dirección");?> </span><span class="direccion"><?=$direccion;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Código postal");?> </span><span class="cod_postal"><?=$cod_postal;?></span> </p>
				<p><span class="guion"> - </span> </p>
				<p><span class="nombre_campo"><?=traducir("Localidad");?> </span><span class="localidad"><?=$localidad;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Provincia");?> </span><span class="provincia"><em>(</em><span><?=$provincia;?></span><em>)</em></span> </p>
<?php
			*/
?>
			</div>
<?php
			if (!$oculta_botones){
?>
			<div class="botones">
<?php
				if ($obj_direccion->codigo > 0){
?>
				<a href="javascript:void(0);" class="eliminar" onclick="eliminar_direccion_envio(<?=$obj_direccion->codigo;?>, <?=$cliente;?>)"title="<?=traducir("Eliminar");?>"><?=traducir("Eliminar");?></a>
				<a href="javascript:void(0);" class="modificar" onclick="inicio_modificar_direccion(<?=$obj_direccion->codigo;?>, <?=$cliente;?>);" title="<?=traducir("Modificar");?>"><?=traducir("Modificar");?></a>
<?php
				}
?>
				<a href="javascript:void(0);" class="predeterminar" onclick="predeterminar_direccion(<?=$obj_direccion->codigo;?>, <?=$cliente;?>);" title="<?=traducir("Predeterminar");?>"><?=traducir("Predeterminar");?></a>
<?php
				if ($obj_direccion->codigo == 0){
?>
				<p class="aclaracion_direcciones"><?=traducir('Esta es su dirección de registro. Para modificarla acceda a su area privada.');?></p>
<?php
				}
?>
			</div>
<?php
			}
?>
		</div>
<?php
		}
	}

	function crear_script_control_direcciones(){
		include('comunes/globals.php');
			//Este escript a continuación no va a funcionar
?>
			<script type="text/javascript">
			document.addEventListener('WSLE', function(event) {
				var scripts = document.getElementsByTagName( 'script' );
				var thisScriptTag = scripts[ scripts.length - 1 ];
				var form_direcciones = $(thisScriptTag).prev();
				var correcto = true;
				var todo_esta_correcto = false;
			
				//No estamos ni en chrome ni en firefox, así que hay que controlar los campos obligatorios
				$(form_direcciones).on("submit", function(event){
					//No dejamos que se haga el submit. Hay que hacerlo si todo está bien
					event.preventDefault();
					correcto = true;
					var fieldset = $(this).children("fieldset")[0];
					//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
					var lista_input =  $(fieldset).children("input[required]");
					var total = lista_input.length;
					for (var i = 0;(i < total) && (correcto); i++){
						var elemento = lista_input[i];
						if ($(elemento).prop("value") == ""){
							correcto = false;
							$(elemento).focus();
							poner_sombra($(elemento));
						}
					}
					//Si todo está correcto, vamos a recoger los valores para hacer el sumbit
					var codigo = $("form.nueva_direccion input[name='codigo']").prop("value");
					var accion = $("form.nueva_direccion input[name='accion']").prop("value");
					var cliente = $("form.nueva_direccion input[name='cliente']").prop("value");
					//Vamos a recoger los valores del formulario en el orden en el que están
					var formParams = "";
					$("form.nueva_direccion fieldset input[name^='campo_direccion_']").each(function(){
						//en el atributo name tenemos el nombre del campo
						var nombre = $(this).attr("name").replace("campo_direccion_", "");
						//var nombre = $(this).attr("name").split("campo_direccion_")[0];
						var valor = $(this).val();
						formParams += "&" + nombre + "=" + valor;
					});
					var parametros = "codigo=" + codigo + "&cliente=" + cliente;
					/*parametros += "&direccion=" + direccion + "&cod_postal=" + cod_postal + "&localidad=" + localidad + "&provincia=" + provincia + "&pais=" + pais;
					parametros += "&nombre=" + nombre + "&telefono=" + telefono;*/
					parametros += formParams;
					parametros += "&accion=" + accion + "&hash=<?=genera_cod_seguridad();?>";
					var url = "<?=Shop::$configuracion->url;?>comunes/consultas/crea_mod_direccion_envio.php";
					//console.log(url, parametros);
					realizar_solicitud(url, parametros, function(respuesta){
						//console.log(respuesta);
						//Según la acción, trataremos la respuesta de una forma o de otra
						if (accion == "nueva"){
							//En respuesta está el código html para añadir a la lista
							$(".lista_direcciones_envio").prepend(respuesta);
							$("p.aviso_nueva_direccion").html('<?=traducir("Dirección añadida satisfactoriamente");?>');
							$("p.aviso_nueva_direccion").show();
						}else if (accion == "modificar"){
							var nuevo_elemento = $(respuesta);
							nuevo_elemento = nuevo_elemento.children("[class *= datos_]");
							$(".direccion_envio").children(".datos_" + codigo).html(nuevo_elemento.html());
							$("p.aviso_nueva_direccion").html('<?=traducir("Dirección modificada satisfactoriamente");?>');
							$("p.aviso_nueva_direccion").show();
						}
						limpiar_form_mod_direccion();
					});
				});

				//Vamos a crear un "listener" para que cuando cambie un input, si el borde es rojo, que se ponga en su borde inicial
				$(form_direcciones).children("fieldset").children("input[required]").on("input", function(){
					quitar_sombra($(this));
				});

				$(form_direcciones).children("fieldset").children("input[name='campo_direccion_cod_postal']").on("blur", function(){
					var elemento = $(this);
					if (elemento.prop("value") != ""){
						var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?=genera_cod_seguridad();?>";
						realizar_solicitud("<?=Shop::$configuracion->url;?>comunes/consultas/cod_postal_get_localidad.php", parametros, function(respuesta){
							if (respuesta != "0"){
								//Tenemos localidad y provincia
								var array_datos = respuesta.split("|");
								var localidad = array_datos[0];
								var provincia = array_datos[1];
								//Vamos a asginar la localidad y provincia
								var campo_localidad = elemento.siblings("[name='campo_direccion_localidad']");
								if (campo_localidad.prop("value") == ""){
									campo_localidad.prop("value", localidad);
								}
								var campo_provincia = elemento.siblings("[name='campo_direccion_provincia']");
								if (campo_provincia.prop("value") == ""){
									campo_provincia.prop("value", provincia);
								}
							}
						});
					}
				});
			});
			</script>
<?php
	}
	//Añadimos las nuevas funcionalidades de las direcciones de envio
	include_once("direcciones_envio_extra.php");
?>