<?php

//---------------------------------------------------------------------------------------------------------
// 21/marzo/2015
// Versi?n 1.0 Extensi?n de widget usuario.
//---------------------------------------------------------------------------------------------------------
// 03/Septiembre/2015
// Versi?n 1.1 A?adimos una funci?n para personalizar los men?s de usuario y sin usuario
//---------------------------------------------------------------------------------------------------------



function formulario_newsletter($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;

    $clase_campo_email = 'email';
    $fichero_newsletter = 'newsletter_usuario';

    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_newsletter = ($opciones->configuracion->fichero_newsletter != NULL) ? $opciones->configuracion->fichero_newsletter : $fichero_newsletter;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        $ruta_fichero = $fichero_newsletter . '.php';
        $ruta_fichero = Theme::findFile($ruta_fichero);
        if ($ruta_fichero != NULL) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class='<?= (__FUNCTION__); ?>'>
                    <?php
                }
                ?>
                <form action="<?= Shop::$configuracion->url; ?>comunes/consultas/nuevo_cliente_boletin.php" method="post" class="registro_boletin">
                    <?php
                    include($ruta_fichero);
                    /*
                      ?>
                      <input type="email" name="email" value="" placeholder="Escribe tu email" class="email" required/>
                      <input type="checkbox" name="aceptar_condiciones" value="" required/>
                      <label class="condiciones_registro"><a href="<?= Shop::$configuracion->url; ?>privacidad" title="<?= traducir("Política de privacidad"); ?>"><?= traducir("Acepto la política de privacidad"); ?></a></label>
                      <input type="submit" name="enviar" value="<?= traducir("Suscribirme"); ?>"/>
                     */
                    ?>
                </form>
                <?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
				<script type="text/javascript" id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var elementObjetive = getLastHtmlObject();
                        elementObjetive.on("submit", function (event) {
                            event.preventDefault();
                            var email_revisado = (elementObjetive.find(".email").val()).trim();
                            if (email_revisado != "") {
                                var parametros = "email=" + elementObjetive.find(".email").val() + "&hash=<?= genera_cod_seguridad(); ?>";
                                var url = elementObjetive.attr("action");
                                realizar_solicitud(url, parametros, function (respuesta) {
                                    if (respuesta == "CORRECTO") {
                                        $('<p class="suscripcion_correcta"><?= traducir("Se ha suscrito correctamente."); ?></p>').prependTo(elementObjetive.parent()).show('fast');
                                        elementObjetive.hide('fast', function () {
                                            $(this).remove();
                                        });
                                    } else {
                                        var mensaje_error_suscripcion = $('<p class="error_suscripcion"><?= traducir("No se ha podido suscribir. El correo indicado ya está suscrito."); ?></p>').prependTo(elementObjetive.parent()).show('fast');
                                        var bt_reintentar = $('<a href="javascript:void(0);" class="btn_reintentar_boletin"><?= traducir("Reintentar"); ?></a>').prependTo(elementObjetive.parent()).show('fast');
                                        bt_reintentar.on("click", function (event) {
                                            elementObjetive.show('fast');
                                            bt_reintentar.hide('fast');
                                            mensaje_error_suscripcion.hide('fast');
                                        });
                                        elementObjetive.hide('fast');
                                    }
                                });
                            }
                        });
                    }());
				});
                </script>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
}

function registroV2($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;

    if (is_a($opciones, 'OpcionesWidget')) {
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    //Si no se nos han pasado opciones, vamos a realizar el registro c?mo se hac?a antes
    if ($opciones == NULL) {
        registro();
        //Aqu? cortamos la funci?n
        return(NULL);
    }
    //Vamos a asegurarnos de que en las opciones haya unos par?metros ya establecidos
    $opciones->configuracion->accion = ($opciones->configuracion->accion == NULL ) ? 'registro' : $opciones->configuracion->accion;
    $opciones->configuracion->texto_cabecera = ($opciones->configuracion->texto_cabecera == NULL ) ? traducir('Para registrarse en nuestra web y disfrutar de las ventajas de ser un usuario registrado, rellene los siguientes campos y pulse el botón "Registrarse". Los campos marcados con * (asterisco) son obligatorios.') : $opciones->configuracion->texto_cabecera;
    $opciones->configuracion->texto_enviar = ($opciones->configuracion->texto_enviar == NULL ) ? traducir('Registro') : $opciones->configuracion->texto_enviar;
//Vamos a controlar que haya un usuario
    $usuario = Usuario::logueado();
    $readonly = '';
    //Hay casos en los que los campos deben ser 'readonly'
    $modificar_datos_envio = dame_valor_variable_global('modificar_datos_envio', '');
    if (($opciones->configuracion->accion == 'datos_usuario') && (strtoupper($modificar_datos_envio) != 'MODIFICAR') && ($datos_usuario_sin_registro != NULL)) {
        $readonly = 'readonly';
    }
    ?>
    <?php
    if ($ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <?php
        //obtenemos cualquier mensaje de registro que nos puedan haber mandado
        $mensaje_registro_correcto = $listaSysMsg->findElement(array("origen" => "/^widget_usuario$/", "clase" => "/^correcto$/"));
        $registro_correcto = false;
        if ($mensaje_registro_correcto != NULL) {
            $registro_correcto = true;
        }
        //Si el mensaje recibido del registro no es correcto, hacemso esto
        if (!$registro_correcto) {
            if ($opciones->configuracion->accion == 'datos_usuario') {
                ?>
                <p class="cabecera"><?= traducir('Indíquenos sus datos o identifíquese'); ?></p>
                <?php
            } else if ($opciones->configuracion->accion == 'registro') {
                ?>
                <p class="cabecera"><?= traducir('Formulario de registro'); ?></p>
                <?php
            }
            ?>
            <p class="texto_aclaracion_registro"><?= $opciones->configuracion->texto_cabecera; ?></p>
            <form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="registro_simple">
                <fieldset>
                    <?php
                    //Vamos a ver si hay que poner un place holder
                    $placeholder = false;
                    if (WEB_MOVIL) {
                        $placeholder = true;
                    }
                    //Recorremos el array de campos
                    foreach ($opciones->elementos as $clave => $valor) {
                        //Si no es un campo del form, tiene un tipo de etiqueta definida
                        if (isset($valor->tipo_etiqueta)) {
                            ?>
                            <<?= $valor->tipo_etiqueta; ?>><?= $valor->campo; ?></<?= $valor->tipo_etiqueta; ?>>
                            <?php
                        } else {
                            //Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
                            $tipo_campo = 'text';
                            $texto_requerido = '';
                            $asterisco = '';
                            $caracter_asterisco = '';
                            $nombre_campo_formulario = 'campo_registro_' . $valor->campo;
                            $fecha_nacimiento = false;
                            $fecha_dividida = false;
                            switch ($valor->campo) {
                                case 'email':
                                    $tipo_campo = 'email';
                                    break;
                                case 'telefono':
                                    $tipo_campo = 'tel';
                                    break;
                                case 'repeticion_password':
                                    $nombre_campo_formulario = $valor->campo;
                                case 'password':
                                    $tipo_campo = 'password';
                                    break;
                                case 'fecha_nacimiento':
                                    $fecha_nacimiento = true;
                                    $tipo_campo = 'date';
                                    break;
                                case 'fecha_nacimiento_dividida':
                                    $fecha_dividida = true;
                                    break;
                            }
                            if ($valor->requerido) {
                                $caracter_asterisco = '*';
                                $texto_requerido = 'required';
                                $asterisco = ' <span class="asterisco">*</span>';
                            }
                            if ($fecha_nacimiento == true) {
                                ?>
                                <label><?= traduce_campo_registro($valor->campo); ?></label>
                                <input type="<?= $tipo_campo; ?>" class="fecha_nac" name="campo_registro_fecha_nacimiento" value="" class="campo_<?= $valor->campo; ?>" <?= $texto_requerido; ?> <?= $readonly; ?>/>
                                <?php
                            } else if ($fecha_dividida) {
                                ?>
                                <fieldset class="fecha_nacimiento_dividida">
                                    <input type="hidden" class="fecha_nac" name="campo_registro_fecha_nacimiento" value=""/>
                                    <label class="titular"><?= traducir('Fecha de nacimiento'); ?></label>
                                    <label class="dia"><?= traducir('Día'); ?></label>
                                    <input type="number" class="dia" name="dia_nacimiento" placeholder="dd" value="" <?= $texto_requerido; ?> <?= $readonly; ?>/>
                                    <?php
									$nombre_script = 'script_' . incrementa_contador();
									?>
									<script type="text/javascript" id="<?= $nombre_script; ?>">
									document.addEventListener('WSLE', function(event) {
                                        ;(function () {
                                            var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                                            //Ahora tenemos que colocar la capa en su sitio, pero cuando se cargue la web
                                            $(window).on("load", function () {
                                                var codigo_capa = "";
                                                for (var i = 1; i <= 31; i++) {
                                                    codigo_capa += '<a href="javascript:void(0);" style="/*display:inline-block; width: 20%; text-align: right;*/">' + i + '</a>'
                                                }
                                                codigo_capa = '<div class="selector_dia">' + codigo_capa + "</div>"

                                                codigo_capa = $(codigo_capa);
                                                $("body").append(codigo_capa);
                                                elementObjetive.on("focus", function () {
                                                    codigo_capa.show('slow');
                                                });
                                                elementObjetive.on("blur", function () {
                                                    codigo_capa.delay(100).hide('fast');
                                                });
                                                //Cogemos la posici?n del input
                                                var offset = elementObjetive.offset();
                                                var alto = elementObjetive.height();
                                                offset.top += alto + 3;
                                                codigo_capa.offset(offset);
                                                //Ahora toca el asignar el "click"
                                                codigo_capa.find("a").on("click", function () {
                                                    elementObjetive.val($(this).html());
                                                });
                                            });
                                        }());
									});
                                    </script>
                                    <label class="mes"><?= traducir("Mes"); ?></label>
                                    <input type="number" class="mes" name="mes_nacimiento" placeholder="mm" value="" <?= $texto_requerido; ?> <?= $readonly; ?>/>
                                    <script type="text/javascript">
									document.addEventListener('WSLE', function(event) {
                                        ;(function () {
                                            var elementObjetive = getLastHtmlObject();
                                            //Ahora tenemos que colocar la capa en su sitio, pero cuando se cargue la web
                                            $(window).on("load", function () {
                                                var codigo_capa = '<div class="selector_mes"><?php
                    for ($i = 1; $i <= 12; $i++) {
                        ?><a href="javascript:void(0);" style="/*display:inline-block; width: 20%; text-align: right;*/" class=<?= $i; ?>><?= dame_mes($i); ?></a><?php
                    }
                    ?></div>';

                                                codigo_capa = $(codigo_capa);
                                                $("body").append(codigo_capa);
                                                elementObjetive.on("focus", function () {
                                                    codigo_capa.show('slow');
                                                });
                                                elementObjetive.on("blur", function () {
                                                    codigo_capa.delay(100).hide('fast');
                                                });
                                                //Cogemos la posici?n del input
                                                var offset = elementObjetive.offset();
                                                var alto = elementObjetive.height();
                                                offset.top += alto + 3;
                                                codigo_capa.offset(offset);
                                                //Ahora toca el asignar el "click"
                                                codigo_capa.find("a").on("click", function () {
                                                    elementObjetive.val($(this).prop("class"));
                                                });
                                            });
                                        }());
									});
                                    </script>
                                    <label class="ano"><?= traducir('Año'); ?></label>
                                    <input type="number" class="ano" name="ano_nacimiento" placeholder="aaaa" value="" <?= $texto_requerido; ?> <?= $readonly; ?>/>
									<?php
									$nombre_script = 'script_' . incrementa_contador();
									?>
                                    <script type="text/javascript" id="<?= $nombre_script; ?>">
									document.addEventListener('WSLE', function(event) {
                                        ;(function () {
                                            var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                                            //Ahora tenemos que colocar la capa en su sitio, pero cuando se cargue la web
                                            $(window).on("load",function () {
                                                var current_year = new Date().getFullYear();
                                                var codigo_capa = "";
                                                for (var i = current_year; i >= (current_year - 90); i--) {
                                                    codigo_capa += '<a href="javascript:void(0);" style="/*display:inline-block; width: 20%; text-align: right;*/">' + i + '</a>'
                                                }
                                                codigo_capa = '<div class="selector_ano">' + codigo_capa + "</div>"

                                                codigo_capa = $(codigo_capa);
                                                $("body").append(codigo_capa);
                                                elementObjetive.on("focus", function () {
                                                    codigo_capa.show('slow');
                                                });
                                                elementObjetive.on("blur", function () {
                                                    codigo_capa.delay(100).hide('fast');
                                                });
                                                //Cogemos la posici?n del input
                                                var offset = elementObjetive.offset();
                                                var alto = elementObjetive.height();
                                                offset.top += alto + 3;
                                                codigo_capa.offset(offset);
                                                //Ahora toca el asignar el "click"
                                                codigo_capa.find("a").on("click", function () {
                                                    elementObjetive.val($(this).html());
                                                });
                                            });
                                        }());
									});
                                    </script>
                                </fieldset>
                                <?php
                            } else {
                                //Vamos a coger el valor por defecto del usuario, siempre y cuando está logueado
                                $valor_x_defecto = "";
                                if ($usuario != NULL) {
                                    $nombre_campo = $valor->campo;
                                    if (isset($usuario->$nombre_campo)) {
                                        $valor_x_defecto = $usuario->$nombre_campo;
                                    }
                                }
                                if ($valor_x_defecto == "") {
                                    if ($datos_usuario_sin_registro != NULL) {
                                        $nombre_campo = $valor->campo;
                                        if (isset($datos_usuario_sin_registro->$nombre_campo)) {
                                            $valor_x_defecto = $datos_usuario_sin_registro->$nombre_campo;
                                        }
                                    }
                                }
                                if (!$placeholder) {
                                    ?>
                                    <label><?= traduce_campo_registro($valor->campo); ?><?= $asterisco; ?></label>
                                    <?php
                                }
                                //comprobamos si el campo es pais, en ese caso no seria un input sino un select
                                if ($valor->campo != 'pais') {
                                    ?>
                                    <input type="<?= $tipo_campo; ?>" name="<?= $nombre_campo_formulario; ?>" value="<?= $valor_x_defecto; ?>" class="campo_<?= $valor->campo; ?>" <?= $texto_requerido; ?> <?= $readonly; ?> <?= ($placeholder) ? 'placeholder="' . traduce_campo_registro($valor->campo) . $caracter_asterisco . '"' : ""; ?>/>
                                    <?php
                                } else {
                                    //como es campo pais entonces tenemos que mostar una selec con los paises que tenga web_pais en la tabla de paises a 1
                                    ?>
                                    <select name="campo_registro_pais" class="campo_pais">
                                        <option><?= traducir('Seleccione pais'); ?></option>
                                        <?php
                                        $sentencia_sql_pais = 'SELECT * FROM  `pais` WHERE web_pais = "1"';
                                        //echo("$sentencia_sql<br />\n");
                                        if ($resultado_pais = mysqli_query($conexionBD, $sentencia_sql_pais)) {
                                            while ($fila_pais = mysqli_fetch_array($resultado_pais)) {
                                                //Tenemos paises que mostrar
                                                ?>
                                                <option value="<?= $fila_pais['codigo'] ?>">
                                                    <?= traducir($fila_pais['nombre']); ?>
                                                </option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                    <?php
                                }
                            }
                        }
                    }

                    //La pol?tica de privacidad no aparece si es "readonly"
                    if ($readonly == "") {
                        ?>
                        <span class="contenedor_politica_privacidad">
                            <input type="checkbox" name="aceptar_condiciones" value="" required/>
                            <label class="condiciones_registro"><?= traducir('Acepto las condiciones de la política de privacidad'); ?>&nbsp;<a href="<?= Shop::$configuracion->url; ?>privacidad" title="<?= traducir('Política de privacidad'); ?>"><?= traducir('Leer política de privacidad'); ?></a></label>
                        </span>
                        <?php
                    }
                    if ($opciones->configuracion->boletin_novedades === true) {
                        ?>
                        <span class="contenedor_boletin_novedades">
                            <input type="checkbox" name="aceptar_boletin" value="true" checked/>
                            <label class="boletin_novedades"><?= traducir('Deseo inscribirme en el boletín de novedades'); ?></label>
                        </span>
                        <?php
                    }
                    if ($readonly == '') {
                        ?>
                        <fieldset class="google_captcha">
                            <?php
                            //A?adimos al registro el captcha de google
                            new Widget("captcha");
                            ?>
                        </fieldset>
                        <?php
                    }
                    ?>
                    <input type="hidden" name="accion" value="<?= $opciones->configuracion->accion; ?>" />
                    <p class="error_registro">&nbsp;</p>

                    <input type="hidden" name="todo_correcto" value="false" />
                    <?php
                    if ($opciones->configuracion->accion != 'datos_usuario') {
                        ?>
                        <input type="submit" name="enviar" value="<?= $opciones->configuracion->texto_enviar; ?>" class="boton"/>
                        <?php
                    }
                    if ($readonly != '') {
                        //Es un formulario de s?lo lectura, vamos a meter la llamada a la url actual pero indicando que queremos modificar el formulario
                        ?>
                        <a class="boton" href="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>?modificar_datos_envio=MODIFICAR" title="<?= traducir('Modificar dirección de envío'); ?>"><?= traducir('Modificar dirección de envío'); ?></a>
                        <?php
                    }
                    ?>
                </fieldset>
            </form>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
            <script type="text/javascript" id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                    var parrafo_error_registro = elementObjetive.find("p.error_registro");
                    elementObjetive.on("submit", function (event) {
                        //No seguimos si est? todo correcto
                        var todo_correcto = elementObjetive.find("input[name='todo_correcto']").val();
                        if (todo_correcto == "false") {
                            //Vamos a convertir la fecha de nacimiento dividida en una fecha de nacimiento
                            if (elementObjetive.find("fieldset.fecha_nacimiento_dividida").length > 0) {
                                var dia = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='dia_nacimiento']").val();
                                var mes = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='mes_nacimiento']").val();
                                var ano = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='ano_nacimiento']").val();
                                var cadena_fecha = ano + "/" + mes + "/" + dia;
                                elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='campo_registro_fecha_nacimiento']").val(cadena_fecha);
                            }
                            var txt_error_registro = "";
                            var correcto = true;
                            //Vamos a empezar con los "required"
                            var lista_input = $(this).find("fieldset").find("input[required]");
                            var i = 0;
                            for (i = 0; (i < lista_input.length) && correcto; i++) {
                                var elemento = lista_input[i];
                                //Si el elemento no es check
                                var tipo = $(elemento).prop("type");
                                if (tipo != "checkbox") {
                                    if ($(elemento).prop("value") == "") {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                } else {
                                    //Si es un check, comprobamos que est? chequeado
                                    if (!($(elemento).is(":checked"))) {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                }
                            }
                            if (!correcto) {
                                //Aqu? paramos
                                event.preventDefault();
                                txt_error_registro = "<?= traducir('Campos obligatorios incorrectos. Revise los datos facilitados.'); ?>";
                            } else {
                                //Ahora toca hacer la comprobaci?n de los campos tipo email
                                lista_input = $(this).find("fieldset").find("input[type='email']");
                                var total = lista_input.length;
                                for (var i = 0; (i < total) && (correcto); i++) {
                                    //Comprobamos que tiene un arroba
                                    var elemento = lista_input[i];
                                    var contenido = $(elemento).prop("value");
                                    if (contenido.split("@").length != 2) {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                }

                                if (!correcto) {
                                    event.preventDefault();
                                    txt_error_registro = "<?= traducir('No ha introducido un email válido.'); ?>";
                                } else {
                                    //ahora toca la comprobaci?n de que los passwords sean iguales
                                    var campo_password = $(this).find("fieldset").find("input[name='campo_registro_password']").prop("value");
                                    var repe_password = $(this).find("fieldset").find("input[name='repeticion_password']").prop("value");
                                    if (campo_password != repe_password) {
                                        correcto = false;
                                        $(this).find("fieldset").find("input[name='campo_registro_password']").focus();
                                        poner_sombra($(this).find("fieldset").find("input[name='campo_registro_password']"));
                                    }
                                    if (!correcto) {
                                        event.preventDefault();
                                        txt_error_registro = "<?= traducir('Las contraseñas introducidas no coinciden.'); ?>";
                                    } else {
                                        //Ahora comprobamos que el check de aceptar las condiciones est? marcado
                                        if (!$("input[name='aceptar_condiciones'").is(":checked")) {
                                            correcto = false;
                                        }
                                        if (!correcto) {
                                            event.preventDefault();
                                            txt_error_registro = "<?= traducir("Debe aceptar las condiciones de la política de privacidad."); ?>";
                                        } else {
                                            //No hay que comprobar si el email existe cuando la acci?n no es registro
        <?php
        if ($opciones->configuracion->accion == 'registro') {
            ?>
                                                //Paramos el submit, pues esta ?ltima funci?n es as?ncrona
                                                event.preventDefault();
                                                //Por ?ltimo, nos vamos a asegurar de que el email no est? repetido
                                                var elemento = $(this).find("fieldset").find("input[type='email']");
                                                var direccion = elemento.prop("value");
                                                //S?lo comprobamos esto si la direcci?n NO est? vac?a
                                                if (direccion != "") {
                                                    var parametros = "email=" + direccion + "&hash=<?= genera_cod_seguridad(); ?>";
                                                    realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/email_comprueba_existe.php", parametros, function (respuesta) {
                                                        if (parseInt(respuesta) > 0) {
                                                            //El email no es correcto
                                                            elemento.focus();
                                                            poner_sombra($(elemento[0]));
                                                            txt_error_registro = "<?= traducir('Ya existe un cliente con esa dirección de email. Si ya se encuentra registrado en nuestra web pruebe a recuperar contraseña. En caso contrario, compruebe que ha escrito bien su dirección de correo electrónico y corríjala.'); ?>";
                                                            parrafo_error_registro.html(txt_error_registro);
                                                            parrafo_error_registro.show();
                                                            elementObjetive.find("input[name='todo_correcto']").val("false");
                                                        } else {
                                                            //Hacemos el submit
                                                            if (elementObjetive != null) {
                                                                elementObjetive.find("input[name='todo_correcto']").val("true");
                                                                elementObjetive.submit();
                                                            }
                                                        }
                                                    });
                                                }
            <?php
        }
        ?>
                                        }
                                    }
                                }
                                //si ha habido alg?n error por el camino, mostramos el error
                                if (!correcto) {
                                    parrafo_error_registro.html(txt_error_registro);
                                    parrafo_error_registro.show();
                                    //Hay que indicar que todo no est? correcto
                                    elementObjetive.find("input[name='todo_correcto']").val("false");
                                }
                            }
                        }
                    });

                    elementObjetive.find("input").on("input", function () {
                        quitar_sombra($(this));
                        parrafo_error_registro.html("&nbsp;");
                        parrafo_error_registro.hide();
                    });

                    elementObjetive.find("input[name='campo_registro_cod_postal']").on("blur", function () {
                        var elemento = $(this);
                        if (elemento.prop("value") != "") {
                            var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?= genera_cod_seguridad(); ?>";
                            realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/cod_postal_get_localidad.php", parametros, function (respuesta) {
                                if (respuesta != "0") {
                                    //Tenemos localidad y provincia
                                    var array_datos = respuesta.split("|");
                                    var localidad = array_datos[0];
                                    var provincia = array_datos[1];
                                    //Vamos a asginar la localidad y provincia
                                    var campo_localidad = elementObjetive.find("[name='campo_registro_localidad']");
                                    if (campo_localidad.prop("value") == "") {
                                        campo_localidad.prop("value", localidad);
                                    }
                                    var campo_provincia = elementObjetive.find("[name='campo_registro_provincia']");
                                    if (campo_provincia.prop("value") == "") {
                                        campo_provincia.prop("value", provincia);
                                    }
                                }
                            });
                        }
                    });
                }());
			});
            </script>

            <?php
        } else {
            //Mostramos el mensaje
            ?>
            <p><?= $mensaje_registro_correcto[0]->getCuerpo(); ?></p>
            <?php
        }
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    //Aqu? llega el momento de limpiar todos los mensajes que haya en el registro, que no sean de widget, claro
    return(true);
}

function peticion_datos_sin_registro($opciones = NULL) {
    include('comunes/globals.php');
    //Si no nos han pasado opciones, vamos a utilizar unas gen?ricas
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('accion' => 'datos_usuario', 'texto_cabecera' => traducir('Si no es usuario registrado o no desea registrarse en nuestra web, por favor rellene estos datos.'), 'texto_enviar' => traducir('Continuar')));
        $opciones->addElement(array('campo' => traducir('Datos de envío'), 'tipo_etiqueta' => 'h4', 'texto_cabecera' => traducir('Por favor, indíquenos sus datos'), 'texto_enviar' => traducir('Continuar')));
        //vamos a rellenar cada campo que queremos en este registro
        $opciones->addElement(array('campo' => 'email', 'requerido' => true));
        $opciones->addElement(array('campo' => 'nombre_legal', 'requerido' => true));
        $opciones->addElement(array('campo' => 'direccion', 'requerido' => true));
        $opciones->addElement(array('campo' => 'cod_postal', 'requerido' => true));
        $opciones->addElement(array('campo' => 'localidad', 'requerido' => true));
        $opciones->addElement(array('campo' => 'provincia', 'requerido' => true));
        $opciones->addElement(array('campo' => 'telefono', 'requerido' => false));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $opciones->accion = 'datos_usuario';
        $widget_registro = new Widget($_WH->GW('usuario', 'registroV2'), $opciones);
    }
}

function menu_usuario_completo($opciones = NULL) {
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_sin_login' => 'menu_usuario_sin_login', 'fichero_con_login' => 'menu_usuario_con_login'));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        include('comunes/globals.php');
        $fichero_sin_login = ($opciones->configuracion->fichero_sin_login != NULL) ? $opciones->configuracion->fichero_sin_login : 'menu_usuario_sin_login';
        $fichero_con_login = ($opciones->configuracion->fichero_con_login != NULL) ? $opciones->configuracion->fichero_con_login : 'menu_usuario_con_login';
        //Si el usuario está logueado, hacemos el include del fichero con login, si no, el contrario.
        $fichero_a_cargar = '';
        if (Usuario::logueado() != NULL) {
            $fichero_a_cargar = $fichero_con_login;
        } else {
            $fichero_a_cargar = $fichero_sin_login;
        }
        $ruta_fichero = Theme::findFile($fichero_a_cargar . '.php');
        if ($ruta_fichero != NULL) {
            include($ruta_fichero);
        }
    }
}

/**
 *  Nueva version para crear la parte del registro, ahora l alogica esta más separada de la vista.
 * @param OpcionesWidget $opciones Contiene las opciones para esta funcion
 * @return type
 */
function registroV3($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    //Si no se nos han pasado opciones, vamos a realizar el registro c?mo se hac?a antes
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }

    if (is_a($opciones, 'OpcionesWidget')) {
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    //Vammos a inicializar los campos con los nombres
    $name_nombre_solo = 'campo_registro_nombre_solo';
	$name_apellido_solo = 'campo_registro_apellidos_solo';
    $name_legal = 'campo_registro_nombre_legal';
    $name_comercial = 'campo_registro_nombre_comercial';
    $name_registroFN = 'campo_registro_fecha_nacimiento';
    $dia_nacimiento = 'dia_nacimiento';
    $mes_nacimiento = 'mes_nacimiento';
    $ano_nacimiento = 'ano_nacimiento'; // :O curioso nombre
    $name_registro_pais = 'campo_registro_pais';
    $aceptar_condiciones = 'aceptar_condiciones';
    $aceptar_boletin = 'aceptar_boletin';
    $name_registro_pais = 'campo_registro_pais';
    $name_registroCP = 'campo_registro_cod_postal';
    $name_registroL = 'campo_registro_localidad';
    $name_registroP = 'campo_registro_provincia';
    $name_email = 'campo_registro_email';
    $name_password = 'campo_registro_password';
    $name_RPassword = 'repeticion_password';
    $name_apellidos_solo = 'campo_registro_apellidos_solo';
    $name_direccion = 'campo_registro_direccion';
    $name_telefono = 'campo_registro_telefono';
    //inicializamos otros valores
    //$captcha = new Widget('captcha');
    //Vamos a asegurarnos de que en las opciones haya unos parametros ya establecidos
    $opciones->configuracion->accion = ($opciones->configuracion->accion == NULL ) ? 'registro' : $opciones->configuracion->accion;
    $accion = $opciones->configuracion->accion;
    $opciones->configuracion->texto_cabecera = ($opciones->configuracion->texto_cabecera == NULL ) ? traducir('Para registrarse en nuestra web y disfrutar de las ventajas de ser un usuario registrado, rellene los siguientes campos y pulse el botón "Registrarse". Los campos marcados con * (asterisco) son obligatorios.') : $opciones->configuracion->texto_cabecera;
    $texto_cabecera = $opciones->configuracion->texto_cabecera;
    $opciones->configuracion->texto_enviar = ($opciones->configuracion->texto_enviar == NULL ) ? traducir('Registro') : $opciones->configuracion->texto_enviar;
    $texto_enviar = $opciones->configuracion->texto_enviar;
    $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : 'registro_perso';

    $registro_correcto = false;
    $mensaje_registro_correcto = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'clase' => '/^correcto$/'));
    $mensaje_error_registro = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'clase' => '/^error$/', 'funcion' => '/^registro$/'));
	$mensaje_error_registro = ($mensaje_error_registro == NULL) ? array() : $mensaje_error_registro;
    //Vamos a ver qué mensaje hay que mostrar

    $mensaje_a_mostrar = ($mensaje_registro_correcto != NULL) ? $mensaje_registro_correcto[0]->getCuerpo() : '';
    $mensaje_a_mostrar = ( ($mensaje_a_mostrar != '') && ($mensaje_error_registro != NULL)) ? $mensaje_error_registro[0]->getCuerpo() : '';
    //Si el registro ha sido correcto y no estamos modificando los datos activamos el flag de registro correcto
    if (($mensaje_registro_correcto != NULL) && ($accion != 'mod_datos')) {
        $registro_correcto = true;
    }
    //Vamos a controlar que haya un usuario
    $usuario = Usuario::logueado();
    $usuarioSinRegistro = $datos_usuario_sin_registro;
    $readonly = '';
    //Hay casos en los que los campos deben ser "readonly"
    $modificar_datos_envio = dame_valor_variable_global('modificar_datos_envio', '');
    if (($accion == 'mod_datos') && (strtoupper($modificar_datos_envio) != 'MODIFICAR') && ($datos_usuario_sin_registro != NULL)) {
        $readonly = 'readonly';
    }
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <?php
        //Si el mensaje recibido del registro no es correcto, hacemos esto
        if (!$registro_correcto) {
            if (count($mensaje_error_registro) > 0) {
                ?>
                <p><?= $mensaje_a_mostrar; ?></p>
                <?php
            }
            ?>
            <form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="registro_simple">
                <?php
                $ruta_fichero = Theme::findFile($fichero . '.php');
                //var_dump($ruta_fichero);
                if ($ruta_fichero != NULL) {
                    //No hacemos nada de esto si no existe el fichero
                    //hacemos el include del fichero en cuestión
                    include($ruta_fichero);
                }
                ?>
                <fieldset class="botones_form_edicion">
                    <?php
                    //Vamos a ver si hay que poner un place holder
                    $placeholder = false;
                    /*if (WEB_MOVIL) {
                        $placeholder = true;
                    }*/
                    ?>
                    <p class="error_registro"></p>
                    <input type="hidden" name="todo_correcto" value="false" />
                    <?php
                    if ($opciones->configuracion->accion != 'datos_usuario') {
                        ?>
                        <input type="submit" name="enviar" value="<?= $opciones->configuracion->texto_enviar; ?>" class="boton enviar_form_datos"/>
                        <a href="javascript:void(0);" class="boton cancelar_form_datos" onClick="$('div.formulario_mod_datos_usuario').hide('fast');"><?= traducir("Cancelar"); ?></a>
                        <?php
                    }
                    if ($readonly != "") {
                        //Es un formulario de sólo lectura, vamos a meter la llamada a la url actual pero indicando que queremos modificar el formulario
                        ?>
                        <a class="boton" href="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>?modificar_datos_envio=MODIFICAR" title="<?= traducir("Modificar dirección de envío"); ?>"><?= traducir("Modificar dirección de envío"); ?></a>
                        <?php
                    }
                    ?>
                </fieldset>
            </form>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
            <script type="text/javascript" id="<?=$nombre_script;?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
                    var parrafo_error_registro = elementObjetive.find("p.error_registro");
                    elementObjetive.on("submit", function (event) {
                        //No seguimos si está todo correcto
                        var todo_correcto = elementObjetive.find("input[name='todo_correcto']").val();
                        if (todo_correcto == "false") {
                            //Vamos a convertir la fecha de nacimiento dividida en una fecha de nacimiento
                            if (elementObjetive.find("fieldset.fecha_nacimiento_dividida").length > 0) {
                                var dia = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='dia_nacimiento']").val();
                                var mes = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='mes_nacimiento']").val();
                                var ano = elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='ano_nacimiento']").val();
                                var cadena_fecha = ano + "/" + mes + "/" + dia;
                                elementObjetive.find("fieldset.fecha_nacimiento_dividida").find("input[name='campo_registro_fecha_nacimiento']").val(cadena_fecha);
                            }
                            var txt_error_registro = "";
                            var correcto = true;
                            //Vamos a empezar con los "required"
                            var lista_input = $(this).find("fieldset").find("input[required]");
                            var i = 0;
                            for (i = 0; (i < lista_input.length) && correcto; i++) {
                                var elemento = lista_input[i];
                                //Si el elemento no es check
                                var tipo = $(elemento).prop("type");
                                if (tipo != "checkbox") {
                                    if ($(elemento).prop("value") == "") {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                } else {
                                    //Si es un check, comprobamos que est? chequeado
                                    if (!($(elemento).is(":checked"))) {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                }
                            }
                            if (!correcto) {
                                //Aquí paramos
                                event.preventDefault();
                                txt_error_registro = "<?= traducir('Campos obligatorios incorrectos. Revise los datos facilitados.'); ?>";
                            } else {
                                //Ahora toca hacer la comprobaci?n de los campos tipo email
                                lista_input = $(this).find("fieldset").find("input[type='email']");
                                var total = lista_input.length;
                                for (var i = 0; (i < total) && (correcto); i++) {
                                    //Comprobamos que tiene un arroba
                                    var elemento = lista_input[i];
                                    var contenido = $(elemento).prop("value");
                                    if (contenido.split("@").length != 2) {
                                        correcto = false;
                                        $(elemento).focus();
                                        poner_sombra($(elemento));
                                    }
                                }

                                if (!correcto) {
                                    event.preventDefault();
                                    txt_error_registro = "<?= traducir('No ha introducido un email válido.'); ?>";
                                } else {
                                    //ahora toca la comprobaci?n de que los passwords sean iguales
                                    var campo_password = $(this).find("fieldset").find("input[name='campo_registro_password']").prop("value");
                                    var repe_password = $(this).find("fieldset").find("input[name='repeticion_password']").prop("value");
                                    if (campo_password != repe_password) {
                                        correcto = false;
                                        $(this).find("fieldset").find("input[name='campo_registro_password']").focus();
                                        poner_sombra($(this).find("fieldset").find("input[name='campo_registro_password']"));
                                    }
                                    if (!correcto) {
                                        event.preventDefault();
                                        txt_error_registro = "<?= traducir('Las contraseñas introducidas no coinciden.'); ?>";
                                    } else {
                                        //Ahora comprobamos que el check de aceptar las condiciones est? marcado
                                        if ($("input[name='aceptar_condiciones'").length > 0) {
                                            if (!$("input[name='aceptar_condiciones'").is(":checked")) {
                                                correcto = false;
                                            }
                                        }
                                        if (!correcto) {
                                            event.preventDefault();
                                            txt_error_registro = "<?= traducir('Debe aceptar las condiciones de la política de privacidad.'); ?>";
                                        } else {
                                            //No hay que comprobar si el email existe cuando la acci?n no es registro
        <?php
        if ($opciones->configuracion->accion == "registro") {
            ?>
                                                //Paramos el submit, pues esta última función es asíncrona
                                                event.preventDefault();
                                                //Por último, nos vamos a asegurar de que el email no esté repetido
                                                var elemento = $(this).find("fieldset").find("input[type='email']");
                                                var direccion = elemento.prop("value");
                                                //S?lo comprobamos esto si la direcci?n NO est? vac?a
                                                if (direccion != "") {
                                                    var parametros = "email=" + direccion + "&hash=<?= genera_cod_seguridad(); ?>";
                                                    realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/email_comprueba_existe.php", parametros, function (respuesta) {
                                                        if (parseInt(respuesta) > 0) {
                                                            //El email no es correcto
                                                            elemento.focus();
                                                            poner_sombra($(elemento[0]));
                                                            txt_error_registro = "<?= traducir('Ya existe un cliente con esa dirección de email. Si ya se encuentra registrado en nuestra web pruebe a recuperar contraseña. En caso contrario, compruebe que ha escrito bien su dirección de correo electrónico y corríjala.'); ?>";
                                                            parrafo_error_registro.html(txt_error_registro);
                                                            parrafo_error_registro.show();
                                                            elementObjetive.find("input[name='todo_correcto']").val("false");
                                                        } else {
                                                            //Hacemos el submit
                                                            if (elementObjetive != null) {
                                                                elementObjetive.find("input[name='todo_correcto']").val("true");
                                                                elementObjetive.submit();
                                                            }
                                                        }
                                                    });
                                                }
            <?php
        }
        ?>
                                        }
                                    }
                                }
                                //si ha habido algún error por el camino, mostramos el error
                                if (!correcto) {
                                    parrafo_error_registro.html(txt_error_registro);
                                    parrafo_error_registro.show();
                                    //Hay que indicar que todo no est? correcto
                                    elementObjetive.find("input[name='todo_correcto']").val("false");
                                }
                            }
                        }
                    });

                    elementObjetive.find("input").on("input", function () {
                        quitar_sombra($(this));
                        parrafo_error_registro.html("&nbsp;");
                        parrafo_error_registro.hide();
                    });

                    elementObjetive.find("input[name='campo_registro_cod_postal']").on("blur", function () {
                        var elemento = $(this);
                        if (elemento.prop("value") != "") {
                            var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?= genera_cod_seguridad(); ?>";
                            realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/cod_postal_get_localidad.php", parametros, function (respuesta) {
                                if (respuesta != "0") {
                                    //Tenemos localidad y provincia
                                    var array_datos = respuesta.split("|");
                                    var localidad = array_datos[0];
                                    var provincia = array_datos[1];
                                    //Vamos a asginar la localidad y provincia
                                    var campo_localidad = elementObjetive.find("[name='campo_registro_localidad']");
                                    if (campo_localidad.prop("value") == "") {
                                        campo_localidad.prop("value", localidad);
                                    }
                                    var campo_provincia = elementObjetive.find("[name='campo_registro_provincia']");
                                    if (campo_provincia.prop("value") == "") {
                                        campo_provincia.prop("value", provincia);
                                    }
                                }
                            });
                        }
                    });
                }());
			});
            </script>
            <?php
        } else {

            //Si no es necesaria la confirmación, entonces mostramos el formulario de login
            if (!Shop::$configuracion->registro_con_confirmacion) {
                new widget('usuario');
            } else {
                //Mostramos el mensaje
                ?>
                <p><?= $mensaje_registro_correcto[0]->getCuerpo(); ?></p>
                <?php
            }
        }
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    //Aquí llega el momento de limpiar todos los mensajes que haya en el registro, que no sean de widget, claro
    return(true);
}

function selector_tipo_cliente($opciones = NULL) {
    include('comunes/globals.php');
    $name = 'campo_registro_tipo_cliente';
    $value = 0;
    $permitir_valor_0 = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $name = ($opciones->configuracion->name != NULL) ? $opciones->configuracion->name : 'campo_registro_tipo_cliente';
        $value = ($opciones->configuracion->value != NULL) ? $opciones->configuracion->value : $value;
        $permitir_valor_0 = ($opciones->configuracion->permitir_valor_0 != NULL) ? $opciones->configuracion->permitir_valor_0 : $permitir_valor_0;

        //echo "El valor es: ".$value;    
        ?>
        <select name = "<?= $name; ?>" class="campo_tipo_cliente">
            <?php
            if ($permitir_valor_0) {
                ?>
                <option><?= traducir('Recogida en tienda'); ?></option>
                <?php
            }

            $sentencia = 'SELECT * FROM `tipo_cliente`';
            //echo("$sentencia<br />\n");
            if ($resultado = mysqli_query($conexionBD, $sentencia)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    ?>
                    <option value="<?= $fila['codigo']; ?>" <?= ($value == $fila['codigo']) ? 'selected="selected"' : "" ?>><?= traducir($fila['nombre']); ?></option>
                    <?php
                }
            }
            ?>
        </select>
        <?php
    }
}
?>
