<?php
/*
	Clase SuperBanner
	// Editado por Tomás añadido el campo target.
	//Editado por Pedro para añadir la clase BaseDatos
*/

class SuperBanner extends Objeto{
	
	public static $nombreTabla = 'banner';
	public static $alias = 'banner';
	
	
	public $codigo = 0;
	public $posicion = 0;
	public $orden = 0;
	public $url = '';
	public $titulo = '';
	public $imagen = '';
	public $activo = 0;
	public $condicion = '';
	private $rutaBase = 'almacen_img/';
	public $target = '_blank';
	
	function __construct($codigo = 0){
		include('comunes/globals.php');
		//Cargamos los datos que necesitamos del banner
		$sentencia_sql = 'SELECT codigo, posicion, orden, url, titulo, imagen, activo, condicion, target FROM banner WHERE codigo = ' . $codigo;
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			if ($fila = $bd->getFila()){
				$imagen = $fila['imagen'];
				$this->codigo = $fila['codigo'];
				$this->posicion = $fila['posicion'];
				$this->orden = $fila['orden'];
				$this->url = $fila['url'];
				$this->titulo = $fila['titulo'];				
				if(!preg_match('/almacen_img/',$imagen)){
					//echo 'entra';
					$imagen = $this->rutaBase.$fila['imagen'];
				}
				$this->imagen = Shop::$configuracion->url.$imagen;
				$this->activo = $fila['activo'];
				$this->condicion = $fila['condicion'];
				$this->target = $fila['target'];
			}
		}
	}
	
	function __destruct() {
        unset($this->codigo);
        unset($this->posicion);
        unset($this->orden);
        unset($this->url);
        unset($this->titulo);
        unset($this->imagen);
        unset($this->activo);
        unset($this->condicion);
        unset($this->target);
    }

	public static function getCampos(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			//include('comunes/diccionario/diccionario.php');
			//self::$campos_tabla = BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'};
			self::$campos_tabla = BaseDatos::dameCampos(self::$nombreTabla);
			//self::$camposSelect = BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}, self::getAlias()) . ' ';
			self::$camposSelect = BaseDatos::dameCamposAlias(self::$nombreTabla) . ' ';
		}
		return(self::$camposSelect);
	}
	
	public static function getNombreTabla(){
		$idioma = WSLocale::$idioma;
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Vamos a simplificar, cogemos el nombre de la tabla usando la función de la clase padre:
		self::$nombreTabla = self::$nombreTabla . ' `' .  self::getAlias() . '`  ';
		return(self::$nombreTabla);
	}  
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_familia = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		if ($codigo_familia != NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = "' . $codigo_familia . '" OR `' .  self::getAlias() . '`.`ean` = "' . $codigo_familia . '" ';
		}
		
		if ($limitar){
			self::$whereSelect .= ' LIMIT 0,1 ';
		}
		return(self::$whereSelect);
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}
?>