<?php
/*
  Clase SuperEmpresa
  @version 1.0
 */
class SuperEmpresa {

    public $nombre_legal = '';
    public $nombre = '';
    public $direccion_email = '';
    public $usuario_email = '';
    public $password_email = '';
    public $smtp_email = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $pais_empresa = '';
    public $cif = '';
    public $telefono_empresa = '';
    public $horario = '';
    public $iframe_gmaps = '';
    public $logo_email = '';
    public $email_empresa = '';
	public $direccion_email_pedidos = '';

    private function cargar_configuracionBD() {
        $resultado = false;
        include('comunes/globals.php');
        //$conexionBD = dame_valor_variable_global('conexionBD', false);
        if ($conexionBD) {
            $sentencia_sql = 'SELECT * FROM configuracion WHERE 1 LIMIT 0 , 1';
            //echo('$sentencia_sql<br />\n');
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->nombre_legal = $fila['nombre_legal'];
                    $this->nombre = $fila['nombre_empresa'];
                    $this->direccion_email = $fila['email'];
                    $this->usuario_email = $fila['usuario'];
                    $this->password_email = $fila['password'];
                    $this->smtp_email = $fila['smtp'];
                    $this->direccion = $fila['direccion_empresa'];
                    $this->cod_postal = $fila['cod_postal'];
                    $this->localidad = $fila['localidad'];
                    $this->provincia = $fila['provincia'];
                    $this->pais_empresa = $fila['pais_empresa'];
                    $this->cif = $fila['cif'];
                    $this->telefono_empresa = $fila['telefono_empresa'];
                    $this->horario = $fila['horario'];
                    $this->iframe_gmaps = $fila['iframe_maps'];
                    $this->logo_email = $fila['logo_email'];
                    $this->email_empresa = $fila['email_empresa'];
					$this->direccion_email_pedidos = $fila['direccion_email_pedidos'];
                    //Si la empresa no tiene email declarado, cogemos el la dirección email utilizada en los envíos
                    if ($this->email_empresa == '') {
                        $this->email_empresa = $this->direccion_email;
                    }
                    $resultado = true;
                }
            }
        } else {
            echo('Error cargando los datos de la empresa, no existe conexi&oacute;n a la base de datos<br />\n');
        }
        return($resultado);
    }

    //Constructor y destructor
    function __construct($ruta_configXML = NULL) {
        //Si existe un fichero xml no cargamos la configuracion de la base de datos
        if ($ruta_configXML != NULL) {
            $resultado = $this->cargar_configuracionXML($ruta_configXML);
        } else {
            $resultado = $this->cargar_configuracionBD();
        }
        if (!$resultado) {
            echo('Ha ocurrido un error al cargar los datos de la empresa<br />\n');
        }
    }

    function __destruct() {
        
    }

    private function cargar_configuracionXML($ruta_fichero) {
        $retorno = false;
        if (file_exists($ruta_fichero)) {
            $datos = simplexml_load_file($ruta_fichero);
            $this->nombre_legal = (string) $datos->nombre_legal;
            $this->nombre = (string) $datos->nombre_empresa;
            $this->direccion_email = (string) $datos->email;
            $this->usuario_email = (string) $datos->usuario;
            $this->password_email = (string) $datos->password;
            $this->smtp_email = (string) $datos->smtp;
            $this->direccion = (string) $datos->direccion;
            $this->cod_postal = (string) $datos->cod_postal;
            $this->localidad = (string) $datos->localidad;
            $this->provincia = (string) $datos->provincia;
            $this->pais_empresa = (string) $datos->pais_empresa;
            $this->cif = (string) $datos->cif;
            $this->telefono_empresa = (string) $datos->telefono_empresa;
            $this->horario = (string) $datos->horario;
            $this->iframe_gmaps = base64_decode((string) $datos->iframe_gmaps);
            $this->logo_email = (string) $datos->logo_email;
            $this->email_empresa = (string) $datos->email_empresa;
            if ($this->email_empresa == '') {
                $this->email_empresa = $this->direccion_email;
            }
            $retorno = true;
        }
        return($retorno);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (gettype($value) == 'string') {
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (is_object($value)) {
                    if (method_exists('"' . get_class($value) . '"', 'getJson')) {
                        $ejecutarJson = false;
                    }
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
            $resp = substr($resp, 0, -1) . "}";
            return $resp;
        }
    }

}

?>