<?php

/*
  Clase SuperGetter
  Clase encargada de recoger los métodos get y post
  @version 1.0
 */

class SuperGetter {
	
    //Constructor y destructor
    public function __construct() {
    }

    public function __destruct() {
        
    }
	
	//Función encargada de recibir una variable recibida vía http (get o post):
	public static function get($variableName = '', $defaultValue = NULL, $method = ''){
		$retorno = $defaultValue;
		//Si nos mandan una variable, la recogemos sólo a ella:
		if ($variableName != ''){
			//Hay que ver si la variable ha llegado por get o por post (siempre y cuandno hayan especificado el método:
			if ($method == ''){
				//Hay que comprobar si la variable está seteada en GET o en POST:
				if (static::isInGet($variableName)){
					$retorno = $_GET[$variableName];
				}else if (static::isInPost($variableName)){
					$retorno = $_POST[$variableName];
				}
			}else{
				$method = strtoupper($method);
				if ( ($method == 'GET') && (static::isInGet($variableName)) ){
					$retorno = $_GET[$variableName];
				}else if ( ($method == 'POST') && (static::isInPost($variableName)) ){
					$retorno = $_POST[$variableName];
				}
			}
		}else{
			$variableList = file_get_contents('php://input');
			$retorno = $variableList;
		}
		return($retorno);
	}
	
	public static function getJson(){
		return(file_get_contents('php://input'));
	}
	
	public static function isInGet($variableName){
		$retorno = false;
		if (isset($_GET[$variableName])){
			$retorno = true;
		}
		return($retorno);
	}
	public static function isInPost($variableName){
		$retorno = false;
		if (isset($_POST[$variableName])){
			$retorno = true;
		}
		return($retorno);
	}
}
