<?php
/*
	Clase SuperSections para las secciones de la web
	@version 1.0
*/
//Esta clase utiliza el compresor/minificador
use MatthiasMullie\Minify;

class SuperMinify{
	//TODO => Si se modifica la sesión hay que limpiar los "media"
	public static function compress($listFiles = array(), $fileName = ''){

		require_once _WS_LIB_DIR_ . 'minify/src/Minify.php';
		require_once _WS_LIB_DIR_ . 'minify/src/CSS.php';
		require_once _WS_LIB_DIR_ . 'minify/src/JS.php';
		require_once _WS_LIB_DIR_ . 'minify/src/Exception.php';
		require_once _WS_LIB_DIR_ . 'minify/src/Exceptions/BasicException.php';
		require_once _WS_LIB_DIR_ . 'minify/src/Exceptions/FileImportException.php';
		require_once _WS_LIB_DIR_ . 'minify/src/Exceptions/IOException.php';
		require_once _WS_LIB_DIR_ . 'converter/src/ConverterInterface.php';
		require_once _WS_LIB_DIR_ . 'converter/src/Converter.php';
		
		
		//Vamos a convertir los ficheros:
		$minifier = NULL;
		$extension = pathinfo($fileName, PATHINFO_EXTENSION);
		$finalPath = _WS_DYNAMIC_DIR_ . 'media/' . $extension . '/';
		if ($extextension = 'js'){
			$minifier = new Minify\JS();
		}else{
			$minifier = new Minify\CSS();
		}
		foreach($listFiles->list as $clave => $filetime){
			$minifier->add(_WS_THEME_HTML_DIR_ . $clave);
		}
		
		$resultado = $minifier->minify();
		
		//Vamos a transformar "resultado" si es CSS porque la librería no pone los "@import" al principio del fichero
		
		$ultima_posicion = 0;
		$imports = '';
		do{
			//echo("vuelta $contador\n");
			$existen = strpos ( $resultado, 'url(', $ultima_posicion);
			if ($existen !== false){
				$existen += 3;
				//Tenemos una ruta, vamos a obtenerla entera
				$punto_y_coma = strpos ( $resultado, ')', $existen );
				$ultima_posicion = $punto_y_coma;
				//Cortamos la cadena de texto:
				$tmp_import = substr($resultado, $existen, $punto_y_coma - $existen + 1);
				//Si la cadena Import tiene dentro "http" entonces no seguimos
				if (!strpos(strtoupper($tmp_import), 'HTTP')){
					//Vamos a quitar las comillas simples y dobles:
					$buscar = array('(', ')', '\'', '"');
					$reemplazo = '';
					$ruta_limpia = str_replace ( $buscar , $reemplazo , $tmp_import);
					//Vamos a obtener el "dirname" del fichero que se ha cargado:
					$ruta_original = dirname($clave);
					$ruta_relativa = str_replace(_WS_DIR_, '', _WS_THEME_HTML_DIR_);
					$nueva_ruta = '("../../../' . $ruta_relativa . $ruta_original . '/' . $ruta_limpia . '")';
					//Vamos a quitar la sentencia de valor:
					$resultado = str_replace ( $tmp_import , $nueva_ruta , $resultado);
				}
			}
		}while( ($existen !== false)  );

		//Ahora cogemos los imports para llevárnoslos arriba
		do{
			//Primero es obtener la posición del primer import:
			$existen = strpos ( $resultado, '@import' );
			if ($existen !== false){
				//Tenemos un import, vamos a obtener el ; que haya al final:
				$punto_y_coma = strpos ( $resultado, ';', $existen );
				//Cortamos la cadena de texto:
				$tmp_import = substr($resultado, $existen, $punto_y_coma - $existen + 1);
				$imports .= $tmp_import;
				//Vamos a quitar la sentencia de valor:
				$resultado = str_replace ( $tmp_import , '' , $resultado);
			}
		}while($existen !== false);
		
		//Vamos a quitar los \n:
		$resultado = str_replace ( "\n" , '' , $resultado);
		
		if ($file = fopen($finalPath . $fileName, 'w')){
			fwrite($file, $imports . $resultado);
			fclose($file);
		}
	}
}
