<?php
/*
	Clase SuperSections para las secciones de la web
	@version 1.0
*/

class SuperSections{

	protected $lista_completa = array();
	protected $lista_privada = array();
	protected $lista_solo_publica = array();
	protected $lista_absoluta = array();
	//Métodos estáticos que vamos a utilizar para variables globales relacionadas con la sesión
	public static $section_list = NULL;
	public static $current_section = 'error';
	//Aquí definimos los parámetros de la sección actual:
	private static $params = NULL;
	public static $path = array();

	/*public function add($nombre, $completa = 0, $privada = 0, $solo_publica = 0, $absoluta = 0){
		$resultado = true;
		//Da igual que exista o no la opción, siempre se sobre escribirá
		$this->lista_completa[$nombre] = $completa;
		$this->lista_privada[$nombre] = $privada;
		$this->lista_solo_publica[$nombre] = $solo_publica;
		$this->lista_absoluta[$nombre] = $absoluta;
		return($resultado);
	}*/
	
	public function __call($funcion, $nombre){
		$retorno = false;
		//El nombre es un array, sólo necesitamos el primer elemento
		$nombre = $nombre[0];
		//la función necesita el valor 'lista_' delante
		$funcion = 'lista_' . $funcion;
		//Para poder acceder a sus propiedades necesito meterlo en un array PHP, es una forma de parsearla
		$array_lista = $this->$funcion;
		//Ahora trabajamos con el array obtenido y con el nombre para comprobarlo todo 
		if ( (!isset($array_lista[$nombre])) || (!isset($array_lista[$nombre])) ){
			//Si falta algún dato, hay que devolver un valor nulo
			$retorno = NULL;
		}else{
			$retorno = $array_lista[$nombre];
		}
		return($retorno);
	}
	
	public function dame_secciones_privadas(){
		//$secciones_privadas = array();
		$cadena = '';
		foreach($this->lista_privada as $clave => $valor){
			if($valor == 1){
				//$secciones_privadas[$clave] = $valor;
				$cadena .= 'Disallow: /' . $clave . '*\n';
				$cadena .= 'Disallow: /' . strtoupper($clave) . '*\n';
			}
		}
		return($cadena);
	}

	public static function getValueAndPage($string){
		$retorno = array($string, 0);
		//Hemos recibido una cadena de texto, vamos a extraer el valor y la página a la que pertenece:
		$pagina = static::preg_replace_callback_array(
			[
				'#(.+)\-p(\d+)#' => function (&$matches) {
					return($matches[2]);
				}
			],
			$string
		);
		if ($pagina == $string){
			$pagina = 0;
		}
		//Si pagina es un número, recomponemos:
		if (is_numeric($pagina)){
			//Ahora vamos a quitar "-p***" al valor:
			$retorno[0] = str_replace('-p' . $pagina, '', $string);
			$retorno[1] = $pagina;
		}
		return($retorno);		
	}
	
	public static function extactArrayFilter($list){
		$retorno = array();
		if (count($list) > 0){
			foreach($list as $key => $value){
				//Sólo cogemos el valor si tiene el texto "filtrar":
				if (strpos($value, 'filtrar') !== false) {
					$value = str_replace('filtrar_', '', $value);
					//convertimos el valor en un array:
					$value = explode('=', $value);
					if (count($value) > 1){
						//Lo que vamos a almacenar son arrays de valores:
						if (!isset($retorno[$value[0]])){
							$retorno[$value[0]] = array();
						}
						$retorno[$value[0]][] = $value[1];
					}
				}
			}
		}
		return($retorno);
	}
	
	public static function extractUrlPart($oldMatches){
		$resto = static::preg_replace_callback_array(
			[
				'#([^/]+)\/(.+)#' => function (&$matches) {
					static::$path[] = $matches[1];
					return($matches[2]);
				},
				'#([^/]+)#' => function (&$matches) {
					static::$path[] = $matches[1];
					return('');
				}
			],
			$oldMatches
		);
		//si hay resto, entonces lo extraemos:
		if ($resto != $oldMatches){
			static::extractUrlPart($resto);
		}
	}
	
	public static function getAttr($attr = '', $cur_section = ''){
		$retorno = NULL;
		//Si no nos indican la sección, cogemos la actual
		if ($cur_section == ''){
			$cur_section = static::$current_section;
		}
		//Si tenemos esa sección, devolvemos el atributo de la misma
		$section_list = static::$section_list;
		if (static::sectionExists($cur_section)){
			$retorno = isset($section_list[$cur_section][$attr]) ? $section_list[$cur_section][$attr] : NULL;
		}
		return($retorno);
	}

	public static function sectionExists($cur_section = ''){
		$retorno = false;
		if ($cur_section == ''){
			$cur_section = static::$current_section;
		}
		$section_list = static::$section_list;
		if (isset($section_list[$cur_section])){
			$retorno = true;
		}
		return($retorno);
	}
	
	//Esta función hace un include de un fichero de la sección
	public static function include_file($from_attr){
		$fichero = static::getAttr($from_attr);
		$file = Theme::include_file($fichero);
	}

	//Constructor y destructor
	function __construct() {
	}

	function __destruct() {

	}

	
	public static function preg_replace_callback_array (array $patterns_and_callbacks, $subject, $limit=-1, &$count=NULL) {
		$count = 0;
		foreach ($patterns_and_callbacks as $pattern => &$callback) {
			/*var_dump($pattern);
			var_dump($callback);
			var_dump($subject);*/
			$subject = preg_replace_callback($pattern, $callback, $subject, $limit, $partial_count);
			//var_dump($subject);

			$count += $partial_count;
		}
		return preg_last_error() == PREG_NO_ERROR ? $subject : NULL;
	}
	
	public static function getParam($paramName, $defaultValue = NULL){
		return( (isset(self::$params->$paramName)) ? self::$params->$paramName : $defaultValue );
	}
	
	public static function setParam($paramName, $value){
		$value = self::$params->$paramName = $value;
	}
	
	public static function checkParams(){
		self::$params = (self::$params == NULL) ? new BasicObject() : self::$params;
	}
	
}
