<?php
/*
*	Al incluir este fichero se inicializa todo el core de webStore
*	@version 1.0.0
*	@date 2018/28/06
*
*/

//Indicamos si hay que comprimir la webStore
define('_WS_COMPRESS_FULL',false);	//Esto luego hay que cambiarlo

//Rutas varias
define('_WS_DIR_', realpath(dirname(__FILE__)) . '/../');
define('_WS_DYNAMIC_DIR_', _WS_DIR_ . 'dynamic/');
define('_WS_THEMES_DIR_', _WS_DIR_ . 'themes/');
define('_WS_CORE_DIR_', _WS_DIR_ . 'core/');
define('_WS_LIB_DIR_', _WS_CORE_DIR_ . 'lib/');
define('_WS_REQUIRED_DIR_', _WS_CORE_DIR_ . 'required/');
define('_WS_CLASSES_DIR_', _WS_CORE_DIR_ . 'classes/');
define('_WS_CONTROLLERS_DIR_', _WS_CORE_DIR_ . 'controllers/');
define('_WS_OVERRIDE_DIR_', _WS_DIR_ . 'override/');
define('_WS_SINCRO_DIR_', _WS_DIR_ . 'sincronizacion/');

//Variables a utilizar:
//Tipos de medios
define('_WS_MEDIA_TYPE_CSS', 'css');
define('_WS_MEDIA_TYPE_JS', 'js');
//Posicion para los medios
define('_WS_MEDIA_POSITION_BOTTOM', 'bottom');
define('_WS_MEDIA_POSITION_TOP', 'top');

//Tipos de compresores js/css
define('_WS_JSHRINK_COMPRESSOR', 'jshrink');
define('_WS_JSQUEEZE_COMPRESSOR', 'jsqueeze');
define('_WS_MINIFY_COMPRESSOR', 'minify');
define('_WS_PHPWEE_COMPRESSOR', 'phpwee');

//Librería de evío de email:
define('_WS_EMAIL_LIB', 'PHPMailer');

//El resto de "defines" son los que nos pasa el usuario:
include(_WS_DIR_ . '/_defines.php');

set_error_handler(function ($severity, $message, $file, $line, $context){
		echo('<pre>');
		echo('	Error in file: ' . $file . '
		In line: ' . $line . '
		');
		print_r($message);
		echo('</pre>');
	}
);

try{
	//Por compatibilidad con webStore:
	//Para que todo webStore viejo cargue bien con los "include" que hace, vamos a definir un include_path
	set_include_path(get_include_path() . PATH_SEPARATOR . _WS_DIR_);
	
	//Importante que existan los directorios dinámicos:
	$dirList = array(
			_WS_DYNAMIC_DIR_ . 'classes', 
			_WS_DYNAMIC_DIR_ . 'controllers',
			_WS_DYNAMIC_DIR_ . 'file_index'
			);
	foreach($dirList as $clave => $dir){
		if (!file_exists($dir)){
			mkdir($dir);
		}
	}
	
	//Incluimos los ficheros necesarios para el funcionamiento de webStore
	include_once(_WS_REQUIRED_DIR_ . 'autoload.php');			//Auto carga de clases lo primero
	//Teniendo el autoload hecho, vamos a cargar la sesión, configuracion, etc.:
	//Vamos a arrancar el motor de bases de datos:
	BaseDatos::initDB();
	//Y creamos el diccionario
	BaseDatos::getDictionary();
	
	//Esta línea que viene ahora se debe de cargar de otra manera:
	//Cargamos la configuración local para esta instalación de webStore
	include_once(_WS_REQUIRED_DIR_ . 'local.php');
	//Cargamos la tienda ==> lo hacemos antes que la sesión porque la misma se configura desde la tienda
	Shop::load();
	//Iniciamos la sesión:
	session_start();
	Sesion::init();
	//Ahora ejecutamos otros procesos necesarios
	include_once(_WS_REQUIRED_DIR_ . 'view.php');				//capturamos y comprimimos la salida de pantalla
	include_once(_WS_REQUIRED_DIR_ . 'compatibility.php');		//Inicializamos la compatibilidad con el viejo webStore
	
	//Ya no hay login
	//Controlamos el usuario que esté logueado o haya datos de envío
	//include_once(_WS_DIR_ . 'comunes/login.php');	//=>Controlamos el login y el registro, por ahora aquí, después lo haremos bien con una clase

	//29/Enero/2019 ==> Antes aquí se recargaba la web. Ahora esto lo hacemos en el index, pues será quien, si es necesario recargar la web lo hará o, en caso contrario, mostrará el contenido, lo cual es más eficiente
	
	//Vamos a inicializar variables globales que necesitamos, en primer lugar vamos a cargar los ficheros de plantilla:
	Theme::loadFiles();
	

	
}catch (Exception $e){
	echo('<pre>');
	print_r($e);
	echo('</pre>');
}

Sesion::commit();