<?php
/*
*	Controlamos en qué sección de la web estamos
*	@version 1.0.0
*	@date 2018/03/07
*
*/
//Vamos a definir la ruta dónde deben estar las secciones del tema:
define('_WS_THEME_SECTION_DIR_', _WS_THEME_DIR_ . 'sections/');
$section_list = NULL;

//Pedro 17/Enero/2019 ==> Vamos a comprobar si hay que redirigir al https y al www:
//Vamos a componer la URL real de la tienda y vamos a comprobar si hay que hacer redirección o no:
$seccionActual = $_SERVER['REQUEST_URI'];
if ( ($seccionActual == '/') || ($seccionActual == '//') ){
	$seccionActual = '';
}
$rightUrl = Shop::$configuracion->url . $seccionActual;
$do_redirect = false;
//Si la web es segura y no hemos entrado así, hacemos redirección:
if ( (Shop::$configuracion->https_on) && ($_SERVER['HTTPS'] != 'on') ){
	//Configurado https y entrado por http
	$do_redirect = true;
}else if ( (!Shop::$configuracion->https_on) && ($_SERVER['HTTPS']=='on') ){
	//Configurado http y entrado por https
	$do_redirect = true;
}else if ( (strpos(Shop::$configuracion->url, 'www.') !== false) && (strpos($_SERVER['SERVER_NAME'], 'www.') === false) ){
	//Configurado www y entrado sin ellas
	$do_redirect = true;;
}else if ( (strpos(Shop::$configuracion->url, 'www.') === false) && (strpos($_SERVER['SERVER_NAME'], 'www.') !== false) ){
	//Configurado sin www y entrado con ellas
	$do_redirect = true;;
}

if ($do_redirect){
	header('Location:' . $rightUrl);
}

//Marca de tiempo del fichero de secciones:
$sections_time = 0;
$sections_conf = _WS_THEME_SECTION_DIR_ . 'sections.php';

if (file_exists($sections_conf)){
	//Vamso a limpiar la caché del fichero
	//clearstatcache (true, $sections_conf); //No vamos a limpiar la caché por ahora por velocidad
	$sections_time = filemtime($sections_conf);
}

//Si no tenemos tiempo de modificación no tiene sentido seguir:
if ($sections_time > 0){
	$section_list = new ConfigFile($sections_time, true, 'sections/');

	$realPath = $section_list->getRealNamePath();
	//Vamos a ver si existe el fichero:
	if (!file_exists($realPath)){
		//Por si no existiese la carpeta, vamos a crearla:
		if (!file_exists(_WS_DYNAMIC_DIR_ . 'sections/')){
			@mkdir(_WS_DYNAMIC_DIR_ . 'sections/');
		}
		//Lo primero es limpiar el directorio:
		FileSystem::cleanDirectory(_WS_DYNAMIC_DIR_ . 'sections/');
		//Ahora vamos a incluir el fichero de configuración:
		$section_list = new ConfigFile($sections_time, false, 'sections/');
		include($sections_conf);
		$section_list->save();
		
	}
	Sections::$section_list = $section_list->sections;
	//Procesamos el htaccess
	if (file_exists(_WS_THEME_SECTION_DIR_ . 'htaccess.php')){
		include(_WS_THEME_SECTION_DIR_ . 'htaccess.php');
	}
	//Vamos a comprobar que la sección esté bien:
	$privada = Sections::getAttr('privada');
	$current_section = Sections::$current_section;
	//Si la sección es privada y el usuario no ha hecho login, hay que obligarlo
	//if ($privada && ($datos_usuario->codigo == 0)){ //$datos_usuario es de globals y es antiguo
		if ($privada && (Usuario::logueado() !== NULL)){
		//Corregimos la sección
		$current_section = 'login_necesario';
	}
	//Si la sección es pública solamente y se ha hecho login, devolvemos al home
	$solo_publica = Sections::getAttr('solo_publica');
	//if ( $solo_publica && ($datos_usuario->codigo > 0) ){//$datos_usuario es de globals y es antiguo
		if ( $solo_publica && (Usuario::logueado() !== NULL) ){
		//Hay que cambiar la sección
		Sections::$current_section = 'home';
	}
	//Si todo va guay, vamos a ver si hay programación específica para esta sección
	//Lo primero es ver si tenemos una sección definida en el tema:
	if (file_exists(_WS_THEME_SECTION_DIR_ . Sections::$current_section . '.php')){
		include(_WS_THEME_SECTION_DIR_ . Sections::$current_section . '.php');
	}
	
	//Cuando tenga todas las secciones en el tema quitaremos esto que viene ahora:
	//Esto en el futuro se tiene que hacer de otra forma:
	if (file_exists("comunes/procesos_seccion/" . Sections::$current_section . '.php')){
		include("comunes/procesos_seccion/" . Sections::$current_section . '.php');
	}
	
	//Asignamos la sesión
	
	//Vamos ahora a cargar la hoja de estilos de la plantilla así como sus CSSs
	Theme::createMedia(Sections::getAttr('jsCabecera'), 'jsCabecera.js');
	Theme::createMedia(Sections::getAttr('jsPie'), 'jsPie.js');
	Theme::createMedia(Sections::getAttr('cssCabecera'), 'cssCabecera.css');
	Theme::createMedia(Sections::getAttr('cssPie'), 'cssPie.css');
}else{
	//Lanzamos la excepción de que no hay secciones configuradas
}

//Vamos a inicializar otras variables que son necesarias para la web, pero no para el core de webStore
define('_WS_THEME_HTML_WWW_DIR_', str_replace(_WS_DIR_, Shop::$configuracion->url, _WS_THEME_HTML_DIR_)); //==> La variable del tema es para PHP, para HTML necesitamos una variable que use el dominio y no la carpeta del alojamiento