<?php
// Obtenemos la ruta hacia el public html
//Inicializamos la configuración

$conexionBD = $GLOBALS["conexionBD"];

//cargar_configuracion();
//Inicializamos la tabla de lecturas
ArmiSync::comprobar_existe_tabla_lecturas();
//Creamos los directorios necesarios
//comprobar_existe_dir_sincro();
//Inicializamos una serie de variables que necesitamos
$fichas_procesadas = 0;
$total_fichas_procesadas = 0;
//$limite_fichas_procesadas = 1000;
$limite_fichas_procesadas = 20000;
$modo_debug = (isset($_GET["debug"])) ? $_GET["debug"] : FALSE;

//Esta función realiza la lectura de un fichero, teniendo en cuenta la línea por la que queremos que continue su lectura (0 es la primera línea)
function procesa_fichero($ruta_fichero_datos, $linea = 0, $borrar_ultima_lectura = false) {
    global $fichas_procesadas, $total_fichas_procesadas, $limite_fichas_procesadas, $conexionBD;
    $con = $conexionBD;
    $buffer = 700;
    $correcto = false;
    //Si tenemos que borrar la última lectura, lo hacemos
    if ($borrar_ultima_lectura) {
        $sentencia_sql = "DELETE FROM ultima_lectura WHERE 1";
        mysqli_query($con, $sentencia_sql);
    }
    //Primero abrimos el fichero para ver el tipo que es
    $fichero = fopen($ruta_fichero_datos, "r");
    //Necesitamos leer la primera línea para comprobar si el fichero cumple con las especificaciones
    if (!feof($fichero)) {
        $valor_linea = iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, 50));
        mostrarLog($valor_linea . '<br />');
        if (substr($valor_linea, 0, 7) == 'IMP-WEB') {
            //Inicializamos "correcto" para que no haya problemas
            $correcto = true;
            //Este fichero cumple con la especificación, vamos a leerlo
            $valor_linea = iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, 6)); //Quito los primeros cinco caracteres que son los que dicen la palabra "tabla"
            $nombre_tabla = iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, 40)); //Leo el resto de la línea que contiene la tabla en si
            //Una vez que sabemos el tipo de fichero, procedemos a su lectura y procesado
            $valor_linea = iconv("ISO-8859-1","UTF-8//IGNORE", fgets($fichero, 700));
            //En $valor_linea tengo las cabeceras, componemos una cadena con los campos a insertar o modificar
            $valor_linea = str_replace("\n", "", $valor_linea);
            $valor_linea = str_replace("\0", "", $valor_linea);
            $valor_linea = str_replace("\r", "", $valor_linea);
            $valor_linea = str_replace("\t", "", $valor_linea);
            $cabeceras = explode("|", $valor_linea);
            //Ahora vamos a generar una plantilla para esta tabla
            $plantilla_datos = genera_plantilla_datos($cabeceras, trim($nombre_tabla));
            //Y le aplico la plantilla a la cabecera para quitar aquellos datos que nos sobran
            $cabeceras = aplica_plantilla_datos($cabeceras, $plantilla_datos);
            $lista_campos = " (`" . trim(implode("`, `", $cabeceras)) . "`) ";
            //Ahora hay que colocarse en la línea indicada
            $i = 0;
            for ($i = 0; ($i < $linea) && (!feof($fichero)); $i++) {
                $valor_linea = iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, $buffer));
                $tam_linea = strlen($valor_linea) - 1;
                if ($valor_linea[$tam_linea] != "\n") {
                    while ((!feof($fichero)) && ($valor_linea[$tam_linea] != "\n")) {
                        $valor_linea .= iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, $buffer));
                    }
                }
                //mostrarLog("Linea $i de $linea<br />\n");
            }
            while ((!feof($fichero)) && ( ($fichas_procesadas + $total_fichas_procesadas) < $limite_fichas_procesadas)) {//Mientras no llegue al final del fichero hago todo lo siguiente, ni se hayan leído todas las filas
                //Cogemos la primera línea de datos que corresponde
                $valor_linea = iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, $buffer));
                $tam_linea = strlen($valor_linea) - 1;

                //mostrarLog("-------------------------------------------------------------<br />\n");
                //He leído sólo un bloque de bytes, si no he llegado al \n tengo que leer otro bloque
                if ($valor_linea[$tam_linea] != "\n") {
                    while ((!feof($fichero)) && ($valor_linea[$tam_linea] != "\n")) {
                        $valor_linea .= iconv("ISO-8859-1", "UTF-8//IGNORE", fgets($fichero, $buffer));
                        $tam_linea = strlen($valor_linea) - 1;
                        //mostrarLog ("-->" . $valor_linea[$tam_linea] . "<--<br/>\n");
                    }
                }
                //mostrarLog($valor_linea . "<br />\n");
                //mostrarLog("-------------------------------------------------------------<br />\n");
                if (strlen($valor_linea) > 1) {
					if (trim($nombre_tabla) == 'categorias-productos'){
						//Esta línea tiene este formato:
						//A|1|330337|50-29999,54-19999,17-09999,|
						//como siempre, pasamos a array, valor en posición 2 es el artículo, valor en posición 3 es la asociación
						$datos = explode("|", $valor_linea);
						$articulo = $datos[2];
						$categoriasProducto = $datos[3];
						//Lo primero es eliminar todas las tuplas de la tabla "categorias_producto" para ese producto
						$sentencia_sql = 'DELETE FROM `categorias-productos` WHERE articulo = ' . $articulo;
						mysqli_query($con, $sentencia_sql);
						//Ahora necesitamos formar las tupas de cateogrias
						$categoriaOrden = explode(",", $categoriasProducto);
						$sentenciaPartida = "";
						foreach($categoriaOrden as $claveCategoria => $valorCategoria){
							if (trim($valorCategoria) != ''){
								$parElementos = explode("-", $valorCategoria);
								$categoria = $parElementos[0];
								$orden = $parElementos[1];
								$sentenciaPartida .= ( ($sentenciaPartida != '') ? ',' : '' ) . '(' . $articulo . ',' . $categoria . ',' . $orden . ')';
							}
						}
						//Si tenemos valores en la sentencia partida vamos a montar una select en condiciones:
						if ($sentenciaPartida != ''){
							$sentencia_sql = 'INSERT INTO `categorias-productos`
												(articulo, categoria, orden)
												VALUES
												' . $sentenciaPartida;
							echo("La sentencia es: $sentencia_sql<br />\n");
							mysqli_query($con, $sentencia_sql);
						}
					}else{
						//Aquí sigue la exportación clásica
						$datos = explode("|", $valor_linea);
						//Según si es novedad, alta o borrado hacemos una cosa u otra
						$tipo_consulta = $datos[0];
						//El número de campos que forman la clave
						$tam_clave = $datos[1];
						//Extraigo el primer elemento que es el tipo de consulta
						$datos = array_slice($datos, 2, count($datos) - 1);
						//Por último le ejecuto la plantilla para quitar lo que no esté en la base de datos
						$datos = aplica_plantilla_datos($datos, $plantilla_datos);
						//mostrarLog("El tipo de consulta es: $tipo_consulta<br />\n");
						switch ($tipo_consulta) {
							case 'A':
								//Modificación o alta, intentamos hacer un update, si no funciona hacemos un insert
								$sentencia_where = entrelaza_campos($cabeceras, $datos, $tam_clave);
								$sentencia_where = str_replace(", ", " AND ", $sentencia_where);
								$sentencia_sql = "SELECT * FROM `" . trim($nombre_tabla) . "` WHERE (" . $sentencia_where . ")";
								//mostrarLog($sentencia_sql . '<br />');

								$resultado = mysqli_query($con, $sentencia_sql);
								/** =ASDASDASD  */
								echo("CASE A " . $sentencia_sql . "<br />\n");
								if ($resultado = mysqli_fetch_array($resultado)) {
									//Hay elementos, hay que hacer un update
									//La sencentia update es la más jodía porque hay que intercalar ambos arrays
									$total_elementos = count($datos);
									//mostrarLog("hay " . $total_elementos . " elementos");
									$lista_datos = entrelaza_campos($cabeceras, $datos, 0);
									$sentencia_sql = "UPDATE `" . trim($nombre_tabla) . "` SET " . trim($lista_datos) . " WHERE (" . $sentencia_where . ")";
									echo("MARCA3 " . $sentencia_sql . '<br />');
									if (!mysqli_query($con, $sentencia_sql)) {
										$correcto = false;
									}
									if ($correcto) {
										//mostrarLog("--CORRECTO--");
									} else {
										mostrarLog("--ERROR: " . mysqli_error($con) . "--<br />\n");
									}
									break;
								}
							//Como hemos hmostrarLog el update cortamos el swithh, si no se hubiese hmostrarLog pasaríamos al alta
							//mostrarLog('Pasa y cortamos <br />');						
							case 'N':
								//Es novedad, un alta directa
								$lista_datos = "( '" . trim(implode("', '", $datos)) . "')";
								//mostrarLog($lista_datos);
								$sentencia_sql = "INSERT INTO `" . trim($nombre_tabla) . "` " . trim($lista_campos) . ' VALUES ' . $lista_datos;
								$sentencia_sql = str_replace("\n", '', $sentencia_sql);
								//mostrarLog ($sentencia_sql . "<br />\n");
								if (!mysqli_query($con, $sentencia_sql)) {
									$correcto = false;
									mostrarLog("Error al hacer $sentencia_sql<br />\n");
									mostrarLog("--ERROR: " . mysqli_error($con) . "--<br />\n");
								}
								//Si estamos en la tabla de clientes, necesitamos el código del cliente insertado, para meterlo en un fichero
								//Con la de pedidos lo hacemos igual
								if ((strtoupper(trim($nombre_tabla)) == "CLIENTE") || (strtoupper(trim($nombre_tabla)) == "MC_PEDCLI") || (strtoupper(trim($nombre_tabla)) == "ML_PEDCLI")) {
									//Tenemos que obtener el código web y el de cliente
									$codigo_web = mysqli_insert_id($con);
									//mostrarLog("El indice es: $codigo_web ");
									if ($indice_codigo !== false) {
										//Se ha creado un cliente, hay que apuntar el ID y el código del mismo en un fichero
										$linea = "";
										if (strtoupper(trim($nombre_tabla)) == "CLIENTE") {
											//mostrarLog("Es un cliente ");
											$nombre_fichero_sincro = "WSCLI.PEN";
											$indice_codigo = array_search("codigo_sinlib", $cabeceras);
											$linea = $codigo_web . "|" . $datos[$indice_codigo] . "\n";
										} else if (strtoupper(trim($nombre_tabla)) == "MC_PEDCLI") {
											$nombre_fichero_sincro = "WSMCP.PEN";
											$indice_codigo = array_search("cod_sinlib", $cabeceras);
											$linea = $codigo_web . "|" . $datos[$indice_codigo] . "\n";
										} else if (strtoupper(trim($nombre_tabla)) == "ML_PEDCLI") {
											$nombre_fichero_sincro = "WSMLP.PEN";
											$indice_codigo_web = array_search("mc_pedcli", $cabeceras);
											$indice_codigo = array_search("mc_pedcli_sinlib", $cabeceras);
											$indice_subcodigo = array_search("codigo_sinlib", $cabeceras);
											$linea = $datos[$indice_codigo_web] . "|" . $codigo_web . "|" . $datos[$indice_codigo] . "|" . $datos[$indice_subcodigo] . "\n";
										}
										//mostrarLog("Linea: $linea <br />\n");
										if ($linea != "") {
											if ($fichero_datos = fopen(getRealPath() . "importacion/exportacion/$nombre_fichero_sincro", "a")) {
												fwrite($fichero_datos, $linea);
												fclose($fichero_datos);
												//Vamos a darle permisos 777 al fichero
												chmod(getRealPath() . "importacion/exportacion/$nombre_fichero_sincro", 0777);
											}
										}
									}
								}
								//TODO Aquí tenemos que añadir el control del fichero de pedidos y el de lineas de pedidos (MC_PEDCLI, ML_PEDCLI)
								break;
							case 'B':
								//Es un borrado
								//Es un borrado. Hay que tener en cuenta, que en los borrados se pasa SIEMPRE el código de SINLIB, así que es el que hay que utilizar
								mostrarLog("Es un borrado<br />\n");
								/* if (strtoupper(trim($nombre_tabla)) == "MC_PEDCLI"){
								  //Los pedidos de clientes NO se borran, se marcan como eliminados:
								  $indice_codigo_web = array_search("cod_sinlib", $cabeceras);
								  $sentencia_sql = "UPDATE mc_pedcli SET pedido_eliminado = 1
								  WHERE pedido_eliminado = 0 AND cod_sinlib = " . $datos[$indice_codigo_web];
								  mysqli_query($con, $sentencia_sql);
								  }else if (strtoupper(trim($nombre_tabla)) == "ML_PEDCLI"){
								  //Los pedidos de clientes NO se borran, se marcan como eliminados:
								  $indice_codigo_cabecera = array_search("mc_pedcli_sinlib", $cabeceras);
								  $indice_codigo_linea = array_search("codigo_sinlib", $cabeceras);
								  $sentencia_sql = "UPDATE ml_pedcli SET pedido_eliminado = 1
								  WHERE pedido_eliminado = 0 AND mc_pedcli_sinlib = " . $datos[$indice_codigo_cabecera] . " AND codigo_sinlib = " . $datos[$indice_codigo_linea];

								  mysqli_query($con, $sentencia_sql);
								  }else{
								 */
								$sentencia_where = entrelaza_campos($cabeceras, $datos, $tam_clave);
								$sentencia_where = str_replace(", ", " AND ", $sentencia_where);
								if ($con) {
									$sentencia_sql = "SELECT * FROM `" . trim($nombre_tabla) . "` WHERE (" . $sentencia_where . ")";
									$resultado = mysqli_query($con, $sentencia_sql);
									/** =ASDASDASD  */
									echo("CASEB" . $sentencia_sql . "<br />\n");
									//var_dump($resultado);
									if ($resultado = mysqli_fetch_array($resultado)) {
										$sentencia_sql = "DELETE FROM `" . trim($nombre_tabla) . "` WHERE (" . $sentencia_where . ")";
										mostrarLog($sentencia_sql . "<br />");
										if (!mysqli_query($con, $sentencia_sql)) {
											$correcto = false;
										}
									}
								}
								break;
						}
					}
                    //mostrarLog($sentencia_sql . "<br />\n");
                    //Controlamos si ha habido algún errory abrimos el fichero de error y lo añadimos
                    if (!$correcto) {
                        $nombre_archivo = extraer_fichero_de_senda($ruta_fichero_datos);
                        $fichero_error = fopen(getRealPath() . 'importacion/logs/' . $nombre_archivo . '.log', "a");
                        fwrite($fichero_error, 'Error a las ' . date('G:i d-F-Y', time()) . '--' . mysqli_error($con) . "\n	" . $sentencia_sql . "\n");
                        fclose($fichero_error);
                        $correcto = true;
                    }
                }
                $fichas_procesadas++;
            }
            //Si aún no hemos llegado al final del fichero, necesitamos guardar los datos de la lectura realizada, para continuar por ahí
            $borrar_fichero = false;
            if (!(feof($fichero))) {
                //Atención, nos hemos quedado a la mitad de la lectura del fichero
                //Borramos la tabla de ultimas lecturas e insertamos estos valores
                $sentencia_sql = "DELETE FROM ultima_lectura WHERE 1";
                mysqli_query($con, $sentencia_sql);
                $sentencia_sql = "INSERT INTO ultima_lectura (fichero, ultima_linea) VALUES ('$ruta_fichero_datos', '" . ($fichas_procesadas + $linea) . "')";
                echo $sentencia_sql;
                mysqli_query($con, $sentencia_sql);
            } else {
                $borrar_fichero = true;
            }
            fclose($fichero);
            $total_fichas_procesadas += $fichas_procesadas;
            //Movemos el fichero a la carpeta de copias siempre y cuando no hayamos llegado al límite de lectura
            if ($borrar_fichero) {
                $nombre_fichero_datos = extraer_fichero_de_senda($ruta_fichero_datos);
                mostrarLog($ruta_fichero_datos . getRealPath() . 'importacion/leidos/' . $nombre_fichero_datos . "<br />\n");
                if (copy($ruta_fichero_datos, getRealPath() . 'importacion/leidos/' . $nombre_fichero_datos)) {
                    unlink($ruta_fichero_datos);
                }
            }
        }
    }
    return($correcto);
}

//Recibimos la ruta completa de un fichero y devolvemos el nombre del fichero
function extraer_fichero_de_senda($ruta_completa_fichero) {
    $array_ruta = explode("/", $ruta_completa_fichero);
    return($array_ruta[count($array_ruta) - 1]);
}

//Esta función entrelaza==> cadena1[0]=cadena2[0], cadena1[1]=cadena2[1].....cadena1[n]=cadena2[n], hasta n=$limite
function entrelaza_campos($cadena1, $cadena2, $limite) {
    if ($limite == 0) {
        $limite = 1000000;
    }
    $lista_datos = '';
    $total_elementos1 = count($cadena1);
    $total_elementos2 = count($cadena2);
    for ($i = 0; ($i < $total_elementos1) && (i < $total_elementos2) && ($i < $limite); $i++) {
        $lista_datos .= " `" . trim($cadena1[$i]) . "` = '" . trim($cadena2[$i]) . "', ";
    }
    $lista_datos = substr($lista_datos, 0, strlen($lista_datos) - 2);
    return($lista_datos);
}

//funciones para comprobar el estado de las tablas
//----------------------------------------------------------------------------------------------------------------------------------------------------
//                                                        COMPROBAR CONFIGURACION TABLAS
//----------------------------------------------------------------------------------------------------------------------------------------------------
function comprobar_conf_tabla($nombre_tabla) {
    $correcto = true;
    $ruta_fichero = getRealPath() . 'importacion/diccionario/' . $nombre_tabla;
    if (!file_exists($ruta_fichero)) {
        //mostrarLog("El fichero NO existe<br />\n");
        //Si no existe el fichero de especificación de la tabla lo vamos a crear ahora mismo
        global $conexionBD;
        $con = $conexionBD;
        if ($con) {
            $sentencia_sql = "SHOW FIELDS FROM `$nombre_tabla`";
            //mostrarLog($sentencia_sql);
            $resultado = mysqli_query($con, $sentencia_sql);
            echo("Comprobar conf tabla" . $sentencia_sql . "<br />\n");
            //var_dump($resultado);
            if (!$resultado) {
                mostrarLog(mysqli_error($con));
            } else {
                //Creamos el fichero con la especificación de la tabla
                while ($datos = mysqli_fetch_array($resultado)) {
                    $cadena .= "$datos[0]|";
                }
                $cadena = rtrim($cadena, '|');
                //mostrarLog($cadena);
                $fich = fopen($ruta_fichero, 'wt');
                if ($fich != NULL) {
                    fwrite($fich, $cadena, strlen($cadena));
                    chmod($ruta_fichero, 0777);
                }
                fclose($fich);
            }
            //cerramos al coenxuón con la base de datos
            //No cerramos la conexión porque esto se usa siempre con otra consulta
            //mysqli_close($con);
        }
    } else {
        //mostrarLog("El fichero ya existe<br />\n");
    }
    //Limpiamos la cache de archivos
    clearstatcache();
    //unlink($ruta_fichero);
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                                                        GENERAMOS UNA PLANTILLA PARA COMPARAR DATOS
//----------------------------------------------------------------------------------------------------------------------------------------------------
function genera_plantilla_datos($lista_datos, $nombre_tabla) {
    comprobar_conf_tabla(trim($nombre_tabla));
    //Tenemos en cuenta si hay o no datos
    $ruta_fichero = getRealPath() . 'importacion/diccionario/' . $nombre_tabla;
    $fich = @fopen($ruta_fichero, 'r');
    if ($fich != NULL) {
        $cadena = iconv("ISO-8859-1","UTF-8//IGNORE", fgets($fich));
        //Ahora vamos a transformar lo leído en un array
        $plantilla = explode("|", $cadena);
        /* foreach($plantilla as $indice => $valor_dato){
          mostrarLog($indice . "<br />\n");
          } */
        foreach ($lista_datos as $indice => $valor_dato) {
            //mostrarLog (array_search(trim($valor_dato), $plantilla) . "<br />\n");
            //$encontrado = buscar_elemento_vector(trim($valor_dato), $plantilla);
            $encontrado = array_search(trim($valor_dato), $plantilla);
            //mostrarLog('indice = ' . $indice . "palabra $valor_dato y resultado = $encontrado<br />\n");
            if ($encontrado === FALSE) {
                //mostrarLog ("falso<br/>\n");
                $resultado[] = false;
            } else {
                $resultado[] = true;
                //mostrarLog ("verdadero<br/>\n");
            }
        }
        return($resultado);
    } else {
        mostrarLog("Error al intentar leer el diccionario de datos de la tabla $nombre_tabla<br />\n");
    }
    fclose($fich);
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                                           GENERAMOS UN ARRAY EN FUNCIÓN DEL QUE RECIBIMOS Y DE UNA PLANTILLA
//----------------------------------------------------------------------------------------------------------------------------------------------------
function aplica_plantilla_datos($lista_datos, $plantilla) {
    foreach ($lista_datos as $indice => $valor_dato) {
        if ($plantilla[$indice]) {
            $resultado[] = $lista_datos[$indice];
        }
    }
    return($resultado);
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                                           COMPROBAMOS QUE EXISTA LA TABLA DE PROCESAMIENTO DE FICHEROS Y SI NO EXISTE SE CREA
//----------------------------------------------------------------------------------------------------------------------------------------------------
function comprobar_existe_tabla_lecturas() {
    global $conexionBD;
    $con = $conexionBD;
    if ($con) {
        $result = mysqli_query($con, "show tables like 'ultima_lectura'");

        if (mysqli_fetch_row($result) == false) {
            $sql = "CREATE TABLE ultima_lectura ( fichero CHAR(150), ultima_linea INT )";
            mysqli_query($con, $sql);
        }
    }
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                          COMPROBAMOS QUE EXISTA EL DIRECTORIO DE FICHEROS DE SINCRONIZACIÓN Y SI NO EXISTE SE CREA
//----------------------------------------------------------------------------------------------------------------------------------------------------
function comprobar_existe_dir_sincro() {
    if (!(file_exists(getRealPath() . "importacion/exportacion"))) {
        //No existe el directorio, hay que crearlo
        mkdir(getRealPath() . "importacion/exportacion", 0777, true);
        chmod(getRealPath() . "importacion/exportacion", 0777);
    }
}

//----------------------------------------------------------------------------------------------------------------------------------------------------
//                  SINCRONIZAMOS LINEAS Y CABECERAS DE PEDIDOS CON EL RESTO DE DATOS WEB QUE NO RECIBIMOS DESDE SINLIB
//----------------------------------------------------------------------------------------------------------------------------------------------------
function sincroniza_cab_lineas_pedido() {
    //Cuando se inserte este update en la web, hay que actualizar antes todos los pedidos que tengan código sinlib como "eliminados" aunque no estén bien asociados.
    //También es recomendable eliminar la tabla de pedidos de la web si no los hay pendientes e insertarlos de nuevo desde SINLIB
    //UPDATE mc_pedcli SET pedido_eliminado = 1 WHERE cod_sinlib > 0
    //UPDATE ml_pedcli SET pedido_eliminado = 1 WHERE codigo_sinlib > 0
    $sentencia_sql = "UPDATE ml_pedcli lineas SET lineas.mc_pedcli = 
								(SELECT codigo FROM mc_pedcli cabecera
									 WHERE cabecera.cod_sinlib = lineas.mc_pedcli_sinlib AND cabecera.pedido_eliminado = 0)
								WHERE lineas.mc_pedcli = 0";
    echo $sentencia_sql;
    global $conexionBD;
    if ($conexionBD) {
        //mostrarLog($sentencia_sql . "<br />\n");
        mysqli_query($conexionBD, $sentencia_sql);
    }

    //Ahora tenemos que asignar a los pedidos, el código web de cliente en función del código de sinlib
    $sentencia_sql = "UPDATE mc_pedcli
							SET cliente = (SELECT codigo FROM cliente WHERE codigo_sinlib = mc_pedcli.cliente_sinlib)
							WHERE cliente = 0";
    if ($conexionBD) {
        //mostrarLog($sentencia_sql . "<br />\n");
        mysqli_query($conexionBD, $sentencia_sql);
    }
}

function mostrarLog($d) {
    // Mostramos la cadena de texto que recibimos
    if ($modo_debug) {
        echo $d;
    }
}

function checkFicheros() {
    $array_archivos = array_filter(glob(getRealPath() . "importacion/import/*.{ok,OK}", GLOB_BRACE), "filtroFicheros");
    if (!$modo_debug) {
        //ob_clean();
    }
    $continuar = false;
    if (count($array_archivos) > 0) {
        echo("Continua");
    } else {
        echo("OK");
    }
}

function filtroFicheros($var) {
    $visible = true;
    if (strpos($var, "DEPOSITOS") !== false) {
        $visible = false;
    }
    return($visible);
}

/**
  Nos deveulve la ruta hasta el public_html y hace un include path
 */
function getRealPath() {
    $ruta = getcwd();
    $tmp = explode("public_html", $ruta);
    $tmp2 = explode(PATH_SEPARATOR, $tmp[1]);
    $ruta = "";
    if ($tmp[1] != "") {
        for ($i = 0; $i < sizeof($tmp2); $i++) {
            $ruta .= '../';
        }
    } else {
        $ruta = './';
    }
    return $ruta;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
        <title>Inserción de elementos</title>
    </head>
    <body>
        <?php
        //Ejecutamos la lectura y procesado de los ficheros
        ArmiSync::procesa_ficheros();
        //Resincronizamos las líneas y las cabeceras de pedidos de clientes
        sincroniza_cab_lineas_pedido();
        //Una vez que se han procesado los ficheros, es posible que se hayan generado ficheros con las correspondencias de los códigos. Si es así, hay que cambiarles el nombre
        if (file_exists(getRealPath() . "importacion/exportacion/WSCLI.PEN")) {
            //Necesitamos el contador de clientes para cambiarle el nombre al fichero
            $contador = incrementa_contador_en_tabla("WSCLI");
            $nuevo_nombre = "WSCLI" . $contador . ".OK";
            rename(getRealPath() . "importacion/exportacion/WSCLI.PEN", getRealPath() . "importacion/exportacion/$nuevo_nombre");
            chmod(getRealPath() . "importacion/exportacion/$nuevo_nombre", 0777);
        }
        if (file_exists(getRealPath() . "importacion/exportacion/WSMCP.PEN")) {
            //Necesitamos el contador de clientes para cambiarle el nombre al fichero
            $contador = incrementa_contador_en_tabla("WSMCP");
            $nuevo_nombre = "WSMCP" . $contador . ".OK";
            rename(getRealPath() . "importacion/exportacion/WSMCP.PEN", getRealPath() . "importacion/exportacion/$nuevo_nombre");
            chmod(getRealPath() . "importacion/exportacion/$nuevo_nombre", 0777);
        }
        if (file_exists(getRealPath() . "importacion/exportacion/WSMLP.PEN")) {
            //Necesitamos el contador de clientes para cambiarle el nombre al fichero
            $contador = incrementa_contador_en_tabla("WSMLP");
            $nuevo_nombre = "WSMLP" . $contador . ".OK";
            rename(getRealPath() . "importacion/exportacion/WSMLP.PEN", getRealPath() . "importacion/exportacion/$nuevo_nombre");
            chmod(getRealPath() . "importacion/exportacion/$nuevo_nombre", 0777);
        }
        //Por el momento voy a probar si se puede obtener la esturctura de los ficheros
        //comprobar_conf_tabla('traducarti');
        checkFicheros();
        if (false) {
            cerrar_conexion_bd();
        }
        ?>
    </body>
</html>