<?php
	
	//---------------------------------------------------------------------------------------------------------
	// 23/Julio/2015
	// Versión 1.0 Recogemos los datos que utilizaremos en el orden y filtrado de las reservas
	//---------------------------------------------------------------------------------------------------------
	
	

	include('comunes/globals.php');
	
	//El funcionamiento es sencillo, miramos si alguna de las variables está activa en las cookies. En caso afirmativo las metemos en la sesión, limpiamos esas cookies
	//y recargamos la página
	
	//---------------------------------------------------------------------------------------------------------
	//Filtrados
	//---------------------------------------------------------------------------------------------------------
	$fecha_inicio_reservas = Sesion::getCookieValue('fecha_inicio');
	$fecha_fin_reservas = Sesion::getCookieValue('fecha_fin');
	$solo_libros_reservas = Sesion::getCookieValue('solo_libros');
	$solo_papeleria_reservas = Sesion::getCookieValue('solo_papeleria');
	
    $recargar_web = $recargar_web | false;
	//Si nos han pasado fecha de inicio la metemos en la sesión
	if ($fecha_inicio_reservas != NULL){
		Sesion::set('fecha_inicio_reservas', $fecha_inicio_reservas);
		borrarCookie('fecha_inicio');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}
	
	//Si nos han pasado fecha de fin, la metemos en la sesión
	if ($fecha_fin_reservas != NULL){
		Sesion::set('fecha_fin_reservas', $fecha_fin_reservas);
		borrarCookie('fecha_fin');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}

	//Si nos han pasado la opción de 'solo libros' la miramos en la sesión
	if ($solo_libros_reservas !== NULL){
		Sesion::set('solo_libros_reservas', $solo_libros_reservas);
		borrarCookie('solo_libros');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}

	//Si nos han pasado la opción de 'solo libros' la miramos en la sesión
	if ($solo_papeleria_reservas !== NULL){
		Sesion::set('solo_papeleria_reservas', $solo_papeleria_reservas);
		borrarCookie('solo_papeleria');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}

	//---------------------------------------------------------------------------------------------------------
	//Orden
	//---------------------------------------------------------------------------------------------------------
	$orden_reservas = Sesion::getCookieValue('orden');
	$tipo_orden_reservas = Sesion::getCookieValue('tipo_orden');


	//Controlamos si nos han pasado un orden
	if ($orden_reservas != NULL){
		Sesion::set('orden_reservas', $orden_reservas);
		borrarCookie('orden');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}
	//Hay que controlar el tipo de orden (ascendente o descendente)
	if ($tipo_orden_reservas != NULL){
		Sesion::set('tipo_orden_reservas', $tipo_orden_reservas);
		borrarCookie('tipo_orden');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}
	
	//---------------------------------------------------------------------------------------------------------
	//Limpiamos las cookies
	//---------------------------------------------------------------------------------------------------------
	$limpiar_filtrado = Sesion::getCookieValue('limpiar_filtrado');
	if ($limpiar_filtrado != NULL){
		Sesion::set('fecha_inicio_reservas', '');
		Sesion::set('fecha_fin_reservas', '');
		Sesion::set('solo_libros_reservas', '');
		Sesion::set('solo_papeleria_reservas', '');
		borrarCookie('limpiar_filtrado');
        Sesion::setReloadPage(Sesion::getReloadPage() | true)
	}
?>
