<?php
	//---------------------------------------------------------------------------------------------------------
	// 03/Noviembre/2014
	// Versión 1.0 Mostramos la información mínima de la cesta de la compra
	//---------------------------------------------------------------------------------------------------------
	// 03/marzo/2015
	// Versión 2.0 Hacemos que las líneas de la cesta sean personalizables
	//---------------------------------------------------------------------------------------------------------
	// 03/Junio/2015
	// Versión 2.1 Para evitar problemas con el orden en la cesta, vamos a ordenar los elementos, mostrando primero los que no tienen lote y el resto después
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function widget_cesta_compra(){
		include('comunes/globals.php');
		//Aquí definimos una serie de parámetros que necesitamos
		$funcion_por_defecto = 'cesta_completa';
		$parametros_por_defecto = array();
		$parametros_recibidos = func_get_args();
		if (count($parametros_recibidos) == 0){
			$parametros_recibidos[0] = $funcion_por_defecto;
		}else{
			if ( ($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL) ){
				$parametros_recibidos[0] = $funcion_por_defecto;
			}
		}
		$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
		$retorno = false;
		//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
		if (count($parametros_recibidos) > 0){
			//Recogemos el nombre de la función de entre el resto de parámetros
			$nombre_funcion = $parametros_recibidos[0];
			//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
			$parametros_recibidos = array_slice($parametros_recibidos, 1);
			//Si la función existe la ejecutamos
			if(function_exists($nombre_funcion)){
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
		return($retorno);
	}


	function contenedor_cantidad($articulo_tmp = NULL, $tener_en_cuenta_pasos_cesta = true, $lote = 0){
		include('comunes/globals.php');
		if (is_string($articulo_tmp)){
			//Cargamos el objeto artículo
			$articulo_tmp = new Articulo($articulo_tmp);
		}
		//Llegados a este punto vamos a comprobar si $articulo es un objeto de la clase articulo
		if (is_a($articulo_tmp, 'Articulo')){
			//Necesitamos la cantidad de este artículo en la cesta
			$array_articulos_cesta = Sesion::get('array_articulos_cesta');
			$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
			$array_lotes_cesta = Sesion::get('array_lotes_cesta');
			//$posicion = array_search($articulo_tmp->ean, $array_articulos_cesta);
			$posicion = busca_articulo_cesta($articulo_tmp->codigo, $lote);

			if ($posicion >= 0){
?>
<div class="<?=(__FUNCTION__);?>">
<?php
				//Tenemos que controlar si el artículo tiene unidades_caja > 1
				/*echo("<pre>");
				print_r($articulo_tmp);
				echo("</pre>");*/
				if($articulo_tmp->unidades_caja == 1){
?>
	<div class="cesta_menos">
<?php
					//Atención, no se muestra esto si estamos en paso cesta > 0
					if (! (($tener_en_cuenta_pasos_cesta == true) && ($paso_cesta > 1)) ){
?>
<a href="javascript:void(0);" onclick="addToCookieBasket('<?=$articulo_tmp->codigo;?>', -1, null, <?=$array_lotes_cesta[$posicion];?>);">-</a>
<?php
					}
?>
	</div>
	<div class="linea_cesta_cantidad"><?=$array_cantidades_cesta[$posicion];?></div>
	<div class="cesta_mas">
<?php
					//Atención, no se muestra esto si estamos en paso cesta > 0
					if (! (($tener_en_cuenta_pasos_cesta == true) && ($paso_cesta > 1)) ){
?>
<a href="javascript:void(0);" onclick="addToCookieBasket('<?=$articulo_tmp->codigo;?>', 1, null, <?=$array_lotes_cesta[$posicion];?>);">+</a>
<?php
					}
?>
	</div>
<?php
				}else{
					//hay que preparar una select para ver la cantidad que se puede añadir a la cesta
					$contador_cantidad = 0;
					$limite = 15 * $articulo_tmp->unidades_caja;
					$txt_readonly = (! (($tener_en_cuenta_pasos_cesta == true) && ($paso_cesta > 1)) ) ? '' : 'disabled';
?>
	<select name="mdo_cant_cesta" class="selector_cantidad_cesta" <?=$txt_readonly;?>>
<?php
					for ($i = 0; $contador_cantidad <= $limite; $i++){
						$cantidad_a_mostrar = $i * $articulo_tmp->unidades_caja;
						$cantidad_justificada = str_pad($cantidad_a_mostrar, strlen($limite), '0', STR_PAD_LEFT );
						$txt_seleccionado = ($cantidad_a_mostrar == $array_cantidades_cesta[$posicion])? 'selected' : '';
?>
		<option class="opciones_mod_cant_cesta" value="<?=$cantidad_a_mostrar;?>" <?=$txt_seleccionado;?> ><?=$cantidad_justificada;?></option>
<?php
						$contador_cantidad += $articulo_tmp->unidades_caja;
					}
?>
	</select>
<?php
	$nombre_script = 'script_' . incrementa_contador();
?>
<script id="<?=$nombre_script;?>">
document.addEventListener('WSLE', function(event) {
	;(function() {
		var elemento = getLastHtmlObject('<?=$nombre_script;?>');
		elemento.on('change', function(){
			//Vamos a coger el select
			var cantidad = $(this).val();
			absAddToCookieBasket('<?=$articulo_tmp->codigo;?>', cantidad, null, <?=$array_lotes_cesta[$posicion];?>);
		});
	})();
});
</script>
<?php
				}
?>
</div>
<?php
			}
		}
	}
	//06/Agosto/2018 ==> Vamos a reescribir este código para que no funcione así:
	/*function contenedor_borrar($articulo_tmp = NULL, $tener_en_cuenta_pasos_cesta = true, $lote = 0){
		include('comunes/globals.php');
		if (is_string($articulo_tmp)){
			//Cargamos el objeto artículo
			$articulo_tmp = new Articulo($articulo_tmp);
		}
		//Llegados a este punto vamos a comprobar si $articulo es un objeto de la clase articulo
		if (is_a($articulo_tmp, 'Articulo')){
			//Necesitamos la cantidad de este artículo en la cesta
			$array_articulos_cesta = Sesion::get('array_articulos_cesta');
			$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
			$array_lotes_cesta = Sesion::get('array_lotes_cesta');
			//$posicion = array_search($articulo_tmp->ean, $array_articulos_cesta);
			$posicion = busca_articulo_cesta($articulo_tmp->codigo, $lote);
			if ($posicion >= 0){
?>
<div class="<?=(__FUNCTION__);?>">
<?php
				//Atención, no se muestra esto si estamos en paso cesta > 0
				if (! (($tener_en_cuenta_pasos_cesta == true) && ($paso_cesta > 1)) ){
?>
	<div class="linea_cesta_borrar">
		<a href="javascript:void(0);" onclick="deleteBasketProduct('<?=$articulo_tmp->codigo;?>', <?=$array_lotes_cesta[$posicion];?>);"><?=traducir('Borrar');?></a>
	</div>
<?php
				}
?>
</div>
<?php
			}
		}
	}
*/
	function contenedor_borrar($linea){
		
		//Llegados a este punto vamos a comprobar si $articulo es un objeto de la clase articulo
		if (is_a($linea, 'LineaCesta')){
			$script_btn_comprar = '{' 
			. 'codigo_articulo:' . $linea->articulo . ','
			. 'accion:\'absoluto\','
			. 'cantidad:0,'
			. (($linea->codigo_oferta > 0) ? 'oferta:' . $linea->codigo_oferta . ',' : '')
			. (($linea->codigo_lote > 0) ? 'lote:' . $linea->codigo_lote . ',' : '')
			. (($linea->puntos_gastados > 0) ? 'puntos_gastados:' . $linea->puntos_gastados . ',' : '')
			.'}';
?>
<div class="<?=(__FUNCTION__);?>">
	<div class="linea_cesta_borrar">
		<a href="javascript:void(0);" onclick="addToBasket(<?=$script_btn_comprar;?>, false);"><?=traducir('Borrar');?></a>
	</div>
</div>
<?php
		}
	}


	function resumen_cesta(){
		include('comunes/globals.php');
		$importe_a_mostrar = $importe_cesta;
		if ($descuento_cesta > 0){
			$importe_a_mostrar = $importe_cesta_con_dto;
		}
?>
	<div class="<?=(__FUNCTION__);?>">
		<div class="totales_cesta" >
			<span class="cantidad_articulos_cesta"><strong><?=number_format($cantidad_cesta, 0, ',', '.')?></strong> <span><?=traducir('Productos')?></span></span>
			<span class="importe_total_con_dto_cesta"><strong><?=number_format($importe_a_mostrar, 2,',', '.')?></strong> <span class="moneda"><?=traducir('€')?></span></span>
		</div>
	</div>
<?php
		return(true);
	}

	function cesta_completa($html_cabecera = '', $separador = '', $fichero_lineas = 'linea_cesta', $widget_login = NULL, $widget_direcciones = NULL, $widget_datos_envio = NULL, $widget_totales_cesta = NULL){
		include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
<?php
	//Ojo, si el login es necesario desde el paso 1, entonces hay que tener en cuenta si el login es necesario
	if ( (Shop::$configuracion->cesta_login_inicio) && (Usuario::logueado() == NULL) ){
		//El login es necesario:
		if ( ($widget_login == NULL) || ! is_a($widget_login, 'Widget')){
						//Es necesario el login
?>
<p class="login_necesario"><?=traducir('Para poder finalizar el pedido es necesario que se identifique en nuestra página web');?></p>
<?php
            new Widget($_WH->GW('usuario'), '', true);
            //new Widget($_WH->GW("usuario", "btnRegistro"));
		}else{
			$widget_login->mostrar();
		}
	}else{
        new Widget($_WH->GW('cesta_compra', 'pasos_cesta'));
		//Si ya estamos en el paso 4, tenemos que ir teniendo en cuenta varias cosas:
		if ($paso_cesta == 4){
			//Vamos a comprobar si no se permiten pedidos sin login
			if  (!Shop::$configuracion->pedidos_sin_login){
				//Pedidos sin login no permitidos, controlamos que el usuario esté logueado
				if (Usuario::logueado() != NULL){
					//Hay que añadir el widget de direcciones
					if ($widget_direcciones == NULL){
						//Vamos a mostrar la dirección predeterminada
                        new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada'));
						//Añadimos el botón de modificar
?>
<a href="<?=Shop::$configuracion->url;?>mis_direcciones" title="<?=traducir('Modificar');?>"><?=traducir('Modificar');?></a>
<?php
					}else{
						if (is_a($widget_direcciones, 'Widget')){
							$widget_direcciones->mostrar();
						}
					}
				}else{
					if ( ($widget_login == NULL) || ! is_a($widget_login, 'Widget')){
						//Es necesario el login
?>
<p class="login_necesario"><?=traducir('Para poder finalizar el pedido es necesario que se identifique en nuestra página web');?></p>
<?php
                        new Widget($_WH->GW('usuario'), '', true);
                        //new Widget($_WH->GW("usuario", "btnRegistro"));
					}else{
						$widget_login->mostrar();
					}
				}
			}else{
				if (Usuario::logueado() == NULL){
					//Mostramos el widget de las direcciones, si no nos lo han pasado, entonces lo creamos a manubrio
					if (! is_a($widget_datos_envio, 'Widget')){
                        new Widget($_WH->GW('usuario', 'peticion_datos_sin_registro'));
					}else{
						$widget_datos_envio->mostrar();
					}
					//además, si nos han pasado un widget de login, lo mostramos
					if ( ($widget_login != NULL) && (is_a($widget_login, 'Widget'))){
						//Es necesario el login
						$widget_login->mostrar();
					}
				}else{
					//El usuario está logueado, vamos a mostrar las direcciones
					if ($widget_direcciones == NULL){
						//Vamos a mostrar la dirección predeterminada
                        new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada'));
						//Añadimos el botón de modificar
?>
<a href="<?=Shop::$configuracion->url;?>mis_direcciones" title="<?=traducir("Modificar");?>"><?=traducir('Modificar');?></a>
<?php
					}else{
						if (is_a($widget_direcciones, 'Widget')){
							$widget_direcciones->mostrar();
						}
					}
				}
			}
		}
		//Mostramos la info de los pasos cesta que hayamos andado
        new Widget($_WH->GW('cesta_compra', 'info_pasos_cesta'), $separador);
		//Si estamos en móvil, vamos a mostrar un texto para que se vea el 'Detalle del pedido'
		if (WEB_MOVIL == 1){
?>
		<p class="detalle_del_pedido"><?=traducir('Detalle del pedido');?></p>
<?php
		}
		//Creamos un widget cesta para mostrarlo
        new Widget($_WH->GW('cesta_compra', 'detalle_cesta'), $html_cabecera, $fichero_lineas);
		//Totales de la cesta:
		if (is_a($widget_totales_cesta, 'Widget')){
			$widget_totales_cesta->mostrar();
		}
		//Pie de la cesta
        new Widget($_WH->GW('cesta_compra', 'pie_cesta'));
	}
?>
</div>
<?php
		return(true);
	}



    function cesta_desplegable($html_cabecera, $fichero_lineas, $widget_totales_cesta = NULL){
		include('comunes/globals.php');
		//Si no nos han pasado widget de totales, lo creamos:
		if ($widget_totales_cesta == NULL){
            $widget_totales_cesta = new Widget($_WH->GW('cesta_compra', 'totales_cesta', 'php', false));
		}
?>
	<div class="<?=(__FUNCTION__);?>">
<?php
	//Resumen cesta será el lanzador
    $widget_resumen_cesta = new Widget($_WH->GW('cesta_compra', 'resumen_cesta', 'php', false));
	//Si hay que iniciar sesión y no está iniciada, entonces no mostramos el desplegable
	if ( (Shop::$configuracion->cesta_login_inicio) && (Usuario::logueado() == NULL) ){
		$widget_resumen_cesta->mostrar();
	}else{
		//Widget cesta será el lanzado
        $widget_cesta = new Widget($_WH->GW('cesta_compra', 'detalle_cesta', 'dropDown', false), $html_cabecera, $fichero_lineas, $widget_totales_cesta);
		//Creo un widget lanzador para lanzar, desde el lanzador declarado antes el objeto lanzado
        $lanzador_widget_cesta = new Widget(LW_params(), $widget_cesta, $widget_resumen_cesta, 'div', 'onmouseenter');
		//Ahora muestro el botón de comprar
?>
		<a href="<?=Shop::$configuracion->url;?>cesta" class="btn_comprar"><?=traducir('Comprar');?></a>
<?php
	}
?>
	</div>
<?php
		return(true);
	}


	function detalle_cesta($html_cabecera = '', $fichero_lineas = 'linea_cesta', $widget_totales_cesta = NULL){
		include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
<?php
			if (! ($paso_cesta > 1) ){
?>
	<div class="cesta_vaciar">
		<a href="javascript:void(0);"><?=traducir('Vaciar');?></a>
<?php
	$nombre_script = 'script_' . incrementa_contador();
?>
<script id="<?=$nombre_script;?>">
document.addEventListener('WSLE', function(event) {
	;(function() {
		var elemento = getLastHtmlObject('<?=$nombre_script;?>');
		elemento.on("click", function(){
			var cadena_consulta = "<?=html_entity_decode(traducir("¿Desea vaciar la cesta por completo?\\nEsta operación no tiene marcha atrás."));?>";
			if (confirm(cadena_consulta)){
				vaciarCesta();
			}
		});
	})();
});
</script>
	</div>
<?php
			}
?>
    <div class="cesta_restaurar"><p><?=traducir("Acaba de eliminar");?> <span class="nombre_producto"></span> <a href="javascript:void(0);" class="restaurar_producto"><?=traducir("Restaurar");?></a></p></div>
<?php
		//Lo primero es crear una cabecera
?>
	<div class="cabecera_cesta">
<?php
		echo($html_cabecera);
		//Ahora añadimos manualmente la cantidad
?>
	</div>
<?php
		//Para saber el tipo de líneas a utilizar, vamos a crear una capa donde aglutinar a las líneas de la cesta
?>
	<div class="lineas_cesta_<?=$fichero_lineas;?>">
<?php
		//Ahora toca mostrar las líneas
		$array_articulos_cesta = Sesion::get('array_articulos_cesta');
		$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
		$array_lotes_cesta = Sesion::get('array_lotes_cesta');
		
		if (is_array($array_lotes_cesta)){
			//Vamos a obtener primero los elementos sin lote
			foreach (array_filter($array_lotes_cesta, 'cesta_sin_lotes') as $clave => $valor){
				$articulo_tmp = new Articulo($array_articulos_cesta[$clave], NULL, $array_cantidades_cesta[$clave], $array_lotes_cesta[$clave]);
				if ($articulo_tmp->codigo > 0){
					//Ejecutamos la función que nos muestra la cantidad
					genera_linea_cesta($articulo_tmp, $fichero_lineas, $valor);
				}
				unset($articulo_tmp);
			}
		
			//Ahora toca sacar sólo los lotes respetando el oden de entrada
			$ultimo_lote = 0;
			foreach (array_filter($array_lotes_cesta, 'cesta_con_lotes') as $clave => $valor){
				$articulo_tmp = new Articulo($array_articulos_cesta[$clave], NULL, $array_cantidades_cesta[$clave], $array_lotes_cesta[$clave]);
				if ($articulo_tmp->codigo > 0){
					//antes de mostrar el artículo, vamos a mostrar una línea indicando que es otro lote
					if ($ultimo_lote != $valor){
						$ultimo_lote = $valor;
						if ($valor != 0){
							genera_cab_lote_cesta($valor);
						}
					}
					//Ejecutamos la función que nos muestra la cantidad
					genera_linea_cesta($articulo_tmp, $fichero_lineas, $valor);
				}
				unset($articulo_tmp);
			}
		}

?>
	</div>
<?php
		//Ahora viene el pie
		$tipo_envio = Sesion::get('tipo_envio');
		$cod_cliente = 0;
		if (Usuario::logueado() != NULL){
			$cod_cliente = $datos_usuario->codigo;
		}
		$g_envio = dame_gastos_x_cliente_pedido($cod_cliente, 0, $tipo_envio, $cantidad_cesta);
		if (is_a($widget_totales_cesta, 'Widget')){
			$widget_totales_cesta->mostrar();
		}
?>
</div>
<?php

		return(true);
	}

	function pasos_cesta(){
		include('comunes/globals.php');
		$tipo_envio = Sesion::get('tipo_envio');
		$forma_pago = Sesion::get('forma_pago');
		$cod_descuento = Sesion::get('cod_descuento');
		//Vamos a ver si es una cesta sin pago, segúnel tipo de envío
		$tipo_envio_sin_pago = false;
		$contra_reembolso = false;
		if ($tipo_envio > 0){
			$sentencia_sql = 'SELECT reembolso, sin_pago FROM tipo_envio_cli WHERE codigo = '.$tipo_envio;
			if ($conexionBD) {
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					if ($fila = mysqli_fetch_array($resultado)){
						if ($fila['sin_pago'] == 1){
							$tipo_envio_sin_pago = true;
						}
						if ($fila['reembolso'] == 1){
							$contra_reembolso = true;
						}
					}
				}
			}	
		}
		//Vamos a coger una variable temporal con el código del cliente
		$cod_cliente = 0;
		if (Usuario::logueado() != NULL){
			$cod_cliente = $datos_usuario->codigo;
		}
?>
<div class="<?=(__FUNCTION__);?>">
	<div class="cab_pasos_cesta" >
		<a class="<?=($paso_cesta == 1)?"actual":"hecho";?>" href="<?=Shop::$configuracion->url;?>datos_compra" title="<?=traducir("Datos de la compra");?>">
			<span></span><span class="txt_paso_cesta"><?=traducir('Datos de la compra');?></span>
		</a>
		<a class="<?=($paso_cesta == 2)?'actual':(($paso_cesta < 2)?'pendiente':'hecho');?>" href="<?=Shop::$configuracion->url;?>tipo_envio" title="<?=traducir('Tipo de envío');?>">
			<span></span><span class="txt_paso_cesta"><?=traducir('Tipo de envío');?></span>
		</a>
		<a class="<?=($paso_cesta == 3)?"actual":(($paso_cesta < 3)?'pendiente':'hecho');?>" href="<?=($tipo_envio > 0)? Shop::$configuracion->url . 'forma_pago' : 'javascript:void(0);';?>" title="<?=traducir("Forma de pago");?>">
			<span></span><span class="txt_paso_cesta"><?=traducir('Forma de pago');?></span>
		</a>
		<a class="<?=($paso_cesta == 4)?"actual":(($paso_cesta < 4)?'pendiente':'hecho');?>" href="<?=( ($tipo_envio_sin_pago || $contra_reembolso ) || ($forma_pago > 0) )? Shop::$configuracion->url . "resumen_compra" : "javascript:void(0);";?>" title="<?=traducir("Finalizar pedido");?>">
			<span></span><span class="txt_paso_cesta"><?=traducir('Finalizar pedido');?></span>
		</a>
	</div>
<?php
		if ($paso_cesta == 1){
			//DATOS DE LA COMPRA
?>
	<div class="contenido_paso_cesta">
		<form class="form_cod_descuento" action="<?=Shop::$configuracion->url;?>cesta" method="post">
			<fieldset>
<?php
			if ($cod_descuento == NULL){
				//vamos a comprobar si hay mensajes 
				 /*$mensaje_error_cod_dto = $listaSysMsg->findElement(array('origen' => '/^codigo_descuento$/'));
				 if ($mensaje_error_cod_dto != NULL){
?>
					<p class="error_cod_dto"><?=$mensaje_error_cod_dto[0]->getCuerpo();?></p>
<?php
				 }*/
				 $placeholder = false;
				 if (WEB_MOVIL){
					$placeholder = true;
				 }
				 if (!$placeholder){
?>
				<label><?=traducir('Si dispone de un código de descuento, introdúzcalo aquí');?></label>
<?php
				 }
?>
				<input name="cod_descuento" value="" <?=($placeholder) ? 'placeholder="' . traducir('Código de descuento') . '"' : "";?>/>
				<a href="javascript:void(0);" title="<?=traducir('Utilizar código de descuento');?>" onclick="$('form.form_cod_descuento').submit();"><?=traducir('Utilizar código de descuento');?></a>
<?php
			}
?>
			</fieldset>
		</form>
	</div>
<?php
		}else if ($paso_cesta == 2){
			//TIPO DE ENVÍO
?>
	<div class="contenido_paso_cesta">
		<form class="form_tipo_envio" action="<?=Shop::$configuracion->url;?>forma_pago" method="post">
			<fieldset>
				<label><?=traducir("Seleccione un tipo de envío");?></label>
				<select name="tipo_envio" class="selector_envio">
					<option value="0" <?=($tipo_envio == 0)? 'selected="selected"':"";?>><?=traducir("Haga click aquí");?></option>
<?php
						$sentencia_sql = "SELECT codigo, nombre FROM tipo_envio_cli WHERE 1";
						//echo("$sentencia_sql<br />\n");
						if ( $resultado = mysqli_query($conexionBD, $sentencia_sql) ){
							while ($fila = mysqli_fetch_array($resultado)){
?>
					<option value="<?=$fila['codigo'];?>" <?=($tipo_envio == $fila['codigo'])? 'selected="selected"':"";?>><?=traducir($fila['nombre']);?> (<?=number_format(dame_gastos_x_cliente_pedido($cod_cliente, 0, $fila['codigo'], $cantidad_cesta), 2);?>&euro;)</option>
<?php
							}
						}
?>
				</select>
			</fieldset>
		</form>
	</div>
<?php
		}else if ($paso_cesta == 3){
			//FORMA DE PAGO
?>
	<div class="contenido_paso_cesta">
		<form class="form_forma_pago" action="<?=Shop::$configuracion->url;?>resumen_compra" method="post">
			<fieldset>
				<label><?=traducir('Seleccione una forma de pago');?></label>
				<select name="forma_pago" class="selector_forma_pago">
					<option value="0" <?=($forma_pago == 0)? 'selected="selected"':"";?>><?=traducir('Haga click aquí');?></option>
<?php
						$sentencia_sql = 'SELECT codigo, nombre FROM formas_de_pago WHERE 1';
						//echo("$sentencia_sql<br />\n");
						if ( $resultado = mysqli_query($conexionBD, $sentencia_sql) ){
							while ($fila = mysqli_fetch_array($resultado)){
?>
					<option value="<?=$fila['codigo'];?>' <?=($forma_pago == $fila['codigo'])? 'selected="selected"':"";?>><?=traducir($fila['nombre']);?></option>
<?php
							}
						}
?>
				</select>
			</fieldset>
		</form>
	</div>
<?php
		}else if ($paso_cesta == 4){
			$modificar_datos_envio = dame_valor_variable_global('modificar_datos_envio', '');
			//RESUMEN DE LA COMPRA
			//no mostramos el formulario del paso de la cesta si el usuario no está logueado o si no tenemos dirección de envío sin registro
			if ( ( (Usuario::logueado() != NULL) || ($datos_usuario_sin_registro != NULL) ) && (strtoupper($modificar_datos_envio) != 'MODIFICAR') ){
?>
	<div class="contenido_paso_cesta">
		<form class="form_observaciones" action="<?=Shop::$configuracion->url;?>cesta" method="post">
			<fieldset>
				<label><?=traducir('Si desea dejar un texto para nosotros o el transportista inclúyalo aquí');?></label>
				<textarea name="observaciones"  placeholder="<?=traducir('Introducir observaciones al pedido');?>"></textarea>
			</fieldset>
		</form>
	</div>
<?php
			}
		}
?>
</div>
<?php
		return(true);
	}

	function info_pasos_cesta($separador = ""){
		include("comunes/globals.php");
		//Según los pasos de la cesta, vamos a ir mostrando la info de lo que hay seleccionado
?>
<div class="<?=(__FUNCTION__);?>">
<?php
		$cod_descuento = Sesion::get('cod_descuento');
		$tipo_envio = Sesion::get('tipo_envio');
		$forma_pago = Sesion::get('forma_pago');

		//Empezamos por los códigos de descuento
		if ($cod_descuento != NULL){
			if ($cod_descuento != ''){
?>
<span class="info_descuento">
	<span class="info_cod_descuento">
		<span class="frase_cod_dto"><?=traducir('Código de descuento:');?> </span><strong><?=$cod_descuento;?></strong>
		<form action="<?=Shop::$configuracion->url;?>cesta" method="post"> <input type="hidden" name="descartar_cod_descuento" value="1" />
			<input type="submit" value="Descartar" />
		</form>
		<p class="porcentaje_de_descuento"><?=traducir('Descuento:');?> <strong><?=$descuento_cesta;?>%</strong></p>
	</span>
</span>
<?php
			}
		}

		//Comprobamos el tipo de envío
		if ($tipo_envio > 0){
			if ($cod_descuento != NULL){
				if ($cod_descuento != ''){
					echo($separador);
				}
			}
			$nombre_tipo_envio = nombre_tipo_envio($tipo_envio);
			$descripcion_tipo_envio = descripcion_tipo_envio($tipo_envio);
?>
<span class="info_tipo_envio"><span class="<?=$nombre_tipo_envio;?>"></span><span class="frase_tipo_envio"><?=traducir("Tipo de envío:");?> </span><strong><?=$nombre_tipo_envio;?></strong><em><?=$descripcion_tipo_envio;?></em></span>
<?php
		}
		
		//Ahora comprobamos la forma de pago
		if ($forma_pago > 0){
			if ($cod_descuento != NULL){
				if ($cod_descuento != ''){
					echo($separador);
				}
			}
			$nombre_forma_pago = nombre_forma_pago($forma_pago);
			$descripcion_forma_pago = descripcion_forma_pago($forma_pago);
?>
<span class="info_forma_pago"><span class="<?=$nombre_forma_pago;?>"></span><span class="frase_forma_pago"><?=traducir('Forma de pago:');?> </span><strong><?=$nombre_forma_pago;?></strong><em><?=$descripcion_forma_pago;?></em></span>
<?php
		}
?>
</div>
<?php
	}

	function pie_cesta(){
		include('comunes/globals.php');
		$tipo_envio = Sesion::get('tipo_envio');
		$forma_pago = Sesion::get('forma_pago');
		$reembolso = $sin_pago = $pasarela = $tipo_pasarela = 0;
		$contenido_form_pasarela = '';
?>
<div class="<?=(__FUNCTION__);?>">
	<div class="pie_cesta" >
		<a href="<?=getBackUrl();?>" class="volver_cesta"><?=traducir("Volver");?></a>
<?php
		$texto_continuar = traducir('Continuar');
		$enlace_continuar = '';
		$script_finalizar = '';
		//Según el paso de la cesta, mostramos una cosa u otra
		
		//En el paso 0 y 1 se muestra siempre el botón de continuar
		if ( $paso_cesta <= 1){
			$enlace_continuar = Shop::$configuracion->url . 'tipo_envio';
		}else if ( ($paso_cesta == 2) && ($tipo_envio > 0) ){
			//Cuando es 2 (tipo de envío) y el tipo de envío es mayor que 0	
			$enlace_continuar = Shop::$configuracion->url . 'forma_pago';
		}else if ( ($paso_cesta == 3) && ($forma_pago > 0) ){
			//Cuando es 3 (forma_pago) y tenemos seleccionada una forma de pago
			$enlace_continuar = Shop::$configuracion->url . 'resumen_compra';
		}else if ($paso_cesta == 4){
			$pasarela = 0;
			$tipo_pasarela = 0;
			$nombre_pasarela = '';
			//Necesitamos datos del tipo de envío y según éste cogemos datos de la forma de pago
			$sentencia_sql = 'SELECT reembolso, sin_pago FROM tipo_envio_cli WHERE codigo = '.$tipo_envio;
			if ($conexionBD) {
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					if ($fila = mysqli_fetch_array($resultado)){
						$reembolso = $fila['reembolso'];
						$sin_pago = $fila['sin_pago'];
					}
				}
			}
			//Si no hay reembolso o es un envío con pago miramos si tiene pasarela
			if ( ($reembolso == 0) && ($sin_pago == 0) ){
				$sentencia_sql = 'SELECT nombre, pasarela, tipo_pasarela FROM formas_de_pago WHERE codigo = '.$forma_pago;
				if ($conexionBD) {
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
						if ($fila = mysqli_fetch_array($resultado)){
							$pasarela = $fila['pasarela'];
							$tipo_pasarela = $fila['tipo_pasarela'];
							$nombre_pasarela = $fila['nombre'];
						}
					}
				}
			}
			//ATENCIÓN. Si la web admite pedidos sin login, tenemos que tener en cuenta si nos han pasado un usuario sin registro
			$listo_para_finalizar = true;
			if (Shop::$configuracion->pedidos_sin_login){
				$listo_para_finalizar = false;
				//Empezamos comprobando si hemos recibido los datos del formulario
				$accion = dame_valor_variable_global('accion', '');
				$modificar_datos_envio = dame_valor_variable_global('modificar_datos_envio', '');
				if ($accion == 'datos_usuario'){
					//Ahora asignamos los datos que necesitamos:
					$texto_continuar = 'Continuar';
					$enlace_continuar = 'javascript:void(0);';
				}else if ( ($datos_usuario_sin_registro != NULL) && (strtoupper($modificar_datos_envio) != 'MODIFICAR') ){
					//Tenemos ya los datos de un usuario,Los botones de finalizar tienen que ser los normales
					$listo_para_finalizar = true;
				}else{
					//Si el usuario ha hecho login, hacemos una cosa
					if (Usuario::logueado() != NULL){
						$listo_para_finalizar = true;
					}else{
						//No tenemos nada aún, estamos a la espera de que el usuario rellene sus datos
						$texto_continuar = 'Continuar';
						//el script tiene que enviar el formulario de datos de usuario
						$nombre_funcion = 'enviar_datos_cliente' . incrementa_contador();
?>
<script>
function <?=$nombre_funcion;?>(){
	$("form.registro_simple").submit();
}
</script>
<?php
						$script_finalizar = ' onclick="' . $nombre_funcion . '();" ';
						$enlace_continuar = 'javascript:void(0);';
					}
				}
			}else if (Usuario::logueado() == NULL){
				$listo_para_finalizar = false;
			}
			//Todo esto se hace sólo cuando se está listo para finalizar la compra
			if ($listo_para_finalizar){
				//Aquí hay que generar todo lo referente a la pasarela de pago
				if ( ($reembolso) || ($sin_pago) || (!$pasarela) ){
					//Todo OK, se puede hacer el pedido
					$enlace_continuar = 'javascript:void(0);';
					$texto_continuar = traducir('Finalizar compra');
					$script_finalizar = ' onclick="modificar_obs_pedido(' . $cod_pedido . ');" ';
					//Vamos a crear el script para modificar las observaciones del pedido
?>
<script type="text/javascript">
	function modificar_obs_pedido(pedido){
		//Cogemos las observaciones:
		var observaciones = $(".form_observaciones textarea[name='observaciones']").val();
		var parametros = "pedido=" + pedido + "&observaciones=" + observaciones + "&hash=<?=genera_cod_seguridad();?>";
		var url = "<?=Shop::$configuracion->url;?>comunes/consultas/pedidos_guardar_observaciones.php";
		realizar_solicitud(url, parametros, function(respuesta){
			window.location = "<?=Shop::$configuracion->url;?>finalizar_compra/" + pedido;
		});
	}
</script>
<?php
				}else{
					//En la mayoría de los casos, este pedido se paga por pasarela, vamos a cargarla
					//Hacemos el include del formulario de la pasarela
					$ruta_fichero = Theme::findFile($nombre_pasarela . ".php");
					if ($ruta_fichero != NULL){
						include($ruta_fichero);
						//Insertamos aquí un script que va a utilizar el formulario anterior para enviarlo cuando se guarden las observaciones
?>
<script type="text/javascript">
document.addEventListener('WSLE', function(event) {
	var scripts = document.getElementsByTagName( 'script' );
	var thisScriptTag_pass = scripts[ scripts.length - 1 ];
	var formObjetive = $(thisScriptTag_pass).prev();
});
	function modificar_obs_pedido_<?=$nombre_pasarela;?>(pedido){
		//Cogemos las observaciones:
		var observaciones = $(".form_observaciones textarea[name='observaciones']").val();
		var parametros = "pedido=" + pedido + "&observaciones=" + observaciones + "&hash=<?=genera_cod_seguridad();?>";
		var url = "<?=Shop::$configuracion->url;?>comunes/consultas/pedidos_guardar_observaciones.php";
		realizar_solicitud(url, parametros, function(respuesta){
			formObjetive.submit();
		});
	}
</script>
<?php
						$script_finalizar = ' onclick="modificar_obs_pedido_' . $nombre_pasarela . '(' . $cod_pedido . ');" ';
	
						$enlace_continuar = "javascript:void(0);";
						$texto_continuar = traducir("Finalizar compra");
					}else{
						echo(traducir("Ha ocurrido un error al intentar cargar la pasarela de pago"));
					}
					$contenido_form_pasarela = ""; //En esta variable vamos a meter el formulario de la pasarela
				}
			//Esto se ha gestionado de otra manera, así que por ahora no tiene sentido
			//Aquí hay varias posibilidades:
			//Que el login sea necesario y hayamos iniciado sesión
			/*if ( (Shop::$configuracion->pedidos_sin_login == 0) && (Usuario::logueado() != NULL) ){
				//$enlace_continuar = Shop::$configuracion->url . "resumen_compra";
				//$texto_continuar = traducir("Comprar");
			}else{
				//Si no se permiten pedidos sin login:
				if (Shop::$configuracion->pedidos_sin_login == 0){
					$enlace_continuar = "";
					$texto_continuar = "";
				}
			}*/
			}
		}
		
		//Si tenemos enlace para continuar, entonces lo mostramos
		if ($enlace_continuar != ""){
//			if ($pasarela == 0){
?>
		<a href="<?=$enlace_continuar;?>" class="continuar_cesta" <?=$script_finalizar;?>><?=$texto_continuar;?></a>
<?php
/*			}else{
				//Hay que utilizar el fomulario de la pasarela
				echo($contenido_form_pasarela);
			}
*/
		}
?>
	</div>
</div>
<?php
		return(true);
	}


	//------------------------------------------------------------------------------------------------------------------------------
	//Funciones que necesita la cesta
	//------------------------------------------------------------------------------------------------------------------------------
	function genera_linea_cesta($articulo_tmp = NULL, $fichero = "linea_cesta", $lote = 0, $tipoCapaContenedora = 'div'){
		include("comunes/globals.php");
		//Aquí se carga la línea de la cesta
        $ruta_fichero = Theme::findFile( $fichero . ".php");
		if ($ruta_fichero != NULL){
			//Si el artículo es correcto vamos a ello
			if (is_string($articulo_tmp)){
				//Cargamos el objeto artículo
				$articulo_tmp = new Articulo($articulo_tmp);
			}
			//Llegados a este punto vamos a comprobar si $articulo es un objeto de la clase articulo
			if (is_a($articulo_tmp, "Articulo")){
				//Necesitamos varias variables que paar al fichero:
				$array_articulos_cesta = Sesion::get("array_articulos_cesta");
				$array_cantidades_cesta = Sesion::get("array_cantidades_cesta");
				$array_lotes_cesta = Sesion::get("array_lotes_cesta");
				$posicion = busca_articulo_cesta($articulo_tmp->codigo, $lote);
				if ($posicion >= 0){
					//Necesitamos la cantidad de este artículo en la cesta
					$cantidad = $array_cantidades_cesta[$posicion];
					//Cojo el artículo a mostrar que es el que se usa en los widgets personalizables
					$articulo_a_mostrar = $articulo_tmp;
					//Inserto el contenido en una capa para poder manejarlo siempre desde javascript, hay que tener en cuenta siempre los lotes
					if ($tipoCapaContenedora != ''){
?>
<<?=$tipoCapaContenedora;?> class="linea_cesta<?=($lote > 0) ? " linea_cesta_lote" : "";?> contenedor_linea_cesta_<?=$articulo_a_mostrar->codigo;?>_<?=$lote;?>" data-ruta="<?=$fichero;?>">
<?php
					}
					$lote_linea = $lote;
					include($ruta_fichero);
					if ($tipoCapaContenedora != ''){
?>
</<?=$tipoCapaContenedora;?>>
<?php
					}
				}
			}
		}
	}

	function genera_cab_lote_cesta($cod_lote){
		include('comunes/globals.php');
		$lote_aux = new Lote($cod_lote);
		if ($lote_aux->codigo > 0){
?>
<div class="lote_cesta cab_lote_cesta_<?=$lote_aux->codigo;?>">
	<?=traducir('Lote:');?> <a href="<?=Shop::$configuracion->url;?>venta_lote/<?=corregir_url($lote_aux->nombre);?>" title="<?=$lote_aux->nombre;?>"><?=$lote_aux->nombre;?></a> 
<?php
		$indice_dto_lote = lote::buscar_dto_lote($cod_lote);
		$cod_dto_lote_actual = "";
		$porcen_dto_actual = 0;
		if ($indice_dto_lote > -1){
			$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
			$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
			$porcen_dto_actual = $cod_dto_lote_actual[1];
			$cod_dto_lote_actual = $cod_dto_lote_actual[2];
		}
		if ($porcen_dto_actual > 0){
?>
	<span><?=traducir('Código promocional aplicado: ');?><strong><?=$cod_dto_lote_actual;?></strong> <?=traducir('Descuento del');?> <strong><?=$porcen_dto_actual;?></strong><span>%</span></span>
<?php	
		}
?>
</div>
<?php
		}
		unset($lote_aux);
	}

	function traduce_campo_cesta($campo){
		$retorno = $campo;
		//De momento traducimos sólo estos campos, ya evolucionaremos
		$lista_nombres_campos = array(
			'codigo' => traducir('Código'),
			'ean' => traducir('EAN'),
			'nombre' => traducir('Nombre'),
			'autor' => traducir('Autor'),
			'pvp' => traducir('PVP'),
			'foto' => traducir('Foto')
		);
		if (array_key_exists($campo, $lista_nombres_campos)){
			$retorno = $lista_nombres_campos[$campo];
		}
		return($retorno);
	}
	
	function busca_articulo_cesta($codigo, $lote){
		$array_articulos_cesta = Sesion::get('array_articulos_cesta');
		$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
		$array_lotes_cesta = Sesion::get('array_lotes_cesta');
		$posicion = -1;
		for ($i = 0; ($i < count($array_articulos_cesta)) && ($posicion < 0); $i++){
			//echo("Buscamos: '$codigo' dentro de " + $array_articulos_cesta[$i] );
			if ( ($array_articulos_cesta[$i] == $codigo) && ($array_lotes_cesta[$i] == $lote) ){
				$posicion = $i;
			}
		}
		return($posicion);
	}
	
	function cesta_sin_lotes($valor){
		if ($valor == 0){
			return(true);
		}
	}
	function cesta_con_lotes($valor){
		if ( ($valor != 0) && ($valor != 999999) ){
			return(true);
		}
	}

	function lote_999999($valor){
		if ($valor == 999999){
			return(true);
		}
	}
//Atención, tenemos un fichero auxiliar de cesta:
include('cesta_extra.php');
?>
