<?php

//---------------------------------------------------------------------------------------------------------
// 13/Febrero/2015
// Versión 1.0 Con este widget gesionamos la información referente a un pedido ya hecho
//---------------------------------------------------------------------------------------------------------



function widget_contacto() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'contacto';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function contacto($opciones = NULL){
	//Pedro 23/Enero/2019 ==> Creamos una nueva función de contacto que reciba los parámetros en una función. En caso de que no recibamos un "OpcionesWidget" es porque llamamos a la función antigua:
	$opciones = ($opciones == NULL) ? new OpcionesWidget() : $opciones;
	if (!is_a($opciones, 'OpcionesWidget')){
		call_user_func_array('contacto_old', func_get_args());
		return(true);
	}
	//Si la función llega aquí es porque no se ha llamado a contacto_old (el viejo contacto). Vamos a seguir de la manera nueva de proceder:
	//El formulario de contacto se compone de un número de campos determinado que será enviado tal cual al cliente. Si queremos adjuntar algún texto especial, lo suyo es meterlo como un hidden
	//Por eso, ahora mismo sólo indicaremos el fichero a cargar:
	$fichero_contacto = ($opciones->configuracion->fichero_contacto != NULL) ? $opciones->configuracion->fichero_contacto : 'form_contacto.php';
	$configuracionWidget = base64_encode(serialize(array(
		'widget' => 'contacto',
		'function' => 'contacto',
		'opciones' => $opciones
	)));
	?>
	<div data-configuration="<?=$configuracionWidget;?>">
	<?php
	$included = Theme::include_file($fichero_contacto);
	?>
	</div>
	<?php
	if ($included){
		//Aquí vamos a meter ahora un javascript que se encargará de recoger el formulario y enviarlo. Se hará con javascript (ajax)
		//La validación de campos se hace con html5, nada de controlarlo con el script. 
		//Me queda pendiente comprobar el captcha
		$script_id = 'script_' . incrementa_contador();
		?>
<script id="form_<?= $script_id; ?>">
document.addEventListener('WSLE', function(event) {
	;(function () {
		//Recogemos el elemento inmediatamente anterior a este script
		var formContacto = getLastHtmlObject('form_<?= $script_id; ?>').find('form');
		var avisoEnviado = getLastHtmlObject('form_<?= $script_id; ?>').find('p.contacto_enviado');
		var errorEnvio = getLastHtmlObject('form_<?= $script_id; ?>').find('p.error_contacto');
		if (formContacto.length > 0){
			formContacto.on("submit", function (event) {
				//Al hacer submit, lo primero es evitar que el fomulario se envíe
				event.preventDefault();
				event.stopPropagation();
				formContacto.hide();
				//Vamos a coger el objeto serializado en un array y pasado a json en la misma línea:
				var datosForm = formContacto.serializeArray();
				//Vamos a recorrer los datos del formulario para extraer el email del usuario y para generar la cadena que enviaremos por email:
				var userEmail = '';
				var texto = '';
				if (datosForm.length > 0){
					datosForm.forEach(function(valor, indice, array){
						texto += valor.name + ": " + valor.value + "\n";
						if (valor.name == 'mail'){
							userEmail = valor.value;
						}
					});
				}
				var sentData = {
					'texto' : texto,
					'asunto' : 'Contacto enviado a través de la web <?=Shop::$configuracion->url;?>',
					'destinatario' : '<?=Shop::$empresa->direccion_email;?>,<?=Shop::$empresa->nombre_legal;?>'
					};
					
				//sentData = JSON.stringify(sentData);
				WS_data_update(
					'Email',
					'send',
					sentData,
					'',
					function(data){
						//Comprobamos si hemos recibido "response"
						var error = true;
						if (data.response != null){
							data.response = JSON.parse(data.response);
							if (data.response.resultado == true){
								error = false;
							}
						}
						if (error){
							errorEnvio.show();
						}else{
							if (avisoEnviado.length > 0){
								avisoEnviado.show();
							}
						}
						//console.log(data);
					}
				);
				//Vamos a enviar otro email al cilente dándole las gracias
				
				if (userEmail != ''){
					var sentDataClient = {
						'texto' : '<?=traducir('Hemos recibido su solicitud de contacto. En breve nos pondremos en contacto con usted. Muchas gracias.');?>',
						'asunto' : 'Contacto enviado a través de la web <?=Shop::$configuracion->url;?>',
						'destinatario' : userEmail
					};
					//sentDataClient = JSON.stringify(sentDataClient);
					WS_data_update(
						'Email',
						'send',
						sentDataClient,
						'',
						function(data){}
					);
				}
			});
		}
	}());
});
</script>
		<?php
	}
}

function contacto_old($array_campos = array('nombre', 'email'), $campos_obligatorios = array('nombre', 'email'), $captcha = true, $valores_x_defecto = array(), $campos_no_editables = array(), $tipos = NULL, $mostrar_condiciones_privacidad = true, $recomendar = 0, $callback = '', $placeholders = array('Nombre', 'Email')) {
    $ocultarCabecera = false;
    if (is_a($array_campos, 'OpcionesWidget')) {
        $opciones = $array_campos;
        //le damos los valores por defecto ya que es el primer valor y viene Seteado con el OpcionesWidget
        $array_campos = array('nombre', 'email');
        $array_campos = ($opciones->configuracion->array_campos != null) ? $opciones->configuracion->array_campos : $array_campos;

        $campos_obligatorios = ($opciones->configuracion->campos_obligatorios != null) ? $opciones->configuracion->campos_obligatorios : $campos_obligatorios;

        $captcha = ($opciones->configuracion->captcha !== null) ? $opciones->configuracion->captcha : $captcha;

        $valores_x_defecto = ($opciones->configuracion->valores_x_defecto != null) ? $opciones->configuracion->valores_x_defecto : $valores_x_defecto;

        $campos_no_editables = ($opciones->configuracion->campos_no_editables != null) ? $opciones->configuracion->campos_no_editables : $campos_no_editables;

        $tipos = ($opciones->configuracion->tipos != null) ? $opciones->configuracion->tipos : $tipos;

        $mostrar_condiciones_privacidad = ($opciones->configuracion->mostrar_condiciones_privacidad !== null) ? $opciones->configuracion->mostrar_condiciones_privacidad : $mostrar_condiciones_privacidad;
        $recomendar = ($opciones->configuracion->recomendar != null) ? $opciones->configuracion->recomendar : $recomendar;

        $callback = ($opciones->configuracion->callback != null) ? $opciones->configuracion->callback : $callback;

        $placeholders = ($opciones->configuracion->placeholders != null) ? $opciones->configuracion->placeholders : $placeholders;

        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    include('comunes/globals.php');
    //Si array campos es un "OpcionesWidgets" entonces cargamos sus opciones
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <form action="<?= Shop::$configuracion->url; ?>contacto" method="post">
            <fieldset class="campos_contacto">
                <?php
                foreach ($array_campos as $clave => $valor) {

                    $tipo_campo = 'text';
                    switch ($valor) {
                        case 'email':
                            $tipo_campo = 'email';
                            break;
                        case 'telefono':
                            $tipo_campo = 'tel';
                            break;
                        case 'repeticion_password':
                            $nombre_campo_formulario = $valor;
                        case 'password':
                            $tipo_campo = 'password';
                            break;
                    }
                    $valor_a_asignar = '';
                    if (array_key_exists($valor, $valores_x_defecto)) {
                        $valor_a_asignar = $valores_x_defecto[$valor];
                    }
                    $deshabilitado = '';
                    if (in_array($valor, $campos_no_editables)) {
                        $deshabilitado = 'disabled';
                    }
                    if (array_key_exists($valor, $placeholders)) {
                        $texto_placeholder = $placeholders[$valor];
                    } else {
                        $texto_placeholder = '';
                    }
                    //comrpobamos que el placeholder del comentario venga
                    if (isset($placeholders['comentario'])) {
                        
                    } else {
                        $placeholders['comentario'] = '';
                    }

                    //Comprobamos si el array está a null, si lo está ponemos todos los campos con input.
                    if ($tipos == NULL) {
						?>
						<label class="<?= $valor; ?>"><?= ucfirst(traducir($valor)); ?></label>
                        <input  class="<?= $valor; ?>" type="<?= $tipo_campo; ?>" name="<?= str_replace(' ', '_', $valor); ?>" value="<?= $valor_a_asignar; ?>" <?= (in_array($valor, $campos_obligatorios)) ? "required" : ""; ?> <?= $deshabilitado; ?> placeholder="<?=$texto_placeholder; ?>" />
						<?php
                    }
                    //Comprobamos el tipo de campo que queremos mostrar
                    if ($tipos[$clave] == 'input') {
						?>
						<label class="<?= $valor; ?>"><?= ucfirst(traducir($valor)); ?></label>
						<input  class="<?= $valor; ?>" type="<?= $tipo_campo; ?>" name="<?= str_replace(' ', '_', $valor); ?>" value="<?= $valor_a_asignar; ?>" <?= (in_array($valor, $campos_obligatorios)) ? "required" : ""; ?> <?= $deshabilitado; ?> placeholder="<?=traducir($valor);?>"/>
                        <?php
                    } else if ($tipos[$clave] == 'textarea') {
						?>
                            <label class="<?= $valor; ?>"><?= ucfirst(traducir($valor)); ?></label>
							<textarea class="<?= $valor; ?>" name="<?= str_replace(' ', '_', $valor); ?>" <?= (in_array($valor, $campos_obligatorios)) ? 'required' : ''; ?> <?= $deshabilitado; ?> placeholder="<?=traducir($valor);?>"><?= $valor_a_asignar; ?></textarea>
                        <?php
                    } else if ($tipos[$clave] == "hidden") {
                        ?>
                        <input type="hidden" class="<?= $valor; ?>" name="<?= str_replace(" ", "_", $valor); ?>" value="<?= $valor_a_asignar; ?>"></>
                        <?php
                    }
                }
				?>
					<label class="comentario"><?= traducir('Comentario'); ?></label>
					<textarea class="comentario" name="texto" required placeholder="<?= $placeholders['comentario']; ?>"></textarea>
            </fieldset>
            <?php
            if ($mostrar_condiciones_privacidad) {
                ?>
                <fieldset class="aceptar_condiciones_contacto">
                    <input type="checkbox" name="condiciones_contacto" class="condiciones_contacto" required="required" />
                    <label class="texto_condiciones_contacto"><span class="asterisco">*</span><span class="texto"> <?= traducir('Usted acepta la '); ?><a href="<?= Shop::$configuracion->url; ?>privacidad" title="<?= traducir('Leer las política de privacidad'); ?>"><?= traducir('política de privacidad'); ?></a></span></label>
                </fieldset>
                <?php
            }
            if ($captcha) {
                ?>
                <fieldset class="google_captcha">
                    <?php
                    new Widget('captcha');
                    ?>
                </fieldset>
                <?php
            }
            ?>
            <fieldset class="botones">
                <a href="<?= getBackUrl(); ?>" class="boton" title="<?= traducir('Volver'); ?>"><?= traducir('Volver'); ?></a>
                <input type="submit" class="enviar_contacto" name="enviar_contacto" value="<?= traducir('Enviar'); ?>">
            </fieldset>
        </form>
        <?php
        $script_id = 'script_' . incrementa_contador();
        ?>
        <script type="text/javascript" id="form_<?= $script_id; ?>">
		document.addEventListener('WSLE', function(event) {
        ;(function () {
            //Recogemos el elemento inmediatamente anterior a este script
            var elementObjetive = getLastHtmlObject('form_<?= $script_id; ?>');
            elementObjetive.find("input").on("changue", function () {
                var msg_error = elementObjetive.parent().find("p.error_contacto");
                if (msg_error.length > 0) {
                    msg_error.remove();
                }
            });
            elementObjetive.on("submit", function (event) {
                //No seguimos por aquí si ya se ha llamado al preventDefault en otro sitio
                if (!event.isDefaultPrevented()) {
            <?php
            if ($mostrar_condiciones_privacidad) {
                ?>
                        if (!($(this).find("input[name='condiciones_contacto']").is(":checked"))) {
                            event.preventDefault();
                            event.stopPropagation();
                            alert("<?= traducir("Debe aceptar la politica de privacidad"); ?>");
                        }
                <?php
            }
            ?>
                    //Ahora vamos a enviar todos los datos 
                    if (!event.isDefaultPrevented()) {
                        event.preventDefault();
                        event.stopPropagation();
                        //Aquí es dónde vamos a recoger todos los elementos input y textarea del formulario y a enviarlos
                        var cadena_envio = "";
                        //Primero los input que haya en el formulario
                        elementObjetive.find("input:not(:checkbox):not(:submit):not(:button):not([name*='Google'])").each(function () {
                            if ($(this).attr("name") != "") {
                                cadena_envio += (cadena_envio != "") ? "&" : "";
                                cadena_envio += $(this).attr("name") + "=" + $(this).val();
                            }
                        });
                        //Ahora los textarea
                        elementObjetive.find("textarea:not([name*='recaptcha'])").each(function () {
                            if ($(this).attr("name") != "") {
                                cadena_envio += (cadena_envio != "") ? "&" : "";
                                cadena_envio += $(this).attr("name") + "=" + $(this).val();
                            }
                        });
                        if (cadena_envio != "") {
                            //Añadimos el hash de seguridad
                            cadena_envio += "&hash=<?= genera_cod_seguridad(); ?>";
                            //console.log(cadena_envio);
                            //console.log(<?= $recomendar ?>);
                            var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/contacto.php";

            <?php
            if ($recomendar == 1) {
                ?>
                                direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/recomendar.php";
                <?php
            }
            ?>
                            realizar_solicitud(direccion, cadena_envio, function (respuesta) {

                                if (respuesta == "CORRECTO") {
                                    //Todo ha ido bien, lo indicamos así
            <?php
            if ($recomendar == 1) {
                ?>
                                        $('<p class="contacto_enviado"><?= traducir("Hemos recomendado este producto, gracias por compartirlo."); ?></p>').prependTo(elementObjetive.parent()).show('fast');
                <?php
            } else {
                ?>
                                        $('<p class="contacto_enviado"><?= traducir("Hemos recibido su mensaje, gracias por ponerse en contacto con nosotros."); ?></p>').prependTo(elementObjetive.parent()).show('fast');
                <?php
            }
            ?>
                                    elementObjetive.hide('fast', function () {
                                        $(this).remove();
                                    });
            <?php
            if ($callback != "") {
                echo "$callback();\n";
            }
            ?>
                                } else {
                                    //Ha habido un error, hay que indicarlo
                                    $('<p class="error_contacto"><?= traducir("Error al enviar los datos. Por favor. Inténtelo de nuevo."); ?></p>').prependTo(elementObjetive.parent()).show('fast');
                                }
                            });
                        }

                    }
                } else {
                    //Evento cancelado
                    //console.log("Evento cancelado");
                }
            });
        }());
		});
        </script>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    return(true);
}
?>