<?php

//---------------------------------------------------------------------------------------------------------
// 12/Enero/2015
// Versión 1.0 Widget que muestra los datos de la empresa
//---------------------------------------------------------------------------------------------------------



function widget_datos_empresa($nombre_funcion = 'datos_empresa') {
    /*
      include("comunes/globals.php");
      $retorno = false;
      //Si existe el tipo de escaparate, entonces lo mostramos
      if(function_exists($nombre_funcion)){
      $retorno = $nombre_funcion($campos, $separador);
      }
      return($retorno);
     */
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'datos_empresa';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function datos_empresa($campos = 'nombre,nombre_legal,direccion,cod_postal,localidad,provincia,email,email_empresa,telefono', $separador = '-') {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if (($campos != NULL) && (is_a($campos, "OpcionesWidget"))) {
        $opciones = $campos;
        $campos = 'nombre,nombre_legal,direccion,cod_postal,localidad,provincia,email,email_empresa,telefono';
        $separador = '-';
        if (is_a($opciones, 'OpcionesWidget')) {
            $campos = ($opciones->configuracion->campos != NULL) ? $opciones->configuracion->campos : $campos;
            $separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $array_base = array(
        'nombre' => '<h3 class="nombre_empresa">' . Shop::$empresa->nombre . '</h3>',
        'nombre_legal' => '<span class="nombre_legal_empresa">' . Shop::$empresa->nombre_legal . '</span>',
        'direccion' => '<span class="direccion_empresa">' . Shop::$empresa->direccion . '</span>',
        'cod_postal' => '<span class="cod_postal_empresa">' . Shop::$empresa->cod_postal . '</span>',
        'localidad' => '<span class="localidad_empresa">' . Shop::$empresa->localidad . '</span>',
        'provincia' => '<span class="provincia_empresa">' . Shop::$empresa->provincia . '</span>',
        'email' => '<span class="email_empresa">' . Shop::$empresa->direccion_email . '</span>',
        'email_empresa' => '<span class="email_empresa">' . Shop::$empresa->email_empresa . '</span>',
        'telefono' => '<a href="tel:' . Shop::$empresa->telefono_empresa . '"><span class="telefono_empresa">' . Shop::$empresa->telefono_empresa . '</span></a>'
    );
    $cadena_datos = '';
    $array_campos = explode(',', $campos);
    foreach ($array_campos as $clave => $valor) {
        if ($array_base[$valor] != NULL) {
            $cadena_datos .= ( ($cadena_datos != '') ? " <span class='separador'>$separador</span> " : "" ) . $array_base[$valor];
        }
    }
    if ($cadena_datos != "") {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>

            <?= $cadena_datos; ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
    return(true);
}

function datos_empresa_perso($opciones = NULL) {
    include('comunes/globals.php');
    $fichero_datos_empresa = 'datos_empresa';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_datos_empresa' => $fichero_datos_empresa));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_datos_empresa = ($opciones->configuracion->fichero_datos_empresa != NULL) ? $opciones->configuracion->fichero_datos_empresa : $fichero_datos_empresa;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_datos_empresa . '.php');
            if ($ruta_fichero != NULL) {
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
    return(true);
}

function google_shopping_itemscope($objeto_empresa) {
    $configuracion = dame_valor_variable_global('configuracion', '');
    ?>
    <span itemscope itemtype="http://data-vocabulary.org/Organization"> 
        <span itemprop="name" content="<?= $objeto_empresa->nombre_legal; ?>"></span>
        <span itemprop="tel" content="<?= $objeto_empresa->telefono_empresa; ?>"></span>
        <span itemprop="address" itemscope itemtype="http://data-vocabulary.org/Address">
            <span itemprop="street-address" content="<?= $objeto_empresa->direccion; ?>"></span>
            <span itemprop="locality" content="<?= $objeto_empresa->localidad; ?>"></span>
            <span itemprop="postal-code" content="<?= $objeto_empresa->cod_postal; ?>"></span> 
            <span itemprop="region" content="<?= $objeto_empresa->provincia; ?>"></span>
            <span itemprop="country-name" content="<?= $objeto_empresa->pais_empresa; ?>"></span>
            <span itemprop="geo" itemscope>
                <span itemprop="latitude" content="xxxxxxxxxxxxxxxxxx"></span>
                <span itemprop="longitude" content="xxxxxxxxxxxxxxxxxx"></span>
            </span>
        </span>
        <span itemprop="url" content="<?= Shop::$configuracion->url; ?>"></span>
    </span>
    <?php
}
?>