<?php
	//---------------------------------------------------------------------------------------------------------
	// 10/Noviembre/2014
	// Versión 1.0 Widget utilizado para que el usuario modifique sus direcciones de envío
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function widget_direcciones_envio(){
		//Aquí definimos una serie de parámetros que necesitamos
		$funcion_por_defecto = 'direcciones_envio';
		$parametros_por_defecto = array();
		$parametros_recibidos = func_get_args();
		if (count($parametros_recibidos) == 0){
			$parametros_recibidos[0] = $funcion_por_defecto;
		}else{
			if ( ($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL) ){
				$parametros_recibidos[0] = $funcion_por_defecto;
			}
		}
		$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
		$retorno = false;
		//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
		if (count($parametros_recibidos) > 0){
			//Recogemos el nombre de la función de entre el resto de parámetros
			$nombre_funcion = $parametros_recibidos[0];
			//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
			$parametros_recibidos = array_slice($parametros_recibidos, 1);
			//Si la función existe la ejecutamos
			if(function_exists($nombre_funcion)){
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
		return($retorno);
	}

	function direcciones_envio($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
				include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
	<h2><?=traducir('Mis direcciones');?></h2>
	<a href="javascript:void(0);" title="<?=traducir('Nueva dirección de envío');?>" onclick="form_nueva_direccion();"><?=traducir('Nueva dirección de envío');?></a>
<?php
		//Primero creamos el widget con el formulario
        new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'), $campos_direccion, $campos_obligatorios);
        new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio'), $campos_direccion);
?>
</div>
<?php
	}


	function direcciones_envio_inverso($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
		//El enlace de nueva dirección va abajo
				include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
	<h2><?=traducir('Mis direcciones');?></h2>

<?php
        new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio'), $campos_direccion);
?>
	<a href="javascript:void(0);" title="<?=traducir('Nueva dirección de envío');?>" onclick="form_nueva_direccion();"><?=traducir('Nueva dirección de envío');?></a>
<?php
        new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'), $campos_direccion, $campos_obligatorios);
?>
</div>
<?php
	}

	function form_nueva_direccion($campos_direccion = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono'), $campos_obligatorios = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia')){
		include('comunes/globals.php');
		//Vamos a calcular la dirección de envío. En este caso consiste en obtener el último elemento del camino seguido
?>
		<div class="<?=(__FUNCTION__);?>">
			<p class="aviso_nueva_direccion"></p>
			<div class="form_nueva_direccion_formulario">
				<p class="texto_aclaracion_nueva_direccion"></p>
				<form action="javascript:void(0);" method="post" class="nueva_direccion">
					<fieldset>
<?php
		//Recorremos el array de campos
		foreach($campos_direccion as $clave => $valor){
			//Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
			$tipo_campo = 'text';
			$texto_requerido = '';
			$asterisco = '';
			$nombre_campo_formulario = 'campo_direccion_' . $valor;
			if (in_array($valor, $campos_obligatorios)){
				$texto_requerido = 'required';
				$asterisco = ' <span class="asterisco">*</span>';
			}
?>
					<label><?=traduce_campo_registro($valor);?><?=$asterisco;?></label>
					<input type="<?=$tipo_campo;?>" name="<?=$nombre_campo_formulario;?>" value="" class="campo_<?=$valor;?>" <?=$texto_requerido;?> />
<?php
		}
?>
					<input type="submit" name="enviar" value="<?=traducir('Guardar');?>"/>
					</fieldset>
					<a href="javascript:void(0);" onclick="limpiar_form_mod_direccion();limpiar_aviso_direccion();" title="<?=traducir('Cancelar');?>"><?=traducir('Cancelar');?></a>
				</form>
<?php
	crear_script_control_direcciones();
?>
			</div>
		</div>
<?php
		return(true);
	}

	function lista_direcciones_envio($lista_campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		include('comunes/globals.php');
		//Vamos a calcular la dirección de envío. En este caso consiste en obtener el último elemento del camino seguido
?>
		<div class="<?=(__FUNCTION__);?>">
<?php
			//Recorremos las direcciones de envío, teniendo en cuenta que la 0 es la de la ficha
			for ($i = 0; $i < count($datos_usuario->direcciones); $i++){
				genera_direccion_envio($datos_usuario->codigo, $datos_usuario->direcciones[$i], $datos_usuario->direc_predeterminada, false, $lista_campos);
			}
?>
		</div>
<script type="text/javascript">
	function form_nueva_direccion(){
		if ($('.form_nueva_direccion_formulario').is(":hidden")){
			$('.form_nueva_direccion_formulario').show('fast');
			//Ocultamos el aviso
			limpiar_aviso_direccion();
		}
		//lo primero es eliminar los campos ocultos que se utilizan en el formulario
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		//Ahora además los insertamos de nuevo con sus valores correspondientes
		$("form.nueva_direccion").append('<input type="hidden" name="codigo" value="0" />');
		$("form.nueva_direccion").append('<input type="hidden" name="accion" value="nueva" />');
		$("form.nueva_direccion").append('<input type="hidden" name="cliente" value="<?=$datos_usuario->codigo;?>" />');
		var texto = "<?=traducir('Introduzca los datos de la nueva dirección de envío y pulse sobre el botón "Guardar". La dirección de envío introducida se sumará a las direcciones existentes.');?>";
		$("p.texto_aclaracion_nueva_direccion").html(texto);
	}
	function limpiar_form_mod_direccion(){
		$('.form_nueva_direccion_formulario').hide('fast');
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		$("form.nueva_direccion fieldset input[name='campo_direccion_nombre']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_direccion']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_cod_postal']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_localidad']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_provincia']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_pais']").prop("value", "");
		$("form.nueva_direccion fieldset input[name='campo_direccion_telefono']").prop("value", "");
	}
	function limpiar_aviso_direccion(){
		//Ocultamos el aviso
		$("p.aviso_nueva_direccion").hide('fast');
		$("p.aviso_nueva_direccion").html("");
	}

	function inicio_modificar_direccion(cod_direccion, cod_cliente){
		/*if ($('.form_nueva_direccion').is(":hidden")){
			$('.form_nueva_direccion').show('fast');
		}*/
		form_nueva_direccion();
		var texto = "<?=traducir("Modifique los datos de la dirección de envío seleccionada y pulse el botón 'Guardar'.");?>";
		$("p.texto_aclaracion_nueva_direccion").html(texto);


		//Tenemos que comprobar si es necesario hacer un scroll
		var posicion = $('.form_nueva_direccion').offset();
		if (posicion.top < $(document).scrollTop()){
			$(document).scrollTop(posicion.top - 50);
		}

		//lo primero es eliminar los campos ocultos que se utilizan en el formulario
		$("form.nueva_direccion input[name='codigo']").remove();
		$("form.nueva_direccion input[name='accion']").remove();
		$("form.nueva_direccion input[name='cliente']").remove();
		//Ahora además los insertamos de nuevo con sus valores correspondientes
		$("form.nueva_direccion").append('<input type="hidden" name="codigo" value="' + cod_direccion + '" />');
		$("form.nueva_direccion").append('<input type="hidden" name="accion" value="modificar" />');
		$("form.nueva_direccion").append('<input type="hidden" name="cliente" value="' + cod_cliente + '" />');
		//Obtenemos los datos de la direccion
		var nombre = $(".direccion_envio .datos_" + cod_direccion + " span.nombre").html();
		var direccion = $(".direccion_envio .datos_" + cod_direccion + " span.direccion").html();
		var cod_postal = $(".direccion_envio .datos_" + cod_direccion + " span.cod_postal").html();
		var localidad = $(".direccion_envio .datos_" + cod_direccion + " span.localidad").html();
		var provincia = $(".direccion_envio .datos_" + cod_direccion + " span.provincia").html();
		var pais = $(".direccion_envio .datos_" + cod_direccion + " span.pais").html();
		var telefono = $(".direccion_envio .datos_" + cod_direccion + " span.telefono").html();
		//Ahora modificamos el resto de datos
		$("form.nueva_direccion fieldset input[name='campo_direccion_nombre']").prop("value", nombre);
		$("form.nueva_direccion fieldset input[name='campo_direccion_direccion']").prop("value", direccion);
		$("form.nueva_direccion fieldset input[name='campo_direccion_cod_postal']").prop("value", cod_postal);
		$("form.nueva_direccion fieldset input[name='campo_direccion_localidad']").prop("value", localidad);
		$("form.nueva_direccion fieldset input[name='campo_direccion_provincia']").prop("value", provincia);
		$("form.nueva_direccion fieldset input[name='campo_direccion_pais']").prop("value", pais);
		$("form.nueva_direccion fieldset input[name='campo_direccion_telefono']").prop("value", telefono);

	}

	function eliminar_direccion_envio(codigo, cliente){
		//quitamos la dirección de la lista
		if (confirm("<?=html_entity_decode(traducir("¿Está seguro de que desea eliminar esta dirección?"));?>")){
			var parametros = "codigo=" + codigo + "&cliente=" + cliente + "&accion=borrar&hash=<?=genera_cod_seguridad();?>";
			var url = "<?=Shop::$configuracion->url;?>comunes/consultas/crea_mod_direccion_envio.php";
			realizar_solicitud(url, parametros, function(respuesta){
				//console.log(respuesta);
				if (respuesta == "BORRADA"){
					//Si se ha borrado la dirección de envío eliminamos la lína
					$(".direccion_envio .datos_" + codigo + " span.nombre").parents(".direccion_envio").remove();
				}
			});
		}
	}

	function predeterminar_direccion(codigo, cliente){
		var parametros = "codigo=" + codigo + "&cliente=" + cliente + "&hash=<?=genera_cod_seguridad();?>";
		var url = "<?=Shop::$configuracion->url;?>comunes/consultas/predeterminar_direccion_envio.php";
		realizar_solicitud(url, parametros, function(respuesta){
			//console.log(respuesta);
			if (respuesta == "CORRECTO"){
				$("#direc_predeterminada").removeAttr("id");
				//Ahora predeterminamos la que nos han pasado en código
				$(".datos_" + codigo ).parent().attr("id", "direc_predeterminada");
			}
		});
	}
</script>
<?php
	}


	function muestra_datos_dir_predeterminada($usuario = NULL, $campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		include('comunes/globals.php');
		if ($usuario != NULL){
			$usuario_a_mostrar = new Usuario($usuario);
		}else{
			$usuario_a_mostrar = $datos_usuario;
		}
		if ($usuario_a_mostrar != NULL){
			//La dirección predeterminada siempre es la 0.
			if (count($usuario_a_mostrar->direcciones) > 0){
				genera_direccion_envio($usuario_a_mostrar->codigo, $usuario_a_mostrar->direcciones[0], $usuario_a_mostrar->direc_predeterminada, true, $campos);
			}
		}
	}

//--------------------------------------------------------------------------------
//Funciones extras que mecesita este widget
//--------------------------------------------------------------------------------
	//function genera_direccion_envio($cliente, $codigo, $nombre, $direccion, $cod_postal, $localidad, $provincia, $pais, $telefono, $direc_predeterminada = NULL, $oculta_botones = false){
	function genera_direccion_envio($cliente, $obj_direccion, $direc_predeterminada = NULL, $oculta_botones = false, $campos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono')){
		$datos_permitidos = array('nombre', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono');
		if (is_a($obj_direccion, 'Direcciones')){
?>
		<div class="direccion_envio" <?=( ($direc_predeterminada == $obj_direccion->codigo) && ($direc_predeterminada != NULL) ) ? 'id="direc_predeterminada"' : "";?>>
			<span></span>
			<div class="datos_<?=$obj_direccion->codigo;?>">
<?php
			foreach($campos as $clave => $valor){
				//Comprobamos que la clave exista en los elementos permitidos
				if (in_array($valor, $datos_permitidos)){
?>
				<p><span class="nombre_campo"><?=traducir($valor);?> </span><span class="<?=$valor;?>"><?=$obj_direccion->$valor;?></span> </p>
<?php
				}
			}
			/*
?>
				<p><span class="nombre_campo"><?=traducir("Nombre");?> </span><span class="nombre"><?=$nombre;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Dirección");?> </span><span class="direccion"><?=$direccion;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Código postal");?> </span><span class="cod_postal"><?=$cod_postal;?></span> </p>
				<p><span class="guion"> - </span> </p>
				<p><span class="nombre_campo"><?=traducir("Localidad");?> </span><span class="localidad"><?=$localidad;?></span> </p>
				<p><span class="nombre_campo"><?=traducir("Provincia");?> </span><span class="provincia"><em>(</em><span><?=$provincia;?></span><em>)</em></span> </p>
<?php
			*/
?>
			</div>
<?php
			if (!$oculta_botones){
?>
			<div class="botones">
<?php
				if ($obj_direccion->codigo > 0){
?>
				<a href="javascript:void(0);" class="eliminar" onclick="eliminar_direccion_envio(<?=$obj_direccion->codigo;?>, <?=$cliente;?>)"title="<?=traducir("Eliminar");?>"><?=traducir("Eliminar");?></a>
				<a href="javascript:void(0);" class="modificar" onclick="inicio_modificar_direccion(<?=$obj_direccion->codigo;?>, <?=$cliente;?>);" title="<?=traducir("Modificar");?>"><?=traducir("Modificar");?></a>
<?php
				}
?>
				<a href="javascript:void(0);" class="predeterminar" onclick="predeterminar_direccion(<?=$obj_direccion->codigo;?>, <?=$cliente;?>);" title="<?=traducir("Predeterminar");?>"><?=traducir("Predeterminar");?></a>
<?php
				if ($obj_direccion->codigo == 0){
?>
				<p class="aclaracion_direcciones"><?=traducir('Esta es su dirección de registro. Para modificarla acceda a su area privada.');?></p>
<?php
				}
?>
			</div>
<?php
			}
?>
		</div>
<?php
		}
	}

	function crear_script_control_direcciones(){
		include('comunes/globals.php');
			//Este escript a continuación no va a funcionar
?>
			<script type="text/javascript">
			document.addEventListener('WSLE', function(event) {
				var scripts = document.getElementsByTagName( 'script' );
				var thisScriptTag = scripts[ scripts.length - 1 ];
				var form_direcciones = $(thisScriptTag).prev();
				var correcto = true;
				var todo_esta_correcto = false;
			
				//No estamos ni en chrome ni en firefox, así que hay que controlar los campos obligatorios
				$(form_direcciones).on("submit", function(event){
					//No dejamos que se haga el submit. Hay que hacerlo si todo está bien
					event.preventDefault();
					correcto = true;
					var fieldset = $(this).children("fieldset")[0];
					//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
					var lista_input =  $(fieldset).children("input[required]");
					var total = lista_input.length;
					for (var i = 0;(i < total) && (correcto); i++){
						var elemento = lista_input[i];
						if ($(elemento).prop("value") == ""){
							correcto = false;
							$(elemento).focus();
							poner_sombra($(elemento));
						}
					}
					//Si todo está correcto, vamos a recoger los valores para hacer el sumbit
					var codigo = $("form.nueva_direccion input[name='codigo']").prop("value");
					var accion = $("form.nueva_direccion input[name='accion']").prop("value");
					var cliente = $("form.nueva_direccion input[name='cliente']").prop("value");
					//Vamos a recoger los valores del formulario en el orden en el que están
					var formParams = "";
					$("form.nueva_direccion fieldset input[name^='campo_direccion_']").each(function(){
						//en el atributo name tenemos el nombre del campo
						var nombre = $(this).attr("name").replace("campo_direccion_", "");
						//var nombre = $(this).attr("name").split("campo_direccion_")[0];
						var valor = $(this).val();
						formParams += "&" + nombre + "=" + valor;
					});
					var parametros = "codigo=" + codigo + "&cliente=" + cliente;
					/*parametros += "&direccion=" + direccion + "&cod_postal=" + cod_postal + "&localidad=" + localidad + "&provincia=" + provincia + "&pais=" + pais;
					parametros += "&nombre=" + nombre + "&telefono=" + telefono;*/
					parametros += formParams;
					parametros += "&accion=" + accion + "&hash=<?=genera_cod_seguridad();?>";
					var url = "<?=Shop::$configuracion->url;?>comunes/consultas/crea_mod_direccion_envio.php";
					//console.log(url, parametros);
					realizar_solicitud(url, parametros, function(respuesta){
						//console.log(respuesta);
						//Según la acción, trataremos la respuesta de una forma o de otra
						if (accion == "nueva"){
							//En respuesta está el código html para añadir a la lista
							$(".lista_direcciones_envio").prepend(respuesta);
							$("p.aviso_nueva_direccion").html('<?=traducir("Dirección añadida satisfactoriamente");?>');
							$("p.aviso_nueva_direccion").show();
						}else if (accion == "modificar"){
							var nuevo_elemento = $(respuesta);
							nuevo_elemento = nuevo_elemento.children("[class *= datos_]");
							$(".direccion_envio").children(".datos_" + codigo).html(nuevo_elemento.html());
							$("p.aviso_nueva_direccion").html('<?=traducir("Dirección modificada satisfactoriamente");?>');
							$("p.aviso_nueva_direccion").show();
						}
						limpiar_form_mod_direccion();
					});
				});

				//Vamos a crear un "listener" para que cuando cambie un input, si el borde es rojo, que se ponga en su borde inicial
				$(form_direcciones).children("fieldset").children("input[required]").on("input", function(){
					quitar_sombra($(this));
				});

				$(form_direcciones).children("fieldset").children("input[name='campo_direccion_cod_postal']").on("blur", function(){
					var elemento = $(this);
					if (elemento.prop("value") != ""){
						var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?=genera_cod_seguridad();?>";
						realizar_solicitud("<?=Shop::$configuracion->url;?>comunes/consultas/cod_postal_get_localidad.php", parametros, function(respuesta){
							if (respuesta != "0"){
								//Tenemos localidad y provincia
								var array_datos = respuesta.split("|");
								var localidad = array_datos[0];
								var provincia = array_datos[1];
								//Vamos a asginar la localidad y provincia
								var campo_localidad = elemento.siblings("[name='campo_direccion_localidad']");
								if (campo_localidad.prop("value") == ""){
									campo_localidad.prop("value", localidad);
								}
								var campo_provincia = elemento.siblings("[name='campo_direccion_provincia']");
								if (campo_provincia.prop("value") == ""){
									campo_provincia.prop("value", provincia);
								}
							}
						});
					}
				});
			});
			</script>
<?php
	}
	


function muestra_direccion_envio_perso($opciones = NULL) {
    include('comunes/globals.php');
    $obj_direccion_envio = NULL;
    $fichero_direccion = 'direccion_envio';
    $usuario = Usuario::logueado();
    if (is_a($opciones, 'OpcionesWidget')) {
		$obj_direccion_envio = ($opciones->configuracion->obj_direccion_envio !== NULL) ? $opciones->configuracion->obj_direccion_envio : $obj_direccion_envio;
		$fichero_direccion = ($opciones->configuracion->fichero_direccion !== NULL) ? $opciones->configuracion->fichero_direccion : $fichero_direccion;
		$usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
    }
    //Vamos a generar un ID único para esta capa. Hay que tener en cuenta que debe ser selecionabel por el código de la línea y además debe permitir obtener el tipo de fichero
    $id = 'codigo_' . $obj_direccion_envio->codigo . '_' . date('His') . substr((string) microtime(), 4, 4) . '_' . $fichero_direccion;
    ?>
    <div class="<?= (__FUNCTION__); ?>" reference="<?= $id; ?>">
        <?php
        $ruta = Theme::findFile($fichero_direccion . '.php');
        if ($ruta != NULL) {
            include($ruta);
        }
        if (is_int($usuario)) {
            $usuario = new Usuario($usuario);
        }
        $usuario_a_mostrar = $usuario;
        ?>
    </div>
    <?php
}

function lista_direcciones_envio_perso($opciones = NULL) {
    include('comunes/globals.php');
    $usuario = Usuario::logueado();
    $fichero_linea = 'direccion_envio_form';
    $fichero_dir_predeterminada = 'direccion_envio';
    //$ocultar_direcciones = false;
    $ocultar_direcciones = false;
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
        $ocultar_direcciones = ($opciones->configuracion->ocultar_direcciones !== NULL) ? $opciones->configuracion->ocultar_direcciones : $ocultar_direcciones;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }

    //Comprobamos que es un entero
    //Obligamos a que sea un entero
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada "usuario_a_mostrar" para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        //Vamos a coger el "fichero_direccion" que tuviesen las opciones
        $fichero_direccion = $opciones->fichero_direccion;
?>
        <div class="<?= (__FUNCTION__); ?>">
            <p class="mensaje_aviso"></p>
<?php
            //Si hay que ocultar las direcciones, vamos a meter aquí un botón para ello
            if ($ocultar_direcciones) {
?>
                <a class="boton" href="javascript:void(0);" title="<?= traducir('Mostrar direcciones'); ?>"><?= traducir('Mostrar direcciones'); ?></a>
				<?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
                <script id="<?=$nombre_script;?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                        elemento.on("click", function () {
                            //Si la siguiente capa es visible, entonces la mostramos, si no, la ocultamos
                            if ($("div.lineas_direcciones_envio").is(":visible")) {
                                //Hay que ocultarlo:
                                $("div.lineas_direcciones_envio").hide('fast');
                                //Al hipervínculo le cambiamos el title y el contenido
                                $(this).prop("title", "<?= traducir("Mostrar direcciones"); ?>");
                                $(this).html("<?= traducir("Mostrar direcciones"); ?>");
                            } else {
                                //hay que mostrarlo
                                $("div.lineas_direcciones_envio").show('fast');
                                //Al hipervínculo le cambiamos el title y el contenido
                                $(this).prop("title", "<?= traducir("Ocultar direcciones"); ?>");
                                $(this).html("<?= traducir("Ocultar direcciones"); ?>");
                            }
                        });
                    })();
				});
                </script>
                <div class="lineas_direcciones_envio">
<?php
                }
                for ($i = 0; $i < count($usuario->direcciones); $i++) {
                    //A la dirección predeterminada hay que ponerle un ID
                    $id = "";
                    if ($usuario->direcciones[$i]->codigo == $usuario->direc_predeterminada) {
                        $id = 'id="direc_predeterminada"';
                    }
                    //Mostramos la direccion perso
?>
                    <div class="linea_lista_direcciones_envio_perso" <?= $id; ?>>
<?php
                        $opciones->addProperty('obj_direccion_envio', $usuario->direcciones[$i]);
                        //Necesitamos utilizar el "fichero dirección" por si las moscas
                        $opciones->addProperty('fichero_direccion', $fichero_linea);
                        $opciones->addProperty('usuario', $usuario);
                        new Widget($_WH->GW('direcciones_envio', 'muestra_direccion_envio_perso'), $opciones);
?>
                    </div>
<?php
                }
                //Volvemos a asignar el 'fichero_direccion' que hubiese antes
                $opciones->addProperty('fichero_direccion', $fichero_direccion);
                if ($ocultar_direcciones) {
?>
                </div>
<?php
            }
            ?>
        </div>
        <?php
    }
}

function muestra_datos_dir_predeterminada_perso($opciones = NULL) {
    include('comunes/globals.php');

    $usuario = Usuario::logueado();
    $fichero_dir_predeterminada = 'direccion_envio';
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_dir_predeterminada = ($opciones->configuracion->fichero_dir_predeterminada !== NULL) ? $opciones->configuracion->fichero_dir_predeterminada : $fichero_dir_predeterminada;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }
    //Si el usuario es un número entero:
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada 'usuario_a_mostrar' para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        //La dirección predeterminada siempre es la 0.
        if (count($usuario->direcciones) > 0) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
                //Cómo va a haber una "re-asignacion" necesitamos coger el que hay ahora mismo
                $fichero_aux = $opciones->fichero_direccion;
                $opciones->addProperty('obj_direccion_envio', $usuario->direcciones[0]);
                $opciones->addProperty('usuario', $usuario);
                $opciones->addProperty('fichero_dir_predeterminada', $fichero_dir_predeterminada);
                $opciones->addProperty('fichero_direccion', $fichero_dir_predeterminada);
                new Widget($_WH->GW('direcciones_envio', 'muestra_direccion_envio_perso'), $opciones);
                //Volvemos a asignar el que corresponde
                $opciones->addProperty('fichero_direccion', $fichero_aux);
                ?>
            </div>
            <?php
        }
    }
}

function form_nueva_direccion_perso($opciones = NULL) {
    include('comunes/globals.php');
    $usuario = Usuario::logueado();
    $fichero_formulario = 'direccion_envio_nueva_form';
    $fichero_linea = 'direccion_envio_form';
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_formulario = ($opciones->configuracion->fichero_formulario !== NULL) ? $opciones->configuracion->fichero_formulario : $fichero_formulario;
        $fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada 'usuario_a_mostrar' para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <p class="texto_aclaracion_nueva_direccion"></p>
            <a href="javascript:void(0);" title="<?= traducir('Añadir dirección'); ?>" class="boton"><?= traducir('Añadir dirección'); ?></a>
            <?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
			<script id="<?=$nombre_script;?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                    elemento.on("click", function () {
                        var hermano = elemento.next().next();	//Dos next porque este script está en medio
                        if (hermano != null) {
                            elemento.hide("fast");
                            $("p.texto_aclaracion_nueva_direccion").hide();
                            hermano.show();
                            //Hay que ocultar el texto de aclaración nueva dirección
                        }
                    });
                })();
			});
            </script>
            <div class="formulario_nueva_direccion">
                <?php
                //Incluimos el fichero con el formulario
                $ruta = Theme::findFile($fichero_formulario . '.php');
                if ($ruta != NULL) {
                    include($ruta);
                }
                ?>
            </div>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
            <script id="<?=$nombre_script;?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var correcto = true;
                    var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                    elemento = elemento.find("form[action='<?= Shop::$configuracion->url ?>comunes/consultas/crea_mod_direccion_envio.php']");
                    elemento.on("submit", function (event) {
                        event.preventDefault();
                        correcto = true;
                        var fieldset = elemento.children("fieldset")[0];
                        //Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
                        var lista_input = $(fieldset).children("input[required]");
                        var total = lista_input.length;
                        for (var i = 0; (i < total) && (correcto); i++) {
                            var elemento_lista = lista_input[i];
                            if ($(elemento_lista).prop("value") == "") {
                                correcto = false;
                                $(elemento_lista).focus();
                                poner_sombra($(elemento_lista));
                            }
                        }
                        //Si todo está correcto, vamos a recoger los valores para hacer el sumbit
                        var codigo = elemento.find("input[name='mod_codigo']").prop("value");
                        var accion = "nueva";
                        var cliente = <?= $usuario_a_mostrar->codigo; ?>;
                        var nombre = elemento.find("textarea[name='campo_direccion_nombre']").prop("value");
                        var direccion = elemento.find("textarea[name='campo_direccion_direccion']").prop("value");
                        var cod_postal = elemento.find("input[name='campo_direccion_cod_postal']").prop("value");
                        var localidad = elemento.find("input[name='campo_direccion_localidad']").prop("value");
                        var provincia = elemento.find("input[name='campo_direccion_provincia']").prop("value");
                        var pais = elemento.find("input[name='campo_direccion_pais']").prop("value");
                        var telefono = elemento.find("input[name='campo_direccion_telefono']").prop("value");
                        //Vamos a recoger los valores del formulario en el orden en el que están
                        var formParams = "";
                        elemento.find("textarea[name^='campo_direccion_']").each(function () {
                            //en el atributo name tenemos el nombre del campo
                            var nombre = $(this).attr("name").replace("campo_direccion_", "");
                            //var nombre = $(this).attr("name").split("campo_direccion_")[0];
                            var valor = $(this).val();
                            formParams += "&" + nombre + "=" + valor;
                        });
                        elemento.find("input[name^='campo_direccion_']").each(function () {
                            //en el atributo name tenemos el nombre del campo
                            var nombre = $(this).attr("name").replace("campo_direccion_", "");
                            //var nombre = $(this).attr("name").split("campo_direccion_")[0];
                            var valor = $(this).val();
                            formParams += "&" + nombre + "=" + valor;
                        });
                        //Datos del cliente
                        var parametros = "codigo=" + codigo + "&cliente=" + cliente;
                        //Datos de la dirección a crear/modificar
                        parametros += formParams;
                        //Fichero "perso" a utilizar
                        parametros += "&fichero_perso=<?= $fichero_linea; ?>";
                        //Parametro con la acción y el hash de seguridad
                        parametros += "&accion=" + accion + "&hash=<?= genera_cod_seguridad(); ?>";
                        var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/crea_mod_direccion_envio.php";

                        realizar_solicitud(url, parametros, function (respuesta) {
                            //console.log(respuesta);
                            //$(".lista_direcciones_envio_perso").prepend(respuesta);
                            //Para que se inserte en la línea de direcciones de envío perso, hay que hacer una pequeña modificacion
                            var elemento_auxiliar = $('<div class="linea_lista_direcciones_envio_perso"></div>');
                            elemento_auxiliar.html(respuesta);
                            $(".lista_direcciones_envio_perso .linea_lista_direcciones_envio_perso").first().before(elemento_auxiliar);
                            $("p.texto_aclaracion_nueva_direccion").html('<?= traducir("Dirección añadida satisfactoriamente"); ?>');
                            $("p.texto_aclaracion_nueva_direccion").show();
                            //Vamos a hacer que este texto se vaya al rato de añadir una dirección
                            window.setTimeout(function () {
                                $("p.texto_aclaracion_nueva_direccion").hide('slow');
                            }, 3000);
                            //Vaciamos los campos al cancelar
                            elemento.find("textarea[name='campo_direccion_nombre']").prop("value", "");
                            elemento.find("textarea[name='campo_direccion_direccion']").prop("value", "");
                            elemento.find("input[name='campo_direccion_cod_postal']").prop("value", "");
                            elemento.find("input[name='campo_direccion_localidad']").prop("value", "");
                            elemento.find("input[name='campo_direccion_provincia']").prop("value", "");
                            elemento.find("input[name='campo_direccion_pais']").prop("value", "");
                            elemento.find("input[name='campo_direccion_telefono']").prop("value", "");
                            //Hay que ocultar el formulario y mostrar el botón
                            elemento.parent().hide('fast');
                            var hermano = elemento.parent().prev().prev();	//Dos prev porque hay un script en medio
                            hermano.show();
							//Vamos a recargar la página para que aparezca todo correcto:
							location.reload();
                        });

                    });

                    elemento.find("input[name='cancelar']").on("click", function (event) {
                        var hermano = elemento.parent().prev().prev();	//Dos prev porque hay un script en medio
                        elemento.parent().hide('fast');
                        hermano.show();
                        //Vaciamos los campos al cancelar
                        elemento.find("textarea[name='campo_direccion_nombre']").prop("value", "");
                        elemento.find("textarea[name='campo_direccion_direccion']").prop("value", "");
                        elemento.find("input[name='campo_direccion_cod_postal']").prop("value", "");
                        elemento.find("input[name='campo_direccion_localidad']").prop("value", "");
                        elemento.find("input[name='campo_direccion_provincia']").prop("value", "");
                        elemento.find("input[name='campo_direccion_pais']").prop("value", "");
                        elemento.find("input[name='campo_direccion_telefono']").prop("value", "");
                    });
                })();
			});
            </script>
        </div>
        <?php
    }
}

function panel_direcciones_movil($usuario = NULL, $fichero = 'direccion_envio') {
    include('comunes/globals.php');
    //Comprobamos que es un entero
    //Obligamos a que sea un entero
    $usuario = (int) $usuario;
    if (is_int($usuario)) {
        if ($usuario != NULL) {
            $usuario_a_mostrar = new Usuario($usuario);
        } else {
            $usuario_a_mostrar = $datos_usuario;
        }
        if (is_a($usuario_a_mostrar, 'Usuario')) {
            if ($usuario_a_mostrar != NULL) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                    //Insertamos el widget que muestra la direccion de envio predeterminada
                    new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada_perso'), $usuario_a_mostrar->codigo, $fichero);
                    //Agregamos los botones para ver la lista de direcciones y el agregar direccion
                    ?>
                    <a class="mis_direcciones" href="javascript:void(0)" title="<?= traducir('Mis direcciones') ?>"><?= traducir('Mis direcciones') ?></a>
                    <a class="agregar_direccion" href="javascript:void(0)" title="<?= traducir('Agregar dirección') ?>"><?= traducir('Agregar dirección') ?></a>
                    <?php
                    //Agregamos el widget que muestra la lista de direcciones
                    new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio_perso'), $usuario_a_mostrar->codigo);
                    //Añadimos el widget que muestra el formulario para añadir una nueva direccion
                    //new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'));
                    new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion_perso'), $usuario_a_mostrar->codigo, 'direccion_envio_nueva_form');
                    ?>
                </div>
				<?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var correcto = true;
                        var elemento = getLastHtmlObject('<?= $nombre_script; ?>');
                        //elemento = elemento.find("form[action='<?= Shop::$configuracion->url ?>comunes/consultas/crea_mod_direccion_envio.php']");
                        elemento.find('.lista_direcciones_envio_perso').hide('fast');
                        elemento.find(".form_nueva_direccion_perso").hide('fast');
                        //Mostramos las direcciondes de envio
                        elemento.find("a[class='mis_direcciones']").on("click", function (event) {
                            if (elemento.find('.lista_direcciones_envio_perso').is(':hidden')) {
                                elemento.find('.lista_direcciones_envio_perso').show('fast');
                            } else if (!elemento.find('.lista_direcciones_envio_perso').is(':hidden')) {
                                elemento.find('.lista_direcciones_envio_perso').hide('fast');
                            }
                        });

                        elemento.find("a[class='agregar_direccion']").on("click", function (event) {
                            var texto = "<?= traducir("Introduzca los datos de la nueva dirección de envío y pulse sobre el botón 'Guardar'. La dirección de envío introducida se sumará a las direcciones existentes."); ?>";
                            elemento.find(".texto_aclaracion_nueva_direccion").html(texto);
                            if (elemento.find('.form_nueva_direccion_perso').is(":hidden")) {
                                elemento.find('.form_nueva_direccion_perso').show('fast');
                                elemento.find('.texto_aclaracion_nueva_direccion').show('fast');
                                //Ocultamos el aviso
                                //limpiar_aviso_direccion();
                            } else if (!elemento.find(".form_nueva_direccion_perso").is(':hidden')) {
                                elemento.find(".form_nueva_direccion_perso").hide('fast');
                            }
                        });
                    })();
				});
                </script>
                <?php
            }
        }
    }
}

function panel_direcciones_perso($opciones) {
    include('comunes/globals.php');
    $fichero_panel = 'panel_direcciones_envio';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_panel = ($opciones->configuracion->fichero_panel != NULL) ? $opciones->configuracion->fichero_panel : $fichero_panel;
        $ruta_fichero = Theme::findFile($fichero_panel . '.php');
        if ($ruta_fichero != NULL) {
            //No hacemos nada de esto si no existe el fichero
            //hacemos el include del fichero en cuestión
            include($ruta_fichero);
        }
    }
}

function guardar_modificaciones_direccion_envio($opciones = NULL) {
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <input type="button" name="enviar" class="boton" value="<?= traducir("Guardar"); ?>" onClick="modificaDireccionEnvio(this, <?= Usuario::logueado()->codigo; ?>);"/>
        <input type="button" name="cancelar" class="boton" value="<?= traducir("Cancelar"); ?>" onClick="cancelarModificaDireccionEnvio(this);"/>
    </div>
    <?php
}

function botones_mod_borrar_direccion_envio($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos las opciones cómo siempre
    $obj_direccion_envio = NULL;
    $usuario = Usuario::logueado();
    $fichero_dir_predeterminada = 'direccion_envio';
    if (is_a($opciones, 'OpcionesWidget')) {
        $obj_direccion_envio = ($opciones->configuracion->obj_direccion_envio !== NULL) ? $opciones->configuracion->obj_direccion_envio : $obj_direccion_envio;
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_dir_predeterminada = ($opciones->configuracion->fichero_dir_predeterminada !== NULL) ? $opciones->configuracion->fichero_dir_predeterminada : $fichero_dir_predeterminada;
    }
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if ((is_a($usuario, 'Usuario')) && (is_a($obj_direccion_envio, 'Direcciones'))) {
        ?>
         <div class="<?= (__FUNCTION__); ?>">
          <?php
              //Las opciones de borrar y modificar sólo se muestran cuando no es la dirección de registro
              if ($obj_direccion_envio->codigo > 0) {
                  ?>
                    <input type="button" name="modificar" class="boton" value="<?= traducir('Modificar'); ?>" onClick="mostrarModificarDireccionEnvio(this);"/>
                    <input type="button" name="borrar" class="boton" value="<?= traducir('Borrar'); ?>" onClick="borrarDireccionenvio(this, <?= Usuario::logueado()->codigo; ?>);"/>
                <?php
              }else{
                ?>
                <p class="aclaracion_direcciones"><?= traducir('Esta es su dirección de registro. Para modificarla acceda a su area privada.'); ?></p>
                <?php
              }
        ?>
            <input type="button" name="seleccionar" class="boton" value="<?= traducir('Seleccionar'); ?>" onClick="seleccionarDireccionEnvio(this, <?= Usuario::logueado()->codigo; ?>, <?= $obj_direccion_envio->codigo; ?>, '<?= $fichero_dir_predeterminada; ?>');"/>
          </div>
        <?php
    }
    }


function addDatoDireccion($opciones = NULL) {
       $disabled= false;
    if (is_a($opciones, 'OpcionesWidget') ){
        $disabled = ($opciones->configuracion->disabled != NULL)? $opciones->configuracion->disabled: false;
        }
    ?>
    <input type="button" class="boton" value="+" onclick="cloneCampo($(this))" <?= ($disabled)?'disabled':''; ?>/>
    <?php
}
function deleteCampo($opciones = NULL) {
    $disabled= false;
    if (is_a($opciones, 'OpcionesWidget') ){
        $disabled = ($opciones->configuracion->disabled != NULL)? $opciones->configuracion->disabled: false;
        }
    ?>
    <input type="button" class="boton" value="-"  onclick="deleteCampo($(this))" <?=($disabled)? 'disabled':''; ?>/>

<?php

}
?>