<?php

//---------------------------------------------------------------------------------------------------------
// 08/Octubre/2014
// Versión 1.0 Este php contiene la función encargada de mostrar la miga según el caso
//---------------------------------------------------------------------------------------------------------
// 16/Octubre/2014
// Versión 2.0 Creamos esta opcion web como widget. Se pasa como parámetro la función a ejecutar (el tipo de objeto que queremos crear)
//---------------------------------------------------------------------------------------------------------



function widget_miga($nombre_funcion = 'muestra_miga') {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'muestra_miga';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function muestra_miga($separador = ' <span>&gt;</span> ') {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if (($separador != NULL) && (is_a($separador, "OpcionesWidget"))) {
        $opciones = $separador;
        $separador = ' <span>&gt;</span> ';
        if (is_a($opciones, 'OpcionesWidget')) {
            $separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $txt_miga = '';
    //Vamos a calcular la miga del escaparate actual
    if ($escaparate_actual != NULL) {
        //Estamos en una búsqueda
        $escaparate_actual->carga_miga();
        $txt_miga = extraer_miga($escaparate_actual, $separador);
    } else {
        $txt_miga = '<a href="javascript:void(0);" title="' . $title_web . '">' . $title_web . '</a>';
    }
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>"><?= $txt_miga; ?></div>
        <?php
    }
    ?>
    <?php
    return(true);
}

//---------------------------------------------------------------------------------------------------------
//Esta función genera la miga de forma recursiva conun formato determinado.
//Si llegado el momento necesitamos otro formato, hay que crear otra funció o parametrizar esta
//---------------------------------------------------------------------------------------------------------
function extraer_miga($escaparate, $separador = " <span>&gt;</span> ") {
    //Esta función carga el escaparate padre y se ejecuta recursivamente. Por último añade a la miga obtenida si propio enlace
    //Se hace en este orden para mostrar siempre del padre más alto al hijo
    $lista_enlaces_miga = '';
    if ($escaparate->padre != NULL) {
        if ($escaparate->padre->codigo > 0) {
            $lista_enlaces_miga = extraer_miga($escaparate->padre, $separador);
        }
    }
    return($lista_enlaces_miga . ( ($lista_enlaces_miga != '') ? $separador : '' ) . '<a href="' . $escaparate->url . '" title="' . $escaparate->title_seo . '">' . $escaparate->nombre_seo . '</a>');
}
?>