<?php

//---------------------------------------------------------------------------------------------------------
// 04/Febrero/2015
// Versión 1.0 Widget que muestra los enlaces de las redes sociales
//---------------------------------------------------------------------------------------------------------



function widget_redes_sociales() {
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'redes_sociales';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function redes_sociales($opciones = NULL, $segundoParametro = NULL, $tercerParametro = NULL) {
    include('comunes/globals.php');
    //Si el primer parámetro que recibimos no es uno opciones widget, entonces vamos a llamar a la función "old"
    if (($opciones != NULL) && (!is_a($opciones, 'OpcionesWidget'))) {
        redes_sociales_old($opciones, $segundoParametro, $tercerParametro);
    } else {
        if ($opciones == NULL){
            $opciones = new OpcionesWidget();
        }
        $ficheroRedSocial = 'itemSocialMedia';
        $ocultarCabecera = false;
        $extraParams = NULL;
        if (is_a($opciones, 'OpcionesWidget')) {
            $ficheroRedSocial = ($opciones->configuracion->ficheroRedSocial != NULL) ? $opciones->configuracion->ficheroRedSocial : $ficheroRedSocial;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
            $extraParams = ($opciones->configuracion->extraParams != NULL) ? $opciones->configuracion->extraParams : $extraParams;
        }

        $ficheroCargar = Theme::findFile($ficheroRedSocial . '.php');
        if ($ficheroCargar != NULL) {
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>"><!--Carrusel-->
                    <?php
                }
                $sentencia_sql = 'SELECT nombre, url, imagen FROM redes_sociales';
                if ($conexionBD) {
                    if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                        while ($fila = mysqli_fetch_array($resultado)) {
                            $nombre = $fila['nombre'];
                            $url = $fila['url'];
                            $imagen = $fila['imagen'];
                            include($ficheroCargar);
                        }
                    }
                }
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
        }
    }
    ?>
    <?php
}

function redes_sociales_old($mostrar_imagen = true, $texto_anterior = '', $texto_posterior = '') {
    include('comunes/globals.php');
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <?php
        //Vamos a cargar las redes sociales disponibles
        $sentencia_sql = 'SELECT nombre, url, imagen FROM redes_sociales';
        $buscar = array(' ', '+', '*', "'");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    ?>
                    <div class="<?= $bodytag = str_replace($buscar, '_', $fila['nombre']); ?>">
                        <a href="<?= $fila['url']; ?>" target="_blank" title="<?= $fila['nombre']; ?>">
                            <?= $texto_anterior; ?>
                            <?php
                            if ($mostrar_imagen) {
                                ?>
                                <img src="<?= Shop::$configuracion->url; ?>almacen_img/<?= $fila['imagen']; ?>" alt="<?= $fila['nombre']; ?>"/>
                                <?php
                            } else {
                                ?>
                                <strong><?= $fila['nombre']; ?></strong>
                                <?php
                            }

                            echo $texto_posterior;
                            ?>
                        </a>
                    </div>
                    <?php
                }
            }
        }
        ?>
    </div>
    <?php
}
?>