<?php
/*
*	Definición de constantes que necesita webStore
*	@version 1.0.0
*	@date 2019/02/07
*
*/

//Como el usuario puede definir estos elementos, comprobamos siempre que existan

//Constantes que necesito en la clase de sesión
if (!defined('PALABRA')){
	define('PALABRA', 'webStore');
}
if (!defined('TIEMPO_VIDA_SESION')){
	define('TIEMPO_VIDA_SESION', '10 DAY');
}
//Indicamos si hay que comprimir la página
if (!defined('_WS_COMPRESS_FULL')){
	define('_WS_COMPRESS_FULL', false);	//Esto luego hay que cambiarlo
}
//La carpeta dónde están los estilos y scripts de la plantilla va aquí:
if (!defined('_WS_CSS_FOLDER')){
	define('_WS_CSS_FOLDER', 'css/');	//Esto luego hay que cambiarlo
}
if (!defined('_WS_JS_FOLDER')){
	define('_WS_JS_FOLDER', 'js/');	//Esto luego hay que cambiarlo
}

//Librería utilizada para enviar emails
if (!defined('_WS_EMAIL_LIB')){
	define('_WS_EMAIL_LIB', 'PHPMailer');
}

//Resto de variables imprescindibles de webStore
//Directorios principales:
define('_WS_DIR_', str_replace('core/', '', _WS_CORE_DIR_));
define('_WS_INDEX_DIR_', realpath(dirname($_SERVER["SCRIPT_FILENAME"])) . '/');

//Necesito ver cuantos saltos hacia atrás y hacia delante hay que dar para llegar desde el index que lo carga todo hasta el core de webStore:
$jump = '';
$jumping = true;
$root_path = explode(DIRECTORY_SEPARATOR , _WS_DIR_);
//limpiamos el array:
//Pedro 08/Mayo/2019 ==> Aplicamos un array values después del filtro para que los índices del array vayan correlativos desde el número 0
$root_path = array_values(array_filter($root_path));
$index_path = explode(DIRECTORY_SEPARATOR , _WS_INDEX_DIR_);
$index_path = array_values(array_filter($index_path));
$limite = min(count($root_path), count($index_path));

for($i = 0; ($i < ($limite)) && ($jumping); $i++){
	//Recorremos ambos arrays para quitar la parte izquierda que sobre:
	if ($root_path[$i] != $index_path[$i]){
		//echo("rompemos en $i\n");
		$jumping = false;
	}
}
//Si al llegar aquí, $i != $limite, es porque no podemos seguir saltando, hay que tener en cuenta que $i se ha incrementado en 1:
$limite = min($i, $limite);
//Cortamos ambos arrays para quitarles ese elemento:
$root_path = array_slice($root_path, $limite);
$index_path = array_slice($index_path, $limite);
//De aquí en adelante, lo que tenga en root path es ruta hacia delante, y lo que tenga en index, es hacia atrás:
$final_path = str_repeat('../', count($index_path)) . implode(DIRECTORY_SEPARATOR , $root_path);
$final_path .= (substr($final_path, -1) != '/') ? '/' : '';	//SIempre tiene que terminar el "/"
define('_WS_FROM_INDEX_TO_ROOT_', $final_path);

if (!defined('_WS_GLOBAL_DYNAMIC_DIR_')){
	define('_WS_GLOBAL_DYNAMIC_DIR_', _WS_DIR_ . 'dynamic/');
}
//Si no existe el directorio, lo vamos a crear:
if (!is_dir(_WS_GLOBAL_DYNAMIC_DIR_)) {
	@mkdir(_WS_GLOBAL_DYNAMIC_DIR_);
}
//Elementos del core:
define('_WS_LIB_DIR_', _WS_CORE_DIR_ . 'lib/');
define('_WS_REQUIRED_DIR_', _WS_CORE_DIR_ . 'required/');
define('_WS_CLASSES_DIR_', _WS_CORE_DIR_ . 'classes/');
define('_WS_CONTROLLERS_DIR_', _WS_CORE_DIR_ . 'controllers/');
define('_WS_OVERRIDE_DIR_', _WS_DIR_ . 'override/');
define('_WS_SINCRO_DIR_', _WS_DIR_ . 'sincronizacion/');
define('_WS_MODULES_DIR_', _WS_DIR_ . 'modules/');

//Variables a utilizar:
//Tipos de medios
define('_WS_MEDIA_TYPE_CSS', 'css');
define('_WS_MEDIA_TYPE_JS', 'js');
//Posicion para los medios
define('_WS_MEDIA_POSITION_BOTTOM', 'bottom');
define('_WS_MEDIA_POSITION_TOP', 'top');

//Tipos de compresores js/css
define('_WS_JSHRINK_COMPRESSOR', 'jshrink');
define('_WS_JSQUEEZE_COMPRESSOR', 'jsqueeze');
define('_WS_MINIFY_COMPRESSOR', 'minify');
define('_WS_PHPWEE_COMPRESSOR', 'phpwee');


//Relativos a la plantilla actual
if (!defined('_WS_THEMES_DIR_')){
	define('_WS_THEMES_DIR_', 'themes/');
}

if (!defined('_WS_THEME_DIR_')){
	define('_WS_THEME_DIR_', 'default/');
}

if (defined('_WS_THEME_DIR_')){
	//Carpetas que dependen del tema:
	define('_WS_THEME_SECTION_DIR_', _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . 'sections/');
	//Carpeta dónde echar la caché del tema:
	define('_WS_DYNAMIC_DIR_', _WS_GLOBAL_DYNAMIC_DIR_ . crc32(_WS_THEMES_DIR_ . _WS_THEME_DIR_) . '/');
	//Si no existe el directorio, lo vamos a crear:
	if (!is_dir(_WS_DYNAMIC_DIR_)) {
		@mkdir(_WS_DYNAMIC_DIR_);
		//echo(_WS_DYNAMIC_DIR_ . "\n");
		/*if ($file = fopen(_WS_DIR_ . 'test.txt', 'a+')){
			fputs($file, '----' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . "-----\n" . 'Nos da el resultado: ' . _WS_DYNAMIC_DIR_ . "\n");
			fclose($file);
		}*/
	}
	define('_WS_THEME_OVERRIDE_DIR_', _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . 'override/');
}

if (!defined('_WS_THEME_HTML_DIR_')){
	define('_WS_THEME_HTML_DIR_', 'html_files/'); 
}
if (defined('_WS_THEME_HTML_DIR_') && ! defined('_WS_THEME_RESOURCE_DIR_')){
	//Ojo que los resources se llamarán desde la web, por tanto se llamarán desde el index. Es necesario añadir la variable de correción de ruta "_WS_FROM_INDEX_TO_ROOT_"
	define('_WS_THEME_RESOURCE_DIR_', _WS_FROM_INDEX_TO_ROOT_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_);
}

if (!defined('_WS_UPLOAD_DIR_')){
	define('_WS_UPLOAD_DIR_', 'upload/');
}
if (!defined('_WS_UPLOAD_IMAGES_DIR_')){
	define('_WS_UPLOAD_IMAGES_DIR_', _WS_UPLOAD_DIR_ . 'img/');
}
?>