<?php

/*
  Class SuperAlbaran
 */
 
class SuperAlbaran extends Objeto{
    public $codigo = 0;
    public $num_doc = 0;
    public $cliente = 0;
	public $objeto_cliente = NULL;
    public $tipo_doc = '';
    public $nombre_tipo_doc = '';
    public $factura = 0;
	public $objetoFactura = NULL;
    public $fecha = 0;
    public $fecha_date_format = 0;
    public $hora = 0;
    public $iva1 = 0;
    public $iva2 = 0;
    public $iva3 = 0;
    public $iva4 = 0;
    public $recargo = 0;
    public $recargo1 = 0;
    public $recargo2 = 0;
    public $recargo3 = 0;
    public $recargo4 = 0;
    public $bruto1 = 0;
    public $bruto2 = 0;
    public $bruto3 = 0;
    public $bruto4 = 0;
    public $base1 = 0;
    public $base2 = 0;
    public $base3 = 0;
    public $base4 = 0;
    public $imp_iva1 = 0;
    public $imp_iva2 = 0;
    public $imp_iva3 = 0;
    public $imp_iva4 = 0;
    public $imp_recargo1 = 0;
    public $imp_recargo2 = 0;
    public $imp_recargo3 = 0;
    public $imp_recargo4 = 0;
    public $total_albaran = 0;
    public $cantidad = 0;
    public $lineas_albaran = array();

	public static function getCampos($soloPrincipal = NULL){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//self::$campos_tabla = BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				$campos .= BaseDatos::dameCamposAlias(self::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' )
				. Usuario::getCampos();
			}
			if ($soloPrincipal == NULL){
				self::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= self::$nombreTabla . ' as `' .  self::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= self::getJoin('Albaran', 'cliente', 'Usuario', 'codigo');	//Queremos esta tabla con la de artículo
			$consulta .= Usuario::getNombreTabla(false);							//Cogemos los left join de artículo
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			self::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_albaran = isset($argumentos[0]) ? $argumentos[0] : 0;
		$usuario = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		include('comunes/globals.php');
		self::$whereSelect = '';
		
		if ($codigo_albaran > 0) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`codigo` = ' . $codigo_albaran . ' ';
		}
		if ($usuario !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`cliente` = ' . $usuario . ' ';
		}		
		if ($limitar){
			self::$whereSelect .= ' LIMIT 1 ';
		}
		return(self::$whereSelect);
	}
	
	function __construct($codigo_albaran = 0, $crear_objetos_linea = false, $crear_objetos_articulo = false, $crear_objeto_cliente = false, $extraer_datos_cabecera = false) {
		$opciones = new OpcionesWidget();
		$objetoFactura = NULL;
		$filaAlbaran = NULL;
		if ($codigo_albaran != NULL){
			if (is_a($codigo_albaran, 'OpcionesWidget')){
				$opciones = $codigo_albaran;
				$codigo_albaran = ($opciones->configuracion->codigo_albaran != NULL) ? $opciones->configuracion->codigo_albaran : $codigo_albaran;
				$extraer_datos_cabecera = ($opciones->configuracion->extraer_datos_cabecera != NULL) ? $opciones->configuracion->extraer_datos_cabecera : $extraer_datos_cabecera;
				$crear_objetos_articulo = ($opciones->configuracion->crear_objetos_articulo != NULL) ? $opciones->configuracion->crear_objetos_articulo : $crear_objetos_articulo;
				$crear_objeto_cliente = ($opciones->configuracion->crear_objeto_cliente != NULL) ? $opciones->configuracion->crear_objeto_cliente : $crear_objeto_cliente;
				$filaAlbaran = ($opciones->configuracion->filaAlbaran != NULL) ? $opciones->configuracion->filaAlbaran : $filaAlbaran;
				$objetoFactura = ($opciones->configuracion->objetoFactura != NULL) ? $opciones->configuracion->objetoFactura : $objetoFactura;
			}
		}
		$fila = NULL;
		if ($filaAlbaran != NULL){
			$fila = $filaAlbaran;
		}else{
			if (intval($codigo_albaran) > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
							FROM ' . self::getNombreTabla() . '
							WHERE ' . self::getWhereTabla($codigo_albaran);

				//echo("$sentencia_sql <br />\n");

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}
		
		if ($fila != NULL) {
			$this->extractData($fila);
		}
	
		//Vamos a ver si nos han pasado un objeto pedido y lo cargamos
		if (is_a($objetoFactura, 'Factura') ){
			$this->objetoFactura = $objetoFactura;
		}else if ($extraer_datos_cabecera) {
			$this->objetoFactura = new Factura($this->factura, false, false, false, false);
		}
		
		//Si no tenemos artículo y nos han dicho que lo cargemos, vamos a crearlo con el código del mismo:
		if (!isset($this->objeto_cliente)){
			$this->objeto_cliente = new Usuario($this->cliente);
		}
		
		//Si se quieren crear las líneas, vamos a ello:
		if ($crear_objetos_linea){
			
		}
	}
	
	public function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->num_doc = $this->getProp($fila, 'num_doc');
		$this->cliente = $this->getProp($fila, 'cliente');;
		$this->objeto_cliente = new Usuario(new OpcionesWidget(array('filaUsuario' => $fila)));
		$this->tipo_doc = $this->getProp($fila, 'tipo_doc');
		$this->nombre_tipo_doc = $this->getProp($fila, 'nombre_tipo_doc');
		$this->factura = $this->getProp($fila, 'factura');
		$this->fecha = $this->getProp($fila, 'fecha');
		$this->fecha_date_format = date_create($this->fecha);
		$this->hora = $this->getProp($fila, 'hora');
		$this->iva1 = $this->getProp($fila, 'iva1');
		$this->iva2 = $this->getProp($fila, 'iva2');
		$this->iva3 = $this->getProp($fila, 'iva3');
		$this->iva4 = $this->getProp($fila, 'iva4');
		$this->recargo = $this->getProp($fila, 'recargo');
		$this->recargo1 = $this->getProp($fila, 'recargo1');
		$this->recargo2 = $this->getProp($fila, 'recargo2');
		$this->recargo3 = $this->getProp($fila, 'recargo3');
		$this->recargo4 = $this->getProp($fila, 'recargo4');
		$this->bruto1 = $this->getProp($fila, 'bruto1');
		$this->bruto2 = $this->getProp($fila, 'bruto2');
		$this->bruto3 = $this->getProp($fila, 'bruto3');
		$this->bruto4 = $this->getProp($fila, 'bruto4');
		$this->base1 = $this->getProp($fila, 'base1');
		$this->base2 = $this->getProp($fila, 'base2');
		$this->base3 = $this->getProp($fila, 'base3');
		$this->base4 = $this->getProp($fila, 'base4');
		$this->imp_iva1 = $this->getProp($fila, 'imp_iva1');
		$this->imp_iva2 = $this->getProp($fila, 'imp_iva2');
		$this->imp_iva3 = $this->getProp($fila, 'imp_iva3');
		$this->imp_iva4 = $this->getProp($fila, 'imp_iva4');
		$this->imp_recargo1 = $this->getProp($fila, 'imp_recargo1');
		$this->imp_recargo2 = $this->getProp($fila, 'imp_recargo2');
		$this->imp_recargo3 = $this->getProp($fila, 'imp_recargo3');
		$this->imp_recargo4 = $this->getProp($fila, 'imp_recargo4');
		$this->total_albaran = $this->getProp($fila, 'total_albaran');
	}
	
    /*function __construct($codigo = 0, $crear_objetos_linea = false, $crear_objetos_articulo = false, $crear_objeto_cliente = false) {
        include('comunes/globals.php');
        //Cargamos todos los datos del albaran
        $sentencia_sql = "SELECT cab_albaran.codigo, num_doc, cliente.codigo cliente, tipo_doc, nombre_tipo_doc, factura, fecha, hora, 
							iva1, iva2, iva3, iva4, 
							recargo, recargo1, recargo2, recargo3, recargo4, 
							bruto1, bruto2, bruto3, bruto4, 
							base1, base2, base3, base4, 
							imp_iva1, imp_iva2, imp_iva3, imp_iva4, 
							imp_recargo1, imp_recargo2, imp_recargo3, imp_recargo4, 
							total_albaran
						FROM cliente, cab_albaran 
						WHERE cab_albaran.codigo = $codigo 
						AND cab_albaran.cliente = cliente.codigo_sinlib";
        //echo("$sentencia_sql<br />\n");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->num_doc = $fila['num_doc'];
                    $this->cliente = ($crear_objeto_cliente) ? new Usuario($fila['cliente']) : NULL;
                    $this->tipo_doc = $fila['tipo_doc'];
                    $this->nombre_tipo_doc = $fila['nombre_tipo_doc'];
                    $this->factura = $fila['factura'];
                    $this->fecha = $fila['fecha'];
                    $this->fecha_date_format = date_create($this->fecha);
                    $this->hora = $fila['hora'];
                    $this->iva1 = $fila['iva1'];
                    $this->iva2 = $fila['iva2'];
                    $this->iva3 = $fila['iva3'];
                    $this->iva4 = $fila['iva4'];
                    $this->recargo = $fila['recargo'];
                    $this->recargo1 = $fila['recargo1'];
                    $this->recargo2 = $fila['recargo2'];
                    $this->recargo3 = $fila['recargo3'];
                    $this->recargo4 = $fila['recargo4'];
                    $this->bruto1 = $fila['bruto1'];
                    $this->bruto2 = $fila['bruto2'];
                    $this->bruto3 = $fila['bruto3'];
                    $this->bruto4 = $fila['bruto4'];
                    $this->base1 = $fila['base1'];
                    $this->base2 = $fila['base2'];
                    $this->base3 = $fila['base3'];
                    $this->base4 = $fila['base4'];
                    $this->imp_iva1 = $fila['imp_iva1'];
                    $this->imp_iva2 = $fila['imp_iva2'];
                    $this->imp_iva3 = $fila['imp_iva3'];
                    $this->imp_iva4 = $fila['imp_iva4'];
                    $this->imp_recargo1 = $fila['imp_recargo1'];
                    $this->imp_recargo2 = $fila['imp_recargo2'];
                    $this->imp_recargo3 = $fila['imp_recargo3'];
                    $this->imp_recargo4 = $fila['imp_recargo4'];
                    $this->total_albaran = $fila['total_albaran'];
                }
            }
            //Ahora vamos con las líneas
            if ($crear_objetos_linea) {
                $this->cargar_lineas($crear_objetos_articulo);
            }
        }
        $this->cantidad = $this->get_cant_total();
    }*/

    function __destruct() {
        unset($this->codigo);
        unset($this->num_doc);
        unset($this->cliente);
        unset($this->tipo_doc);
        unset($this->nombre_tipo_doc);
        unset($this->factura);
        unset($this->fecha);
        unset($this->hora);
    }
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }
	function cargar_lineas($crear_objetos_articulo = false) {
        include('comunes/globals.php');
        $sentencia_sql = "SELECT codigo FROM lin_albaran WHERE cab_albaran = " . $this->codigo;
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                $this->lineas_albaran[count($this->lineas_albaran)] = new LineaAlbaran($fila['codigo'], $this->codigo, $crear_objetos_articulo);
            }
        }
    }

    function cargar_objeto_articulo_linea() {
        foreach ($lineas_albaran as $clave => $valor) {
            $valor->cargar_objeto_articulo();
        }
    }

    function get_cant_total() {
        include('comunes/globals.php');
        $cantidad = 0;
        if ($this->codigo > 0) {
            $sentencia_sql = "SELECT SUM( cantidad ) total FROM lin_albaran WHERE cab_albaran = " . $this->codigo;
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $cantidad = $fila['total'];
                }
            }
        }
        return($cantidad);
    }

}

?>