<?php
/*
	Clase SuperBanner
	// Editado por Tomás añadido el campo target.
	//Editado por Pedro para añadir la clase BaseDatos
*/

class SuperBanner extends Objeto{
	
	public static $nombreTabla = 'banner';
	public static $alias = 'banner';
	
	
	public $codigo = 0;
	public $posicion = 0;
	public $orden = 0;
	public $url = '';
	public $titulo = '';
	public $imagen = '';
	public $ruta = '';
	public $activo = 0;
	public $condicion = '';
	private $rutaBase = _WS_UPLOAD_IMAGES_DIR_;
	public $target = '_blank';
	public $idioma = '';
	
	function __construct($codigo = 0){
		//08/Mayo/2019 ==> Hay que inicualizar los campos en la lista de campos de la tabla sólo si no está inicializada:
		if (empty(static::$publicFieldList)){
			$this->initPublicFields();
		}
		//include('comunes/globals.php');
		$filaBanner = NULL;
		if (is_a($codigo, 'OpcionesWidget')){
			$params = $codigo;
			$codigo = ($params->configuracion->codigo != null) ? $params->configuracion->codigo : 0;
			$filaBanner = ($params->configuracion->filaBanner != null) ? $params->configuracion->filaBanner : $this->filaBanner;
		}
		
		$fila = NULL;
		if ($filaBanner == NULL){
			//Cargamos los datos que necesitamos del banner
			//$sentencia_sql = 'SELECT codigo, posicion, orden, url, titulo, imagen, activo, condicion, target FROM banner WHERE codigo = ' . $codigo;
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
								FROM ' . self::getNombreTabla() . '
								WHERE ' . self::getWhereTabla($codigo, true);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaBanner;
		}
		if ($fila != NULL){
			$this->extractData($fila);
		}
	}
	
	private function extractData($fila){
		$imagen = $this->getProp($fila, 'imagen');
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->posicion = $this->getProp($fila, 'posicion');
		$this->orden = $this->getProp($fila, 'orden');
		$this->url = $this->getProp($fila, 'url');
		$this->titulo = $this->getProp($fila, 'titulo');
		$this->ruta = $this->getProp($fila, 'imagen');
		$imagen = $this->rutaBase . $this->getProp($fila, 'imagen');
		$this->imagen = Shop::$configuracion->url . $imagen;
		$this->activo = $this->getProp($fila, 'activo');
		$this->condicion = $this->getProp($fila, 'condicion');
		$this->target = $this->getProp($fila, 'target');
		$this->idioma = $this->getProp($fila, 'idioma');
	}
	
	function __destruct() {
        unset($this->codigo);
        unset($this->posicion);
        unset($this->orden);
        unset($this->url);
		unset($this->ruta);
        unset($this->titulo);
        unset($this->imagen);
        unset($this->activo);
        unset($this->condicion);
        unset($this->target);
    }
	
	/*public function initPublicFields(){	//El banner tiene todos sus campos públicos
		//En esta función se deben de poner los nombres de los campos en la tabla
		//Sólo pondremos aquellos campos a los que les vamos a dar acceso al usuario
		$publicFieldList = array();
		$publicFieldList[] = 'posicion';
		$publicFieldList[] = 'orden';
		$publicFieldList[] = 'url';
		$publicFieldList[] = 'ruta';
		$publicFieldList[] = 'titulo';
		$publicFieldList[] = 'imagen';
		$publicFieldList[] = 'condicion';
		$publicFieldList[] = 'target';
		static::$publicFieldList = $publicFieldList;
	}*/
	public static function getCampos(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			//include('comunes/diccionario/diccionario.php');
			//self::$campos_tabla = BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'};
			self::$campos_tabla = BaseDatos::dameCampos(self::$nombreTabla);
			//self::$camposSelect = BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}, self::getAlias()) . ' ';
			self::$camposSelect = BaseDatos::dameCamposAlias(self::$nombreTabla) . ' ';
		}
		return(self::$camposSelect);
	}
	
	public static function getNombreTabla(){
		$idioma = WSLocale::$idioma;
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Vamos a simplificar, cogemos el nombre de la tabla usando la función de la clase padre:
		self::$nombreTabla = self::$nombreTabla . ' `' .  self::getAlias() . '`  ';
		return(self::$nombreTabla);
	}  
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		$ruta = isset($argumentos[2]) ? $argumentos[2] : NULL;	//Para que no haya problemas con las viejas llamadas, los nuevos parámetros van aquí:
		$posicion = isset($argumentos[3]) ? $argumentos[3] : NULL;	//Para que no haya problemas con las viejas llamadas, los nuevos parámetros van aquí:
		$activo = isset($argumentos[4]) ? $argumentos[4] : NULL;	//Para que no haya problemas con las viejas llamadas, los nuevos parámetros van aquí:
		$condicion = isset($argumentos[5]) ? $argumentos[5] : NULL;	//Para que no haya problemas con las viejas llamadas, los nuevos parámetros van aquí:
		$idioma = isset($argumentos[6]) ? $argumentos[6] : NULL;	//Para que no haya problemas con las viejas llamadas, los nuevos parámetros van aquí:
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		if ($codigo != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`codigo` = "' . $codigo . '" ';
		}
		if ($ruta != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`imagen` = "' . $ruta . '" ';
		}
		if ($posicion != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`posicion` = "' . $posicion . '" ';
		}
		if ($activo != NULL) {
			$activo = ($activo) ? '1' : '0';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`activo` = "' . $activo . '" ';
		}
		if ($condicion != NULL) {
			//Si recibimos una cadena vamos a hacer un filtrado normal:
			if (is_string($condicion)){
				self::$whereSelect .= ' `' . self::getAlias() . '`.`condicion` = "' . $condicion . '" ';
			}else{
				//En caso contrario la cosa puede ser más compleja. Lo normal es que recibamos un objeto con la consulta anidada:
				
			}
		}
		if ($idioma != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`idioma` = "' . $idioma . '" ';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 1 ';
		}
		return(self::$whereSelect);
	}

	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }
	
	public static function loadList($filter = NULL){
		$retorno = array();
		//Si no mandamos filtro, miramos a ver si hay alguno en la sesión
		/*if ($filter == NULL){
			$filter = Sesion::get('bannerFilter', '{}');
		}*/
		//28/Marzo/2019 ==> Cambiamos esta función para que use el where array:
		$whereTabla = ' 1 ';
		if (is_array($filter)){
			if (count($filter) > 0){
				$whereTabla = self::getWhereTablaArray( $filter );
			}
		}
		/*//Vamos a extraer los campos por los que filtrar la lista de banners:
		$posicion = (isset($filter->posicion)) ? $filter->posicion : NULL;
		$activo = (isset($filter->activo)) ? $filter->activo : NULL;
		$condicion = (isset($filter->condicion)) ? $filter->condicion : NULL;
		$idioma = (isset($filter->idioma)) ? $filter->idioma : NULL;

		//Vamos a obtener el filtro:
		$whereTabla = self::getWhereTabla(NULL, false, NULL, $posicion, $activo, $condicion, $idioma);
		if (is_string($filter)){
			$whereTabla = $filter;
		}else{
			//. self::getWhereTablaArray( $condition );
			$filter = json_decode($filter);
		}*/
		
		$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
								FROM ' . self::getNombreTabla() . ( ($whereTabla != '') ? ' WHERE ' . $whereTabla : '');
		//echo("$sentencia_sql\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while($fila = $bd->getFila()){
				$retorno[]= new Banner(new OpcionesWidget(array('filaBanner' => $fila)));
			}
		}

		return($retorno);
	}
	
	public static function removeImage($fileName){
		//En $fileName tenemos el nombre de la imagen junto con la ruta a seguir para llegar.
		$retorno = false;
		$codigoBanner = 0;
		if ($fileName != ''){
			$fileName = str_replace(_WS_UPLOAD_IMAGES_DIR_, '', $fileName);
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
										FROM ' . self::getNombreTabla() . '
										WHERE ' . self::getWhereTabla(NULL, true, $fileName);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				if(!$fila = $bd->getFila()){
					//Podemos eliminar el banner por completo:
					//Si el fichero viene con la ruta de subida, hay que quitarla:
					$ruta_fichero = realpath(_WS_UPLOAD_IMAGES_DIR_) . '/' . $fileName;
					if (file_exists($ruta_fichero)){
						@unlink($ruta_fichero);
						$retorno = true;
					}
				}
			}
		}
		return($retorno);
	}

	/*public static function showImage($options){
		$templateFile = 'simple_img.php';
		$img_name = '';
		if (is_a($options, 'OpcionesWidget')){
			$templateFile = ($options->configuracion->templateFile != NULL) ? $options->configuracion->templateFile : $templateFile;
			$img_name = ($options->configuracion->img_name != NULL) ? $options->configuracion->img_name : $img_name;
			if ( ($img_name != '') && ($templateFile != '') ){
				$img_name = _WS_UPLOAD_IMAGES_DIR_ . $img_name;
				Theme::include_file($templateFile, $img_name);
			}
		}		
	}*/
	
	
	public static function remoteRemoveImage($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$retorno->resultado = self::removeImage($data->fileName);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
	
	public static function activateBanner($id, $active = 1){
		/*
		$sentencia_sql = 'UPDATE `banner` SET `activo` = ' . ( ($active == 1) ? '1' : '0' ) . '
						WHERE `codigo` = \'' . $id . '\';';
		//echo($sentencia_sql);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
		*/
		static::updateField($id, 'activo', $active);
		//Ahora vamos a comprobar el estado del banner y devolvemos el estado del mismo:
		$banner = new Banner($id);
		return($banner->activo);
	}
	
	public static function remoteActivateBanner($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$id = (isset($data->id)) ? $data->id : 0;
		$active = (isset($data->active)) ? $data->active : NULL;
		$retorno->resultado = self::activateBanner($id, $active);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
	
	
	/*public static function updateField($id, $fieldName, $value){
		$sentencia_sql = 'UPDATE `banner` SET `' . $fieldName . '` = \'' . $value . '\'
						WHERE `codigo` = \'' . $id . '\';';
		//echo($sentencia_sql);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
		//Ahora vamos a comprobar el estado del banner y devolvemos el estado del mismo:
		$banner = new Banner($id);
		return($banner->$fieldName);
	}*/
	
	public static function remoteUpdateField($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$id = (isset($data->id)) ? $data->id : 0;
		$fieldName = (isset($data->fieldName)) ? $data->fieldName : 0;
		$value = (isset($data->value)) ? $data->value : 0;
		self::updateField($id, $fieldName, $value);
		$banner = new Banner($id);
		$retorno->resultado = $banner->$fieldName;

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
	
	
	public static function createBanner($fields){
		//Los campos son un array del tipo "nombre_campo" => "valor"
		if (is_array($fields)){
			if (count($fields) > 0){
				$campos = array_keys($fields);
				$campos = ' ( `' . implode('`, `', $campos) . '` ) ';
				$valores = ' ( \'' . implode('\', \'', $fields) . '\' ) ';
			}
		}
		$sentencia_sql = 'INSERT INTO `banner` ' . $campos . '
							VALUES ' . $valores;
		echo($sentencia_sql);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
		//Ahora vamos a comprobar el estado del banner y devolvemos el estado del mismo:
		$codigo = $bd->getAutonumerico();
		return($codigo);
	}
	public static function removeBanner($codigo){
		//Los campos son un array del tipo "nombre_campo" => "valor"
		$sentencia_sql = 'DELETE FROM `banner` WHERE codigo = ' . $codigo;
		//echo($sentencia_sql);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
		//Recargamos la página:
		Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
	}

}
?>