<?php

class SuperFormasPago extends Objeto{

    public $codigo = 0;
    public $nombre = '';
    public $descripcion = '';
    public $transferencia = 0;
    public $cuenta_bancaria = '';
    public $pasarela = 0;
    public $tipo_pasarela = 0;

	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		if ($codigo != NULL){
			self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = ' . $codigo . ' ';
		}
		return(self::$whereSelect);
	}
	
    function __construct($opciones = 0) {
		if (is_numeric($opciones)){
			$opciones = array('codigo' => $opciones);
		}
		$opciones = new ObOptions($opciones);
		$filaFormaPago = $opciones->getDefaultValue('filaFormaPago', NULL);
		$codigo = $opciones->getDefaultValue('codigo', NULL);

		$fila = NULL;
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaFormaPago == NULL){
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
							FROM `' . self::getNombreTabla() . '` `' . self::getAlias() . '`
							WHERE ' . self::getWhereTabla($codigo);
			/*
			$sentencia_sql = 'SELECT codigo, nombre, descripcion, transferencia, cuenta_bancaria, pasarela, tipo_pasarela '
					. 'FROM formas_de_pago '
					. 'WHERE codigo = '. $codigo;
			*/
			//echo("$sentencia_sql<br />\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaFormaPago;
		}

        if ($fila != NULL) {
			$this->codigo = $fila[self::getAlias() . '_codigo'];
			$this->nombre = $fila[self::getAlias() . '_nombre'];
			$this->descripcion = $fila[self::getAlias() . '_descripcion'];
			$this->transferencia = $fila[self::getAlias() . '_transferencia'];
			$this->cuenta_bancaria = $fila[self::getAlias() . '_cuenta_bancaria'];
			$this->pasarela = $fila[self::getAlias() . '_pasarela'];
			$this->tipo_pasarela = $fila[self::getAlias() . '_tipo_pasarela'];
        }
    }

	public static function formaPagoTodas(){
		$retorno = array();
		$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
						FROM `' . self::getNombreTabla() . '` `' . self::getAlias() . '` ';
		//echo("$sentencia_sql<br />\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($retorno, new FormasPago(new OpcionesWidget(array('filaFormaPago' => $fila))));
			}
		}
		return($retorno);
	}
	
    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->descripcion);
        unset($this->transferencia);
        unset($this->cuenta_bancaria);
        unset($this->pasarela);
        unset($this->tipo_pasarela);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>