<?php

class SuperLineaAlbaran extends Objeto {

    public $codigo = 0;
    public $cab_albaran = 0;
	public $objeto_albaran = NULL;
	public $articulo = 0;
    public $objeto_articulo = NULL;
    public $prensa = 0;
    public $cantidad = 0;
    public $descripcion = '';
    public $precio = 0;
    public $descuento = 0;
    public $importe = 0;
    public $iva = 0;
    public $ean = '';

	
	public static function getCampos($soloPrincipal = NULL){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//self::$campos_tabla = BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}, self::getAlias());
				$campos .= BaseDatos::dameCamposAlias(self::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' )
				. Articulo::getCampos();
			}
			if ($soloPrincipal == NULL){
				self::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= self::$nombreTabla . ' as `' .  self::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= self::getJoin('LineaAlbaran', 'articulo', 'Articulo', 'codigo'); //Queremos esta tabla con la de artículo
			$consulta .= Articulo::getNombreTabla(false);								//Cogemos los left join de artículo
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			self::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigoAlbaran = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$codigoLinea = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		$coma = '';
		if ($codigoAlbaran !== NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`cab_albaran` = "' . $codigoAlbaran . '" ';
			$coma = ' AND  ';
		}
		if ($codigoLinea !== NULL) {
			self::$whereSelect .= $coma . ' `' . self::getAlias() . '`.`codigo` = "' . $codigoLinea . '" ';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 1 ';
		}
		return(self::$whereSelect);
	}
	
    function __construct($codigo_linea = 0, $codigo_albaran = 0, $crear_objetos_articulo = false, $extraer_datos_cabecera = false) {
		$opciones = new OpcionesWidget();
		$objetoAlbaran = NULL;
		$filaLineaAlbaran = NULL;
		if ($codigo_albaran != NULL){
			if (is_a($codigo_albaran, 'OpcionesWidget')){
				$opciones = $codigo_albaran;
				$codigo_albaran = ($opciones->configuracion->codigo_albaran != NULL) ? $opciones->configuracion->codigo_albaran : $codigo_albaran;
				$codigo_linea = ($opciones->configuracion->codigo_linea != NULL) ? $opciones->configuracion->codigo_linea : $codigo_linea;
				$extraer_datos_cabecera = ($opciones->configuracion->extraer_datos_cabecera != NULL) ? $opciones->configuracion->extraer_datos_cabecera : $extraer_datos_cabecera;
				$crear_objetos_articulo = ($opciones->configuracion->crear_objetos_articulo != NULL) ? $opciones->configuracion->crear_objetos_articulo : $crear_objetos_articulo;
				$filaLineaAlbaran = ($opciones->configuracion->filaLineaAlbaran != NULL) ? $opciones->configuracion->filaLineaAlbaran : $filaLineaAlbaran;
				$objetoAlbaran = ($opciones->configuracion->objetoAlbaran != NULL) ? $opciones->configuracion->objetoAlbaran : $objetoAlbaran;
			}
		}
		$fila = NULL;
		if ($filaLineaAlbaran != NULL){
			$fila = $filaLineaAlbaran;
		}else{
			if (is_a($objetoAlbaran, 'Albaran')){
				$codigo_albaran = $objetoAlbaran->codigo;
			}
			if (intval($codigo_albaran) > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
							FROM ' . self::getNombreTabla() . '
							WHERE ' . self::getWhereTabla($codigo_albaran, $codigo_linea);

				//echo("$sentencia_sql <br />\n");

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}
		
		if ($fila != NULL) {
			$this->extractData($fila);
		}
	
		//Vamos a ver si nos han pasado un objeto pedido y lo cargamos
		if (is_a($objetoAlbaran, 'Albaran') ){
			$this->objeto_albaran = $objetoAlbaran;
		}else if ($extraer_datos_cabecera) {
			$this->objeto_albaran = new Albaran($this->codigoAlbaran, false, false, false);
		}
		
		//Si no tenemos artículo y nos han dicho que lo cargemos, vamos a crearlo con el código del mismo:
		if ( ($this->objeto_articulo->codigo == NULL) && ( $crear_objetos_articulo ) ){
			$this->objeto_articulo->codigo = new Articulo($this->articulo);
		}
    }

	public function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->cab_albaran = $this->getProp($fila, 'cab_albaran');
		$this->articulo = $this->getProp($fila, 'articulo');
		$this->objeto_articulo = new Articulo(new OpcionesWidget(array('filaArticulo' => $fila)));
		$this->prensa = $this->getProp($fila, 'prensa');
		$this->cantidad = $this->getProp($fila, 'cantidad');
		$this->descripcion = $this->getProp($fila, 'descripcion');
		$this->precio = $this->getProp($fila, 'precio');
		$this->descuento = $this->getProp($fila, 'descuento');
		$this->importe = $this->getProp($fila, 'importe');
		$this->iva = $this->getProp($fila, 'iva');
		$this->ean = $this->objeto_articulo->ean;
	}
	
    function cargar_objeto_articulo() {
        $this->objeto_articulo = new Articulo($this->articulo, NULL, 1, 0, true, true);
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->cab_albaran);
        unset($this->articulo);
        unset($this->prensa);
        unset($this->cantidad);
        unset($this->descripcion);
        unset($this->precio);
        unset($this->descuento);
        unset($this->importe);
        unset($this->iva);
        unset($this->objeto_articulo);
        unset($this->ean);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>