<?php

class SuperPedidoCliente extends Objeto{

    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $cliente = 0;
    public $nombre_legal = '';
    public $email = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $telefono = '';
    public $telefono2 = '';
    public $cif = '';
    public $pendiente_sinlib = 0;
    public $fecha = 0;
    public $fecha_date_format = 0;
    public $cadena_fecha = '';
    public $fecha_pago = 0;
    public $fecha_envio = 0;
    public $pagado = 0;
    public $referencia = '';
    public $enviado = 0;
    public $observaciones = '';
    public $tipo_envio = NULL;
    public $no_revisado = 1;
    public $pedido_preparado = 0;
    public $pais = 0;
    public $datos_facturacion = '';
    public $factura = 0;
    public $descuento = 0;
    public $envolver_regalo = 0;
    public $comercial = 0;
    public $g_envio = 0;
    public $forma_pago = 0;
    public $pendiente_paypal = 0;
    public $oculto = 0;
    public $forma_pago_nombre = '';
    public $tipo_envio_nombre = '';
    public $reembolso = 0;
    public $transferencia = 0;
    public $sin_pago = 0;
    public $cuenta_bancaria = '';
    public $cantidad_total = 0;
    public $cantidad_pendiente = 0;
    public $cantidad_reservada = 0;
    public $total_pvp = 0;
	public $base = 0;
    public $total_pvp_pendiente = 0;
    public $total_pvp_reservado = 0;
    public $total_pvp_con_dto = 0;
    public $total_pvp_con_dto_pendiente;
    public $total_pvp_con_dto_reservado = 0;
    public $importe_total = 0;
    public $importe_total_pendiente = 0;
    public $importe_total_reservado = 0;
    public $lineas = array();
    public $tipo_pasarela = 0;
	public $emailEnviado = false;
	
    private $flag_utf8 = false;

	public static function getCampos($soloPrincipal = NULL){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la select
		
		$campos = '';
		if (self::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}, self::getAlias());
				$campos .= BaseDatos::dameCamposAlias(self::$nombreTabla);

			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				/*$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{TraduccionArticulo::getNombreTabla() . 'Campos'}, TraduccionArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{SeoArticulo::getNombreTabla() . 'Campos'}, SeoArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{Familia::getNombreTabla() . 'Campos'}, Familia::getAlias());*/
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				BaseDatos::dameCamposAlias(TipoEnvioCliente::getNombreTablaSinAlias(true)) . ', ' .
				BaseDatos::dameCamposAlias(FormasPago::getNombreTablaSinAlias(true)) . ', ' .
				Usuario::getCampos();
			}
			if ($soloPrincipal == NULL){
				self::$camposSelect = $campos;
			}
		}
	
		return($campos);
	}

	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= self::$nombreTabla . ' as `' .  self::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= self::getJoin('PedidoCliente', 'cliente', 'Usuario', 'codigo'); 				//Cogemos el cliente
			$consulta .= self::getJoin('PedidoCliente', 'tipo_envio', 'TipoEnvioCliente', 'codigo');	//Cogemos el tipo de envío
			$consulta .= self::getJoin('PedidoCliente', 'forma_pago', 'FormasPago', 'codigo');	//Cogemos el tipo de envío
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			self::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_pedido_cliente = isset($argumentos[0]) ? $argumentos[0] : 0;
		$pagado = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$usuario = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$pendienteSinlib = isset($argumentos[3]) ? $argumentos[3] : NULL;
		include('comunes/globals.php');
		self::$whereSelect = '';
		
		if ($codigo_pedido_cliente > 0) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`codigo` = ' . $codigo_pedido_cliente . ' ';
		}
		if ($pagado !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`pagado` = ' . $pagado . ' ';
		}
		if ($pendienteSinlib !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`pendiente_sinlib` > 0 ';
		}
		if ($usuario !== NULL) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' . self::getAlias() . '`.`cliente` = \'' . $usuario . '\' ';
		}		
							
		return(self::$whereSelect);
	}
	
	
	
    function __construct($codigo_pedido_cliente = 0, $pagado = NULL, $con_detalle = true, $finalizado = NULL) {
		include('comunes/globals.php');
        $filaPedido = NULL;
		$opciones = NULL;
		if (is_a($codigo_pedido_cliente, 'OpcionesWidget')) {
			$opciones = $codigo_pedido_cliente;
			$codigo_pedido_cliente = ($opciones->configuracion->codigo_pedido_cliente != NULL) ? $opciones->configuracion->codigo_pedido_cliente : 0;
			$pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
			$con_detalle = ($opciones->configuracion->con_detalle != NULL) ? $opciones->configuracion->con_detalle : $con_detalle;
			$finalizado = ($opciones->configuracion->finalizado != NULL) ? $opciones->configuracion->finalizado : $finalizado;
			$filaPedido = ($opciones->configuracion->filaPedido != NULL) ? $opciones->configuracion->filaPedido : $filaPedido;
		}
		$fila = NULL;
		if ($filaPedido == NULL){
			$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
								FROM ' . self::getNombreTabla() . ' 
								WHERE ' . self::getWhereTabla($codigo_pedido_cliente, $pagado, NULL, NULL, $finalizado);
			//echo($sentencia_sql);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaPedido;
		}
		if ($fila != NULL){
			$this->extracData($fila);
		}
		//var_dump($this);
		
		//Ahora vamos con las líneas si lo queremos con detalle, claro
		if ($con_detalle) {
			$this->cargarDetalle();
		} else {
			//Cargamos las líneas pero no creamos los objetos
			$sentencia_sql = "SELECT pvp, cantidad, recibida, reservada, pvp_con_dto, importe_con_dto, iva, base FROM  ml_pedcli WHERE mc_pedcli = $codigo_pedido_cliente";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					$pendiente = $fila["cantidad"] - $fila['recibida'] - $fila['reservada'];
					$reservado = $fila['recibida'];
					$this->total_pvp += $fila['pvp'] * $fila['cantidad'];
					$this->total_pvp_pendiente += $fila['pvp'] * $pendiente;
					$this->total_pvp_reservado += $fila['pvp'] * $reservado;
					$this->total_pvp_con_dto += $fila['importe_con_dto'];
					$this->base += round($fila['base'], 2);
					$this->total_pvp_con_dto_pendiente += $fila['pvp_con_dto'] * $pendiente;
					$this->total_pvp_con_dto_reservado += $fila['pvp_con_dto'] * $reservado;
					$this->cantidad_total += $fila['cantidad'];
					$this->cantidad_pendiente += $pendiente;
					$this->cantidad_reservada += $reservado;
				}
			}
		}

		$this->importe_total = Price::setDiscount($this->total_pvp_con_dto, $this->descuento);
		$this->importe_total_pendiente = Price::setDiscount($this->total_pvp_con_dto_pendiente, $this->descuento);
		$this->importe_total_reservado = Price::setDiscount($this->total_pvp_con_dto_reservado, $this->descuento);

    }

	public function extracData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->codigo_sinlib = $this->getProp($fila, 'cod_sinlib');
		//$this->cliente = new Usuario($fila[PedidoCliente::getAlias() . '_' . 'cliente']);
		$this->cliente = new Usuario(new OpcionesWidget(Array('filaUsuario' => $fila)));
		$this->nombre_legal =  $this->getProp($fila, 'nombre_legal');
		$this->email =  $this->getProp($fila, 'email');
		$this->direccion = $this->getProp($fila, 'direccion');
		$this->cod_postal = $this->getProp($fila, 'cod_postal');
		$this->localidad = $this->getProp($fila, 'localidad');
		$this->provincia = $this->getProp($fila, 'provincia');
		$this->telefono = $this->getProp($fila, 'telefono');
		$this->telefono2 = $this->getProp($fila, 'telefono2');
		$this->cif = $this->getProp($fila, 'cif');
		$this->pendiente_sinlib = $this->getProp($fila, 'pendiente_sinlib');
		$this->fecha = $this->getProp($fila, 'fecha');
		$this->fecha_date_format = date_create($this->fecha);
		$aux_fecha = new DateTime($this->fecha);
		$this->cadena_fecha = dame_dia_de_la_semana($aux_fecha->format('w')) . ' <strong>' . $aux_fecha->format('d') . '</strong> de <strong>' . dame_mes($aux_fecha->format('n')) . '</strong> a las ' . $aux_fecha->format('H:i') . 'h';
		$this->fecha_pago = $this->getProp($fila, 'fecha_pago');
		$this->fecha_envio = $this->getProp($fila, 'fecha_envio');
		$this->pagado = $this->getProp($fila, 'pagado');
		$this->referencia = $this->getProp($fila, 'referencia');
		$this->enviado = $this->getProp($fila, 'enviado');
		$this->observaciones = $this->getProp($fila, 'observaciones');
		$this->no_revisado = $this->getProp($fila, 'no_revisado');
		$this->pedido_preparado = $this->getProp($fila, 'pedido_preparado');
		$this->pais = $this->getProp($fila, 'pais');
		$this->datos_facturacion = $this->getProp($fila, 'datos_facturacion');
		$this->factura = $this->getProp($fila, 'factura');
		$this->descuento = $this->getProp($fila, 'descuento');
		$this->envolver_regalo = $this->getProp($fila, 'envolver_regalo');
		$this->comercial = $this->getProp($fila, 'comercial');
		$this->g_envio = $this->getProp($fila, 'g_envio');
		$this->pendiente_paypal = $this->getProp($fila, 'pendiente_paypal');
		$this->oculto = $this->getProp($fila, 'oculto');
		$this->emailEnviado = ($this->getProp($fila, 'emailEnviado') == 1); // Lo hacemos así para asignar un valor booleano
		
		//Tipo de envío
		//$this->tipo_envio = $fila[PedidoCliente::getAlias() . '_' . 'tipo_envio'];
		$this->tipo_envio = new TipoEnvioCliente(new OpcionesWidget(Array('filaTipoEnvio' => $fila)));
		$this->tipo_envio_nombre = $this->getProp($fila, 'nombre', TipoEnvioCliente::getAlias());
		$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria', TipoEnvioCliente::getAlias());
		$this->reembolso = $this->getProp($fila, 'reembolso', TipoEnvioCliente::getAlias());
		$this->transferencia = $this->getProp($fila, 'transferencia', TipoEnvioCliente::getAlias());
		$this->sin_pago = $this->getProp($fila, 'sin_pago', TipoEnvioCliente::getAlias());
		//formas de pago
		//$this->forma_pago = $fila[PedidoCliente::getAlias() . '_' . 'forma_pago'];
		$this->forma_pago = new FormasPago(new OpcionesWidget(Array('filaFormaPago' => $fila)));
		$this->forma_pago_nombre = $this->getProp($fila, 'nombre', FormasPago::getAlias() );
		if ($fila[FormasPago::getAlias() . '_cuenta_bancaria'] != '') {
			$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria', FormasPago::getAlias() );
		}
		if ($fila[FormasPago::getAlias() . '_transferencia'] != '') {
			$this->transferencia = $this->getProp($fila, 'transferencia', FormasPago::getAlias() );
		}
		$this->tipo_pasarela = $this->getProp($fila, 'tipo_pasarela', FormasPago::getAlias() );
	}
	public function cargarDetalle(){
		//Limpiamos las líneas si contienen algo:
		if (count($this->lineas) > 0){
			$this->cleanLines();
		}
		//Compondremos aquí una nueva select que nos dé todas las líneas de pedido ya con los campos y el resto de datos:
		$sentencia_sql = 'SELECT ' . LineaPedidoCliente::getCampos() . ' 
							FROM ' . LineaPedidoCliente::getNombreTabla() . '
							WHERE ' . LineaPedidoCliente::getWhereTabla($this->codigo, NULL, false);	// ==> No indicamos código de línea y no limitamos
		//echo("$sentencia_sql<br />\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while($fila = $bd->getFila()){
				$linea = new LineaPedidoCliente(new OpcionesWidget(array(
					'filaLineaPedido' => $fila,
					'objetoPedido' => $this
				)));
				$this->lineas[] = $linea;
			}
		}
		//Recalculamos los totales
		$this->recalculate();
	}
	
	public function cargarProductos(){
		foreach ($this->lineas as $clave => $valor) {
			$valor->cargarArticulo();
		}
	}
	
	private function cleanLines(){
		foreach ($this->lineas as $clave => $valor) {
			unset($this->lineas[$clave]);
		}
		unset($this->lineas);
		$this->lineas = array();
	}
	
    public function recalculate() {
        //El recálculo lo vamos a hacer de los datos que hay en las líneas. Así todo se hace siempre por el mismo camino
		//Ponemos a 0 los acumulados de la tabla:
		$this->total_pvp = 0;
		$this->total_pvp_pendiente = 0;
		$this->total_pvp_reservado = 0;
		$this->total_pvp_con_dto = 0;
		$this->total_pvp_con_dto_pendiente = 0;
		$this->total_pvp_con_dto_reservado = 0;
		$this->cantidad_total = 0;
		$this->cantidad_pendiente = 0;
		$this->cantidad_reservada = 0;
		//Ahora toca recorrer las líneas para calcular los totales
		foreach ($this->lineas as $clave => $valor) {
			$this->total_pvp += $valor->pvp * $valor->cantidad;
			$this->total_pvp_pendiente += $valor->pvp * $valor->pendiente;
			$this->total_pvp_reservado += $valor->pvp * $valor->recibida;
			$this->total_pvp_con_dto += $valor->importe_con_dto;
			$this->base += $valor->base;
			$this->total_pvp_con_dto_pendiente += $valor->pvp_con_dto * $valor->pendiente;
			$this->total_pvp_con_dto_reservado += $valor->pvp_con_dto * $valor->recibida;
			$this->cantidad_total += $valor->cantidad;
			$this->cantidad_pendiente += $valor->pendiente;
			$this->cantidad_reservada += $valor->recibida;
		}
    }

	//------------------------------------------
	//	Damos un pedido por finalizado
	//------------------------------------------
	public function finalizado(){
		return(self::darPorFinalizado($this));
	}
	public static function darPorFinalizado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pendiente_sinlib` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		//Para hacer pruebas, no actualizo el pedido
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}

		if($retorno){
			//Necesitamos un objeto pedido cliente:
			if ($mc_pedcli == NULL){
				$mc_pedcli = new PedidoCliente($codPedido);
			}
			//si todo ha ido bien, vamos a hacer más recálculos
			//Si los productos comprados itenen ficheros adjuntos
			$listaFicheros = array();
			foreach($mc_pedcli->lineas as $clave => $valor){
				if ($valor->articulo == NULL){
					$valor->cargarArticulo();
				}
				$valor->articulo->venderAdjuntos($mc_pedcli->cliente->codigo);
			}
			//var_dump($listaFicheros);
		}

		return($retorno);
	}
	
	//------------------------------------------
	//	Damos un pedido por pagado
	//------------------------------------------
	public function pagado(){
		return(self::darPorPagado($this));
	}
	public static function darPorPagado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pagado` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}

	//------------------------------------------
	//	Damos un pedido por pagado y finalizado
	//------------------------------------------
	public function pagadoFinalizado(){
		return(self::darPorpagadoFinalizado($this));
	}
	public static function darPorpagadoFinalizado($codPedido){
		$retorno = self::darPorPagado($codPedido) | self::darPorFinalizado($codPedido);
		return($retorno);
	}
	
	//------------------------------------------
	//	Indicamos que el email de aviso de un pedido ya se ha enviado
	//------------------------------------------
	public function pedidoEmailEnviado(){
		return(self::darPedidoEmailEnviado($this));
	}
	public static function darPedidoEmailEnviado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `emailEnviado` = 1 WHERE `codigo` = ' . $codPedido . '; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}
	
	//------------------------------------------
	//	Actualizamos el stock de los productos de un pedido:
	//------------------------------------------
	public static function SactualizaStockPedido($codigoPedido){
		$obpedido = new PedidoCliente($codigoPedido);
		$obpedido->actualizarStockPedido();
	}
	public function actualizarStockPedido(){
		include('coumes/globals.php');
		$sentencia_sql = '';
		foreach($this->lineas as $clave => $valor){
			$sentencia_sql .= ' UPDATE articulo SET stock = stock - ' . $valor->cantidad . ' WHERE codigo = ' . $valor->articulo . '; ';
		}
		if ($sentencia_sql != ''){
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
	
	//------------------------------------------
	//	Extraemos una lista de pedidos de un cliente
	//------------------------------------------
	public static function getPedidosCliente($cliente = NULL, $pagado = NULL, $pendienteSinlib = NULL, $orden = ' ORDER BY `fecha` DESC '){
		include('comunes/globals.php');
		$listaPedidos = array();
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
									FROM ' . self::getNombreTabla() . ' 
									WHERE ' . self::getWhereTabla(NULL, $pagado, $cliente->codigo, $pendienteSinlib)
									. $orden;
				//echo($sentencia_sql);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					while($fila = $bd->getFila()){
						array_push($listaPedidos, new PedidoCliente(new OpcionesWidget(array('filaPedido' => $fila))));
					}
				}
			}				
		}
		return($listaPedidos);
	}
	
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

	public static function newOrderFromCart($objetoCesta){
		$tipo_envio = 0;
		$retorno = NULL;
		//Si el objeto de la cesta no está listo para pedir, no seguimos:
		//echo("-----------Comprobación-------------");
		if ($objetoCesta->readyToFinish()){
			//Necesitamos una direccion
			$direccion = $objetoCesta->objeto_cliente->getCurrentDirection();
			//Cogemos el tipo de envío y la forma de pago
			//$tipo_envio = Sesion::get('tipo_envio'); //TODO ==> Hay que cogerlo del objeto de la cesta
			$obTipoEnvio = new TipoEnvioCliente($tipo_envio);
			//vamos a ver si este pedido está pendiente de ser exportado (siempre que no haya que pagarlo por pasarela):
			$pendienteSinlib = ($obTipoEnvio->pasarela > 0) ? 0 : 1;
			//No necesitamos comprobaciones, Vamos a inicializar los valores a insertar en la tabla:
			$camposInsert = ' '
				. '`cliente`, '
				. '`nombre_legal`, '
				. '`email`, '
				. '`direccion`, '
				. '`cod_postal`, '
				. '`localidad`, '
				. '`provincia`, '
				. '`telefono`, '
				. '`telefono2`, '
				. '`cif`, '
				. '`pais`, '
				. '`pendiente_sinlib`, '
				. '`pendiente_paypal`, '
				. '`pagado`, '
				. '`observaciones`, '
				. '`tipo_envio`, '
				. '`forma_pago`, '
				. '`cliente_sinlib`, '
				. '`g_envio`, '
				. '`comercial`, '
				. '`envolver_regalo` ';
			$valoresInsert = ''
			. ' '
			. '\'' . $objetoCesta->cliente . '\', '
			. '\'' . $direccion->nombre . '\', '
			. '\'' . $objetoCesta->objeto_cliente->email . '\', '
			. '\'' . $direccion->direccion . '\', '
			. '\'' . $direccion->cod_postal . '\', '
			. '\'' . $direccion->localidad . '\', '
			. '\'' . $direccion->provincia . '\', '
			. '\'' . $direccion->telefono . '\', '
			. '\'' . $objetoCesta->objeto_cliente->telefono2 . '\', '
			. '\'' . $objetoCesta->objeto_cliente->cif . '\', '
			. '\'' . $objetoCesta->objeto_cliente->pais . '\', '
			. '\'' . $pendienteSinlib . '\', '
			. '\'0\', '	//Pendiente de pagarse por paypal
			. '\'0\', '	//Pagado
			. '\'' . Sesion::get('ObservacionesPedido', ''). '\', '
			. '\'' . $tipo_envio . '\', '
			. '\'' . Sesion::get('forma_pago') . '\', '
			. '\'' . $objetoCesta->objeto_cliente->codigo_sinlib . '\', '
			. '\'' . $objetoCesta->shippingCosts() . '\', '	//Gastos de envío
			. '\'' . Sesion::get("vendedorActual") . '\', '
			. '\'' . Sesion::get("envolverRegalo") . '\' ';
			//Generamos una sentencia para insertar los valores en la tabla de pedidos:
			$sentenciaInsert = ' INSERT INTO `mc_pedcli` (' . $camposInsert . ') values (' . $valoresInsert . ');';
			//echo($sentenciaInsert);
			$codigoPedido = 0;
			//Hagamos la insert y cojamos el código:
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentenciaInsert);
				//11/Enero/2019 ==> Esto no funciona pues ya no hay código autonumérico en la tabla. Es por ello que vamos a cargar en este preciso instante el último pedido
				//creado por este cliente
				$codigoPedido = $bd->getAutonumerico('mc_pedcli');
				//echo("\nEl último código insertado es: $codigoPedido.\n");
			}
			if ($codigoPedido > 0){
				//Si tenemos código de pedido vamos a generar una insert global como dios manda:
				$valoresLineas = '';
				$camposLineas = '';
				$coma = '';
				foreach ($objetoCesta->lineas as $clave => $linea){
					  $valoresLineas .= $coma . ' ( '
					  . '\'' . $codigoPedido . '\','
					  . '\'' . $linea->articulo . '\','
					  . '\'' . $linea->cantidad . '\','
					  . '\'' . $linea->pvp_unitario . '\','
					  . '\'0\','	// ==> Cantidad recibida, por defecto es siempre 0
					  . '\'0\','	// ==> Cantidad retirada, por defecto es siempre 0
					  . '\'' . $linea->descuento . '\','
					  . '\'' . $linea->importe_sin_descuento . '\','
					  . '\'' . $linea->importe / $linea->cantidad . '\','
					  . '\'' . $linea->importe . '\','
					  . '\'' . $linea->codigo_lote . '\','
					  . '\'0\''	// ==> Descuento del lote, hay que calcular más tarde
					  . ' ) ';
					  $coma = ',' . "\n";
					  //Vamos a controlar que haya una oferta, en cuyo caso tenemos que añadir una línea más con precio 
					  if ($linea->oferta != NULL){
						  $valoresLineas .= $coma . ' ( '
						  . '\'' . $codigoPedido . '\','
						  . '\'' . $linea->articulo . '\','
						  . '\'' . $linea->oferta->cantidad_regalo . '\','
						  . '\'0\','	// ==> Precio unitario
						  . '\'0\','	// ==> Cantidad recibida, por defecto es siempre 0
						  . '\'0\','	// ==> Cantidad retirada, por defecto es siempre 0
						  . '\'0\',' // ==> descuento
						  . '\'0\','	// ==> Importe sin descuento
						  . '\'0\','	// ==> Importe unitario
						  . '\'0\','	// ==> importe
						  . '\'0\','	// ==> lote
						  . '\'0\''	// ==> Descuento del lote, hay que calcular más tarde
						  . ' ) ';
					  }
				}
				if ($valoresLineas != ''){
					$camposLineas = ''
						. ' `mc_pedcli`, '
						. ' `articulo`, '
						. ' `cantidad`, '
						. ' `pvp`, '
						. ' `recibida`, '
						. ' `retirada`, '
						. ' `descuento`, '
						. ' `importe`, '
						. ' `pvp_con_dto`, '
						. ' `importe_con_dto`, '
						. ' `lote`, '
						. ' `dto_lote` ';
				}
				
				$sentenciaInsert = ' INSERT INTO `ml_pedcli` (' . $camposLineas . ') values ' . $valoresLineas . ';';
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentenciaInsert);
				}
				$retorno = $codigoPedido;
				$objPedido = new PedidoCliente($codigoPedido);
				//Vaciamos el carrito:
				CabeceraCesta::emtpyCart(); // ==> para las pruebas no borramos
				//Enviamos el email: TODO
				//envia_email_pedido($codigoPedido, "email_pedido");
				//Vamos a enviar dos emails, uno al cliente:
				
				Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $objetoCesta->objeto_cliente->email . ',' . $direccion->nombre, 
									'asunto' => 'Confirmación de pedido en la web ' . Shop::$empresa->nombre . '(' . Shop::$configuracion->url . ')', 
									'contenido' => $objPedido,
									'templateFile' => 'email_pedido_cliente.php')));
				Email::sendMail(new OpcionesWidget(array(
									'destinatario' => Shop::$empresa->email_empresa . ',' . Shop::$empresa->nombre_legal, 
									'asunto' => 'Hemos recibido un pedido de: ' . $direccion->nombre . '(' . $objetoCesta->objeto_cliente->email . ')', 
									'contenido' => $objPedido,
									'templateFile' => 'email_pedido_empresa.php')));
				
				//Si hay que actualizar el stock, lo hacemos: 
				if(Shop::$configuracion->controlar_stock){
					PedidoCliente::SactualizarStockPedido($codigoPedido);
				}
			}
		}
		return($retorno);
	}
	
	public static function associateEmptyClientsCode(){
		$sentencia_sql = 'UPDATE `mc_pedcli` `pedidos_cliente` SET `cliente_sinlib` = 
								( SELECT `codigo_sinlib` FROM `cliente` WHERE `cliente`.`codigo` = `pedidos_cliente`.`cliente` LIMIT 1) 
							WHERE `mc_pedcli`.`cliente_sinlib` = 0';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
}

?>