<?php

/*
  Clase SuperFileSystem
  @version 1.0
 */

class SuperFileSystem {
	
    //Constructor y destructor
    function __construct() {
        
    }

    function __destruct() {
        
    }
	
	public static function cleanDirectory($path, $removeHiddenFiles = false){
		if ($removeHiddenFiles){
			$files = glob($path . ((substr($path, -1, 1) != '/' )? '/' : '') . '{,.}*', GLOB_BRACE);
		}else{
			$files = glob($path . ((substr($path, -1, 1) != '/' )? '/' : '') . '*'); // get all file names
		}
		foreach($files as $file){ //recorremos cada fichero:
			if(is_file($file)){
				unlink($file); // delete file
			}
		}
	}
	
	public static function dir_is_empty($dir) {
		$retorno = true;
		if ($handle = opendir($dir)){
			while (false !== ($entry = readdir($handle))) {
				if ($entry != '.' && $entry != '..') {
				  closedir($handle);
				  $retorno = false;
				}
			}
			closedir($handle);
		}
		return($retorno);
	}
	
	public static function remoteDirIsEmpty($data){
		//Ojo, estas consultas son siempre partiendo desde la carpeta de subidas
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		$path = $data->path;
		$fileType = 'img';
		if (isset($data->fileType)){
			$fileType = $data->fileType;
		}
		$uploadPath = '';
		switch(strtolower($fileType)){
			case 'img':
				$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
			break;
		}
		if ($path = realpath($uploadPath . DIRECTORY_SEPARATOR . $path)){
			$retorno->resultado = self::dir_is_empty($path);
		}else{
			$retorno->resultado = false;
		}
		return(json_encode($retorno));
	}
	
	public static function remoteCreateDir($data){
		$fileType = 'img';
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		$subCarpeta = "";
		if (isset($data->fileType)){
			$fileType = $data->fileType;
		}
		$uploadPath = '';
		switch(strtolower($fileType)){
			case 'img':
				$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
			break;
		}
		//Si no hay uploadPath, no hacemos nada
		$uploadPath = str_replace('.', '', $uploadPath);	//Simplemente vamos a quitar los '.' de la ruta
		if ($uploadPath != ''){
			//Por seguridad SIEMPRE los directorios se podrán crear dentro de UPLOAD
			$uploadPath .= DIRECTORY_SEPARATOR . $data->path;
			//Ahora ha llegado el momento de crear el directorio en cuestión:
			if (!is_dir($uploadPath)){
				if (mkdir($uploadPath, 0755, true)){
					$retorno->resultado = true;
				}
			}
		}
		return(json_encode($retorno));
	}
	
	public static function remoteDeleteDir($data){
		$fileType = 'img';
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		$subCarpeta = "";
		if (isset($data->fileType)){
			$fileType = $data->fileType;
		}
		$uploadPath = '';
		switch(strtolower($fileType)){
			case 'img':
				$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
			break;
		}
		//Si no hay uploadPath, no hacemos nada
		$uploadPath = str_replace('.', '', $uploadPath);	//Simplemente vamos a quitar los '.' de la ruta
		if ($uploadPath != ''){
			//Por seguridad SIEMPRE los directorios se podrán crear dentro de UPLOAD
			$uploadPath .= DIRECTORY_SEPARATOR . $data->path;
			//Ahora ha llegado el momento de crear el directorio en cuestión:
			if (is_dir($uploadPath)){
				if (rmdir($uploadPath)){
					$retorno->resultado = true;
				}
			}
		}
		return(json_encode($retorno));
	}
}
