<?php

/*
  Clase SuperModule
  @version 1.0
  //Esta clase será, en el futuro la encargada de cargar un módulo para su uso
 */

class SuperModule{

	private $name = '';
	private $componentList = array();

	public function setName($name = ''){
		$this->name = $name;
	}

	
    //Constructor y destructor
    public function __construct() {
		
		//Vamos a recibir los parámetros:
		$numargs = func_num_args();
		$argumentos = func_get_arg();
		if (isset($argumentos[0])){
			$this->name = $argumentos[0];
		}
    }

    public function __destruct() {
        
    }
	//------------------------------------------------------------------------------------------------
	// estas funciones son para cargar los componentes (viejos módulos también llamados widgets)
	//------------------------------------------------------------------------------------------------
	public static function loadComponent($module, $component, $options){
		//Esta función, por ahora la vamos a usar para cargar los widgets de las versiones antiguas de webStore
		ob_start();
		new Widget(array('nombre' => $module, 'funcion' => $component), $options);
		$retorno = ob_get_clean();
		/*if ($retorno == ''){
			ob_start();
			echo("<div>");
			echo("nombre:$module\n");
			echo("funcion:$component\n");
			var_dump($options);
			echo("</div>");
			$retorno = ob_get_clean();
		}*/
		return($retorno);
	}

	public static function loadEncryptedComponent($data){
		//Esta función, por ahora la vamos a usar para cargar los widgets de las versiones antiguas de webStore
		//Recibimos el componente encriptado:
		$newData = unserialize(base64_decode($data));
		//var_dump($data);
		return(array('hash' => $data, 'content' => static::loadComponent($newData['widget'], $newData['function'], $newData['opciones'])));
		//return($data);
	}
	//------------------------------------------------------------------------------------------------
	// estas funciones son para cargar los componentes (viejos módulos también llamados widgets)
	//------------------------------------------------------------------------------------------------

	
	//------------------------------------------------------------------------------------------------
	// ACCIONES ==>Con estas funciones gestionamos las acciones
	//------------------------------------------------------------------------------------------------
	public static function execModuleActions($pathToActionsFile = NULL){
		$fileModuleActionList = array();
		if ($pathToActionsFile === NULL){
			//Quieren que ejecutemos todas las acciones:
			$listFiles = new ConfigFile('moduleActions', true, 'controlFiles/');
			if ($listFiles->list === NULL){
				$listFiles->list = array();	// Nos vamos a asegurar de que siempre haya una lista, aunque sea vacía
			}
			$fileModuleActionList = array_keys($listFiles->list);	//Los nombres de los ficheros son la clave del array, el valor es el timestamp
		}else{
			if (is_string($pathToActionsFile)){
				$fileModuleActionList[] = $pathToActionsFile;
			}else if (is_array($pathToActionsFile)){
				$fileModuleActionList = $pathToActionsFile;
			}
		}
		//Llegados a este punto, la lista de ficheros de acción de los módulos es un array. Puede estar vacío, pero es un array:
		foreach($fileModuleActionList as $clave => $valor){
			//Cada entrada de "valor" es un fichero, si existe lo incluimos
			if (file_exists($valor)){
				include($valor);
			}
		}
	}
	
	//Creado por pedro el 31/Enero/2018 ==> Este proceso probablemente desaparezca en el futuro. Lo que hace es controlar las acciones para
	// crear un fichero de control
	public static function checkModuleActions(){
		//Lo primero que vamos a hacer es controlar si el directorio existe:
		$controlFileUrl = _WS_DYNAMIC_DIR_ . 'controlFiles/';
		if (!file_exists($controlFileUrl)){
			@mkdir($controlFileUrl);
		}
		//Vamos a crear un fichero de control dónde guardar las acciones a realizar:
		$listFiles = new ConfigFile('moduleActions', true, 'controlFiles/');
		//vamos a obtener la lista de ficheros:
		if ($listFiles->list === NULL){
			$listFiles->list = array();
		}
		$currentList = static::compareActionFileList($listFiles->list);
		//Si $currentList es NULL, entonces todo está ok. Si no lo es nos devolverá la lista que tenemos que guardar:
		if (is_array($currentList)){
			$listFiles->list = $currentList;
			//Y guardamos:
			$listFiles->save();
		}
		
	}
	
	private static function compareActionFileList($originalList){
		//Recibimos la lista original. Si es igual a la real devolvemos NULL, si son distintas devolvemos la lista nueva
		$listaFicheros = scandir(_WS_MODULES_DIR_);	// Esto lo quito porque no me muestra directorios, lo hago a mano
		/*$listaFicheros = array();
		foreach(glob(_WS_MODULES_DIR_ . '*', GLOB_ONLYDIR) as $dir) {
			$listaFicheros[] = basename($dir);
		}*/
		$actionList = array();
		foreach($listaFicheros as $clave => $valor){
			if ( ($valor != '.') && ($valor != '..') ){
				$ruta = _WS_MODULES_DIR_ . $valor . '/actions.php';
				if (file_exists($ruta)){
					$actionList[$ruta] = filemtime($ruta);
				}
			}
		}
		$listAreEqual = true;
		//Ahora vamos a comparar ambas listas:
		while( ($elemento = current($originalList)) && ($listAreEqual) ) {
			$listAreEqual = false;	//Lo inicializo a falso para que sea verdadero sólo si coinciden los datos
			//Extraemos del arrray el índice (nombre del fichero)
			$ruta_fichero = key($originalList);
			if (isset($actionList[$ruta_fichero])){
				if ($actionList[$ruta_fichero] == $elemento){
					$listAreEqual = true;
				}
			}
			//Avanzamos
			next($originalList);
		}
		//Si llegados a este punto, son iguales, vamos a ver si tienen el mismo tamaño:
		if ( count($originalList) != (count($actionList)) ){
			$listAreEqual = false;
		}
		if ($listAreEqual){
			$retorno = NULL;
		}else{
			$retorno = $actionList;
		}
		return($retorno);
	}
}
