<?php
/*
*	Archivo que hace al autocarga de las Clases que forman la estructura de datos. Ademas de otras cosas.
*	@version 1.0.0
*	@date 2018/28/06
*
*/

//spl_autoload_register('WebStore\core\required\autoload');
spl_autoload_register('autoload');

//Vamos a definir la función autoload:
function autoload($clase) {
	$is_class = false;
	$is_controller = false;
	$padre_cargado = true;
	try{
		//Vamos a ver si es una clase o un controlador:
		if (file_exists(_WS_CLASSES_DIR_ . $clase . '.php')){
			$is_class = include(_WS_CLASSES_DIR_ . $clase . '.php');
		}else if (file_exists(_WS_CONTROLLERS_DIR_ . $clase . '.php')){
			$is_controller = include(_WS_CONTROLLERS_DIR_ . $clase . '.php');
		}else{
			//echo(_WS_CONTROLLERS_DIR_ . $clase . '.php' . " No encontrado");
			$padre_cargado = false;
		}
			
	}catch(Exception $e){
		//Hay un error, hay que anotarlo en la salida de errores
		$padre_cargado = false;
		echo("ERRROOOORRRR $clase<br />");
		print_r($e);
	}
	
	//Si tenemos el padre cargado, vamos a por el hijo:
	if ($padre_cargado){
		//Vemos si estamos cargando una clase o un controlador:
		$class_path = '';
		if ($is_class){
			$class_path = 'classes';
		}else if ($is_controller){
			$class_path = 'controllers';
		}
		//En class_path tengo la ruta según el tipo, ahora vamos a ver si está en overrides
		//Vamos a ver si está en overrides de la plantilla, después de webStore y después en dynamic:
		$final_path = '';
		if (file_exists(_WS_THEME_OVERRIDE_DIR_ . $class_path . '/' . $clase . '.php')){
			$final_path = _WS_THEME_OVERRIDE_DIR_ . $class_path . '/' . $clase . '.php';
		}else if (file_exists(_WS_OVERRIDE_DIR_ . $class_path . '/' . $clase . '.php')){
			$final_path = _WS_OVERRIDE_DIR_ . $class_path . '/' . $clase . '.php';
		}else {
			$final_path = _WS_DYNAMIC_DIR_ . $class_path . '/' . $clase . '.php';
			if (!file_exists($final_path)){
				//Si no existe, lo creamos
				$str_class = '<?php
class ' . $clase . ' extends Super' . $clase . '{
	public function __construct(){
		parent::__construct(...func_get_args());
	}   
}';
				if ($fp = fopen($final_path, 'w')){
					fwrite($fp, $str_class);
					fclose($fp);
				}
			}
		}
		//Incluimos el fichero:
		if ($final_path != ''){
			include($final_path);
		}else{
			throw new Exception("Clase no cargada");
		}
		return(true);
	}else{
		//Vamos a lanzar la excepción
		throw new Exception("Clase padre no cargada");
		return(false);
	}
}

?>