<?php
	//Antes de arrancar el core de webStore vamos a inicializar las variables locales que indicarán qué web vamos a mostrar con este index.
	// Es decir, vamos a tener preparado en el motor de webStore una constante en la que especificar que plantilla cogemos:
	include_once('local.php');	// ==> Lo hacemos con un include para no tener que editar el index en cada cliente (Pedro 07/Febrero/2019)
	
	//Nos aseguramos de que SIEMPRE exista un "core_path"
	if (!defined('_WS_CORE_PATH')){
		define('_WS_CORE_PATH', '');	//Esta variable SÓLO se usa para poder hacer el include de webStore sin tener que tocar el index.php.
										//	Existe otra variable que es "_WS_CORE_DIR_" que contiene la ruta absoluta interna al core de webStore
	}
	
	//Arrancamos el core de webStore
	include(_WS_CORE_PATH . 'core/initWebStore.php');

	error_reporting(E_ALL);	// Esto en el futuro debe desaparecer

	//Vamos a cargar el control de secciones:
	//Álvaro 050219 Tarea 5170: Ahora, en vez de hacer un include de sectioncontrol.php, vamos ahora a llamar a esa funcion estática de sections.php
	//include_once(_WS_CORE_DIR_ . 'sectionControl.php');
	Sections::sectionControl();	//Obsérvese que para que esto tenga sentido se ha cargado el core de webStore, si no, no podríamos hacer referencia a ninguna clase

	//Una vez que se ha controlado todo esto, vamos a mostrar el contenido, pero ojo, si la web hay que recargarla lo hacemos sin más
	//Si hay que recargar la web, lo hacemos aquí
	if (Sesion::getReloadPage()) {
		//header('location:' . $url_sin_parametros); ==> la web se va a recargar a si misma
		Sesion::reloadPage($_SERVER["REQUEST_URI"]);
	}else{
		//Si la sección es completa la cargamos directamente:
		$completa = Sections::getAttr('completa');
		if ($completa){
			Theme::showContent();
		}else{
			//cargamos el fichero de la sección, según la sección, la plantilla puede ser diferente
			$ficheroPlantilla = Sections::getAttr('plantilla');
			if ( ($ficheroPlantilla != NULL) && ($ficheroPlantilla != '') ){
				Theme::include_file($ficheroPlantilla);
			}
		}
		
		$absoluta = Sections::getAttr('absoluta');
		//Si la sección no es absoluta mostramos lo siguiente:
		if (!$absoluta){
		//WebStore tiene algunos Scripts que son independientes del tema, vienen SIEMPRE de serie:
		
		//Es muy importante programar en javascript que si se ha cargado la web se lance el evento de WSLE (Web Store Load Event
?>
<script>
var auxFunc = window.onload;
auxFunc = (auxFunc == null) ? function(){} : auxFunc;
window.onload = function() {auxFunc(); var event = new Event('WSLE'); document.dispatchEvent(event); };
</script>
<script>
	<?php
		//vamos a declarar una función javaScript que sea capaz de actualizar cualquier capa de la web de manera asíncrona
		//Para ello usamos el atributo "data-update" con las funciones que deben actualizar la cama separadas por guiones
	?>
	function WS_data_update(controller, method, data, event, callback){
		//Nos aseguramos de que las variables tengan un valor
		controller = (typeof controller != 'undefined') ? controller : '';
		method = (typeof method != 'undefined') ? method : '';
		event = (typeof event != 'undefined') ? event : '';
		callback = (typeof callback != 'undefined') ? callback : function(){};

		//Si los campos obligatorios están inicializados vamos allá
		if ( (controller != '') && (method != '')){
			var components = new Array();
			//Vamos a cargar los objetos de este evento a recargarlos y a ejecutar el callback
			if (event != ''){
				//Pedro 22/Abril/2019 ==> Modificamos el componente para que se puedan añadir más campos a actualizar utilizando un pipe como separador: |
				var eventArray = event.split('|');
				eventArray.forEach(function (currentValue, index, completeArray) {
					if (currentValue != ''){
						//console.log("$('[data-update" + currentValue + "]')");
						$('[data-update' + currentValue + ']').each(function() {
							components.push({'component' : $(this).data('configuration')});
						});
					}
				});
			}
			//console.log(components);
			//Si hay componentes se añaden a los datos que tenemos
			//if (components.length > 0){ //==> Aunque no haya componentes, hay que ejecutar la función remota
			data['components'] = components; 
			var dataToSend = {
				controller : controller,
				method : method,
				data: data,
			};
			//Vamos a pasar los datos en base64:
			dataToSend = JSON.stringify(dataToSend);
			//dataToSend = btoa(dataToSend);
			dataToSend = b64EncodeUnicode(dataToSend);
			//Vamos a enviar la petición:
			$.ajax({
				url: '<?=Shop::$configuracion->url;?>remote_request.php',
				type: 'post',
				dataType: 'text',
				contentType: 'application/json',
				success: function (data) {
					//
					//	24/Enero/2019 ==> A partir de ahora data es una estructura como esta:
					//	{
					//		response: respuesta que nos manda la función remota ejecutada, puede ser cualquier cosa (objeto, array, dato, etc.)
					//		data: lista de objetos a insertar en el HTML
					//		msgs: mensaje devuelto por el sistema
					//	}
					//	//Adatamos la función para que procese estos datos
					//
					//Tenemos que coger los datos recibidos y procesarlos
					//Básicamente tengo el texto que debo meter en cada widget:
					//console.log(data);
					data = JSON.parse(data);
					//console.log(data.msgs);
					//console.log(data.data);
					//console.log("inicio actualización de datos");
					if (data != null){
						//data = JSON.parse(data.data);
						var i = 0;
						//No hay que hacer nada si no hay evento asociado:
						if (event != ''){
							var listaComponentes = data.data
							//Insertamos el contenido de cada componente en su sitio
							if (Array.isArray(listaComponentes)){
								var limit = listaComponentes.length;
								for(i = 0; i < limit; i++){
									//console.log(listaComponentes[i]);
									insertComponentData(listaComponentes[i]);
								}
							}else{
								insertComponentData(listaComponentes);
							}
							//console.log("Terminado de actualizar");
							function insertComponentData(data){
								//console.log("Insetamos componentes");
								//console.log(data);
								//Si no hay hash, o content, no podemos hacer nada:
								if (typeof data != 'undefined'){
									//Vamos a buscar el componente:
									//console.log('[data-configuration="' + data.hash + '"]');
									//console.log(data.content);
									$('[data-configuration="' + data.hash + '"]').html($(data.content).html());
								}
							}
						}
						//Ejecutamos el callback
						callback(data);
					}
				},
				error : function(e, x, settings, exception) {
					console.log(e);
				},
				data: JSON.stringify(dataToSend)
			});
			//}
		}
	}	
</script>
<?php
		}
	//}
//
//	//29/Enero/2019 ==> Vamos a quitar, por ahora toda referencia a los mensajes de sistema. Esto es obsoleto
//	//Vamos a incrementar el contador de la lista de mensajes
//	$listaSysMsg->incrementaContador();

//	//Vamos a limpiar la lista de mensajes del sistema que hayan superado dos cargas
//	$listaSysMsg->limpiar();

//	//El resultado lo vamos a meter en la variable de sesión para que no se pierda
//  Sesion::set('listaSysMsg', $listaSysMsg);




//	//Sólo se añade contenido extra si la sección no es absoluta
//	if ($secciones->absoluta($seccion) === 0){
//		define('COMPRIMIR_PAGINA', true);
//		
//	}else{
//		define('COMPRIMIR_PAGINA', false);
//	}
	


	//Para asegurarnos de que se guarde en la sesión todo, hacemos un commit
	Sesion::commit();
}

	//Lo último es desconectarnos de la base de datos
	BaseDatos::closeConexion();

//----------------------------------------------------------------------------------------------------------------------------
// ---------------------  AQUÍ SE COMPRIME LA PÁGINA -------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------
/*
	function comprimir_pagina($buffer) {
		if (COMPRIMIR_PAGINA){
			//$busca = array('/\>[^\S ]+/s','/[^\S ]+\</s','/(\s)+/s');
			//$reemplaza = array('>','<','\\1');
			//return preg_replace($busca, $reemplaza, $buffer);
			//return preg_replace(' //', '', $buffer);
			//return preg_replace("/t", '', $buffer);
			$buffer = preg_replace('/    /', '', $buffer);
			$buffer = preg_replace('/[\t]/', '', $buffer);
			$buffer = preg_replace('/<!--(.|\s)*?-->/', '', $buffer);
			//$buffer = preg_replace('/\n\n/', "\n", $buffer);
			$buffer = preg_replace('/\n/', '', $buffer);
			$buffer = preg_replace('[ /]', '/', $buffer);
		}
		return($buffer);
	}
*/