<?php

//Inicializamos la sesión
header('content-type: text/html; charset: iso-8859-1');
header('Expires: Tue, 01 Jul 2001 06:00:00 GMT');
header('Last-Modified: ' . ArmiSync::getLastInserted() . ' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');

$resultado_login = Sesion::get('resultado_login', 0);
$datos_login = Sesion::get('datos_login', NULL);
$usuario_inicial = '';
if ($datos_login != NULL){
	$usuario_inicial = $datos_login;
}

?>
<!DOCTYPE html>
<html dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?=Shop::$configuracion->url;?><?=_WS_THEME_RESOURCE_DIR_;?>assets/images/favicon.png">
    <title>Admin</title>
    <!-- Custom CSS -->
	<?php
	Theme::loadMedia(_WS_MEDIA_TYPE_CSS, _WS_MEDIA_POSITION_TOP);
	Theme::loadMedia(_WS_MEDIA_TYPE_JS, _WS_MEDIA_POSITION_TOP);
	?>
</head>

<body>
    <div class="main-wrapper">
       
        <div class="preloader">
            <div class="lds-ripple">
                <div class="lds-pos"></div>
                <div class="lds-pos"></div>
            </div>
        </div>
       
        <div class="auth-wrapper d-flex no-block justify-content-center align-items-center bg-dark">
            <div class="auth-box bg-dark border-top border-secondary">
                <div id="loginform">
                    <div class="text-center p-t-20 p-b-20">
                        <span class="db"><img src="<?=Shop::$configuracion->url;?><?=_WS_THEME_RESOURCE_DIR_;?>/assets/images/logo.png" alt="logo" /></span>
                    </div>
                    <!-- Form -->
                    <form class="form-horizontal m-t-20" id="loginform" method="post">
                        <div class="row p-b-30">
                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-success text-white" id="basic-addon1"><i class="ti-user"></i></span>
                                    </div>
                                    <input type="text" class="form-control form-control-lg" placeholder="Username" aria-label="Username" aria-describedby="basic-addon1" name="usuario" required="">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-warning text-white" id="basic-addon2"><i class="ti-pencil"></i></span>
                                    </div>
                                    <input type="password" class="form-control form-control-lg" placeholder="Password" aria-label="Password" aria-describedby="basic-addon1" name="password" required="">
                                </div>
								<?php
								if ($resultado_login == -1){
									$usuario_inicial = '';
								?>
									<p class="col-12 text-danger text-center"><?=traducir('El usuario especificado no se encuentra en nuestra base de datos.');?></p>
								<?php
								}else if ($resultado_login == -2){
								?>
									<p class="col-12 text-danger text-center"><?=traducir('Contraseña incorrecta.');?></p>
								<?php
								}
								?>
								
                            </div>
                        </div>
                        <div class="row border-top border-secondary">
                            <div class="col-12">
                                <div class="form-group">
                                    <div class="p-t-20">
                                        <button class="btn btn-info" id="to-recover" type="button"><i class="fa fa-lock m-r-5"></i> Lost password?</button>
                                        <button class="btn btn-success float-right" type="submit">Login</button>
                                    </div>
                                </div>
                            </div>
                        </div>
						<input type="hidden" name="accion" value="login">
                    </form>
                </div>
                <div id="recoverform">
                    <div class="text-center">
                        <span class="text-white">Enter your e-mail address below and we will send you instructions how to recover a password.</span>
                    </div>
                    <div class="row m-t-20">
                        <!-- Form -->
                        <form class="col-12" action="index.html">
                            <!-- email -->
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-danger text-white" id="basic-addon1"><i class="ti-email"></i></span>
                                </div>
                                <input type="text" class="form-control form-control-lg" placeholder="Email Address" aria-label="Username" aria-describedby="basic-addon1">
                            </div>
                            <!-- pwd -->
                            <div class="row m-t-20 p-t-20 border-top border-secondary">
                                <div class="col-12">
                                    <a class="btn btn-success" href="#" id="to-login" name="action">Back To Login</a>
                                    <button class="btn btn-info float-right" type="button" name="action">Recover</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
Theme::loadMedia(_WS_MEDIA_TYPE_CSS, _WS_MEDIA_POSITION_BOTTOM);
Theme::loadMedia(_WS_MEDIA_TYPE_JS, _WS_MEDIA_POSITION_BOTTOM);
?>
    <script>

    $('[data-toggle="tooltip"]').tooltip();
    $(".preloader").fadeOut();
    // ============================================================== 
    // Login and Recover Password 
    // ============================================================== 
    $('#to-recover').on("click", function() {
        $("#loginform").slideUp();
        $("#recoverform").fadeIn();
    });
    $('#to-login').click(function(){
        
        $("#recoverform").hide();
        $("#loginform").fadeIn();
    });
    </script>

</body>

</html>
<?php
//Eliminamos el rastro del resultado del login que haya venido por aquí
Sesion::remove('resultado_login');
Sesion::remove('datos_login');