<?php

//---------------------------------------------------------------------------------------------------------
// 15/Abril/2015
// Versión 1.0 Funciones extra a añadir al widget de artículo
//---------------------------------------------------------------------------------------------------------
// 14/Julio/2015
// Versión 1.1 Añadimos los favoritos del producto
//---------------------------------------------------------------------------------------------------------



function valoracion_articulo($objeto_articulo, $puntuacion_maxima = 5) {
    include('comunes/globals.php');
    //Lo primero es comprobar que hayamos recibido un artículo
    if (is_a($objeto_articulo, 'Articulo')) {
        //Para las pruebas, vamos a darle 300 puntos sobre 80 votos
        //$objeto_articulo->suma_votos = 5;
        //$objeto_articulo->total_votos = 2;
        if (($objeto_articulo->total_votos == 0) || ($puntuacion_maxima == 0)) {
            $porcentaje = 0;
        } else {
            $porcentaje = ( ($objeto_articulo->suma_votos / $objeto_articulo->total_votos) * 100) / $puntuacion_maxima;
        }
        //$porcentaje = 50;
        ?>
        <div class="<?= (__FUNCTION__); ?>" id="votacion_articulo_<?= $objeto_articulo->codigo; ?>">
            <?php
            //Vamos a comprobar en las cookies si el artículo ya ha sido votado en esta sesión
            $codigos_votados = Sesion::getCookieValue('codigos_votados');
            $array_codigos_votados = array();
            if ($codigos_votados != NULL) {
                //transformamos la variable en una lista
                $array_codigos_votados = explode(',', $codigos_votados);
            }
            //Si el ean está en el array de codigos_votados, entonces mostramos un div en vez e un a
            if (in_array($objeto_articulo->codigo, $array_codigos_votados)) {
                ?>
                <div class="silueta"></div>
                <?php
            } else {
                ?>
                <a href="javascript:void(0);" class="silueta"></a>
                <?php
            }
            ?>
            <div class="fondo" style="width:0%"></div>
            <div class="votacion_hecha">
                <?php
                if (in_array($objeto_articulo->codigo, $array_codigos_votados)) {
                    ?>
                    <p class="votacion_hecha"><?= traducir('Gracias por valorar este artículo'); ?></p>
                    <?php
                }
                ?>
            </div>
        </div>
        <?php
        $nombre_script = 'script_' . incrementa_contador();
        ?>
        <script type="text/javascript" id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var limite_estrellas = <?= $puntuacion_maxima; ?>;
                var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                var estrellas_actual = 0;
                var codigos_votados = '<?= $codigos_votados; ?>';
                //Vamos a hacer la animación de que las estrellas se rellenan, pero lo haremos dentro de 1 segundo
                setTimeout(function () {
                    elementObjetive.find('.fondo').animate({width: '<?= $porcentaje; ?>%'}, 'fast');
                    //Y aquí asociamos los eventos
                    elementObjetive.find("a.silueta").on("mousemove", function (event) {
                        var valores = calcula_porcentaje(event);
                        var estrellas = valores[0];
                        var porcentaje = valores[1];
                        //Si las estrellas han cambiado entonces hacemos lo correspondiente
                        if (estrellas != estrellas_actual) {
                            var palabra = (estrellas == 1) ? "<?= traducir("estrella"); ?>" : "<?= traducir("estrellas"); ?>";
                            elementObjetive.find("a.silueta").attr("title", "<?= traducir("Valorar con"); ?>: " + estrellas + " " + palabra);
                            entra(porcentaje);
                            estrellas_actual = estrellas;
                        }
                    });
                    elementObjetive.find("a.silueta").on("mouseleave", function (event) {
                        sale();
                    });
                    elementObjetive.find("a.silueta").on("click", function (event) {
                        var valores = calcula_porcentaje(event);
                        //Lo primero es recalcular la nueva valoracion del artículo
                        var porcentaje = (((<?= $objeto_articulo->suma_votos; ?> + valores[0]) / (<?= $objeto_articulo->total_votos; ?> + 1)) * 100) / limite_estrellas;
                        //Vamos a cambiar la clase del objeto "silueta" para quitar los eventos asociados y el ratón
                        var capa_temporal = $('<div class="silueta"></div>');
                        //Añadimos la capa temporal y borramos silueta
                        capa_temporal.insertBefore(elementObjetive.find("a.silueta"));
                        elementObjetive.find("a.silueta").remove();
                        entra(porcentaje);

                        var direccion = '<?= Shop::$configuracion->url; ?>comunes/consultas/valorar_articulo.php';
                        //Vamos a lanzar la consulta
                        var parametros = "valoracion=" + valores[0] + "&articulo=" + <?= $objeto_articulo->codigo; ?> + "&hash=<?= genera_cod_seguridad(); ?>";
                        realizar_solicitud(direccion, parametros, function (respuesta) {
                            //console.log(respuesta);
                            //Vamos a grabar en las cookies
                            codigos_votados += ((codigos_votados != "") ? "," : "") + <?= $objeto_articulo->codigo; ?>;
                            document.cookie = "codigos_votados=" + codigos_votados + "; domain=<?= $dominio; ?>;path=<?= $carpeta; ?>;";
                            var nueva_capa = $('<p class="votacion_hecha" style="display:none;"><?= traducir("Gracias por valorar este artículo"); ?></p>').appendTo(elementObjetive.find("div.votacion_hecha"));
                            nueva_capa.show('slow');
                        });

                    });
                }, 1000);

                function entra(porcentaje) {
                    elementObjetive.find(".fondo").stop();
                    elementObjetive.find(".fondo").animate({width: porcentaje + '%'}, 'fast');
                }
                function sale() {
                    elementObjetive.find(".fondo").stop();
                    elementObjetive.find(".fondo").animate({width: '<?= $porcentaje; ?>%'}, 'fast');
                    estrellas_actual = 0;
                }
                function calcula_porcentaje(event) {
                    //Ahora tenemos que ver en qué posición está el raton
                    var x = y = -1;
                    if (event.offsetX != null) { // Opera, Chrome
                        x = event.offsetX;
                    } else if (event.layerX != null) { // Firefox
                        x = event.layerX;
                    }
                    //console.log("se mueve: x=",x," y=",y);
                    var H = elementObjetive.find("a.silueta").width();
                    var estrellas = Math.ceil((limite_estrellas * x) / H);
                    var porcentaje = estrellas * (100 / limite_estrellas);
                    return(new Array(estrellas, porcentaje));
                }
            }());
		});
        </script>
        <?php
    }
}

function comentario_articulo($objeto_articulo) {
    include('comunes/globals.php');
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <p class="cabecera_comentarios"><?= traducir('Comentarios'); ?></p>
        <?php
        if (Usuario::logueado() == NULL) {
            ?>
            <p><?= traducir('Sólo los usuarios registrados pueden publicar comentarios'); ?>.</p>
            <?php
            new Widget($_WH->GW('usuario', 'acceso_usuario'), array(), 'Inicio de sesión', true, '|', 'modal', 'incrustado');
        } else {
            ?>
            <p><?= traducir('Tu opinión nos interesa. Escríbenos lo que te ha parecido este libro'); ?></p>
            <form class="formulario_comentario" action="<?= Shop::$configuracion->url; ?>comunes/consultas/nuevo_comentario.php">
                <label><?= traducir('Escritor: (este nombre aparecerá al pie del comentario como autor)'); ?></label>
                <input name="escritor" value="" class="autor_comentario" required />
                <label><?= traducir('Comentario:'); ?></label>
                <textarea class="comentario" name="comentario" required></textarea>
                <p class="error_comentario"></p>
                <input type="submit" value="<?= traducir('Enviar'); ?>" />
            </form>
            <?php
        }
        ?>
        <div class="lista_comentarios">
            <?php
            if ($datos_usuario->administrador) {
                //Si el usuario es administrador, cargamos todos los comentarios
                $sentencia_sql = "SELECT codigo FROM comentario WHERE articulo = $objeto_articulo->codigo ORDER BY fecha DESC";
            } else {
                //En caso contrario sólo salen los que no están denunciados
                $sentencia_sql = "SELECT codigo FROM comentario WHERE articulo = $objeto_articulo->codigo AND denuncias = 0 ORDER BY fecha DESC";
            }
            if ($conexionBD) {
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    while ($fila = mysqli_fetch_array($resultado)) {
                        new Widget($_WH->GW('articulo', 'comentario_usuario'), $fila['codigo']);
                    }
                }
            }
            ?>
        </div>
    </div>
    <?php
    //Hay que crear un nombre para el script
    $nombre_script = 'script_' . incrementa_contador(true);
    ?>
    <script type="text/javascript" id="<?= $nombre_script; ?>">
	document.addEventListener('WSLE', function(event) {
        ;(function () {
            var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
            var formulario = elementObjetive.find("form.formulario_comentario");
            formulario.on("submit", function (event) {
                event.preventDefault();
                var escritor = formulario.find('input[name="escritor"]').val().trim();
                var comentario = formulario.find('textarea[name="comentario"]').val().trim();
                var direccion = formulario.attr("action");
                //Antes de seguir, hay que asegurarse de que todos los campos están rellenos
                if (escritor == "") {
                    //Error con el escritor
                    formulario.find('.error_comentario').text("<?= traducir("Debe especificar su nombre"); ?>");
                    poner_sombra(formulario.find('input[name="escritor"]'));
                    formulario.find('input[name="escritor"]').focus();
                } else if (comentario == "") {
                    //Error con el comentario
                    formulario.find('.error_comentario').text("<?= traducir("Escriba un comentario"); ?>");
                    poner_sombra(formulario.find('textarea[name="comentario"]'));
                    formulario.find('textarea[name="comentario"]').focus();
                } else {
                    //Quitamos el formulario
                    formulario.hide('fast', function () {
                        formulario.remove();
                    });
                    var parametros = "escritor=" + escritor + "&comentario=" + comentario + "&articulo=<?= $objeto_articulo->codigo; ?>&cliente=<?= $datos_usuario->codigo; ?>&url_comentario=<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>&hash=<?= genera_cod_seguridad(); ?>";
                    realizar_solicitud(direccion, parametros, function (respuesta) {
                        if (respuesta != "") {
                            //Vamos a insertar el comentario
                            var nuevo_elemento = $(respuesta);
                            nuevo_elemento.css("display", "none");
                            nuevo_elemento = nuevo_elemento.prependTo(elementObjetive.find("div.lista_comentarios"));
                            nuevo_elemento.show('slow');
                        }
                        //Vamos a grabar en las cookies
                    });
                }
            });
            //Por si tienen sombra, se la quitamos
            formulario.find('input[name="escritor"]').on("input", function () {
                quitar_sombra($(this));
            });
            formulario.find('input[name="comentario"]').on("input", function () {
                quitar_sombra($(this));
            });
        }());
	});
    </script>
    <?php
}

function comentario_usuario($codigo, $solo_comentario = false) {
    include('comunes/globals.php');
    if ($datos_usuario->administrador) {
        //Si el usuario es administrador, cargamos todos los comentarios
        $sentencia_sql = 'SELECT codigo, nombre, texto, cod_cliente, denuncias FROM comentario WHERE codigo = ' . $codigo;
    } else {
        //En caso contrario sólo salen los que no están denunciados
        $sentencia_sql = "SELECT codigo, nombre, texto, cod_cliente, denuncias FROM comentario WHERE codigo = $codigo AND denuncias = 0";
    }
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                ?>
                <div class="<?= (__FUNCTION__); ?>" id="comentario_<?= $fila['codigo']; ?>">
                    <p class="texto_comentario"><?= $fila['texto']; ?></p>
                    <p class="usuario_comentario"><?= $fila['nombre']; ?></p>
                    <?php
                    //Sólo permitimos estos botones si no estamos en modo "sólo comentario"
                    if (!$solo_comentario) {
                        //Si el comentario es nuestro o somos administradores ponemos los botones para borrarlo
                        if (($fila['cod_cliente'] == $datos_usuario->codigo) || ($datos_usuario->administrador)) {
                            //Si el usuario es administrador, vamos a ver cuantas denuncias tiene este comentario
                            if (($datos_usuario->administrador) && ($fila['denuncias'] > 0)) {
                                ?>
                                <p class="comentario_denunciado"><?= traducir('Comentario denunciado'); ?></p>
                                <a class="eliminar_denuncias" href="javascript:void(0);" title="<?= traducir('Eliminar denuncia'); ?>"><?= traducir("Eliminar denuncias"); ?></a>
                                <?php
                                //Hay que crear un nombre para el script
                                $nombre_script = 'script_' . incrementa_contador(true);
                                ?>
                                <script type="text/javascript" id="<?= $nombre_script; ?>">
								document.addEventListener('WSLE', function(event) {
                                    ;(function () {
                                        var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                                        elementObjetive.on("click", function (event) {
                                            if (confirm("<?= traducir("Para eliminar la denuncia de este comentario pulse 'Aceptar'. En caso contrario pulse 'Cancelar'"); ?>")) {
                                                //necesitamos el código del comentario
                                                var cod_comentario = $(this).parent("div.comentario_usuario").attr("id").split("_")[1];
                                                var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/eliminar_denuncias_comentario.php";
                                                var parametros = "comentario=" + cod_comentario + "&hash=<?= genera_cod_seguridad(); ?>";
                                                realizar_solicitud(direccion, parametros, function (respuesta) {
                                                    if (respuesta == "CORRECTO") {
                                                        //Ocultamos el elemento y después lo borramos
                                                        elementObjetive.hide('fast', function () {
                                                            $(this).remove();
                                                        });
                                                        elementObjetive.parent("div.comentario_usuario").find("p.comentario_denunciado").hide('fast', function () {
                                                            $(this).remove();
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }());
								});
                                </script>
                                <?php
                            }
                            ?>
                            <a href="javascript:void(0);" title="<?= traducir('Eliminar comentario'); ?>"><?= traducir('Eliminar comentario'); ?></a>
                            <?php
                            //Hay que crear un nombre para el script
                            $nombre_script = 'script_' . incrementa_contador(true);
                            ?>
                            <script type="text/javascript" id="<?= $nombre_script; ?>">
							document.addEventListener('WSLE', function(event) {
                                ;(function () {
                                    var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                                    elementObjetive.on('click', function (event) {
                                        if (confirm("<?= traducir('Para eliminar este comentario pulse "Aceptar". En caso contrario pulse "Cancelar"'); ?>")) {
                                            //necesitamos el código del comentario
                                            var cod_comentario = $(this).parent("div.comentario_usuario").attr("id").split("_")[1];
                                            var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/borrar_comentario.php";
                                            var parametros = "comentario=" + cod_comentario + "&hash=<?= genera_cod_seguridad(); ?>";
                                            realizar_solicitud(direccion, parametros, function (respuesta) {
                                                if (respuesta == "CORRECTO") {
                                                    //Ocultamos el elemento y después lo borramos
                                                    elementObjetive.parent("div.comentario_usuario").hide('fast', function () {
                                                        $(this).remove();
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }());
							});
                            </script>
                            <?php
                        } else {
                            //Si no estamos logueados ponemos el botón de "denunciar"
                            ?>
                            <a href="javascript:void(0);" title="<?= traducir('Marcar como inapropiado'); ?>"><?= traducir('Marcar como inapropiado'); ?></a>
                            <?php
                            //Hay que crear un nombre para el script
                            $nombre_script = 'script_' . incrementa_contador(true);
                            ?>
                            <script type="text/javascript" id="<?= $nombre_script; ?>">
							document.addEventListener('WSLE', function(event) {
                                ;(function () {
                                    var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                                    elementObjetive.on("click", function (event) {
                                        if (confirm("<?= traducir("Para denunciar este comentario pulse 'Aceptar'. En caso contrario pulse 'Cancelar'"); ?>")) {
                                            //necesitamos el código del comentario
                                            var cod_comentario = $(this).parent("div.comentario_usuario").attr("id").split("_")[1];
                                            var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/comentario_inapropiado.php";
                                            var parametros = "comentario=" + cod_comentario + "&url_comentario=<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>&hash=<?= genera_cod_seguridad(); ?>";
                                            realizar_solicitud(direccion, parametros, function (respuesta) {
                                                if (respuesta == "CORRECTO") {
                                                    //Ocultamos el elemento y después lo borramos
                                                    elementObjetive.parent("div.comentario_usuario").hide('fast', function () {
                                                        $(this).remove();
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }());
							});
                            </script>
                            <?php
                        }
                    }
                    ?>
                </div>
                <?php
            }
        }
    }
}

function articulo_solicitar_info($objeto_articulo, $array_campos = array('nombre', 'email', 'datos_producto'), $campos_obligatorios = array('nombre', 'email'), $catpcha = true, $valores_x_defecto = NULL, $campos_no_editables = array('datos_producto'), $recomendacion = 0) {
    if (is_a($objeto_articulo, 'Articulo')) {
        include('comunes/globals.php');
        //Si por algún motivo no nos han enviado valores por defecto, o si lo han hecho y no está el "Datos produto", lo componemos nosotros
        $componer_datos_articulo = false;
        if ($valores_x_defecto == NULL) {
            $componer_datos_articulo = true;
            $valores_x_defecto = array();
        }
        if (!$componer_datos_articulo) {
            if (!in_array('datos_producto', $valores_x_defecto)) {
                $componer_datos_articulo = true;
            }
        }
        //Llegados a este punto, comprobamos si hay que componer los datos del artículo
        if ($componer_datos_articulo) {
            $valores_x_defecto['datos_producto'] = traducir('Información referente al producto: ') . "$objeto_articulo->ean - $objeto_articulo->nombre ($objeto_articulo->codigo)";
        }
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            echo $recomendacion;
            //Nos creamos un widget de contacto
            //$array_campos = array("nombre", "email"), $campos_obligatorios = array("nombre", "email"), $catpcha = true, $valores_x_defecto = array(), $campos_no_editables = array(), $tipos = NULL, $mostrar_condiciones_privacidad = true, $recomendar = 0
            $widgetContacto = new Widget($_WH->GW('contacto'), $array_campos, $campos_obligatorios, $catpcha, $valores_x_defecto, $campos_no_editables, NULL, true, $recomendacion);
            ?>
        </div>
        <?php
    }
}

function google_shopping_itemprop($objeto_articulo) {
    $configuracion = dame_valor_variable_global('configuracion', '');
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <!--Datos para google shoping-->
        <span itemprop="name" content="<?= $objeto_articulo->nombre; ?>"></span>
        <span itemprop="offerURL" content="<?= $objeto_articulo->url; ?>"></span>
        <span itemprop="image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $objeto_articulo->ean; ?>.jpg"></span>
        <span itemprop="offerDetails" itemscope itemtype="http://data-vocabulary.org/Offer">
            <span itemprop="identifier" content="isbn:<?= $objeto_articulo->ean; ?>"></span>
            <span class="precio-producto">
                <span itemprop="price" content="<?= number_format($objeto_articulo->pvp, Shop::$configuracion->decimales, ",", "."); ?>"></span>
                <span itemprop="currency" content="EUR"></span>
            </span>
            <?php
            if ($objeto_articulo->stock > 0) {
                $disponibilidad = 'in_stock';
            } else {
                $disponibilidad = 'out_of_stock';
            }
            ?>
            <span itemprop="availability" content="<?= $disponibilidad; ?>"></span>
        </span>
    </div>
    <?php
}

function favoritosCliente($opciones = NULL) {
    include('comunes/globals.php');
    //Tratamiento de las opciones
    if (!is_a($opciones, 'OpcionesWidget')) {
        $opciones = new OpcionesWidget(array('fichero_perso' => 'ficha_favoritos'));
    }
    //Procesamos las opciones
    $fichero_perso = ($opciones->configuracion->fichero_perso == NULL) ? 'ficha_favoritos' : $opciones->configuracion->fichero_perso;
    $objeto_cliente = ($opciones->configuracion->objeto_cliente == NULL) ? Usuario::logueado() : $opciones->configuracion->objeto_cliente;
    //Si no hay cliente, no seguimos
    if ((is_a($objeto_cliente, 'Usuario')) && (is_string($fichero_perso))) {
        //Los favoritos se mostrarán cómo una lista (<ul><li></li></ul>
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <ul>
                <?php
                foreach ($objeto_cliente->favoritos as $clave => $valor) {
                    //Creamos el artículo
                    $articulo_a_mostrar = new Articulo($valor);
                    ?>
                    <li>
                        <?php
                        new Widget($_WH->GW('articulo', $fichero_perso), $articulo_a_mostrar);
                        //Después del artículo, vamos a poner el botón de borrar
                        ?>
                        <a class="boton" title="<?= traducir('Quitar de favoritos'); ?>" href="javascript:void(0);"><?= traducir('Quitar de favoritos'); ?></a>
                        <?php
                        $nombre_script = 'script_' . incrementa_contador();
                        ?>
                        <script id="<?= $nombre_script; ?>">
						document.addEventListener('WSLE', function(event) {
                            ;(function () {
                                var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                                enlace.on("click", function () {
                                    var ficha_producto_li = $(this).parent("li");
                                    var articulo = '<?= $articulo_a_mostrar->codigo; ?>';
                                    var usuario = '<?= $objeto_cliente->codigo; ?>';
                                    //Realizamos la consulta
                                    var parametros = "articulo=" + articulo + "&usuario=" + usuario + "&hash=<?= genera_cod_seguridad(); ?>";
                                    realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/borrar_favorito.php", parametros, function (respuesta) {
                                        //Si todo ha ido correcto
                                        if (respuesta.toUpperCase() == "CORRECTO") {
                                            //Hay que eliminar el enlaec y la ficha del producto
                                            ficha_producto_li.fadeOut(500, function () {
                                                $(this).remove();
                                            });
                                        }
                                    });
                                });
                            })();
						});
                        </script>
                    </li>
                    <?php
                    //Eliminamos el artículo
                    unset($articulo_a_mostrar);
                }
                ?>
            </ul>
        </div>
        <?php
    }
}

function addFavoritos($articulo = NULL, $usuario = NULL) {
    include('comunes/globals.php');
    //print_r($articulo);
    if (is_a($articulo, 'Articulo')) {
        $usuario = ($usuario == NULL) ? Usuario::logueado() : $usuario;
        if (is_a($usuario, 'Usuario')) {
            //print_r($usuario);
            //Hay que ver si el usuario tiene o no el producto en sus favoritos
            if (in_array($articulo->codigo, $usuario->favoritos)) {
                ?>
                <a class="quitar_favoritos" title="<?= traducir('Quitar de favoritos'); ?>" href="javascript:void(0);"><?= traducir('Quitar de favoritos'); ?></a>
                <?php
            } else {
                ?>
                <a class="add_favoritos" title="<?= traducir('Añadir a favoritos'); ?>" href="javasript:void(0);"><?= traducir('Añadir a favoritos'); ?></a>
                <?php
            }
            //Ahora creamos el script
            $nombre_script = 'script_' . incrementa_contador();
            ?>
            <script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                    enlace.on("click", function () {
                        var accion = "add";
                        //Vamos a tener en cuenta si estamos elimiando o añadiendo
                        if ($(this).attr("class") == 'quitar_favoritos') {
                            //Quitar
                            accion = "quitar"
                        }
                        var ficha_producto_li = $(this).parent("li");
                        var articulo = '<?= $articulo->codigo; ?>';
                        var usuario = '<?= $usuario->codigo; ?>';
                        //Realizamos la consulta
                        var parametros = "articulo=" + articulo + "&usuario=" + usuario + "&hash=<?= genera_cod_seguridad(); ?>";
                        var url = (accion == "quitar") ? "<?= Shop::$configuracion->url; ?>comunes/consultas/borrar_favorito.php" : "<?= Shop::$configuracion->url; ?>comunes/consultas/add_favorito.php";
                        //
                        realizar_solicitud(url, parametros, function (respuesta) {
                            //console.log(respuesta);
                            //Si todo ha ido correcto
                            if (respuesta.toUpperCase() == "CORRECTO") {
                                //Hay que eliminar el enlaec y la ficha del producto
                                //Según la acción hay que tener en cuenta una cosa u otra
                                if (accion == "quitar") {
                                    enlace.html("<?= traducir("Añadir a favoritos"); ?>");
                                    enlace.prop("title", "<?= html_entity_decode(traducir("Añadir a favoritos")); ?>");
                                    enlace.prop("class", "add_favoritos");
                                } else {
                                    enlace.html("<?= traducir("Quitar de favoritos"); ?>");
                                    enlace.prop("title", "<?= html_entity_decode(traducir("Quitar de favoritos")); ?>");
                                    enlace.prop("class", "quitar_favoritos");
                                }
                            }
                        });
                    });
                })();
			});
            </script>
            <?php
        } else {
            ?>
            <a class="not_add_favoritos" title="<?= traducir("Debe iniciar sesión para añadir un producto a favoritos"); ?>" href="javascript:void(0);"><?= traducir("Debe iniciar sesión para añadir un producto a favoritos"); ?></a>
            <?php
        }
    }
}

/**
 *
 */
function btnComprar($opciones = NULL) {
    include('comunes/globals.php');
    $articulo = $articulo_actual;
    $fichero_boton = 'botonComprar';
    $fichero_boton_sin_login = 'btnComprarSinLogin';
    $cantidad_dinamica = false;
    $input = '';
    $addBtnCantidad = false;
    $tipo = 'select'; // Input o select
    $minValue = 1;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $mostrarBoton = true; //bandera que nos determina si mostraremos el boton o no
        $cantidad_dinamica = ($opciones->configuracion->cantidad_dinamica != NULL) ? $opciones->configuracion->cantidad_dinamica : $cantidad_dinamica;
        $articulo = ($opciones->configuracion->articulo != NULL) ? $opciones->configuracion->articulo : $articulo;
        $fichero_boton = ($opciones->configuracion->fichero_boton != NULL) ? $opciones->configuracion->fichero_boton : $fichero_boton;
        $fichero_boton_sin_login = ($opciones->configuracion->fichero_boton_sin_login != NULL) ? $opciones->configuracion->fichero_boton_sin_login : $fichero_boton_sin_login;
        $addBtnCantidad = ($opciones->configuracion->addBtnCantidad != NULL) ? $opciones->configuracion->addBtnCantidad : $addBtnCantidad;
        $input = ($opciones->configuracion->input != NULL) ? $opciones->configuracion->input : $input;
        $minValue = ($opciones->configuracion->minValue != NULL) ? $opciones->configuracion->minValue : $minValue;
        if (is_a($articulo, 'Articulo')) {
            //Variables que vamos a poner en disponibles en el widget:
            $articulo_a_mostrar = $articulo;
            $extradata = '';
            $clase = '';
            $btnMas = $btnMenos = '';
            //Comprobamos si la opcion de controlar Stock esta activa
            if (Shop::$configuracion->controlar_stock) {
                //En caso de estarlo comprbamos que sea 0 o menor
                if ($articulo->stock <= 0) {
                    $mostrarBoton = false;
                }
            }
            if (Shop::$configuracion->controlar_stock) {
                $stock = 0;
                $cantidadCesta = 0;
                //echo $articulo->ean;
                $array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
                $indiceArt = busca_articulo_cesta($articulo->codigo, 0);
                //echo $indiceArt;
                if ($indiceArt >= 0) {
                    $cantidadCesta = $array_cantidades_cesta[$indiceArt];
                }
                $stock = $articulo->stock;
                if ($stock - $cantidadCesta <= 0) {
                    $clase = '_disabled';
                }
            }
            ?>
            <div class="<?= (__FUNCTION__) . $clase; ?>">
                <?php
                $cantidad = ($opciones->configuracion->cantidad != NULL) ? $opciones->configuracion->cantidad : $articulo_a_mostrar->unidades_caja;
                //Si el logine s necesario y no estamos logueados, entonces el enlace va a la cesta directamente
				//var_dump(Shop::$configuracion->cesta_login_inicio);
				//var_dump(Usuario::logueado());
                if ((Shop::$configuracion->cesta_login_inicio) && (Usuario::logueado() == NULL)) {
                    //Aquí incluimos el fichero
                    $ruta_fichero = Theme::findFile($fichero_boton_sin_login . '.php');
                    if ($ruta_fichero != NULL) {
                        include($ruta_fichero);
                    }
                } else {
                    //Si la cantidad es dinámica, hay que hacer el formulario de mod de cantidad
                    if ($cantidad_dinamica) {
                        //hay que grabar este html para usarlo después en una variable
                        ob_start();
                        ?>
                        <form class="cantidadBtnComprar">
                            <fieldset>
                                <?php
                                if ($articulo_a_mostrar->unidades_caja > 1 && $tipo == 'select') {
                                    //$script_btn_comprar = "addToCookieBasket('" . $articulo_a_mostrar->ean . "', $(this).parent().prev('form').find('.cantidad_compra option:selected').text(), $(this));";
                                    $script_btn_comprar = "addToCookieBasket('" . $articulo_a_mostrar->codigo . "', $(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('select.cantidad_compra option:selected').text(), $(this));";
                                    ?>
                                    <select name="cantidad" class="cantidad_compra">
                                        <?php
                                        $contador_cantidad = 0;
                                        $limite = 15 * $articulo_a_mostrar->unidades_caja;
                                        for ($i = 0; $contador_cantidad <= $limite; $i++) {
                                            $cantidad_a_mostrar = $i * $articulo_a_mostrar->unidades_caja;
                                            $cantidad_justificada = str_pad($cantidad_a_mostrar, strlen($limite), "0", STR_PAD_LEFT);
                                            $txt_seleccionado = ($cantidad_a_mostrar == $articulo_a_mostrar->unidades_caja) ? "selected" : "";
                                            ?>
                                            <option class="opcion_selector_btn_cesta" value="<?= $cantidad_a_mostrar; ?>" <?= $txt_seleccionado; ?> ><?= $cantidad_justificada; ?></option>
                                            <?php
                                            $contador_cantidad += $articulo_a_mostrar->unidades_caja;
                                        }
                                        ?>
                                    </select>
                                    <?php
                                } else {
									$script_btn_comprar = 'addToBasket({codigo_articulo:' . $articulo_a_mostrar->codigo . ', accion:\'sumar\', cantidad:' . $cantidad . ',element:$(this).parents(\'.btnComprar\').find(\'form.cantidadBtnComprar\').find(\'input.cantidad_compra\'),button:$(this)});';
                                    //$script_btn_comprar = "addToCookieBasket('" . $articulo_a_mostrar->codigo . "', $(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('input.cantidad_compra').val(), $(this));";
                                    ?>
                                    <input type="number" class="cantidad_compra" name="cantidad" value="<?= $articulo_a_mostrar->unidades_caja; ?>" min="<?= $minValue ?>"/>
                                    <?php
                                }
                                ?>
                            </fieldset>
                        </form>
                        <?php
                        //Dejamos de grabar
                        $extradata = ob_get_contents();
                        ob_end_clean();
                        if ($addBtnCantidad) {
                            //Si hay que añadir los botones de + y -, vamos a añadir aquí el script:
                            ob_start();
                            ?>
                            <a href="javascript:void(0);" title="<?= traducir('Quitar una unidad'); ?>" onclick="var valor = parseInt($(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('input.cantidad_compra').val()); valor = (valor > 0) ? valor - 1 : 0;$(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('input.cantidad_compra').val(valor)">-</a>
                            <?php
                            $btnMenos = ob_get_contents();
                            ob_end_clean();

                            ob_start();
                            ?>
                            <a href="javascript:void(0);" title="<?= traducir('Añadir una unidad'); ?>" onclick="var valor = parseInt($(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('input.cantidad_compra').val()); $(this).parents('.btnComprar').find('form.cantidadBtnComprar').find('input.cantidad_compra').val(valor + 1)">+</a>
                            <?php
                            $btnMas = ob_get_contents();
                            ob_end_clean();
                        }
                    } else {

						//Vamos a montar el nuevo script de comprar:
						$script_btn_comprar = 'addToBasket({codigo_articulo:' . $articulo_a_mostrar->codigo . ', accion:\'sumar\', cantidad:' . $cantidad . ',button:$(this)});';
						
                        //$script_btn_comprar = "addToCookieBasket('" . $articulo_a_mostrar->codigo . "', " . $cantidad . ', $(this));';
                    }
                    if ($mostrarBoton) {
                        //Aquí incluimos el fichero
                        $ruta_fichero = Theme::findFile($fichero_boton . '.php');
                        if ($ruta_fichero != NULL) {
                            include($ruta_fichero);
                        } else {
                            //echo("No se encuentra: $fichero_boton");						
                        }
                    }
                }
                ?>
            </div>
            <?php
        }
    }
}

function selectorListaArticulos($opciones) {
    include('comunes/globals.php');
    if (is_a($opciones, 'OpcionesWidget')) {
        $tipo_selector = ($opciones->configuracion->tipo_selector != NULL) ? $opciones->configuracion->tipo_selector : '';
        $frase = ($opciones->configuracion->frase != NULL) ? $opciones->configuracion->frase : '';
        $tipo_actual = ($opciones->configuracion->tipo_actual != NULL) ? $opciones->configuracion->tipo_actual : '';
        $clase = ($opciones->configuracion->clase != NULL) ? $opciones->configuracion->clase : '';
        //Hay que decidir si tenemos el tipo seleccionado y cual tenemos seleccionado
        $tipo_seleccionado = false;
        if ($tipo_actual == '') {
            $tipo_actual = Sesion::get('tipo_ficha_producto');
        }
        if ($tipo_actual == NULL) {
            $tipo_actual = '';
        }
        if ($tipo_selector == $tipo_actual) {
            $tipo_seleccionado = true;
        }
        ?>
        <form class="<?= (__FUNCTION__); ?> <?= ($tipo_seleccionado) ? ' seleccionado' : ''; ?> <?= $clase; ?>" action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post">
            <span <?= ($tipo_seleccionado) ? 'class="seleccionado"' : ""; ?>><?= traducir($frase); ?></span>
            <?php
//Vamos a meter el script sólo cuando el selector sea distinto del actual
            if (!$tipo_seleccionado) {
                $nombre_script = 'script_' . incrementa_contador();
                ?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                        enlace.on("click", function () {
                            $(this).parent("form").submit();
                        });
                    })();
				});
                </script>
                <?php
            }
            ?>
            <input type="hidden" name="tipo_ficha_producto" value="<?= $tipo_selector; ?>" />
        </form>
        <?php
    }
}

function selector_orden_articulos($opciones = NULL) {
    include('comunes/globals.php');
    $orden_actual = Sesion::get('orden_lista_productos');
    if (is_a($opciones, 'OpcionesWidget')) {
        $clase_elemento = ($opciones->configuracion->clase_elemento != NULL) ? $opciones->configuracion->clase_elemento : '';
        $elemento_actual = ($opciones->configuracion->elemento_actual != NULL) ? $opciones->configuracion->elemento_actual : $orden_actual;
        if (count($opciones->elementos) > 0) {
            ?>
            <form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" <?= ($clase_elemento != "") ? 'class="' . $clase_elemento . '" ' : ""; ?> method="post">
                <select <?= ($clase_elemento != "") ? 'class="' . $clase_elemento . '" ' : ""; ?> name="orden_lista_productos">
                    <?php
                    foreach ($opciones->elementos as $clave => $valor) {
                        ?>
                        <option value="<?= $valor->valor; ?>" <?= ($orden_actual == $valor->valor) ? 'selected="selected"' : ""; ?>><?= $valor->texto_a_mostrar; ?></option>
                        <?php
                    }
                    ?>
                </select>
                <?php
                $nombre_script = 'script_' . incrementa_contador();
                ?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                        enlace.on("change", function () {
                            $(this).parent("form").submit();
                        });
                    })();
				});
                </script>
            </form>
            <?php
        }
    }
}

function selector_articulos_por_pagina($opciones = NULL) {
    include('comunes/globals.php');
    $elementos_por_pagina = Sesion::get('elementos_por_pagina');
    if (is_a($opciones, 'OpcionesWidget')) {
        $clase_elemento = ($opciones->configuracion->clase_elemento != NULL) ? $opciones->configuracion->clase_elemento : '';
        $elemento_actual = ($opciones->configuracion->elemento_actual != NULL) ? $opciones->configuracion->elemento_actual : $elementos_por_pagina;
        if (count($opciones->elementos) > 0) {
            ?>
            <form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" <?= ($clase_elemento != '') ? 'class="' . $clase_elemento . '" ' : ""; ?> method="post">
                <select <?= ($clase_elemento != "") ? 'class="' . $clase_elemento . '" ' : ""; ?> name="elementos_por_pagina">
                    <?php
                    foreach ($opciones->elementos as $clave => $valor) {
                        ?>
                        <option value="<?= $valor->valor; ?>" <?= ($elementos_por_pagina == $valor->valor) ? 'selected="selected"' : ''; ?>><?= $valor->texto_a_mostrar; ?></option>
                        <?php
                    }
                    ?>
                </select>
                <?php
                $nombre_script = 'script_' . incrementa_contador();
                ?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                        enlace.on("change", function () {
                            $(this).parent("form").submit();
                        });
                    })();
				});
                </script>
            </form>
            <?php
        }
    }
}

/**
 *  Obtiene una lista de los articulos hijos
 * */
function getArticuloExtra($opciones = NULL) {
    include('comunes/globals.php');
    $ruta_fichero = ($opciones->configuracion->ruta_fichero != NULL) ? $opciones->configuracion->ruta_fichero : 'extrasArticulo';
    $campos = ($opciones->configuracion->campos != NULL) ? $opciones->configuracion->campos : array('talla', 'color');
    $valores = ($opciones->configuracion->valores != NULL) ? $opciones->configuracion->valores : NULL;
    $padre = ($opciones->configuracion->padre != NULL) ? $opciones->configuracion->padre : 0;
    $articulo = ($opciones->configuracion->articulo != NULL) ? $opciones->configuracion->articulo : NULL;
    //Vamos a controlar que tenemos un objeto artículo
    if (!is_a($articulo, 'Articulo')) {
        $articulo = new Articulo($articulo);
    }

    //Siempre tenemos en mente el campo primero que vamos a sacar, por eso es importante el orden.
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <?php
        for ($i = 0; $i < count($campos); $i++) {
            $campos2 = $campos;
            //Este solo contiene los demas elementos menos el que se está lanzando de forma que en JS no haya que preocuparse de el.
            unset($campos2[$i]);
            $opciones = new OpcionesWidget(array('ruta_fichero' => $ruta_fichero, 'campos' => $campos2, 'padre' => $padre, 'soy' => $campos[$i], 'valor' => $valores[$i]));
            new Widget($_WH->GW('articulo', 'getPersonalizable'), $opciones);
        }
        ?>
    </div>
    <?php
    $nombre_script = 'script_' . incrementa_contador(true);
    ?>
    <script type="text/javascript" id="<?= $nombre_script; ?>">
	document.addEventListener('WSLE', function(event) {
        ;(function () {
            var ultimoCampo = getLastHtmlObject('<?= $nombre_script; ?>');
            //var padreSelectores = $(ultimoCampo).closest(".<?= (__FUNCTION__); ?>");
            //var camposUpdate = [];
    <?php
    /* 	foreach($camposUpdate as $key => $val){
      ?>
      camposUpdate['<?= $val ;?>'] ='<?=$val; ?>';
      <?php
      }
     */
    ?>
            var totalCampos = <?= count($campos); ?>;
            var flag = true;
            /*
             function colocarConten(json){
             for(var key in camposUpdate){
             if(camposUpdate[key] == 'observaciones'){
             var iframe=$("[data-update='observaciones']").find('div');
             $("[data-update='observaciones']").html('');
             $("[data-update='observaciones']").append(iframe);
             $("[data-update='observaciones']").append(json.observaciones);
             }else if(key =="pvp_final" || key == "pvp"){				
             $("[data-update='"+key+"']").html(new Intl.NumberFormat("de-DE").format(json[key]));
             }
             }
             //$(".mostrarPortadaMultiFotoLupita img").prop("src" "");
             }
             */
            /*
             function getAndSetObj(){
             var obj = {}
             for(key in arraySelectores){
             obj[key] = arraySelectores[key].contenido;
             }
             $.ajax({
             method: "POST",
             url: "<?= Shop::$configuracion->url ?>comunes/consultas/getArticuloJson.php",
             data: JSON.stringify(obj),
             success: function (result) {
             console.log(result.articulos);
             colocarConten(result.articulos[0]);			
             },
             error: function () {
             alert("La petición AJAX falló");
             },
             cache: false
             });
             }
             */
            //$(document).ready(function(){
            //console.log($(padreSelectores).find(".selector").parent());
            //$(padreSelectores).find(".selector").parent().bind("DOMSubtreeModified",function(){
            ultimoCampo.find(".selector").parent().bind("DOMSubtreeModified", function () {
                //
                if (flag) {
                    flag = false;
                    setTimeout(function () {
                        //var options = $(padreSelectores).find(".selector option:selected").not("option[value='0']");
                        var options = ultimoCampo.find(".selector option:selected").not("option[value='NULL']");
                        //console.log("Total Campos: " + totalCampos);
                        //console.log(options.length);
                        if (totalCampos == options.length) {
                            //getAndSetObj();
                            //TODO ==> cargar la ficha del producto.
                            var obj = {}
                            for (key in arraySelectores) {
                                obj[key] = arraySelectores[key].contenido;
                            }
                            //Hay que añadir el artículo padre:
                            var articulo_padre = '<?= $padre; ?>';
                            $hash = "";
                            var jsonCargaArticulo = JSON.stringify(obj);
                            var extraData = JSON.stringify(obj);
                            //var codigoArticulo = "<?= $padre; ?>"; ==> NO es necesario
                            //var eanArticulo = "0"; ==> NO es necesario
                            //var fichero = $(padreSelectores).closest("#ficha_producto_<?= $articulo->ean; ?>").data("file");
                            //var fichero = ultimoCampo.closest("#ficha_producto_<?= $articulo->ean; ?>").data("file");
                            var fichero = ultimoCampo.closest("[data-type='ficha_producto']").data("file");
                            //console.log(ultimoCampo.closest("[data-type='ficha_producto']"));
                            var parametros = "&articulo_padre=" + articulo_padre + "&fichero=" + fichero + "&extraData=" + extraData + "&jsonCargaArticulo=" + jsonCargaArticulo + "&hash=<?= genera_cod_seguridad(); ?>";
                            //console.log(parametros);
                            realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/getArticulo.php", parametros, function (respuesta) {
                                //console.log(respuesta);
                                //jqueryzamos lo recibido
                                respuesta = $(respuesta);
                                var id = respuesta.attr("id");
                                //var capaPrincipal = $(padreSelectores).closest("#ficha_producto_<?= $articulo->ean; ?>");
                                var capaPrincipal = ultimoCampo.closest("[data-type='ficha_producto']");
                                capaPrincipal.html(respuesta.html());
                                capaPrincipal.attr("id", id);
                                capaPrincipal.data("file", fichero);
                                //Ejecutamos el script que re-ejecuta los js:
                                //recargarScripts("#" + id);
                            });
                        }
                        flag = true;
                    }, 500);
                }
                //});
            });
            for (key in arraySelectores) {
                arraySelectores[key].setListener();
            }
        })();
		});
    </script>
    <?php
}

/**
 * Funcion dos
 */
function getPersonalizable($opciones = NULL) {
    include("comunes/globals.php");
    $ruta_fichero = ($opciones->configuracion->ruta_fichero != NULL) ? $opciones->configuracion->ruta_fichero : 'extrasArticulo';
    $f_custom = ($opciones->configuracion->ruta_fichero != NULL) ? $opciones->configuracion->ruta_fichero : 'extrasArticulo';
    $campos = ($opciones->configuracion->campos != NULL) ? $opciones->configuracion->campos : array('talla', 'color');
    $padre = ($opciones->configuracion->padre != NULL) ? $opciones->configuracion->padre : 0;
    $soy = ($opciones->configuracion->soy != NULL) ? $opciones->configuracion->soy : 'talla';
    $valores = ($opciones->configuracion->valores != NULL) ? $opciones->configuracion->valores : false;
    $valor = ($opciones->configuracion->valor != NULL) ? $opciones->configuracion->valor : '';
    $showScript = ($opciones->configuracion->showScript != NULL) ? false : true;
    if ($conexionBD && !$valores) {
        $sentencia_sql = "SELECT DISTINCT $soy FROM `articulo` WHERE `articulo_padre` = $padre ";
        //echo $sentencia_sql;
        $resultado = mysqli_query($conexionBD, $sentencia_sql);
        while ($fila = mysqli_fetch_array($resultado)) {
            $valores[] = $fila[$soy];
        }
    }
    if ($showScript) {
        ?>
        <div id="<?= $soy ?>" class="disponibles">
        <?php
	}
	$ruta_fichero = Theme::findFile($ruta_fichero . ".php");
	//echo $ruta_fichero;
	if ($ruta_fichero != NULL) {
		include($ruta_fichero);
	}
	if ($showScript) {
	?>
        </div>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
        <script type="text/javascript" id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                //Este array es equivalente al que existe en el servidor.
                var campos_<?= $soy ?> = [];
        <?php
        foreach ($campos as $key => $val) {
            ?>
                    campos_<?= $soy ?>.push('<?= $val ?>');
            <?php
        }
        ?>
                var s_<?= $soy ?> = new selectorClass('<?= $soy ?>', campos_<?= $soy ?>, <?= $padre ?>, '<?= $f_custom ?>');
                arraySelectores['<?= $soy ?>'] = s_<?= $soy ?>;
            })();
		});
        </script>
        <?php
    }
}
?>
