<?php
	//---------------------------------------------------------------------------------------------------------
	// 24/Noviembre/2015
	// Versión 1.0 Widget Que sirve para mostrar los depósitos
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function widget_depositos(){
		//Aquí definimos una serie de parámetros que necesitamos
		$funcion_por_defecto = 'depositos';
		$parametros_por_defecto = array();
		$parametros_recibidos = func_get_args();
		if (count($parametros_recibidos) == 0){
			$parametros_recibidos[0] = $funcion_por_defecto;
		}else{
			if ( ($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL) ){
				$parametros_recibidos[0] = $funcion_por_defecto;
			}
		}
		$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
		$retorno = false;
		//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
		if (count($parametros_recibidos) > 0){
			//Recogemos el nombre de la función de entre el resto de parámetros
			$nombre_funcion = $parametros_recibidos[0];
			//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
			$parametros_recibidos = array_slice($parametros_recibidos, 1);
			//Si la función existe la ejecutamos
			if(function_exists($nombre_funcion)){
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
		return($retorno);
	}

	function depositos($opciones = NULL){
		include('comunes/globals.php');
?>
<div class="<?=(__FUNCTION__);?>">
<?php
		//Como siempre en V2, procesamos las opciones. Pero en esta función, estas opciones se meterán en el objeto para usarlo después
		$codigo_usuario = 0;
		$fichero_linea = 'linea_deposito';
		$fichero_cabecera = '';
		$fichero_pie = '';
		$cargar_articulo = false;
		$cargar_cliente = false;
		$cargar_albaran = false;
		$cargar_lineas_albaran = false;
		$cargar_articulos_albaran = false;
		
		//Vamos a coger el filtro de las fechas
		$filtro_fecha = '';
		$fecha_inicio = Sesion::get('fecha_inicio_depositos');
		$fecha_fin = Sesion::get('fecha_fin_depositos');
		if ( ($fecha_inicio !== NULL) && ($fecha_fin !== NULL) ){
			$filtro_fecha = "$fecha_inicio $fecha_fin";
		}
		
		$orden = Sesion::get('orden_depositos');
		if ($orden == NULL){	$orden = 'deposito.codigo';	}
		$tipo_orden = Sesion::get('tipo_orden_depositos');
		if ($tipo_orden == NULL){	$tipo_orden = 'DESC';	}

		$cliente = Usuario::logueado();
		if ($cliente !== NULL){
			$codigo_usuario = $cliente->codigo;
		}
		
		$solo_libros_depositos = Sesion::get('solo_libros_depositos');
		if ($solo_libros_depositos == NULL){	$solo_libros_depositos = '';	}
		$solo_papeleria_depositos = Sesion::get('solo_papeleria_depositos');
		if ($solo_papeleria_depositos == NULL){	$solo_papeleria_depositos = '';	}
		
		if (is_a($opciones, 'OpcionesWidget')){
			$cliente = ($opciones->configuracion->cliente !== NULL) ? $opciones->configuracion->cliente : $cliente;
			if (is_numeric($cliente)){
				$cliente = new usuario($cliente);
			}
			$codigo_usuario = ($opciones->configuracion->codigo_usuario !== NULL) ? $opciones->configuracion->codigo_usuario : $cliente->codigo;
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
			$fichero_cabecera = ($opciones->configuracion->fichero_cabecera !== NULL) ? $opciones->configuracion->fichero_cabecera : $fichero_cabecera;
			$fichero_pie = ($opciones->configuracion->fichero_pie !== NULL) ? $opciones->configuracion->fichero_pie : $fichero_pie;
			
			$filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
			$orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;
			$permitir_anular = ($opciones->configuracion->permitir_anular !== NULL) ? $opciones->configuracion->permitir_anular : $orden;
			$solo_libros_depositos = ($opciones->configuracion->solo_libros_depositos !== NULL) ? $opciones->configuracion->solo_libros_depositos : $solo_libros_depositos;
			$solo_papeleria_depositos = ($opciones->configuracion->solo_papeleria_depositos !== NULL) ? $opciones->configuracion->solo_papeleria_depositos : $solo_papeleria_depositos;
			
			$cargar_articulo = ($opciones->configuracion->cargar_articulo !== NULL) ? $opciones->configuracion->cargar_articulo : $cargar_articulo;
			$cargar_cliente = ($opciones->configuracion->cargar_cliente !== NULL) ? $opciones->configuracion->cargar_cliente : $cargar_cliente;
			$cargar_albaran = ($opciones->configuracion->cargar_albaran !== NULL) ? $opciones->configuracion->cargar_albaran : $cargar_albaran;
			$cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
			$cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;

		}else{
			$opciones = new OpcionesWidget();
		}
		
		//Vamos a hacer ahora la carga
		if ($cliente !== NULL){
			if ($cliente->codigo > 0){
				$codigo_usuario = $cliente->codigo;
				$filtro_fecha = trim($filtro_fecha);
				$orden = trim($orden);//Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
				//Vamos a componer la select:
				
				$sentencia_sql = "SELECT deposito.cab_albaran cab_albaran,deposito.codigo codigo
								FROM deposito, cliente, articulo
								WHERE  deposito.cliente = cliente.codigo_sinlib AND cliente.codigo = $codigo_usuario AND deposito.articulo = articulo.codigo";
				
				if($filtro_fecha != ""){
					$array_fechas = explode(" ", $filtro_fecha);
					$sentencia_sql .= " AND fecha_vencimiento BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ";
				}

				//Los filtros por tipo de artículo, se hacen sólo si son distintos los flags:
				if ($solo_libros_depositos != $solo_papeleria_depositos){
					if($solo_libros_depositos != ""){
						$sentencia_sql .= " AND articulo.tipo = 'L' ";
					}
					
					if($solo_papeleria_depositos != ""){
						$sentencia_sql .= " AND articulo.tipo = 'P' ";
					}
				}
				//Ahora agrupamos por albaran
				$sentencia_sql .= ' GROUP BY deposito.cab_albaran ';
				//echo("$sentencia_sql<br />\n");
				//Necesitamos saber cuantos elementos hay para poder hacer la paginación
				$total_elementos = mysqli_query($conexionBD, $sentencia_sql);
				$total_elementos = mysqli_num_rows($total_elementos);

				//Vamos con el orden
				//Primero miramos la cabecera:
				$cadena_orden = '';

				if (( $orden != '') && ($tipo_orden != '') ){
					$cadena_orden .= ( ($cadena_orden != '') ? ' , ' : '' ) . $orden . ' ' . $tipo_orden . ' ';
				}
				//Siempre se termina ordenando por albaran para agruparlos
				$cadena_orden = ($cadena_orden != '') ? " ORDER BY $cadena_orden " : $cadena_orden;

				//Falta por añadir la paginación
				//$pagina = dame_valor_variable_global('pagina', 0);
				$pagina = Sections::getParam('pagina', 0);
				$enlace = Shop::$configuracion->url . 'depositos';
				$sentencia_sql .= $cadena_orden . ' LIMIT ' . ($pagina * Shop::$configuracion->elementos_depositos) . ', ' . Shop::$configuracion->elementos_depositos;

				//echo("$sentencia_sql<br />\n");

				if ($conexionBD){
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
						//Comprobamos si tenemos depositos
						if($total_elementos === 0){
?>
						<p class="error_no_hay_depositos"><?=traducir('Aún no ha realizado ningún depósito');?></p>
<?php
						}else{
							$fichero_cabecera = Theme::findFile($fichero_cabecera . '.php');
							$fichero_cabecera = ($fichero_cabecera == NULL) ? '': $fichero_cabecera;

							$fichero_pie = Theme::findFile($fichero_pie . '.php');
							$fichero_pie = ($fichero_pie == NULL) ? $fichero_pie: $fichero_pie;
							//Vamos a cargar unos totales por depósito y página
							while ($fila = mysqli_fetch_array($resultado)){
?>
<div class="deposito_cliente">
<?php
								$deposito = new Deposito($fila["codigo"], $cargar_articulo, $cargar_cliente, $cargar_albaran, $cargar_lineas_albaran, $cargar_articulos_albaran);
								//si hay fichero de cabecera, hacemos el include:
								if ( ($fichero_cabecera != NULL) && ($fichero_cabecera != "") ){
									include($fichero_cabecera);
								}
								//Ahora componemos la línea
								$opciones = new OpcionesWidget(array( 	'fichero_linea' => $fichero_linea,
																		'cargar_articulo' => $cargar_articulo,
																		'cargar_cliente' => $cargar_cliente,
																		'cargar_albaran' => $cargar_albaran,
																		'cargar_lineas_albaran' => $cargar_lineas_albaran,
																		'cargar_articulos_albaran' => $cargar_articulos_albaran,
																		'cab_albaran' => $fila['cab_albaran']
								));
                                new Widget($_WH->GW('depositos', 'depositos_x_albaran'), $opciones);
								//Si hay pie lo incluimos
								if ( ($fichero_pie != NULL) && ($fichero_pie != '') ){
									include($fichero_pie);
								}
?>
</div>
<?php
							}
							//Paginacion:
                            new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_depositos);
						}
					}
				}
			}
		}
?>
</div>
<?php
	}
	
	
	function depositos_x_albaran($opciones){
		include('comunes/globals.php');
		$fichero_linea = 'linea_deposito';
		$cargar_articulo = false;
		$cargar_cliente = false;
		$cargar_albaran = false;
		$cargar_lineas_albaran = false;
		$cargar_articulos_albaran = false;
		$cab_albaran = 0;
		if (is_a($opciones, 'OpcionesWidget')){
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;

			$cargar_articulo = ($opciones->configuracion->cargar_articulo !== NULL) ? $opciones->configuracion->cargar_articulo : $cargar_articulo;
			$cargar_cliente = ($opciones->configuracion->cargar_cliente !== NULL) ? $opciones->configuracion->cargar_cliente : $cargar_cliente;
			$cargar_albaran = ($opciones->configuracion->cargar_albaran !== NULL) ? $opciones->configuracion->cargar_albaran : $cargar_albaran;
			$cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
			$cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;

			$cab_albaran = ($opciones->configuracion->cab_albaran !== NULL) ? $opciones->configuracion->cab_albaran : $cab_albaran;
		}
		$sentencia_sql = 'SELECT codigo FROM deposito WHERE cab_albaran = '.$cab_albaran;
		$fichero_linea = Theme::findFile($fichero_linea . '.php');
		$fichero_linea = ($fichero_linea == NULL) ? '': $fichero_linea;
		if ( ($fichero_linea != NULL) && ($fichero_linea != '') ){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
?>
<div class="<?=(__FUNCTION__);?>">
<?php
				while ($fila = mysqli_fetch_array($resultado)){
					$deposito = new Deposito($fila['codigo'], $cargar_articulo, $cargar_cliente, $cargar_albaran, $cargar_lineas_albaran, $cargar_articulos_albaran);
					include($fichero_linea);
				}
?>
</div>
<?php
			}
		}
	}
?>